
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from .state import TypeUpdatesState
    from ..update import TypeUpdate
    from ..message import TypeMessage
    from ..encrypted_message import TypeEncryptedMessage
    from ....gadgets.byteutils import Reader


class DifferenceEmpty(TLObject, family='TypeUpdatesDifference'):
    """
    No events.
    """

    _id = 0X5D75A138
    _group_id = 0XCAABD573

    def __init__(
        self,
        date: int,
        seq: int
    ):

        """
        No events.

        Args:
            date (int): Current date
            seq (int): Number of sent updates
        """

        self.date = date
        self.seq = seq

    def to_bytes(self, boxed: bool=True):
        with Writer(b'8\xa1u]' if boxed else b'') as writer:
            writer.int(self.date)
            writer.int(self.seq)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        date_ = reader.int()
        seq_ = reader.int()

        return cls(
            date=date_,
            seq=seq_
        )

class Difference(TLObject, family='TypeUpdatesDifference'):
    """
    Full list of occurred events.
    """

    _id = 0XF49CA0
    _group_id = 0XCAABD573

    def __init__(
        self,
        new_messages: List['TypeMessage'],
        new_encrypted_messages: List['TypeEncryptedMessage'],
        other_updates: List['TypeUpdate'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        state: 'TypeUpdatesState'
    ):

        """
        Full list of occurred events.

        Args:
            new_messages (List['TypeMessage']): List of new messages
            new_encrypted_messages (List['TypeEncryptedMessage']): List of new encrypted secret chat messages
            other_updates (List['TypeUpdate']): List of updates
            chats (List['TypeChat']): List of chats mentioned in events
            users (List['TypeUser']): List of users mentioned in events
            state ('TypeUpdatesState'): Current state
        """

        self.new_messages = new_messages
        self.new_encrypted_messages = new_encrypted_messages
        self.other_updates = other_updates
        self.chats = chats
        self.users = users
        self.state = state

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\x9c\xf4\x00' if boxed else b'') as writer:
            writer.vector(
                self.new_messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.new_encrypted_messages,
                lambda value: writer.object(
                    value,
                    group_id=0XB38C0DC2
                )
            )
            writer.vector(
                self.other_updates,
                lambda value: writer.object(
                    value,
                    group_id=0X54E058F5
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.object(
                self.state,
                group_id=0X68F21FDA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        new_encrypted_messages_ = reader.vector(
            lambda: reader.object(
                group_id=0XB38C0DC2
            )
        )

        other_updates_ = reader.vector(
            lambda: reader.object(
                group_id=0X54E058F5
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        state_ = reader.object(
            group_id=0X68F21FDA
        )

        return cls(
            new_messages=new_messages_,
            new_encrypted_messages=new_encrypted_messages_,
            other_updates=other_updates_,
            chats=chats_,
            users=users_,
            state=state_
        )

class DifferenceSlice(TLObject, family='TypeUpdatesDifference'):
    """
    Incomplete list of occurred events.
    """

    _id = 0XA8FB1981
    _group_id = 0XCAABD573

    def __init__(
        self,
        new_messages: List['TypeMessage'],
        new_encrypted_messages: List['TypeEncryptedMessage'],
        other_updates: List['TypeUpdate'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        intermediate_state: 'TypeUpdatesState'
    ):

        """
        Incomplete list of occurred events.

        Args:
            new_messages (List['TypeMessage']): List of new messages
            new_encrypted_messages (List['TypeEncryptedMessage']): New messages from the [encrypted event sequence](https://core.telegram.org/api/updates)
            other_updates (List['TypeUpdate']): List of updates
            chats (List['TypeChat']): List of chats mentioned in events
            users (List['TypeUser']): List of users mentioned in events
            intermediate_state ('TypeUpdatesState'): Intermediary state
        """

        self.new_messages = new_messages
        self.new_encrypted_messages = new_encrypted_messages
        self.other_updates = other_updates
        self.chats = chats
        self.users = users
        self.intermediate_state = intermediate_state

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81\x19\xfb\xa8' if boxed else b'') as writer:
            writer.vector(
                self.new_messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.new_encrypted_messages,
                lambda value: writer.object(
                    value,
                    group_id=0XB38C0DC2
                )
            )
            writer.vector(
                self.other_updates,
                lambda value: writer.object(
                    value,
                    group_id=0X54E058F5
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.object(
                self.intermediate_state,
                group_id=0X68F21FDA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        new_messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        new_encrypted_messages_ = reader.vector(
            lambda: reader.object(
                group_id=0XB38C0DC2
            )
        )

        other_updates_ = reader.vector(
            lambda: reader.object(
                group_id=0X54E058F5
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        intermediate_state_ = reader.object(
            group_id=0X68F21FDA
        )

        return cls(
            new_messages=new_messages_,
            new_encrypted_messages=new_encrypted_messages_,
            other_updates=other_updates_,
            chats=chats_,
            users=users_,
            intermediate_state=intermediate_state_
        )

class DifferenceTooLong(TLObject, family='TypeUpdatesDifference'):
    """
    The difference is [too long](https://core.telegram.org/api/updates#recovering-gaps), and the specified state must be used to refetch updates.
    """

    _id = 0X4AFE8F6D
    _group_id = 0XCAABD573

    def __init__(
        self,
        pts: int
    ):

        """
        The difference is [too long](https://core.telegram.org/api/updates#recovering-gaps), and the specified state must be used to refetch updates.

        Args:
            pts (int): The new state to use.
        """

        self.pts = pts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'm\x8f\xfeJ' if boxed else b'') as writer:
            writer.int(self.pts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        pts_ = reader.int()

        return cls(
            pts=pts_
        )

TypeUpdatesDifference = Union[
    DifferenceEmpty,
    Difference,
    DifferenceSlice,
    DifferenceTooLong
]