
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class WallPaperSettings(TLObject, family='TypeWallPaperSettings'):
    """
    [Wallpaper](https://core.telegram.org/api/wallpapers) rendering information.
    """

    _id = 0X372EFCD0
    _group_id = 0X28E332CF

    def __init__(
        self,
        blur: bool = False,
        motion: bool = False,
        background_color: Optional[int] = None,
        second_background_color: Optional[int] = None,
        third_background_color: Optional[int] = None,
        fourth_background_color: Optional[int] = None,
        intensity: Optional[int] = None,
        rotation: Optional[int] = None,
        emoticon: Optional[str] = None
    ):

        """
        [Wallpaper](https://core.telegram.org/api/wallpapers) rendering information.

        Args:
            blur (bool, optional): For [image wallpapers](https://core.telegram.org/api/wallpapers#image-wallpapers): if set, the JPEG must be downscaled to fit in 450x450 square and then box-blurred with radius 12.
            motion (bool, optional): If set, the background needs to be slightly moved when the device is rotated.
            background_color (Optional[int], optional): Used for [solid](https://core.telegram.org/api/wallpapers#solid-fill), [gradient](https://core.telegram.org/api/wallpapers#gradient-fill) and [freeform gradient](https://core.telegram.org/api/wallpapers#freeform-gradient-fill) fills.
            second_background_color (Optional[int], optional): Used for [gradient](https://core.telegram.org/api/wallpapers#gradient-fill) and [freeform gradient](https://core.telegram.org/api/wallpapers#freeform-gradient-fill) fills.
            third_background_color (Optional[int], optional): Used for [freeform gradient](https://core.telegram.org/api/wallpapers#freeform-gradient-fill) fills.
            fourth_background_color (Optional[int], optional): Used for [freeform gradient](https://core.telegram.org/api/wallpapers#freeform-gradient-fill) fills.
            intensity (Optional[int], optional): Used for [pattern wallpapers](https://core.telegram.org/api/wallpapers#pattern-wallpapers).
            rotation (Optional[int], optional): Clockwise rotation angle of the gradient, in degrees; 0-359. Should be always divisible by 45.
            emoticon (Optional[str], optional): If set, this wallpaper can be used as a channel wallpaper and is represented by the specified UTF-8 emoji.
        """

        self.blur = blur
        self.motion = motion
        self.background_color = background_color
        self.second_background_color = second_background_color
        self.third_background_color = third_background_color
        self.fourth_background_color = fourth_background_color
        self.intensity = intensity
        self.rotation = rotation
        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd0\xfc.7' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.blur, 1)
                flags(self.motion, 2)

                if flags(self.background_color, 0):
                    writer.int(self.background_color)

                if flags(self.second_background_color, 4):
                    writer.int(self.second_background_color)

                if flags(self.third_background_color, 5):
                    writer.int(self.third_background_color)

                if flags(self.fourth_background_color, 6):
                    writer.int(self.fourth_background_color)

                if flags(self.intensity, 3):
                    writer.int(self.intensity)

                if flags(self.rotation, 4):
                    writer.int(self.rotation)

                if flags(self.emoticon, 7):
                    writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        background_color_ = (
            reader.int()
            if flags(0) else None
        )

        second_background_color_ = (
            reader.int()
            if flags(4) else None
        )

        third_background_color_ = (
            reader.int()
            if flags(5) else None
        )

        fourth_background_color_ = (
            reader.int()
            if flags(6) else None
        )

        intensity_ = (
            reader.int()
            if flags(3) else None
        )

        rotation_ = (
            reader.int()
            if flags(4) else None
        )

        emoticon_ = (
            reader.string()
            if flags(7) else None
        )

        return cls(
            blur=flags(1),
            motion=flags(2),
            background_color=background_color_,
            second_background_color=second_background_color_,
            third_background_color=third_background_color_,
            fourth_background_color=fourth_background_color_,
            intensity=intensity_,
            rotation=rotation_,
            emoticon=emoticon_
        )

TypeWallPaperSettings = WallPaperSettings