
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document_attribute import TypeDocumentAttribute
    from ...gadgets.byteutils import Reader


class WebDocument(TLObject, family='TypeWebDocument'):
    """
    Remote document
    """

    _id = 0X1C570ED1
    _group_id = 0XCDE930D7

    def __init__(
        self,
        url: str,
        access_hash: int,
        size: int,
        mime_type: str,
        attributes: List['TypeDocumentAttribute']
    ):

        """
        Remote document

        Args:
            url (str): Document URL
            access_hash (int): Access hash
            size (int): File size
            mime_type (str): MIME type
            attributes (List['TypeDocumentAttribute']): Attributes for media types
        """

        self.url = url
        self.access_hash = access_hash
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd1\x0eW\x1c' if boxed else b'') as writer:
            writer.string(self.url)
            writer.long(self.access_hash)
            writer.int(self.size)
            writer.string(self.mime_type)
            writer.vector(
                self.attributes,
                lambda value: writer.object(
                    value,
                    group_id=0X9EBF3A46
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        access_hash_ = reader.long()
        size_ = reader.int()
        mime_type_ = reader.string()
        attributes_ = reader.vector(
            lambda: reader.object(
                group_id=0X9EBF3A46
            )
        )

        return cls(
            url=url_,
            access_hash=access_hash_,
            size=size_,
            mime_type=mime_type_,
            attributes=attributes_
        )

class WebDocumentNoProxy(TLObject, family='TypeWebDocument'):
    """
    Remote document that can be downloaded without [proxying through telegram](https://core.telegram.org/api/files)
    """

    _id = 0XF9C8BCC6
    _group_id = 0XCDE930D7

    def __init__(
        self,
        url: str,
        size: int,
        mime_type: str,
        attributes: List['TypeDocumentAttribute']
    ):

        """
        Remote document that can be downloaded without [proxying through telegram](https://core.telegram.org/api/files)

        Args:
            url (str): Document URL
            size (int): File size
            mime_type (str): MIME type
            attributes (List['TypeDocumentAttribute']): Attributes for media types
        """

        self.url = url
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6\xbc\xc8\xf9' if boxed else b'') as writer:
            writer.string(self.url)
            writer.int(self.size)
            writer.string(self.mime_type)
            writer.vector(
                self.attributes,
                lambda value: writer.object(
                    value,
                    group_id=0X9EBF3A46
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        size_ = reader.int()
        mime_type_ = reader.string()
        attributes_ = reader.vector(
            lambda: reader.object(
                group_id=0X9EBF3A46
            )
        )

        return cls(
            url=url_,
            size=size_,
            mime_type=mime_type_,
            attributes=attributes_
        )

TypeWebDocument = Union[
    WebDocument,
    WebDocumentNoProxy
]