
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .document import TypeDocument
    from .star_gift import TypeStarGift
    from .story_item import TypeStoryItem
    from .theme_settings import TypeThemeSettings
    from ...gadgets.byteutils import Reader


class WebPageAttributeTheme(TLObject, family='TypeWebPageAttribute'):
    """
    Page theme
    """

    _id = 0X54B56617
    _group_id = 0X3FDCCA54

    def __init__(
        self,
        documents: Optional[List['TypeDocument']] = None,
        settings: Optional['TypeThemeSettings'] = None
    ):

        """
        Page theme

        Args:
            documents (Optional[List['TypeDocument']], optional): Theme files
            settings (Optional['TypeThemeSettings'], optional): Theme settings
        """

        self.documents = documents
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x17f\xb5T' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.documents, 0):
                    writer.vector(
                        self.documents,
                        lambda value: writer.object(
                            value,
                            group_id=0X6547BD50
                        )
                    )

                if flags(self.settings, 1):
                    writer.object(
                        self.settings,
                        group_id=0X71DD876E
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        documents_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6547BD50
                )
            )
            if flags(0) else None
        )

        settings_ = (
            reader.object(
                group_id=0X71DD876E
            )
            if flags(1) else None
        )

        return cls(
            documents=documents_,
            settings=settings_
        )

class WebPageAttributeStory(TLObject, family='TypeWebPageAttribute'):
    """
    Webpage preview of a Telegram story
    """

    _id = 0X2E94C3E7
    _group_id = 0X3FDCCA54

    def __init__(
        self,
        peer: 'TypePeer',
        id: int,
        story: Optional['TypeStoryItem'] = None
    ):

        """
        Webpage preview of a Telegram story

        Args:
            peer ('TypePeer'): Peer that posted the story
            id (int): [Story ID](https://core.telegram.org/api/stories#watching-stories)
            story (Optional['TypeStoryItem'], optional): May contain the story, if not the story should be fetched when and if needed using [stories.getStoriesByID](https://core.telegram.org/method/stories.getStoriesByID) with the above id and peer.
        """

        self.peer = peer
        self.id = id
        self.story = story

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe7\xc3\x94.' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.id)

                if flags(self.story, 0):
                    writer.object(
                        self.story,
                        group_id=0X8436985A
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        id_ = reader.int()
        story_ = (
            reader.object(
                group_id=0X8436985A
            )
            if flags(0) else None
        )

        return cls(
            peer=peer_,
            id=id_,
            story=story_
        )

class WebPageAttributeStickerSet(TLObject, family='TypeWebPageAttribute'):
    """
    Contains info about a [stickerset](https://core.telegram.org/api/stickers), for a [webPage](https://core.telegram.org/constructor/webPage) preview of a [stickerset deep link](https://core.telegram.org/api/links#stickerset-links) (the [webPage](https://core.telegram.org/constructor/webPage) will have a type of telegram_stickerset).
    """

    _id = 0X50CC03D3
    _group_id = 0X3FDCCA54

    def __init__(
        self,
        stickers: List['TypeDocument'],
        emojis: bool = False,
        text_color: bool = False
    ):

        """
        Contains info about a [stickerset](https://core.telegram.org/api/stickers), for a [webPage](https://core.telegram.org/constructor/webPage) preview of a [stickerset deep link](https://core.telegram.org/api/links#stickerset-links) (the [webPage](https://core.telegram.org/constructor/webPage) will have a type of telegram_stickerset).

        Args:
            stickers (List['TypeDocument']): A subset of the stickerset in the stickerset.
            emojis (bool, optional): Whether this i s a [custom emoji stickerset](https://core.telegram.org/api/custom-emoji).
            text_color (bool, optional): Whether the color of this TGS custom emoji stickerset should be changed to the text color when used in messages, the accent color if used as emoji status, white on chat photos, or another appropriate color based on context.
        """

        self.stickers = stickers
        self.emojis = emojis
        self.text_color = text_color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd3\x03\xccP' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.emojis, 0)
                flags(self.text_color, 1)
                writer.vector(
                    self.stickers,
                    lambda value: writer.object(
                        value,
                        group_id=0X6547BD50
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stickers_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            stickers=stickers_,
            emojis=flags(0),
            text_color=flags(1)
        )

class WebPageAttributeUniqueStarGift(TLObject, family='TypeWebPageAttribute'):
    _id = 0XCF6F6DB8
    _group_id = 0X3FDCCA54

    def __init__(
        self,
        gift: 'TypeStarGift'
    ):

        self.gift = gift

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb8mo\xcf' if boxed else b'') as writer:
            writer.object(
                self.gift,
                group_id=0X87440C7B
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        gift_ = reader.object(
            group_id=0X87440C7B
        )

        return cls(
            gift=gift_
        )

class WebPageAttributeStarGiftCollection(TLObject, family='TypeWebPageAttribute'):
    _id = 0X31CAD303
    _group_id = 0X3FDCCA54

    def __init__(
        self,
        icons: List['TypeDocument']
    ):

        self.icons = icons

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x03\xd3\xca1' if boxed else b'') as writer:
            writer.vector(
                self.icons,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        icons_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            icons=icons_
        )

TypeWebPageAttribute = Union[
    WebPageAttributeTheme,
    WebPageAttributeStory,
    WebPageAttributeStickerSet,
    WebPageAttributeUniqueStarGift,
    WebPageAttributeStarGiftCollection
]