from setuptools import setup, find_packages


with open("README.md", "r", encoding="utf-8") as f:
    long_description = f.read()


setup(
    name='airtestProject',
    version='0.1.9',
    packages=find_packages(include=['airtestProject', 'airtestProject.*']),
    long_description=long_description,
    long_description_content_type="text/markdown",
    install_requires=[
        "openpyxl==1.1.0",
        "qrcode==7.4.2",
        "watchdog==4.0.0",
        "easyocr==1.7.1",
        "paddleocr==2.7.3",
        "loguru==0.5.3",
        "paddlepaddle==2.6.1",
        "numpy==1.22.4",
        "torch==2.3.0",
        "hrpc>=1.0.9",
        "websocket-client==0.48.0",
        "pynput",
        "pywin32",
        "uiautomation",
        "six"
        # 项目依赖项列表
    ],
    python_requires='>=3.9',
    author="mortal_sjh",                                     # 作者
    author_email="mortal_sjh@qq.com"
)
