#  Copyright (c) ETH Zurich, SIS ID and HVL D-ITET
#
"""
Device classes for Heinzinger Digital Interface I/II and Heinzinger PNC power supply.

The Heinzinger Digital Interface I/II is used for many Heinzinger power units.
Interface Manual:
https://www.heinzinger.com/assets/uploads/downloads/Handbuch_DigitalInterface_2021-12-14-V1.6.pdf

The Heinzinger PNC series is a series of high voltage direct current power supplies.
The class HeinzingerPNC is tested with two PNChp 60000-1neg and a PNChp 1500-1neg.
Check the code carefully before using it with other PNC devices, especially PNC3p
or PNCcap.
Manufacturer homepage:
https://www.heinzinger.com/en/products/pnc-serie
"""

from hvl_ccb.dev.heinzinger.base import (  # noqa: F401
    HeinzingerConfig,
    HeinzingerDI,
    HeinzingerPNC,
    HeinzingerSerialCommunication,
    HeinzingerSerialCommunicationConfig,
)
from hvl_ccb.dev.heinzinger.constants import (  # noqa: F401
    HeinzingerPNCDeviceNotRecognizedError,
    HeinzingerPNCError,
    HeinzingerPNCMaxCurrentExceededError,
    HeinzingerPNCMaxVoltageExceededError,
)
