# import _cython_3_0_10
from typing_extensions import Buffer
from fractions import Fraction

import numpy.typing as npt
import numpy as np

from .wrapper import FourCC
from .locks import RLock, Condition

_UintArray = npt.NDArray[np.uint8]


class VideoFrame:
    # __pyx_vtable__: ClassVar[PyCapsule] = ...
    fourcc: FourCC
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def xres(self) -> int: ...
    @property
    def yres(self) -> int: ...
    @property
    def bits_per_pixel(self) -> int: ...
    @property
    def padded_bits_per_pixel(self) -> int: ...
    def get_buffer_size(self) -> int: ...
    def get_data_size(self) -> int: ...
    def get_format_string(self) -> str: ...
    def get_fourcc(self) -> FourCC: ...
    def get_frame_rate(self) -> Fraction: ...
    def get_line_stride(self) -> int: ...
    def get_resolution(self) -> tuple[int, int]: ...
    def get_timecode_posix(self) -> float: ...
    def get_timestamp_posix(self) -> float: ...
    def set_fourcc(self, value: FourCC) -> None: ...
    def set_frame_rate(self, value: Fraction) -> None: ...
    def set_resolution(self, xres: int, yres: int) -> None: ...
    def __reduce__(self): ...


class VideoFrameSync(VideoFrame, Buffer):
    shape: tuple[int]
    strides: tuple[int]
    def get_array(self) -> _UintArray: ...


class VideoRecvFrame(VideoFrame, Buffer):
    # __pyx_vtable__: ClassVar[PyCapsule] = ...
    current_frame_data: npt.NDArray[np.uint8]
    max_buffers: int
    read_lock: RLock
    read_ready: Condition
    write_lock: RLock
    write_ready: Condition
    def buffer_full(self) -> bool: ...
    def fill_p_data(self, dest: Buffer|_UintArray) -> bool: ...
    def get_buffer_depth(self) -> int: ...
    def get_view_count(self) -> int: ...
    def skip_frames(self, eager: bool) -> int: ...


class VideoSendFrame(VideoFrame, Buffer):
    # __pyx_vtable__: ClassVar[PyCapsule] = ...
    @property
    def attached_to_sender(self) -> bool: ...
    @property
    def ndim(self) -> int: ...
    @property
    def read_index(self) -> int: ...
    @property
    def shape(self) -> tuple[int,...]: ...
    @property
    def strides(self) -> tuple[int,...]: ...
    @property
    def write_index(self) -> int: ...
    def destroy(self) -> None: ...
    def get_write_available(self) -> bool: ...
    def write_data(self, data: Buffer|_UintArray) -> None: ...
