# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class EntityWarningType(str, Enum):
    """
    Warning type:   * `NO_AVAILABLE_TRANSPORT` - the order cannot be fulfilled, since there is no available (by shift limitations) transport   * `NO_AVAILABLE_PERFORMER` - the order cannot be fulfilled, since there is not a single available (by shift limitations) performer   * `NO_COMPATIBLE_TRANSPORT` - the order cannot be completed, since there is not a single compatible (in terms of capacity and \\ or compatibility tags) transport   * `NO_COMPATIBLE_PERFORMER` - the order cannot be completed, since there is not a single compatible (by compatibility tags) performer   * `PICKUP_AND_DROP_VIOLATION` - for each cargo within the order there must be exactly one loading and exactly one unloading (except for `PICKUP_TO_BOX` and `DROP_FROM_BOX` orders)   * `PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_ORDER` - for each cargo within the order, loading must go before unloading (`precedence_in_order`)   * `PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_TRIP` - conflicting requirements for the precedence of orders were specified (`precedence_in_trip`)   * `VIOLATION_PRECEDENCE_IN_TRIP_AND_ORDER` - requirements for the precedence of orders in the trip (`precedence_in_trip`) and in the order (` precedence_in_order`) contradict each other   * `TIME_WINDOW_VIOLATION` - the start time of the time window is later than the end time of the window or time window exceeds the maximum allowed   * `DURATION_VIOLATION` - duration does not correspond to the allowed interval   * `ORDER_WINDOWS_INTERSECTION_VIOLATION` - soft windows should not go beyond the boundaries of the hard window   * `PERFORMER_SHIFTS_INTERSECTION_VIOLATION` - time ranges of the performer's work shifts must not overlap, the beginning of the next window cannot be equal to the end of the previous one   * `TRANSPORT_SHIFTS_INTERSECTION_VIOLATION` - time ranges of transport work shifts should not overlap, the beginning of the next window cannot be equal to the end of the previous one   * `LOCATION_WINDOWS_INTERSECTION_VIOLATION` - time ranges of working windows of one location should not intersect, the beginning of the next window cannot be equal to the end of the previous one   * `INVALID_LOCATION_DURATIONS` - location has a working window that is less than the sum of the times `arrival + departure`   * `NO_TRANSPORT_BOXES` - if there are orders with cargo, then the transport must have at least one box   * `MAX_CAPACITY_VIOLATION` - `max_capacity` limit exceeds the total capacity of all boxes or set for only one box or less than the capacity of some box   * `MAX_BOXES_VIOLATION` - limit `max_boxes` is greater than or equal to the total number of boxes or specified for one box or equal to zero   * `TOO_MANY_CARGOS_FOR_DROP_VIOLATION` - the number of loads for an order of the` DROP` / `DROP_FROM_BOX` type must be no more than one   * `EMPTY_CARGOES_LIST` - empty list of loads for orders of type `DROP` / `DROP_FROM_BOX` / `PICKUP` / `PICKUP_TO_BOX`   * `CARGO_WORK_VIOLATION` - for a `WORK` order, the cargo list must be empty   * `GEODATA_TIME_WINDOW_VIOLATION` - the planning horizon exceeds the maximum available value   * `SHIFT_RESTRICTIONS_COULD_BE_MORE_PRECISE` - the working window `working_window` of the change of the artist does not lie entirely inside the window of availability `availability_window`   * `DURATION_DOES_NOT_FIT_INTO_HARD_WINDOW` - the duration of the event does not fit into the hard time window   * `DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW` - the duration of the event does not fit into the soft time window   * `EXTRA_DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW` - additional time for demand execution does not fit into the soft time window   * `MAX_CALCULATION_TIME_VIOLATION` - the maximum allowable calculation time has been exceeded   * `MAX_WAITING_TIME_VIOLATION` - the maximum allowable waiting time has been exceeded   * `INVALID_HARDLINK` - it is impossible to assign an order with demands with the `WORK` type to transport   * `CARGO_BOX_VIOLATION` - for requests of all types except `DROP_FROM_BOX` the key of the box where the cargo is located must be empty   * `CARGO_MULTIBOX_VIOLATION` - for an order of type `DROP_FROM_BOX` the indicated cargoes are in boxes of different vehicles   * `CARGO_CAPACITY_VIOLATION` - the specified cargo on board exceeds the size of the box in which it is located   * `CARGO_ORDER_VIOLATION` - the cargo specified in the order is not present in orders   * `FEATURE_LIFETIME_VIOLATION` - feature time windows intersect with each other or the working window `working_window` for changing the performer or transport does not intersect with the feature time window   * `QUOTA_EXCEEDED` - service quota exceeded   * `MAX_LOCATIONS_LIMITS_PENALTY_EXCEEDED` - the resulting solution does not satisfy the `max_locations_limits_penalty` requirement   * `REMOVED_ITEMS_NOT_EMPTY` - during data validation, items were removed from the original dataset, the list of removed items is in the `removed_items` object 
    """

    """
    allowed enum values
    """
    NO_AVAILABLE_TRANSPORT = 'NO_AVAILABLE_TRANSPORT'
    NO_AVAILABLE_PERFORMER = 'NO_AVAILABLE_PERFORMER'
    NO_COMPATIBLE_TRANSPORT = 'NO_COMPATIBLE_TRANSPORT'
    NO_COMPATIBLE_PERFORMER = 'NO_COMPATIBLE_PERFORMER'
    PICKUP_AND_DROP_VIOLATION = 'PICKUP_AND_DROP_VIOLATION'
    PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_ORDER = 'PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_ORDER'
    PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_TRIP = 'PICKUP_AND_DROP_VIOLATION_PRECEDENCE_IN_TRIP'
    VIOLATION_PRECEDENCE_IN_TRIP_AND_ORDER = 'VIOLATION_PRECEDENCE_IN_TRIP_AND_ORDER'
    TIME_WINDOW_VIOLATION = 'TIME_WINDOW_VIOLATION'
    DURATION_VIOLATION = 'DURATION_VIOLATION'
    ORDER_WINDOWS_INTERSECTION_VIOLATION = 'ORDER_WINDOWS_INTERSECTION_VIOLATION'
    PERFORMER_SHIFTS_INTERSECTION_VIOLATION = 'PERFORMER_SHIFTS_INTERSECTION_VIOLATION'
    TRANSPORT_SHIFTS_INTERSECTION_VIOLATION = 'TRANSPORT_SHIFTS_INTERSECTION_VIOLATION'
    LOCATION_WINDOWS_INTERSECTION_VIOLATION = 'LOCATION_WINDOWS_INTERSECTION_VIOLATION'
    INVALID_LOCATION_DURATIONS = 'INVALID_LOCATION_DURATIONS'
    NO_TRANSPORT_BOXES = 'NO_TRANSPORT_BOXES'
    MAX_CAPACITY_VIOLATION = 'MAX_CAPACITY_VIOLATION'
    MAX_BOXES_VIOLATION = 'MAX_BOXES_VIOLATION'
    TOO_MANY_CARGOS_FOR_DROP_VIOLATION = 'TOO_MANY_CARGOS_FOR_DROP_VIOLATION'
    EMPTY_CARGOES_LIST = 'EMPTY_CARGOES_LIST'
    CARGO_WORK_VIOLATION = 'CARGO_WORK_VIOLATION'
    GEODATA_TIME_WINDOW_VIOLATION = 'GEODATA_TIME_WINDOW_VIOLATION'
    SHIFT_RESTRICTIONS_COULD_BE_MORE_PRECISE = 'SHIFT_RESTRICTIONS_COULD_BE_MORE_PRECISE'
    DURATION_DOES_NOT_FIT_INTO_HARD_WINDOW = 'DURATION_DOES_NOT_FIT_INTO_HARD_WINDOW'
    DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW = 'DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW'
    EXTRA_DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW = 'EXTRA_DURATION_DOES_NOT_FIT_INTO_SOFT_WINDOW'
    MAX_CALCULATION_TIME_VIOLATION = 'MAX_CALCULATION_TIME_VIOLATION'
    MAX_WAITING_TIME_VIOLATION = 'MAX_WAITING_TIME_VIOLATION'
    INVALID_HARDLINK = 'INVALID_HARDLINK'
    CARGO_BOX_VIOLATION = 'CARGO_BOX_VIOLATION'
    CARGO_MULTIBOX_VIOLATION = 'CARGO_MULTIBOX_VIOLATION'
    CARGO_CAPACITY_VIOLATION = 'CARGO_CAPACITY_VIOLATION'
    CARGO_ORDER_VIOLATION = 'CARGO_ORDER_VIOLATION'
    FEATURE_LIFETIME_VIOLATION = 'FEATURE_LIFETIME_VIOLATION'
    QUOTA_EXCEEDED = 'QUOTA_EXCEEDED'
    MAX_LOCATIONS_LIMITS_PENALTY_EXCEEDED = 'MAX_LOCATIONS_LIMITS_PENALTY_EXCEEDED'
    REMOVED_ITEMS_NOT_EMPTY = 'REMOVED_ITEMS_NOT_EMPTY'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of EntityWarningType from a JSON string"""
        return cls(json.loads(json_str))


