# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.calculation_state import CalculationState
from vrt_lss_studio.models.experiment_check import ExperimentCheck
from vrt_lss_studio.models.experiment_settings import ExperimentSettings
from vrt_lss_studio.models.experiment_specification import ExperimentSpecification
from vrt_lss_studio.models.experiment_statistics import ExperimentStatistics
from typing import Optional, Set
from typing_extensions import Self

class Experiment(BaseModel):
    """
    Experiment.
    """ # noqa: E501
    key: StrictStr = Field(description="Key, unique identifier.")
    specification: ExperimentSpecification
    settings: ExperimentSettings
    statistics: ExperimentStatistics
    progress: Optional[Annotated[int, Field(le=100, strict=True, ge=0)]] = Field(default=0, description="Calculation progress as a percentage. The progress displays the current number of completed steps. ")
    calculation: Optional[CalculationState] = None
    check: Optional[ExperimentCheck] = None
    pristine: StrictBool = Field(description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    sharing: Optional[StrictBool] = Field(default=False, description="Experiment sharing flag. ")
    edit_date: datetime = Field(description="Last edit date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    creation_date: datetime = Field(description="Creation date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "specification", "settings", "statistics", "progress", "calculation", "check", "pristine", "sharing", "edit_date", "creation_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Experiment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "pristine",
            "sharing",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of specification
        if self.specification:
            _dict['specification'] = self.specification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of calculation
        if self.calculation:
            _dict['calculation'] = self.calculation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check
        if self.check:
            _dict['check'] = self.check.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if calculation (nullable) is None
        # and model_fields_set contains the field
        if self.calculation is None and "calculation" in self.model_fields_set:
            _dict['calculation'] = None

        # set to None if check (nullable) is None
        # and model_fields_set contains the field
        if self.check is None and "check" in self.model_fields_set:
            _dict['check'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Experiment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "specification": ExperimentSpecification.from_dict(obj["specification"]) if obj.get("specification") is not None else None,
            "settings": ExperimentSettings.from_dict(obj["settings"]) if obj.get("settings") is not None else None,
            "statistics": ExperimentStatistics.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "calculation": CalculationState.from_dict(obj["calculation"]) if obj.get("calculation") is not None else None,
            "check": ExperimentCheck.from_dict(obj["check"]) if obj.get("check") is not None else None,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "sharing": obj.get("sharing") if obj.get("sharing") is not None else False,
            "edit_date": obj.get("edit_date"),
            "creation_date": obj.get("creation_date")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


