# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.location_cargos_limit import LocationCargosLimit
from vrt_lss_studio.models.location_transports_limit import LocationTransportsLimit
from vrt_lss_studio.models.time_window import TimeWindow
from typing import Optional, Set
from typing_extensions import Self

class LocationLimit(BaseModel):
    """
    Limitation on the capacity of a location during a certain time period. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Constraint key, unique identifier.")
    time_window: Optional[TimeWindow]
    min_cargos: Optional[Annotated[List[LocationCargosLimit], Field(min_length=0, max_length=5)]] = Field(default=None, description="A function that describes the limitation of a location's ability to handle cargo and penalties for violating the restrictions. Penalties are cumulative independently for each qualifying part of the function. ")
    max_cargos: Optional[Annotated[List[LocationCargosLimit], Field(min_length=0, max_length=5)]] = Field(default=None, description="A function that describes the limitation of a location's ability to handle cargo and penalties for violating the restrictions. Penalties are cumulative independently for each qualifying part of the function. ")
    min_transports: Optional[Annotated[List[LocationTransportsLimit], Field(min_length=0, max_length=5)]] = Field(default=None, description="A function that describes the limitation of a location’s ability to serve transport and penalties for violating the restrictions. Penalties are cumulative independently for each qualifying part of the function. ")
    max_transports: Optional[Annotated[List[LocationTransportsLimit], Field(min_length=0, max_length=5)]] = Field(default=None, description="A function that describes the limitation of a location’s ability to serve transport and penalties for violating the restrictions. Penalties are cumulative independently for each qualifying part of the function. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["key", "time_window", "min_cargos", "max_cargos", "min_transports", "max_transports"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocationLimit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_window
        if self.time_window:
            _dict['time_window'] = self.time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in min_cargos (list)
        _items = []
        if self.min_cargos:
            for _item in self.min_cargos:
                if _item:
                    _items.append(_item.to_dict())
            _dict['min_cargos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in max_cargos (list)
        _items = []
        if self.max_cargos:
            for _item in self.max_cargos:
                if _item:
                    _items.append(_item.to_dict())
            _dict['max_cargos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in min_transports (list)
        _items = []
        if self.min_transports:
            for _item in self.min_transports:
                if _item:
                    _items.append(_item.to_dict())
            _dict['min_transports'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in max_transports (list)
        _items = []
        if self.max_transports:
            for _item in self.max_transports:
                if _item:
                    _items.append(_item.to_dict())
            _dict['max_transports'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if time_window (nullable) is None
        # and model_fields_set contains the field
        if self.time_window is None and "time_window" in self.model_fields_set:
            _dict['time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocationLimit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "time_window": TimeWindow.from_dict(obj["time_window"]) if obj.get("time_window") is not None else None,
            "min_cargos": [LocationCargosLimit.from_dict(_item) for _item in obj["min_cargos"]] if obj.get("min_cargos") is not None else None,
            "max_cargos": [LocationCargosLimit.from_dict(_item) for _item in obj["max_cargos"]] if obj.get("max_cargos") is not None else None,
            "min_transports": [LocationTransportsLimit.from_dict(_item) for _item in obj["min_transports"]] if obj.get("min_transports") is not None else None,
            "max_transports": [LocationTransportsLimit.from_dict(_item) for _item in obj["max_transports"]] if obj.get("max_transports") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


