# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.demand_extra_duration import DemandExtraDuration
from typing import Optional, Set
from typing_extensions import Self

class PerformerLimits(BaseModel):
    """
    The performer limitations. 
    """ # noqa: E501
    max_work_shifts: Optional[Annotated[int, Field(le=31, strict=True, ge=1)]] = Field(default=31, description="Limit of the number of performer's shifts in one planning.")
    demand_extra_durations: Optional[Annotated[List[DemandExtraDuration], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of demands for which the performer will spend more time than indicated in the demand. Valid for the specified performer-order pair for all performer's shifts and all demands's events. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["max_work_shifts", "demand_extra_durations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerformerLimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in demand_extra_durations (list)
        _items = []
        if self.demand_extra_durations:
            for _item in self.demand_extra_durations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['demand_extra_durations'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerformerLimits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "max_work_shifts": obj.get("max_work_shifts") if obj.get("max_work_shifts") is not None else 31,
            "demand_extra_durations": [DemandExtraDuration.from_dict(_item) for _item in obj["demand_extra_durations"]] if obj.get("demand_extra_durations") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


