# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.general_statistics import GeneralStatistics
from vrt_lss_studio.models.location_statistics import LocationStatistics
from vrt_lss_studio.models.quality import Quality
from vrt_lss_studio.models.task_statistics import TaskStatistics
from vrt_lss_studio.models.trip_statistics import TripStatistics
from typing import Optional, Set
from typing_extensions import Self

class PlanStatistics(BaseModel):
    """
    General statistics on the calculation result. 
    """ # noqa: E501
    total_statistics: GeneralStatistics
    trips_statistics: Annotated[List[TripStatistics], Field(min_length=0, max_length=15001)] = Field(description="List of statistics for each scheduled trip separately. ")
    locations_statistics: Annotated[List[Optional[LocationStatistics]], Field(min_length=0, max_length=15001)] = Field(description="Statistics on the loading of locations for which bandwidth restrictions have been set.")
    task_statistics: Optional[TaskStatistics]
    quality: Optional[Quality]
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["total_statistics", "trips_statistics", "locations_statistics", "task_statistics", "quality"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of total_statistics
        if self.total_statistics:
            _dict['total_statistics'] = self.total_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in trips_statistics (list)
        _items = []
        if self.trips_statistics:
            for _item in self.trips_statistics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trips_statistics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in locations_statistics (list)
        _items = []
        if self.locations_statistics:
            for _item in self.locations_statistics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['locations_statistics'] = _items
        # override the default output from pydantic by calling `to_dict()` of task_statistics
        if self.task_statistics:
            _dict['task_statistics'] = self.task_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if task_statistics (nullable) is None
        # and model_fields_set contains the field
        if self.task_statistics is None and "task_statistics" in self.model_fields_set:
            _dict['task_statistics'] = None

        # set to None if quality (nullable) is None
        # and model_fields_set contains the field
        if self.quality is None and "quality" in self.model_fields_set:
            _dict['quality'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_statistics": GeneralStatistics.from_dict(obj["total_statistics"]) if obj.get("total_statistics") is not None else None,
            "trips_statistics": [TripStatistics.from_dict(_item) for _item in obj["trips_statistics"]] if obj.get("trips_statistics") is not None else None,
            "locations_statistics": [LocationStatistics.from_dict(_item) for _item in obj["locations_statistics"]] if obj.get("locations_statistics") is not None else None,
            "task_statistics": TaskStatistics.from_dict(obj["task_statistics"]) if obj.get("task_statistics") is not None else None,
            "quality": Quality.from_dict(obj["quality"]) if obj.get("quality") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


