# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.14.2618
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.cargo_action import CargoAction
from vrt_lss_studio.models.trip_state_flag import TripStateFlag
from typing import Optional, Set
from typing_extensions import Self

class TripState(BaseModel):
    """
    Trip state.
    """ # noqa: E501
    time: datetime = Field(description="Start time according to the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6).")
    order_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the order with which an action is taken.")
    demand_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the demand with which an action is taken.")
    event_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the event at which an action is taken.")
    location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key of the location at which an action is taken.")
    flags: Annotated[List[TripStateFlag], Field(min_length=0, max_length=9)] = Field(description="List of flags, describing current state.     Values of flags responsible for geographic location (there can be several flags at the same time):   * `AROUND_LOCATION` - the performer is near the location - in the process of parking or leaving it.   * `INSIDE_LOCATION` - the performer is at the location.  Values of flags responsible for being in time windows (there can be several flags at the same time):   * `INSIDE_WORKING_WINDOW` - the performer is inside the working time window.   * `INSIDE_LOCATION_WINDOW` - the performer is inside the working time of the location.   * `INSIDE_EVENT_HARD_WINDOW` - the performer is inside the hard time window.   * `INSIDE_EVENT_SOFT_WINDOW` - the performer is inside the soft time window.  Values of flags responsible for actions (there can be only one flag at a time):   * `ON_DEMAND` - the performer has started working on the request.   * `WAITING` - the performer has started waiting.   * `RELOCATING` - the performer has started moving to the next stop.   * `BREAK` - the performer has started a break.   * `REST` - the performer has started a long rest.   * `ARRIVAL` - the performer has started parking.   * `DEPARTURE` - the performer has finished leaving the parking lot.  The values of the flags responsible for the logical state:   * `DURING_ROUNDTRIP` - the performer is making a roundtrip. ")
    cargo_actions: Optional[Annotated[List[CargoAction], Field(min_length=0, max_length=1000)]] = Field(default=None, description="List of actions with cargo in transport at the beginning of the state.")
    distance: Optional[Annotated[int, Field(le=4000000000, strict=True, ge=0)]] = Field(default=0, description="Cumulative distance from the start of the flight, in meters.")
    cost: Optional[Union[Annotated[float, Field(le=10000000000, strict=True, ge=0)], Annotated[int, Field(le=2147483647, strict=True, ge=0)]]] = Field(default=0, description="Cumulative cost calculated based on the performer's and transport tariffs.")
    reward: Optional[Union[Annotated[float, Field(le=10000000000, strict=True, ge=0)], Annotated[int, Field(le=2147483647, strict=True, ge=0)]]] = Field(default=0, description="Cumulative reward for orders fulfillment.")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["time", "order_key", "demand_key", "event_key", "location_key", "flags", "cargo_actions", "distance", "cost", "reward", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TripState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cargo_actions (list)
        _items = []
        if self.cargo_actions:
            for _item in self.cargo_actions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cargo_actions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if order_key (nullable) is None
        # and model_fields_set contains the field
        if self.order_key is None and "order_key" in self.model_fields_set:
            _dict['order_key'] = None

        # set to None if demand_key (nullable) is None
        # and model_fields_set contains the field
        if self.demand_key is None and "demand_key" in self.model_fields_set:
            _dict['demand_key'] = None

        # set to None if event_key (nullable) is None
        # and model_fields_set contains the field
        if self.event_key is None and "event_key" in self.model_fields_set:
            _dict['event_key'] = None

        # set to None if location_key (nullable) is None
        # and model_fields_set contains the field
        if self.location_key is None and "location_key" in self.model_fields_set:
            _dict['location_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TripState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "time": obj.get("time"),
            "order_key": obj.get("order_key"),
            "demand_key": obj.get("demand_key"),
            "event_key": obj.get("event_key"),
            "location_key": obj.get("location_key"),
            "flags": obj.get("flags"),
            "cargo_actions": [CargoAction.from_dict(_item) for _item in obj["cargo_actions"]] if obj.get("cargo_actions") is not None else None,
            "distance": obj.get("distance") if obj.get("distance") is not None else 0,
            "cost": obj.get("cost") if obj.get("cost") is not None else 0,
            "reward": obj.get("reward") if obj.get("reward") is not None else 0,
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


