# Generated by Django 3.1.12 on 2021-10-05 10:34

import django.db.models.deletion
import django_cryptography.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="FHEmployee",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employee_id",
                    models.CharField(
                        help_text="Unique employee ID from FactorialHR",
                        max_length=3000,
                        unique=True,
                    ),
                ),
                ("full_name", models.CharField(blank=True, max_length=300, null=True)),
                ("employee_object", models.JSONField(blank=True, null=True)),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "verbose_name": "Factorial: Employee",
                "verbose_name_plural": "Factorial: Employees",
            },
        ),
        migrations.CreateModel(
            name="FHOAuth",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "refresh_token",
                    django_cryptography.fields.encrypt(
                        models.CharField(max_length=3000)
                    ),
                ),
                (
                    "access_token",
                    django_cryptography.fields.encrypt(
                        models.CharField(max_length=3000)
                    ),
                ),
                ("expires_in", models.CharField(max_length=500)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                ("stale", models.BooleanField(default=False)),
                (
                    "site",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="factorial_oa",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Factorial: OAuth",
                "verbose_name_plural": "Factorial: OAuth",
            },
        ),
        migrations.CreateModel(
            name="FHTeam",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("team_id", models.CharField(max_length=100, unique=True)),
                ("name", models.CharField(max_length=200)),
                (
                    "oauth",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="factorial.fhoauth",
                    ),
                ),
            ],
            options={
                "verbose_name": "Factorial: Team",
                "verbose_name_plural": "Factorial: Teams",
            },
        ),
        migrations.CreateModel(
            name="FHTeamMember",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="teams",
                        to="factorial.fhemployee",
                    ),
                ),
                (
                    "team",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="members",
                        to="factorial.fhteam",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="FHTeamLead",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="teams_lead",
                        to="factorial.fhemployee",
                    ),
                ),
                (
                    "lead",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="leads",
                        to="factorial.fhteam",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.AddField(
            model_name="fhemployee",
            name="oauth",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="factorial.fhoauth"
            ),
        ),
    ]
