# -*- coding: utf-8 -*-
"""EVEN_20250325_00.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1stUKiAAfY_S1ord17cYblIgimL6gNrbL

# EasyVen

settings_ven.env から生成される環境変数を利用しやすい形で読み込む

```
2025/03/25 0.1.0 完成
2025/03/25 0.1.1 バグ取り
2025/03/25 0.1.2 バグ取り
2025/03/25 0.1.5 循環参照回避の試み
2025/03/27 0.1.6 バグ取り
```

# EasyVen

## 1. モジュール定義
"""

# @title a. EasyVen 定義
import os
from pathlib import Path
# env_file_list に読み込む.envファイルを指定（デフォルトは settings_ven.env）
get_ipython().system( "pip install an_DebugHelper" )
from an_debughelper import DebugHelper
get_ipython().system( "pip install an_EnvManager" )
from an_envmanager import EnvManager


class EasyVen:
    def __init__( self ):
        pass

    def setup( self,venv_name ):
        self.venv_name = venv_name

        self.debug = DebugHelper()
        self.debug = DebugHelper( instance_name = "EasyVen" )
        self.debug.enable_log_to_file_stdout()
        self.debug.enable_log_to_file_stderr()
        self.debug.enable_timestamp()

        # env_file_list に読み込む.envファイルを指定（デフォルトは settings_ven.env）
        self.envmanager = EnvManager(env_files=["settings_ven.env"])

        # 環境変数から各種パスを読み出し
        self.base_folder            = self.envmanager.get_env_var("Ven_base_folder")
        self.venv_folder            = self.envmanager.get_env_var("Ven_venv_folder")
        self.app_folder             = self.envmanager.get_env_var("Ven_app_folder")
        self.venv_config_folder     = self.envmanager.get_env_var("Ven_venv_config_folder")
        self.venv_contents_folder   = self.envmanager.get_env_var("Ven_venv_contents_folder")
        self.local_venv_folder      = self.envmanager.get_env_var("Ven_local_venv_folder")
        self.local_app_folder       = self.envmanager.get_env_var("Ven_local_app_folder")
        self.archive_folder         = self.envmanager.get_env_var("Ven_archive_folder")

        self.bch_path = os.path.join( self.venv_contents_folder )
        self.dst_path = os.path.join( self.local_venv_folder )

        self.cur_path = Path( self.base_folder )
        self.src_path = Path( self.venv_folder ).joinpath( self.venv_name, self.venv_contents_folder )
        self.arc_path = Path( self.archive_folder ).joinpath( "arcvenv" ).with_suffix( ".tar.gz" )
        self.lcl_path = Path( self.local_venv_folder ).joinpath( self.venv_name, self.venv_contents_folder )
        self.bin_path = self.lcl_path.joinpath( "bin" )
        self.lib_path = self.lcl_path.joinpath( "lib" )

        self.debug.log_step( f"venv_name : { self.venv_name }", success = None )
        self.debug.log_step( f"bch_path  : { self.bch_path }", success = None )
        self.debug.log_step( f"dst_path  : { self.dst_path }", success = None )
        self.debug.log_step( f"cur_path  : { self.cur_path }", success = None )
        self.debug.log_step( f"src_path  : { self.src_path }", success = None )
        self.debug.log_step( f"arc_path  : { self.arc_path }", success = None )
        self.debug.log_step( f"lcl_path  : { self.lcl_path }", success = None )
        self.debug.log_step( f"bin_path  : { self.bin_path }", success = None )
        self.debug.log_step( f"lib_path  : { self.lib_path }", success = None )

        return  [ self.bch_path,
                  self.dst_path,
                  self.cur_path,
                  self.src_path,
                  self.arc_path,
                  self.lcl_path,
                  self.bin_path,
                  self.lib_path ]

if __name__ == "__main__":
    from google.colab import drive
    drive.mount( '/content/drive' )
    even = EasyVen()
    [ bch_path,
      dst_path,
      cur_path,
      src_path,
      arc_path,
      lcl_path,
      bin_path,
      lib_path ] = even.setup( venv_name = "kohya_env" )