# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['WirelessSsidsIdentityPsksArgs', 'WirelessSsidsIdentityPsks']

@pulumi.input_type
class WirelessSsidsIdentityPsksArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 number: pulumi.Input[str],
                 expires_at: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 identity_psk_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passphrase: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WirelessSsidsIdentityPsks resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[str] expires_at: Timestamp for when the Identity PSK expires, or 'null' to never expire
        :param pulumi.Input[str] group_policy_id: The group policy to be applied to clients
        :param pulumi.Input[str] identity_psk_id: identityPskId path parameter. Identity psk ID
        :param pulumi.Input[str] name: The name of the Identity PSK
        :param pulumi.Input[str] passphrase: The passphrase for client authentication
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if identity_psk_id is not None:
            pulumi.set(__self__, "identity_psk_id", identity_psk_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[str]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp for when the Identity PSK expires, or 'null' to never expire
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group policy to be applied to clients
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)

    @property
    @pulumi.getter(name="identityPskId")
    def identity_psk_id(self) -> Optional[pulumi.Input[str]]:
        """
        identityPskId path parameter. Identity psk ID
        """
        return pulumi.get(self, "identity_psk_id")

    @identity_psk_id.setter
    def identity_psk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_psk_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Identity PSK
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        The passphrase for client authentication
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passphrase", value)


@pulumi.input_type
class _WirelessSsidsIdentityPsksState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 identity_psk_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 passphrase: Optional[pulumi.Input[str]] = None,
                 wifi_personal_network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsIdentityPsks resources.
        :param pulumi.Input[str] email: The email associated with the System's Manager User
        :param pulumi.Input[str] expires_at: Timestamp for when the Identity PSK expires, or 'null' to never expire
        :param pulumi.Input[str] group_policy_id: The group policy to be applied to clients
        :param pulumi.Input[str] identity_psk_id: identityPskId path parameter. Identity psk ID
        :param pulumi.Input[str] name: The name of the Identity PSK
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[str] passphrase: The passphrase for client authentication
        :param pulumi.Input[str] wifi_personal_network_id: The WiFi Personal Network unique identifier
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if identity_psk_id is not None:
            pulumi.set(__self__, "identity_psk_id", identity_psk_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if wifi_personal_network_id is not None:
            pulumi.set(__self__, "wifi_personal_network_id", wifi_personal_network_id)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email associated with the System's Manager User
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp for when the Identity PSK expires, or 'null' to never expire
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group policy to be applied to clients
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)

    @property
    @pulumi.getter(name="identityPskId")
    def identity_psk_id(self) -> Optional[pulumi.Input[str]]:
        """
        identityPskId path parameter. Identity psk ID
        """
        return pulumi.get(self, "identity_psk_id")

    @identity_psk_id.setter
    def identity_psk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_psk_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Identity PSK
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        The passphrase for client authentication
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passphrase", value)

    @property
    @pulumi.getter(name="wifiPersonalNetworkId")
    def wifi_personal_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The WiFi Personal Network unique identifier
        """
        return pulumi.get(self, "wifi_personal_network_id")

    @wifi_personal_network_id.setter
    def wifi_personal_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wifi_personal_network_id", value)


class WirelessSsidsIdentityPsks(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 identity_psk_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 passphrase: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsIdentityPsks("example",
            expires_at="2018-02-11T00:00:00.090210Z",
            group_policy_id="101",
            name="Sample Identity PSK",
            network_id="string",
            number="string",
            passphrase="secret")
        pulumi.export("merakiNetworksWirelessSsidsIdentityPsksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsIdentityPsks:WirelessSsidsIdentityPsks example "identity_psk_id,network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expires_at: Timestamp for when the Identity PSK expires, or 'null' to never expire
        :param pulumi.Input[str] group_policy_id: The group policy to be applied to clients
        :param pulumi.Input[str] identity_psk_id: identityPskId path parameter. Identity psk ID
        :param pulumi.Input[str] name: The name of the Identity PSK
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[str] passphrase: The passphrase for client authentication
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsIdentityPsksArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.WirelessSsidsIdentityPsks("example",
            expires_at="2018-02-11T00:00:00.090210Z",
            group_policy_id="101",
            name="Sample Identity PSK",
            network_id="string",
            number="string",
            passphrase="secret")
        pulumi.export("merakiNetworksWirelessSsidsIdentityPsksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsIdentityPsks:WirelessSsidsIdentityPsks example "identity_psk_id,network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsIdentityPsksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsIdentityPsksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 identity_psk_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 passphrase: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsIdentityPsksArgs.__new__(WirelessSsidsIdentityPsksArgs)

            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["group_policy_id"] = group_policy_id
            __props__.__dict__["identity_psk_id"] = identity_psk_id
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["passphrase"] = passphrase
            __props__.__dict__["email"] = None
            __props__.__dict__["wifi_personal_network_id"] = None
        super(WirelessSsidsIdentityPsks, __self__).__init__(
            'meraki:networks/wirelessSsidsIdentityPsks:WirelessSsidsIdentityPsks',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            expires_at: Optional[pulumi.Input[str]] = None,
            group_policy_id: Optional[pulumi.Input[str]] = None,
            identity_psk_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            number: Optional[pulumi.Input[str]] = None,
            passphrase: Optional[pulumi.Input[str]] = None,
            wifi_personal_network_id: Optional[pulumi.Input[str]] = None) -> 'WirelessSsidsIdentityPsks':
        """
        Get an existing WirelessSsidsIdentityPsks resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The email associated with the System's Manager User
        :param pulumi.Input[str] expires_at: Timestamp for when the Identity PSK expires, or 'null' to never expire
        :param pulumi.Input[str] group_policy_id: The group policy to be applied to clients
        :param pulumi.Input[str] identity_psk_id: identityPskId path parameter. Identity psk ID
        :param pulumi.Input[str] name: The name of the Identity PSK
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[str] passphrase: The passphrase for client authentication
        :param pulumi.Input[str] wifi_personal_network_id: The WiFi Personal Network unique identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsIdentityPsksState.__new__(_WirelessSsidsIdentityPsksState)

        __props__.__dict__["email"] = email
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["group_policy_id"] = group_policy_id
        __props__.__dict__["identity_psk_id"] = identity_psk_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["passphrase"] = passphrase
        __props__.__dict__["wifi_personal_network_id"] = wifi_personal_network_id
        return WirelessSsidsIdentityPsks(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email associated with the System's Manager User
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[str]:
        """
        Timestamp for when the Identity PSK expires, or 'null' to never expire
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> pulumi.Output[str]:
        """
        The group policy to be applied to clients
        """
        return pulumi.get(self, "group_policy_id")

    @property
    @pulumi.getter(name="identityPskId")
    def identity_psk_id(self) -> pulumi.Output[str]:
        """
        identityPskId path parameter. Identity psk ID
        """
        return pulumi.get(self, "identity_psk_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Identity PSK
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[str]:
        """
        The passphrase for client authentication
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="wifiPersonalNetworkId")
    def wifi_personal_network_id(self) -> pulumi.Output[str]:
        """
        The WiFi Personal Network unique identifier
        """
        return pulumi.get(self, "wifi_personal_network_id")

