"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import GetCollateralRecordResponse
from ..models import GetFlexiblePersonalLeftQuotaResponse
from ..models import GetFlexibleProductPositionResponse
from ..models import GetFlexibleRedemptionRecordResponse
from ..models import GetFlexibleRewardsHistoryResponse
from ..models import GetFlexibleSubscriptionPreviewResponse
from ..models import GetFlexibleSubscriptionRecordResponse
from ..models import GetLockedPersonalLeftQuotaResponse
from ..models import GetLockedProductPositionResponse
from ..models import GetLockedRedemptionRecordResponse
from ..models import GetLockedRewardsHistoryResponse
from ..models import GetLockedSubscriptionPreviewResponse
from ..models import GetLockedSubscriptionRecordResponse
from ..models import GetRateHistoryResponse
from ..models import GetSimpleEarnFlexibleProductListResponse
from ..models import GetSimpleEarnLockedProductListResponse
from ..models import RedeemFlexibleProductResponse
from ..models import RedeemLockedProductResponse
from ..models import SetFlexibleAutoSubscribeResponse
from ..models import SetLockedAutoSubscribeResponse
from ..models import SetLockedProductRedeemOptionResponse
from ..models import SimpleAccountResponse
from ..models import SubscribeFlexibleProductResponse
from ..models import SubscribeLockedProductResponse


class FlexibleLockedApi:
    """API Client for FlexibleLockedApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def get_collateral_record(
        self,
        product_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCollateralRecordResponse]:
        """
                Get Collateral Record(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/history/collateralRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Collateral-Record

                Get Collateral Record

        * The time between `startTime` and `endTime` cannot be longer than 30 days.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 1

                Args:
                    product_id (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCollateralRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "product_id": product_id,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/history/collateralRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetCollateralRecordResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_personal_left_quota(
        self,
        product_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexiblePersonalLeftQuotaResponse]:
        """
                Get Flexible Personal Left Quota(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/personalLeftQuota
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Flexible-Personal-Left-Quota

                Get Flexible Personal Left Quota

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexiblePersonalLeftQuotaResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )

        payload = {"product_id": product_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/personalLeftQuota",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexiblePersonalLeftQuotaResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_product_position(
        self,
        asset: Optional[str] = None,
        product_id: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleProductPositionResponse]:
        """
                Get Flexible Product Position(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/position
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Flexible-Product-Position

                Get Flexible Product Position

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    product_id (Optional[str] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleProductPositionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "product_id": product_id,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/position",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleProductPositionResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_redemption_record(
        self,
        product_id: Optional[str] = None,
        redeem_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleRedemptionRecordResponse]:
        """
                Get Flexible Redemption Record(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/history/redemptionRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Flexible-Redemption-Record

                Get Flexible Redemption Record

        *	The time between `startTime` and `endTime` cannot be longer than 3 months.
        *	If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        *	If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        *	If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Optional[str] = None):
                    redeem_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleRedemptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "product_id": product_id,
            "redeem_id": redeem_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/history/redemptionRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleRedemptionRecordResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_rewards_history(
        self,
        type: Union[str, None],
        product_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleRewardsHistoryResponse]:
        """
                Get Flexible Rewards History(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/history/rewardsRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Flexible-Rewards-History

                Get Flexible Rewards History

        *	The time between `startTime` and `endTime` cannot be longer than 3 months.
        *	If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        *	If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        *	If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    type (Union[str, None]): FAST or STANDARD, defaults to STANDARD
                    product_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "type": type,
            "product_id": product_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/history/rewardsRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleRewardsHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_subscription_preview(
        self,
        product_id: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleSubscriptionPreviewResponse]:
        """
                Get Flexible Subscription Preview(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/subscriptionPreview
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Get-Flexible-Subscription-Preview

                Get Flexible Subscription Preview

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleSubscriptionPreviewResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "product_id": product_id,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/subscriptionPreview",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleSubscriptionPreviewResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_subscription_record(
        self,
        product_id: Optional[str] = None,
        purchase_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleSubscriptionRecordResponse]:
        """
                Get Flexible Subscription Record(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/history/subscriptionRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Flexible-Subscription-Record

                Get Flexible Subscription Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Optional[str] = None):
                    purchase_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleSubscriptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "product_id": product_id,
            "purchase_id": purchase_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/history/subscriptionRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleSubscriptionRecordResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_personal_left_quota(
        self,
        project_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedPersonalLeftQuotaResponse]:
        """
                Get Locked Personal Left Quota(USER_DATA)
                GET /sapi/v1/simple-earn/locked/personalLeftQuota
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Locked-Personal-Left-Quota

                Get Locked Personal Left Quota

        Weight: 150

                Args:
                    project_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedPersonalLeftQuotaResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if project_id is None:
            raise RequiredError(
                field="project_id",
                error_message="Missing required parameter 'project_id'",
            )

        payload = {"project_id": project_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/personalLeftQuota",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedPersonalLeftQuotaResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_product_position(
        self,
        asset: Optional[str] = None,
        position_id: Optional[int] = None,
        project_id: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedProductPositionResponse]:
        """
                Get Locked Product Position
                GET /sapi/v1/simple-earn/locked/position
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Locked-Product-Position

                Get Locked Product Position

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    position_id (Optional[int] = None):
                    project_id (Optional[str] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedProductPositionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "position_id": position_id,
            "project_id": project_id,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/position",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedProductPositionResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_redemption_record(
        self,
        position_id: Optional[int] = None,
        redeem_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedRedemptionRecordResponse]:
        """
                Get Locked Redemption Record(USER_DATA)
                GET /sapi/v1/simple-earn/locked/history/redemptionRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Locked-Redemption-Record

                Get Locked Redemption Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    position_id (Optional[int] = None):
                    redeem_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedRedemptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "position_id": position_id,
            "redeem_id": redeem_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/history/redemptionRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedRedemptionRecordResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_rewards_history(
        self,
        position_id: Optional[int] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedRewardsHistoryResponse]:
        """
                Get Locked Rewards History(USER_DATA)
                GET /sapi/v1/simple-earn/locked/history/rewardsRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Locked-Rewards-History

                Get Locked Rewards History

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    position_id (Optional[int] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "position_id": position_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/history/rewardsRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedRewardsHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_subscription_preview(
        self,
        project_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedSubscriptionPreviewResponse]:
        """
                Get Locked Subscription Preview(USER_DATA)
                GET /sapi/v1/simple-earn/locked/subscriptionPreview
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Get-Locked-Subscription-Preview

                Get Locked Subscription Preview

        Weight: 150

                Args:
                    project_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedSubscriptionPreviewResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if project_id is None:
            raise RequiredError(
                field="project_id",
                error_message="Missing required parameter 'project_id'",
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "project_id": project_id,
            "amount": amount,
            "auto_subscribe": auto_subscribe,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/subscriptionPreview",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedSubscriptionPreviewResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_locked_subscription_record(
        self,
        purchase_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedSubscriptionRecordResponse]:
        """
                Get Locked Subscription Record(USER_DATA)
                GET /sapi/v1/simple-earn/locked/history/subscriptionRecord
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Locked-Subscription-Record

                Get Locked Subscription Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    purchase_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedSubscriptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "purchase_id": purchase_id,
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/history/subscriptionRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLockedSubscriptionRecordResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rate_history(
        self,
        product_id: Union[str, None],
        apr_period: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRateHistoryResponse]:
        """
                Get Rate History(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/history/rateHistory
                https://developers.binance.com/docs/simple_earn/flexible-locked/history/Get-Rate-History

                Get Rate History

        * The time between startTime and endTime cannot be longer than 1 year.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    apr_period (Optional[str] = None): "DAY","YEAR",default"DAY"
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )

        payload = {
            "product_id": product_id,
            "apr_period": apr_period,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/history/rateHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRateHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_simple_earn_flexible_product_list(
        self,
        asset: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSimpleEarnFlexibleProductListResponse]:
        """
                Get Simple Earn Flexible Product List(USER_DATA)
                GET /sapi/v1/simple-earn/flexible/list
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Simple-Earn-Flexible-Product-List

                Get available Simple Earn flexible product list

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSimpleEarnFlexibleProductListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/flexible/list",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSimpleEarnFlexibleProductListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_simple_earn_locked_product_list(
        self,
        asset: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSimpleEarnLockedProductListResponse]:
        """
                Get Simple Earn Locked Product List(USER_DATA)
                GET /sapi/v1/simple-earn/locked/list
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Get-Simple-Earn-Locked-Product-List

                Get Simple Earn Locked Product List

        * Get available Simple Earn locked product list

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSimpleEarnLockedProductListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/locked/list",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSimpleEarnLockedProductListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def redeem_flexible_product(
        self,
        product_id: Union[str, None],
        redeem_all: Optional[bool] = None,
        amount: Optional[float] = None,
        dest_account: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemFlexibleProductResponse]:
        """
                Redeem Flexible Product(TRADE)
                POST /sapi/v1/simple-earn/flexible/redeem
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Redeem-Flexible-Product

                Redeem Flexible Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    product_id (Union[str, None]):
                    redeem_all (Optional[bool] = None): true or false, default to false
                    amount (Optional[float] = None): if redeemAll is false, amount is mandatory
                    dest_account (Optional[str] = None): `SPOT`,`FUND`, default `SPOT`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemFlexibleProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )

        payload = {
            "product_id": product_id,
            "redeem_all": redeem_all,
            "amount": amount,
            "dest_account": dest_account,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/flexible/redeem",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RedeemFlexibleProductResponse,
            is_signed=True,
            signer=self._signer,
        )

    def redeem_locked_product(
        self,
        position_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemLockedProductResponse]:
        """
                Redeem Locked Product(TRADE)
                POST /sapi/v1/simple-earn/locked/redeem
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Redeem-Locked-Product

                Redeem Locked Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1/3s per account

                Args:
                    position_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemLockedProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if position_id is None:
            raise RequiredError(
                field="position_id",
                error_message="Missing required parameter 'position_id'",
            )

        payload = {"position_id": position_id, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/locked/redeem",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RedeemLockedProductResponse,
            is_signed=True,
            signer=self._signer,
        )

    def set_flexible_auto_subscribe(
        self,
        product_id: Union[str, None],
        auto_subscribe: Union[bool, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetFlexibleAutoSubscribeResponse]:
        """
                Set Flexible Auto Subscribe(USER_DATA)
                POST /sapi/v1/simple-earn/flexible/setAutoSubscribe
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Set-Flexible-Auto-Subscribe

                Set Flexible Auto Subscribe

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    auto_subscribe (Union[bool, None]): true or false
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetFlexibleAutoSubscribeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )
        if auto_subscribe is None:
            raise RequiredError(
                field="auto_subscribe",
                error_message="Missing required parameter 'auto_subscribe'",
            )

        payload = {
            "product_id": product_id,
            "auto_subscribe": auto_subscribe,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/flexible/setAutoSubscribe",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SetFlexibleAutoSubscribeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def set_locked_auto_subscribe(
        self,
        position_id: Union[str, None],
        auto_subscribe: Union[bool, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetLockedAutoSubscribeResponse]:
        """
                Set Locked Auto Subscribe(USER_DATA)
                POST /sapi/v1/simple-earn/locked/setAutoSubscribe
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Set-Locked-Auto-Subscribe

                Set locked auto subscribe

        Weight: 150

                Args:
                    position_id (Union[str, None]):
                    auto_subscribe (Union[bool, None]): true or false
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetLockedAutoSubscribeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if position_id is None:
            raise RequiredError(
                field="position_id",
                error_message="Missing required parameter 'position_id'",
            )
        if auto_subscribe is None:
            raise RequiredError(
                field="auto_subscribe",
                error_message="Missing required parameter 'auto_subscribe'",
            )

        payload = {
            "position_id": position_id,
            "auto_subscribe": auto_subscribe,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/locked/setAutoSubscribe",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SetLockedAutoSubscribeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def set_locked_product_redeem_option(
        self,
        position_id: Union[str, None],
        redeem_to: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetLockedProductRedeemOptionResponse]:
        """
                Set Locked Product Redeem Option(USER_DATA)
                POST /sapi/v1/simple-earn/locked/setRedeemOption
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Set-Locked-Redeem-Option

                Set redeem option for Locked product

        Weight: 50

                Args:
                    position_id (Union[str, None]):
                    redeem_to (Union[str, None]): `SPOT`,'FLEXIBLE'
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetLockedProductRedeemOptionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if position_id is None:
            raise RequiredError(
                field="position_id",
                error_message="Missing required parameter 'position_id'",
            )
        if redeem_to is None:
            raise RequiredError(
                field="redeem_to",
                error_message="Missing required parameter 'redeem_to'",
            )

        payload = {
            "position_id": position_id,
            "redeem_to": redeem_to,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/locked/setRedeemOption",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SetLockedProductRedeemOptionResponse,
            is_signed=True,
            signer=self._signer,
        )

    def simple_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SimpleAccountResponse]:
        """
                Simple Account(USER_DATA)
                GET /sapi/v1/simple-earn/account
                https://developers.binance.com/docs/simple_earn/flexible-locked/account/Simple-Account

                Simple Account query

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SimpleAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/simple-earn/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SimpleAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def subscribe_flexible_product(
        self,
        product_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        source_account: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeFlexibleProductResponse]:
        """
                Subscribe Flexible Product(TRADE)
                POST /sapi/v1/simple-earn/flexible/subscribe
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Subscribe-Flexible-Product

                Subscribe Flexible Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    product_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    source_account (Optional[str] = None): `SPOT`,`FUND`,`ALL`, default `SPOT`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeFlexibleProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if product_id is None:
            raise RequiredError(
                field="product_id",
                error_message="Missing required parameter 'product_id'",
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "product_id": product_id,
            "amount": amount,
            "auto_subscribe": auto_subscribe,
            "source_account": source_account,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/flexible/subscribe",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SubscribeFlexibleProductResponse,
            is_signed=True,
            signer=self._signer,
        )

    def subscribe_locked_product(
        self,
        project_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        source_account: Optional[str] = None,
        redeem_to: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeLockedProductResponse]:
        """
                Subscribe Locked Product(TRADE)
                POST /sapi/v1/simple-earn/locked/subscribe
                https://developers.binance.com/docs/simple_earn/flexible-locked/earn/Subscribe-Locked-Product

                Subscribe Locked Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    project_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    source_account (Optional[str] = None): `SPOT`,`FUND`,`ALL`, default `SPOT`
                    redeem_to (Optional[str] = None): `SPOT`,`FLEXIBLE`, default `FLEXIBLE`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeLockedProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if project_id is None:
            raise RequiredError(
                field="project_id",
                error_message="Missing required parameter 'project_id'",
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "project_id": project_id,
            "amount": amount,
            "auto_subscribe": auto_subscribe,
            "source_account": source_account,
            "redeem_to": redeem_to,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/simple-earn/locked/subscribe",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SubscribeLockedProductResponse,
            is_signed=True,
            signer=self._signer,
        )
