"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import GetRwusdAccountResponse
from ..models import GetRwusdQuotaDetailsResponse
from ..models import GetRwusdRateHistoryResponse
from ..models import GetRwusdRedemptionHistoryResponse
from ..models import GetRwusdRewardsHistoryResponse
from ..models import GetRwusdSubscriptionHistoryResponse
from ..models import RedeemRwusdResponse
from ..models import SubscribeRwusdResponse


class RwusdApi:
    """API Client for RwusdApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def get_rwusd_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdAccountResponse]:
        """
                Get RWUSD Account (USER_DATA)
                GET /sapi/v1/rwusd/account
                https://developers.binance.com/docs/simple_earn/rwusd/account/

                Get RWUSD account information.

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rwusd_quota_details(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdQuotaDetailsResponse]:
        """
                Get RWUSD Quota Details (USER_DATA)
                GET /sapi/v1/rwusd/quota
                https://developers.binance.com/docs/simple_earn/rwusd/account/Get-RWUSD-Quota-Details

                Get RWUSD quota details including subscription quota, fast redemption quota, and standard redemption quota.

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdQuotaDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/quota",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdQuotaDetailsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rwusd_rate_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRateHistoryResponse]:
        """
                Get RWUSD Rate History (USER_DATA)
                GET /sapi/v1/rwusd/history/rateHistory
                https://developers.binance.com/docs/simple_earn/rwusd/history/Get-RWUSD-Rate-History

                Get RWUSD rate history sorted by descending order.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/history/rateHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdRateHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rwusd_redemption_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRedemptionHistoryResponse]:
        """
                Get RWUSD Redemption History (USER_DATA)
                GET /sapi/v1/rwusd/history/redemptionHistory
                https://developers.binance.com/docs/simple_earn/rwusd/history/Get-RWUSD-Redemption-History

                Get RWUSD redemption history.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRedemptionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/history/redemptionHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdRedemptionHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rwusd_rewards_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRewardsHistoryResponse]:
        """
                Get RWUSD Rewards History (USER_DATA)
                GET /sapi/v1/rwusd/history/rewardsHistory
                https://developers.binance.com/docs/simple_earn/rwusd/history/Get-RWUSD-Rewards-History

                Get RWUSD rewards history.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/history/rewardsHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdRewardsHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_rwusd_subscription_history(
        self,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdSubscriptionHistoryResponse]:
        """
                Get RWUSD subscription history(USER_DATA)
                GET /sapi/v1/rwusd/history/subscriptionHistory
                https://developers.binance.com/docs/simple_earn/rwusd/history/Get-RWUSD-subscription-history

                Get RWUSD subscription history

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time advanced by one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdSubscriptionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/rwusd/history/subscriptionHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetRwusdSubscriptionHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def redeem_rwusd(
        self,
        amount: Union[float, None],
        type: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemRwusdResponse]:
        """
                Redeem RWUSD(TRADE)
                POST /sapi/v1/rwusd/redeem
                https://developers.binance.com/docs/simple_earn/rwusd/earn/Redeem-RWUSD

                Redeem RWUSD to USDC

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 150

                Args:
                    amount (Union[float, None]): Amount
                    type (Union[str, None]): FAST or STANDARD, defaults to STANDARD
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemRwusdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {"amount": amount, "type": type, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/rwusd/redeem",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=RedeemRwusdResponse,
            is_signed=True,
            signer=self._signer,
        )

    def subscribe_rwusd(
        self,
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeRwusdResponse]:
        """
                Subscribe RWUSD(TRADE)
                POST /sapi/v1/rwusd/subscribe
                https://developers.binance.com/docs/simple_earn/rwusd/earn/Subscribe-RWUSD

                Subscribe RWUSD

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 150

                Args:
                    asset (Union[str, None]): USDT or USDC (whichever is eligible)
                    amount (Union[float, None]): Amount
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeRwusdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {"asset": asset, "amount": amount, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/rwusd/subscribe",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SubscribeRwusdResponse,
            is_signed=True,
            signer=self._signer,
        )
