# coding: utf-8

"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_simple_earn.rest_api.models.get_flexible_product_position_response_rows_inner_tier_annual_percentage_rate import (
    GetFlexibleProductPositionResponseRowsInnerTierAnnualPercentageRate,
)
from typing import Set
from typing_extensions import Self


class GetFlexibleProductPositionResponseRowsInner(BaseModel):
    """
    GetFlexibleProductPositionResponseRowsInner
    """  # noqa: E501

    total_amount: Optional[StrictStr] = Field(default=None, alias="totalAmount")
    tier_annual_percentage_rate: Optional[
        GetFlexibleProductPositionResponseRowsInnerTierAnnualPercentageRate
    ] = Field(default=None, alias="tierAnnualPercentageRate")
    latest_annual_percentage_rate: Optional[StrictStr] = Field(
        default=None, alias="latestAnnualPercentageRate"
    )
    yesterday_airdrop_percentage_rate: Optional[StrictStr] = Field(
        default=None, alias="yesterdayAirdropPercentageRate"
    )
    asset: Optional[StrictStr] = None
    air_drop_asset: Optional[StrictStr] = Field(default=None, alias="airDropAsset")
    can_redeem: Optional[StrictBool] = Field(default=None, alias="canRedeem")
    collateral_amount: Optional[StrictStr] = Field(
        default=None, alias="collateralAmount"
    )
    product_id: Optional[StrictStr] = Field(default=None, alias="productId")
    yesterday_real_time_rewards: Optional[StrictStr] = Field(
        default=None, alias="yesterdayRealTimeRewards"
    )
    cumulative_bonus_rewards: Optional[StrictStr] = Field(
        default=None, alias="cumulativeBonusRewards"
    )
    cumulative_real_time_rewards: Optional[StrictStr] = Field(
        default=None, alias="cumulativeRealTimeRewards"
    )
    cumulative_total_rewards: Optional[StrictStr] = Field(
        default=None, alias="cumulativeTotalRewards"
    )
    auto_subscribe: Optional[StrictBool] = Field(default=None, alias="autoSubscribe")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "totalAmount",
        "tierAnnualPercentageRate",
        "latestAnnualPercentageRate",
        "yesterdayAirdropPercentageRate",
        "asset",
        "airDropAsset",
        "canRedeem",
        "collateralAmount",
        "productId",
        "yesterdayRealTimeRewards",
        "cumulativeBonusRewards",
        "cumulativeRealTimeRewards",
        "cumulativeTotalRewards",
        "autoSubscribe",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetFlexibleProductPositionResponseRowsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tier_annual_percentage_rate
        if self.tier_annual_percentage_rate:
            _dict["tierAnnualPercentageRate"] = (
                self.tier_annual_percentage_rate.to_dict()
            )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetFlexibleProductPositionResponseRowsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "totalAmount": obj.get("totalAmount"),
                "tierAnnualPercentageRate": (
                    GetFlexibleProductPositionResponseRowsInnerTierAnnualPercentageRate.from_dict(
                        obj["tierAnnualPercentageRate"]
                    )
                    if obj.get("tierAnnualPercentageRate") is not None
                    else None
                ),
                "latestAnnualPercentageRate": obj.get("latestAnnualPercentageRate"),
                "yesterdayAirdropPercentageRate": obj.get(
                    "yesterdayAirdropPercentageRate"
                ),
                "asset": obj.get("asset"),
                "airDropAsset": obj.get("airDropAsset"),
                "canRedeem": obj.get("canRedeem"),
                "collateralAmount": obj.get("collateralAmount"),
                "productId": obj.get("productId"),
                "yesterdayRealTimeRewards": obj.get("yesterdayRealTimeRewards"),
                "cumulativeBonusRewards": obj.get("cumulativeBonusRewards"),
                "cumulativeRealTimeRewards": obj.get("cumulativeRealTimeRewards"),
                "cumulativeTotalRewards": obj.get("cumulativeTotalRewards"),
                "autoSubscribe": obj.get("autoSubscribe"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
