# coding: utf-8

"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class GetLockedProductPositionResponseRowsInner(BaseModel):
    """
    GetLockedProductPositionResponseRowsInner
    """  # noqa: E501

    position_id: Optional[StrictInt] = Field(default=None, alias="positionId")
    parent_position_id: Optional[StrictInt] = Field(
        default=None, alias="parentPositionId"
    )
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    asset: Optional[StrictStr] = None
    amount: Optional[StrictStr] = None
    purchase_time: Optional[StrictStr] = Field(default=None, alias="purchaseTime")
    duration: Optional[StrictStr] = None
    accrual_days: Optional[StrictStr] = Field(default=None, alias="accrualDays")
    reward_asset: Optional[StrictStr] = Field(default=None, alias="rewardAsset")
    apy: Optional[StrictStr] = Field(default=None, alias="APY")
    reward_amt: Optional[StrictStr] = Field(default=None, alias="rewardAmt")
    extra_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="extraRewardAsset"
    )
    extra_reward_apr: Optional[StrictStr] = Field(default=None, alias="extraRewardAPR")
    est_extra_reward_amt: Optional[StrictStr] = Field(
        default=None, alias="estExtraRewardAmt"
    )
    boost_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="boostRewardAsset"
    )
    boost_apr: Optional[StrictStr] = Field(default=None, alias="boostApr")
    total_boost_reward_amt: Optional[StrictStr] = Field(
        default=None, alias="totalBoostRewardAmt"
    )
    next_pay: Optional[StrictStr] = Field(default=None, alias="nextPay")
    next_pay_date: Optional[StrictStr] = Field(default=None, alias="nextPayDate")
    pay_period: Optional[StrictStr] = Field(default=None, alias="payPeriod")
    redeem_amount_early: Optional[StrictStr] = Field(
        default=None, alias="redeemAmountEarly"
    )
    rewards_end_date: Optional[StrictStr] = Field(default=None, alias="rewardsEndDate")
    deliver_date: Optional[StrictStr] = Field(default=None, alias="deliverDate")
    redeem_period: Optional[StrictStr] = Field(default=None, alias="redeemPeriod")
    redeeming_amt: Optional[StrictStr] = Field(default=None, alias="redeemingAmt")
    redeem_to: Optional[StrictStr] = Field(default=None, alias="redeemTo")
    partial_amt_deliver_date: Optional[StrictStr] = Field(
        default=None, alias="partialAmtDeliverDate"
    )
    can_redeem_early: Optional[StrictBool] = Field(default=None, alias="canRedeemEarly")
    can_fast_redemption: Optional[StrictBool] = Field(
        default=None, alias="canFastRedemption"
    )
    auto_subscribe: Optional[StrictBool] = Field(default=None, alias="autoSubscribe")
    type: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    can_re_stake: Optional[StrictBool] = Field(default=None, alias="canReStake")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "positionId",
        "parentPositionId",
        "projectId",
        "asset",
        "amount",
        "purchaseTime",
        "duration",
        "accrualDays",
        "rewardAsset",
        "APY",
        "rewardAmt",
        "extraRewardAsset",
        "extraRewardAPR",
        "estExtraRewardAmt",
        "boostRewardAsset",
        "boostApr",
        "totalBoostRewardAmt",
        "nextPay",
        "nextPayDate",
        "payPeriod",
        "redeemAmountEarly",
        "rewardsEndDate",
        "deliverDate",
        "redeemPeriod",
        "redeemingAmt",
        "redeemTo",
        "partialAmtDeliverDate",
        "canRedeemEarly",
        "canFastRedemption",
        "autoSubscribe",
        "type",
        "status",
        "canReStake",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLockedProductPositionResponseRowsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLockedProductPositionResponseRowsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "positionId": obj.get("positionId"),
                "parentPositionId": obj.get("parentPositionId"),
                "projectId": obj.get("projectId"),
                "asset": obj.get("asset"),
                "amount": obj.get("amount"),
                "purchaseTime": obj.get("purchaseTime"),
                "duration": obj.get("duration"),
                "accrualDays": obj.get("accrualDays"),
                "rewardAsset": obj.get("rewardAsset"),
                "APY": obj.get("APY"),
                "rewardAmt": obj.get("rewardAmt"),
                "extraRewardAsset": obj.get("extraRewardAsset"),
                "extraRewardAPR": obj.get("extraRewardAPR"),
                "estExtraRewardAmt": obj.get("estExtraRewardAmt"),
                "boostRewardAsset": obj.get("boostRewardAsset"),
                "boostApr": obj.get("boostApr"),
                "totalBoostRewardAmt": obj.get("totalBoostRewardAmt"),
                "nextPay": obj.get("nextPay"),
                "nextPayDate": obj.get("nextPayDate"),
                "payPeriod": obj.get("payPeriod"),
                "redeemAmountEarly": obj.get("redeemAmountEarly"),
                "rewardsEndDate": obj.get("rewardsEndDate"),
                "deliverDate": obj.get("deliverDate"),
                "redeemPeriod": obj.get("redeemPeriod"),
                "redeemingAmt": obj.get("redeemingAmt"),
                "redeemTo": obj.get("redeemTo"),
                "partialAmtDeliverDate": obj.get("partialAmtDeliverDate"),
                "canRedeemEarly": obj.get("canRedeemEarly"),
                "canFastRedemption": obj.get("canFastRedemption"),
                "autoSubscribe": obj.get("autoSubscribe"),
                "type": obj.get("type"),
                "status": obj.get("status"),
                "canReStake": obj.get("canReStake"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
