# coding: utf-8

"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class GetLockedSubscriptionPreviewResponseInner(BaseModel):
    """
    GetLockedSubscriptionPreviewResponseInner
    """  # noqa: E501

    reward_asset: Optional[StrictStr] = Field(default=None, alias="rewardAsset")
    total_reward_amt: Optional[StrictStr] = Field(default=None, alias="totalRewardAmt")
    extra_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="extraRewardAsset"
    )
    est_total_extra_reward_amt: Optional[StrictStr] = Field(
        default=None, alias="estTotalExtraRewardAmt"
    )
    boost_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="boostRewardAsset"
    )
    est_daily_reward_amt: Optional[StrictStr] = Field(
        default=None, alias="estDailyRewardAmt"
    )
    next_pay: Optional[StrictStr] = Field(default=None, alias="nextPay")
    next_pay_date: Optional[StrictStr] = Field(default=None, alias="nextPayDate")
    value_date: Optional[StrictStr] = Field(default=None, alias="valueDate")
    rewards_end_date: Optional[StrictStr] = Field(default=None, alias="rewardsEndDate")
    deliver_date: Optional[StrictStr] = Field(default=None, alias="deliverDate")
    next_subscription_date: Optional[StrictStr] = Field(
        default=None, alias="nextSubscriptionDate"
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "rewardAsset",
        "totalRewardAmt",
        "extraRewardAsset",
        "estTotalExtraRewardAmt",
        "boostRewardAsset",
        "estDailyRewardAmt",
        "nextPay",
        "nextPayDate",
        "valueDate",
        "rewardsEndDate",
        "deliverDate",
        "nextSubscriptionDate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLockedSubscriptionPreviewResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLockedSubscriptionPreviewResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "rewardAsset": obj.get("rewardAsset"),
                "totalRewardAmt": obj.get("totalRewardAmt"),
                "extraRewardAsset": obj.get("extraRewardAsset"),
                "estTotalExtraRewardAmt": obj.get("estTotalExtraRewardAmt"),
                "boostRewardAsset": obj.get("boostRewardAsset"),
                "estDailyRewardAmt": obj.get("estDailyRewardAmt"),
                "nextPay": obj.get("nextPay"),
                "nextPayDate": obj.get("nextPayDate"),
                "valueDate": obj.get("valueDate"),
                "rewardsEndDate": obj.get("rewardsEndDate"),
                "deliverDate": obj.get("deliverDate"),
                "nextSubscriptionDate": obj.get("nextSubscriptionDate"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
