# coding: utf-8

"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_simple_earn.rest_api.models.get_rwusd_quota_details_response_fast_redemption_quota import (
    GetRwusdQuotaDetailsResponseFastRedemptionQuota,
)
from binance_sdk_simple_earn.rest_api.models.get_rwusd_quota_details_response_standard_redemption_quota import (
    GetRwusdQuotaDetailsResponseStandardRedemptionQuota,
)
from binance_sdk_simple_earn.rest_api.models.get_rwusd_quota_details_response_subscription_quota import (
    GetRwusdQuotaDetailsResponseSubscriptionQuota,
)
from typing import Set
from typing_extensions import Self


class GetRwusdQuotaDetailsResponse(BaseModel):
    """
    GetRwusdQuotaDetailsResponse
    """  # noqa: E501

    subscription_quota: Optional[GetRwusdQuotaDetailsResponseSubscriptionQuota] = Field(
        default=None, alias="subscriptionQuota"
    )
    fast_redemption_quota: Optional[GetRwusdQuotaDetailsResponseFastRedemptionQuota] = (
        Field(default=None, alias="fastRedemptionQuota")
    )
    standard_redemption_quota: Optional[
        GetRwusdQuotaDetailsResponseStandardRedemptionQuota
    ] = Field(default=None, alias="standardRedemptionQuota")
    subscribe_enable: Optional[StrictBool] = Field(
        default=None, alias="subscribeEnable"
    )
    redeem_enable: Optional[StrictBool] = Field(default=None, alias="redeemEnable")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "subscriptionQuota",
        "fastRedemptionQuota",
        "standardRedemptionQuota",
        "subscribeEnable",
        "redeemEnable",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetRwusdQuotaDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of subscription_quota
        if self.subscription_quota:
            _dict["subscriptionQuota"] = self.subscription_quota.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fast_redemption_quota
        if self.fast_redemption_quota:
            _dict["fastRedemptionQuota"] = self.fast_redemption_quota.to_dict()
        # override the default output from pydantic by calling `to_dict()` of standard_redemption_quota
        if self.standard_redemption_quota:
            _dict["standardRedemptionQuota"] = self.standard_redemption_quota.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetRwusdQuotaDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "subscriptionQuota": (
                    GetRwusdQuotaDetailsResponseSubscriptionQuota.from_dict(
                        obj["subscriptionQuota"]
                    )
                    if obj.get("subscriptionQuota") is not None
                    else None
                ),
                "fastRedemptionQuota": (
                    GetRwusdQuotaDetailsResponseFastRedemptionQuota.from_dict(
                        obj["fastRedemptionQuota"]
                    )
                    if obj.get("fastRedemptionQuota") is not None
                    else None
                ),
                "standardRedemptionQuota": (
                    GetRwusdQuotaDetailsResponseStandardRedemptionQuota.from_dict(
                        obj["standardRedemptionQuota"]
                    )
                    if obj.get("standardRedemptionQuota") is not None
                    else None
                ),
                "subscribeEnable": obj.get("subscribeEnable"),
                "redeemEnable": obj.get("redeemEnable"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
