# coding: utf-8

"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class GetSimpleEarnLockedProductListResponseRowsInnerDetail(BaseModel):
    """
    GetSimpleEarnLockedProductListResponseRowsInnerDetail
    """  # noqa: E501

    asset: Optional[StrictStr] = None
    reward_asset: Optional[StrictStr] = Field(default=None, alias="rewardAsset")
    duration: Optional[StrictInt] = None
    renewable: Optional[StrictBool] = None
    is_sold_out: Optional[StrictBool] = Field(default=None, alias="isSoldOut")
    apr: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    subscription_start_time: Optional[StrictInt] = Field(
        default=None, alias="subscriptionStartTime"
    )
    extra_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="extraRewardAsset"
    )
    extra_reward_apr: Optional[StrictStr] = Field(default=None, alias="extraRewardAPR")
    boost_reward_asset: Optional[StrictStr] = Field(
        default=None, alias="boostRewardAsset"
    )
    boost_apr: Optional[StrictStr] = Field(default=None, alias="boostApr")
    boost_end_time: Optional[StrictInt] = Field(default=None, alias="boostEndTime")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "asset",
        "rewardAsset",
        "duration",
        "renewable",
        "isSoldOut",
        "apr",
        "status",
        "subscriptionStartTime",
        "extraRewardAsset",
        "extraRewardAPR",
        "boostRewardAsset",
        "boostApr",
        "boostEndTime",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetSimpleEarnLockedProductListResponseRowsInnerDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetSimpleEarnLockedProductListResponseRowsInnerDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "asset": obj.get("asset"),
                "rewardAsset": obj.get("rewardAsset"),
                "duration": obj.get("duration"),
                "renewable": obj.get("renewable"),
                "isSoldOut": obj.get("isSoldOut"),
                "apr": obj.get("apr"),
                "status": obj.get("status"),
                "subscriptionStartTime": obj.get("subscriptionStartTime"),
                "extraRewardAsset": obj.get("extraRewardAsset"),
                "extraRewardAPR": obj.get("extraRewardAPR"),
                "boostRewardAsset": obj.get("boostRewardAsset"),
                "boostApr": obj.get("boostApr"),
                "boostEndTime": obj.get("boostEndTime"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
