"""
Binance Simple Earn REST API

OpenAPI Specification for the Binance Simple Earn REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

import requests
from typing import Optional, TypeVar, Union
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request
from .api.flexible_locked_api import FlexibleLockedApi
from .api.rwusd_api import RwusdApi

from .models import GetCollateralRecordResponse
from .models import GetFlexiblePersonalLeftQuotaResponse
from .models import GetFlexibleProductPositionResponse
from .models import GetFlexibleRedemptionRecordResponse
from .models import GetFlexibleRewardsHistoryResponse
from .models import GetFlexibleSubscriptionPreviewResponse
from .models import GetFlexibleSubscriptionRecordResponse
from .models import GetLockedPersonalLeftQuotaResponse
from .models import GetLockedProductPositionResponse
from .models import GetLockedRedemptionRecordResponse
from .models import GetLockedRewardsHistoryResponse
from .models import GetLockedSubscriptionPreviewResponse
from .models import GetLockedSubscriptionRecordResponse
from .models import GetRateHistoryResponse
from .models import GetSimpleEarnFlexibleProductListResponse
from .models import GetSimpleEarnLockedProductListResponse
from .models import RedeemFlexibleProductResponse
from .models import RedeemLockedProductResponse
from .models import SetFlexibleAutoSubscribeResponse
from .models import SetLockedAutoSubscribeResponse
from .models import SetLockedProductRedeemOptionResponse
from .models import SimpleAccountResponse
from .models import SubscribeFlexibleProductResponse
from .models import SubscribeLockedProductResponse
from .models import GetRwusdAccountResponse
from .models import GetRwusdQuotaDetailsResponse
from .models import GetRwusdRateHistoryResponse
from .models import GetRwusdRedemptionHistoryResponse
from .models import GetRwusdRewardsHistoryResponse
from .models import GetRwusdSubscriptionHistoryResponse
from .models import RedeemRwusdResponse
from .models import SubscribeRwusdResponse


T = TypeVar("T")


class SimpleEarnRestAPI:
    def __init__(
        self,
        configuration: ConfigurationRestAPI,
    ) -> None:
        self.configuration = configuration
        self._session = requests.Session()
        self._signer = (
            Signers.get_signer(
                configuration.private_key, configuration.private_key_passphrase
            )
            if configuration.private_key is not None
            else None
        )

        self._flexibleLockedApi = FlexibleLockedApi(
            self.configuration, self._session, self._signer
        )
        self._rwusdApi = RwusdApi(self.configuration, self._session, self._signer)

    def send_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends an request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session, self.configuration, method, endpoint, params
        )

    def send_signed_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends a signed request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session,
            self.configuration,
            method,
            endpoint,
            params,
            is_signed=True,
            signer=self._signer,
        )

    def get_collateral_record(
        self,
        product_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCollateralRecordResponse]:
        """
                Get Collateral Record(USER_DATA)

                Get Collateral Record

        * The time between `startTime` and `endTime` cannot be longer than 30 days.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 1

                Args:
                    product_id (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCollateralRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_collateral_record(
            product_id, start_time, end_time, current, size, recv_window
        )

    def get_flexible_personal_left_quota(
        self,
        product_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexiblePersonalLeftQuotaResponse]:
        """
                Get Flexible Personal Left Quota(USER_DATA)

                Get Flexible Personal Left Quota

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexiblePersonalLeftQuotaResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_personal_left_quota(
            product_id, recv_window
        )

    def get_flexible_product_position(
        self,
        asset: Optional[str] = None,
        product_id: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleProductPositionResponse]:
        """
                Get Flexible Product Position(USER_DATA)

                Get Flexible Product Position

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    product_id (Optional[str] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleProductPositionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_product_position(
            asset, product_id, current, size, recv_window
        )

    def get_flexible_redemption_record(
        self,
        product_id: Optional[str] = None,
        redeem_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleRedemptionRecordResponse]:
        """
                Get Flexible Redemption Record(USER_DATA)

                Get Flexible Redemption Record

        *	The time between `startTime` and `endTime` cannot be longer than 3 months.
        *	If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        *	If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        *	If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Optional[str] = None):
                    redeem_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleRedemptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_redemption_record(
            product_id,
            redeem_id,
            asset,
            start_time,
            end_time,
            current,
            size,
            recv_window,
        )

    def get_flexible_rewards_history(
        self,
        type: Union[str, None],
        product_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleRewardsHistoryResponse]:
        """
                Get Flexible Rewards History(USER_DATA)

                Get Flexible Rewards History

        *	The time between `startTime` and `endTime` cannot be longer than 3 months.
        *	If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        *	If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        *	If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    type (Union[str, None]): FAST or STANDARD, defaults to STANDARD
                    product_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_rewards_history(
            type, product_id, asset, start_time, end_time, current, size, recv_window
        )

    def get_flexible_subscription_preview(
        self,
        product_id: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleSubscriptionPreviewResponse]:
        """
                Get Flexible Subscription Preview(USER_DATA)

                Get Flexible Subscription Preview

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleSubscriptionPreviewResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_subscription_preview(
            product_id, amount, recv_window
        )

    def get_flexible_subscription_record(
        self,
        product_id: Optional[str] = None,
        purchase_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleSubscriptionRecordResponse]:
        """
                Get Flexible Subscription Record(USER_DATA)

                Get Flexible Subscription Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Optional[str] = None):
                    purchase_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFlexibleSubscriptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_flexible_subscription_record(
            product_id,
            purchase_id,
            asset,
            start_time,
            end_time,
            current,
            size,
            recv_window,
        )

    def get_locked_personal_left_quota(
        self,
        project_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedPersonalLeftQuotaResponse]:
        """
                Get Locked Personal Left Quota(USER_DATA)

                Get Locked Personal Left Quota

        Weight: 150

                Args:
                    project_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedPersonalLeftQuotaResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_personal_left_quota(
            project_id, recv_window
        )

    def get_locked_product_position(
        self,
        asset: Optional[str] = None,
        position_id: Optional[int] = None,
        project_id: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedProductPositionResponse]:
        """
                Get Locked Product Position

                Get Locked Product Position

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    position_id (Optional[int] = None):
                    project_id (Optional[str] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedProductPositionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_product_position(
            asset, position_id, project_id, current, size, recv_window
        )

    def get_locked_redemption_record(
        self,
        position_id: Optional[int] = None,
        redeem_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedRedemptionRecordResponse]:
        """
                Get Locked Redemption Record(USER_DATA)

                Get Locked Redemption Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    position_id (Optional[int] = None):
                    redeem_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedRedemptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_redemption_record(
            position_id,
            redeem_id,
            asset,
            start_time,
            end_time,
            current,
            size,
            recv_window,
        )

    def get_locked_rewards_history(
        self,
        position_id: Optional[int] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedRewardsHistoryResponse]:
        """
                Get Locked Rewards History(USER_DATA)

                Get Locked Rewards History

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    position_id (Optional[int] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_rewards_history(
            position_id, asset, start_time, end_time, current, size, recv_window
        )

    def get_locked_subscription_preview(
        self,
        project_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedSubscriptionPreviewResponse]:
        """
                Get Locked Subscription Preview(USER_DATA)

                Get Locked Subscription Preview

        Weight: 150

                Args:
                    project_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedSubscriptionPreviewResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_subscription_preview(
            project_id, amount, auto_subscribe, recv_window
        )

    def get_locked_subscription_record(
        self,
        purchase_id: Optional[str] = None,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLockedSubscriptionRecordResponse]:
        """
                Get Locked Subscription Record(USER_DATA)

                Get Locked Subscription Record

        * The time between `startTime` and `endTime` cannot be longer than 3 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    purchase_id (Optional[str] = None):
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLockedSubscriptionRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_locked_subscription_record(
            purchase_id, asset, start_time, end_time, current, size, recv_window
        )

    def get_rate_history(
        self,
        product_id: Union[str, None],
        apr_period: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRateHistoryResponse]:
        """
                Get Rate History(USER_DATA)

                Get Rate History

        * The time between startTime and endTime cannot be longer than 1 year.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, the next 30 days' data beginning from `startTime` will be returned.
        * If `endTime` is sent but `startTime` is not sent, the 30 days' data before `endTime` will be returned.

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    apr_period (Optional[str] = None): "DAY","YEAR",default"DAY"
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_rate_history(
            product_id, apr_period, start_time, end_time, current, size, recv_window
        )

    def get_simple_earn_flexible_product_list(
        self,
        asset: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSimpleEarnFlexibleProductListResponse]:
        """
                Get Simple Earn Flexible Product List(USER_DATA)

                Get available Simple Earn flexible product list

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSimpleEarnFlexibleProductListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_simple_earn_flexible_product_list(
            asset, current, size, recv_window
        )

    def get_simple_earn_locked_product_list(
        self,
        asset: Optional[str] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSimpleEarnLockedProductListResponse]:
        """
                Get Simple Earn Locked Product List(USER_DATA)

                Get Simple Earn Locked Product List

        * Get available Simple Earn locked product list

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSimpleEarnLockedProductListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.get_simple_earn_locked_product_list(
            asset, current, size, recv_window
        )

    def redeem_flexible_product(
        self,
        product_id: Union[str, None],
        redeem_all: Optional[bool] = None,
        amount: Optional[float] = None,
        dest_account: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemFlexibleProductResponse]:
        """
                Redeem Flexible Product(TRADE)

                Redeem Flexible Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    product_id (Union[str, None]):
                    redeem_all (Optional[bool] = None): true or false, default to false
                    amount (Optional[float] = None): if redeemAll is false, amount is mandatory
                    dest_account (Optional[str] = None): `SPOT`,`FUND`, default `SPOT`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemFlexibleProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.redeem_flexible_product(
            product_id, redeem_all, amount, dest_account, recv_window
        )

    def redeem_locked_product(
        self,
        position_id: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemLockedProductResponse]:
        """
                Redeem Locked Product(TRADE)

                Redeem Locked Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1/3s per account

                Args:
                    position_id (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemLockedProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.redeem_locked_product(position_id, recv_window)

    def set_flexible_auto_subscribe(
        self,
        product_id: Union[str, None],
        auto_subscribe: Union[bool, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetFlexibleAutoSubscribeResponse]:
        """
                Set Flexible Auto Subscribe(USER_DATA)

                Set Flexible Auto Subscribe

        Weight: 150

                Args:
                    product_id (Union[str, None]):
                    auto_subscribe (Union[bool, None]): true or false
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetFlexibleAutoSubscribeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.set_flexible_auto_subscribe(
            product_id, auto_subscribe, recv_window
        )

    def set_locked_auto_subscribe(
        self,
        position_id: Union[str, None],
        auto_subscribe: Union[bool, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetLockedAutoSubscribeResponse]:
        """
                Set Locked Auto Subscribe(USER_DATA)

                Set locked auto subscribe

        Weight: 150

                Args:
                    position_id (Union[str, None]):
                    auto_subscribe (Union[bool, None]): true or false
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetLockedAutoSubscribeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.set_locked_auto_subscribe(
            position_id, auto_subscribe, recv_window
        )

    def set_locked_product_redeem_option(
        self,
        position_id: Union[str, None],
        redeem_to: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetLockedProductRedeemOptionResponse]:
        """
                Set Locked Product Redeem Option(USER_DATA)

                Set redeem option for Locked product

        Weight: 50

                Args:
                    position_id (Union[str, None]):
                    redeem_to (Union[str, None]): `SPOT`,'FLEXIBLE'
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetLockedProductRedeemOptionResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.set_locked_product_redeem_option(
            position_id, redeem_to, recv_window
        )

    def simple_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SimpleAccountResponse]:
        """
                Simple Account(USER_DATA)

                Simple Account query

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SimpleAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.simple_account(recv_window)

    def subscribe_flexible_product(
        self,
        product_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        source_account: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeFlexibleProductResponse]:
        """
                Subscribe Flexible Product(TRADE)

                Subscribe Flexible Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    product_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    source_account (Optional[str] = None): `SPOT`,`FUND`,`ALL`, default `SPOT`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeFlexibleProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.subscribe_flexible_product(
            product_id, amount, auto_subscribe, source_account, recv_window
        )

    def subscribe_locked_product(
        self,
        project_id: Union[str, None],
        amount: Union[float, None],
        auto_subscribe: Optional[bool] = None,
        source_account: Optional[str] = None,
        redeem_to: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeLockedProductResponse]:
        """
                Subscribe Locked Product(TRADE)

                Subscribe Locked Product

        * You need to open `Enable Spot & Margin Trading` permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    project_id (Union[str, None]):
                    amount (Union[float, None]): Amount
                    auto_subscribe (Optional[bool] = None): true or false, default true.
                    source_account (Optional[str] = None): `SPOT`,`FUND`,`ALL`, default `SPOT`
                    redeem_to (Optional[str] = None): `SPOT`,`FLEXIBLE`, default `FLEXIBLE`
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeLockedProductResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._flexibleLockedApi.subscribe_locked_product(
            project_id, amount, auto_subscribe, source_account, redeem_to, recv_window
        )

    def get_rwusd_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdAccountResponse]:
        """
                Get RWUSD Account (USER_DATA)

                Get RWUSD account information.

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_account(recv_window)

    def get_rwusd_quota_details(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdQuotaDetailsResponse]:
        """
                Get RWUSD Quota Details (USER_DATA)

                Get RWUSD quota details including subscription quota, fast redemption quota, and standard redemption quota.

        Weight: 150

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdQuotaDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_quota_details(recv_window)

    def get_rwusd_rate_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRateHistoryResponse]:
        """
                Get RWUSD Rate History (USER_DATA)

                Get RWUSD rate history sorted by descending order.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRateHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_rate_history(
            start_time, end_time, current, size, recv_window
        )

    def get_rwusd_redemption_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRedemptionHistoryResponse]:
        """
                Get RWUSD Redemption History (USER_DATA)

                Get RWUSD redemption history.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRedemptionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_redemption_history(
            start_time, end_time, current, size, recv_window
        )

    def get_rwusd_rewards_history(
        self,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdRewardsHistoryResponse]:
        """
                Get RWUSD Rewards History (USER_DATA)

                Get RWUSD rewards history.

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time minus one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdRewardsHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_rewards_history(
            start_time, end_time, current, size, recv_window
        )

    def get_rwusd_subscription_history(
        self,
        asset: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetRwusdSubscriptionHistoryResponse]:
        """
                Get RWUSD subscription history(USER_DATA)

                Get RWUSD subscription history

        * The time between `startTime` and `endTime` cannot be longer than 6 months.
        * If `startTime` and `endTime` are both not sent, then the last 30 days' data will be returned.
        * If `startTime` is sent but `endTime` is not sent, `endTime` will default to current time, and results from `startTime` onward will be returned.
        * If `endTime` is sent but `startTime` is not sent, `startTime` defaults to the current time advanced by one month, and data between `startTime` and `endTime` will be returned.

        Weight: 150

                Args:
                    asset (Optional[str] = None): USDC or USDT
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Currently querying the page. Start from 1. Default:1
                    size (Optional[int] = None): Default:10, Max:100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetRwusdSubscriptionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.get_rwusd_subscription_history(
            asset, start_time, end_time, current, size, recv_window
        )

    def redeem_rwusd(
        self,
        amount: Union[float, None],
        type: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[RedeemRwusdResponse]:
        """
                Redeem RWUSD(TRADE)

                Redeem RWUSD to USDC

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 150

                Args:
                    amount (Union[float, None]): Amount
                    type (Union[str, None]): FAST or STANDARD, defaults to STANDARD
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[RedeemRwusdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.redeem_rwusd(amount, type, recv_window)

    def subscribe_rwusd(
        self,
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubscribeRwusdResponse]:
        """
                Subscribe RWUSD(TRADE)

                Subscribe RWUSD

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 150

                Args:
                    asset (Union[str, None]): USDT or USDC (whichever is eligible)
                    amount (Union[float, None]): Amount
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubscribeRwusdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._rwusdApi.subscribe_rwusd(asset, amount, recv_window)
