import gzip
import json
import base64
import os
import urllib3

http = urllib3.PoolManager()

slack_webhook_url = os.getenv("SLACK_WEBHOOK_URL")
channel = os.getenv("SLACK_CHANNEL")
username = os.getenv("SLACK_USERNAME")
recipe_name = os.getenv("RECIPE_NAME")

def lambda_handler(event, context):
    print(f'Logging Event: {event}')
    print(f"Awslog: {event['awslogs']}")
    cw_data = event['awslogs']['data']

    compressed_payload = base64.b64decode(cw_data)
    uncompressed_payload = gzip.decompress(compressed_payload)
    print(uncompressed_payload)
    payload = json.loads(uncompressed_payload)

    log_events = payload['logEvents']
    for log_event in log_events:
        send_to_slack(log_event['message'])

def send_to_slack(message):
    msg = {
        "channel": channel,
        "username": username,
        "text": f'{recipe_name}: {message}',
        "icon_emoji": ""
    }
    
    encoded_msg = json.dumps(msg).encode('utf-8')
    resp = http.request('POST', slack_webhook_url, body=encoded_msg)
