"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const aws_logs_destinations_1 = require("aws-cdk-lib/aws-logs-destinations");
const snsSubscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
class SlackNotification extends constructs_1.Construct {
    constructor(scope, id, snsTopic, slackConfig, recipename) {
        super(scope, id);
        this.snsTopic = snsTopic;
        if (slackConfig.slackWebhookUrl && slackConfig.channel && slackConfig.username) {
            const pipelineSlackFn = new lambda.Function(this, 'PipelineSlackFunction', {
                runtime: lambda.Runtime.PYTHON_3_12,
                handler: 'main.lambda_handler',
                code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification')),
                environment: {
                    SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                    SLACK_CHANNEL: slackConfig.channel,
                    SLACK_USERNAME: slackConfig.username,
                },
            });
            this.snsTopic.addSubscription(new snsSubscriptions.LambdaSubscription(pipelineSlackFn));
            const fn = new lambda.Function(this, 'SubFiltSlackFunction', {
                runtime: lambda.Runtime.PYTHON_3_12,
                handler: 'main.lambda_handler',
                code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification-sub-filter')),
                environment: {
                    SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                    SLACK_CHANNEL: slackConfig.channel,
                    SLACK_USERNAME: slackConfig.username,
                    RECIPE_NAME: recipename,
                },
            });
            const logGroup = new logs.LogGroup(this, `${recipename}LogGroup`, {
                logGroupName: `/aws/imagebuilder/${recipename}`,
                retention: logs.RetentionDays.ONE_DAY,
            });
            new logs.SubscriptionFilter(this, 'SlackSubFilter', {
                destination: new aws_logs_destinations_1.LambdaDestination(fn),
                filterPattern: logs.FilterPattern.allTerms('Step'),
                logGroup: logGroup,
            });
        }
    }
}
exports.SlackNotification = SlackNotification;
_a = JSII_RTTI_SYMBOL_1;
SlackNotification[_a] = { fqn: "halloumi-ami-pipelines.SlackNotification", version: "0.0.40" };
//# sourceMappingURL=data:application/json;base64,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