"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentVersionBump = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ComponentVersionBump extends constructs_1.Construct {
    constructor(scope, id, componentName) {
        super(scope, id);
        this.componentName = componentName;
        const fn = new lambda.SingletonFunction(this, 'ComponentLatestVersion', {
            uuid: '2e19301f-4792-43a6-ba35-8899ff89a708',
            runtime: lambda.Runtime.PYTHON_3_12,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'component-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'ListComponents',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListComponents',
                    ],
                    Resource: '*',
                }),
            ],
            timeout: cdk.Duration.minutes(5),
        });
        const provider = new cr.Provider(this, `ComponentVersionProvider${this.componentName}`, {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ComponentLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                ComponentName: this.componentName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ComponentVersionBump = ComponentVersionBump;
//# sourceMappingURL=data:application/json;base64,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