"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayv2Domain = void 0;
/**
 * Defines an API Gateway V2 domain name as the alias target.
 *
 * @stability stable
 */
class ApiGatewayv2Domain {
    /**
     * @stability stable
     */
    constructor(domainName) {
        this.domainName = domainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            dnsName: this.domainName.regionalDomainName,
            hostedZoneId: this.domainName.regionalHostedZoneId,
        };
    }
}
exports.ApiGatewayv2Domain = ApiGatewayv2Domain;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXl2Mi1kb21haW4tbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaS1nYXRld2F5djItZG9tYWluLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFNQSxNQUFhLGtCQUFrQjs7OztJQUM3QixZQUE2QixVQUE4QjtRQUE5QixlQUFVLEdBQVYsVUFBVSxDQUFvQjtJQUFJLENBQUM7Ozs7OztJQUV6RCxJQUFJLENBQUMsT0FBMkI7UUFDckMsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLGtCQUFrQjtZQUMzQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxvQkFBb0I7U0FDbkQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQVRELGdEQVNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXBpZ3YyIGZyb20gJ0Bhd3MtY2RrL2F3cy1hcGlnYXRld2F5djInO1xuaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Myc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEFwaUdhdGV3YXl2MkRvbWFpbiBpbXBsZW1lbnRzIHJvdXRlNTMuSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkb21haW5OYW1lOiBhcGlndjIuSURvbWFpbk5hbWUpIHsgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBkbnNOYW1lOiB0aGlzLmRvbWFpbk5hbWUucmVnaW9uYWxEb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLmRvbWFpbk5hbWUucmVnaW9uYWxIb3N0ZWRab25lSWQsXG4gICAgfTtcbiAgfVxufVxuIl19