"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassicLoadBalancerTarget = void 0;
/**
 * Use a classic ELB as an alias record target.
 *
 * @stability stable
 */
class ClassicLoadBalancerTarget {
    /**
     * @stability stable
     */
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneNameId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.ClassicLoadBalancerTarget = ClassicLoadBalancerTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xhc3NpYy1sb2FkLWJhbGFuY2VyLXRhcmdldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsYXNzaWMtbG9hZC1iYWxhbmNlci10YXJnZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFNQSxNQUFhLHlCQUF5Qjs7OztJQUNwQyxZQUE2QixZQUE4QjtRQUE5QixpQkFBWSxHQUFaLFlBQVksQ0FBa0I7SUFDM0QsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE9BQTJCO1FBQ3JDLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxxQ0FBcUM7WUFDckUsT0FBTyxFQUFFLGFBQWEsSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRTtTQUM5RCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBVkQsOERBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGIgZnJvbSAnQGF3cy1jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5nJztcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBDbGFzc2ljTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxiLkxvYWRCYWxhbmNlcikge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0KTogcm91dGU1My5BbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGhvc3RlZFpvbmVJZDogdGhpcy5sb2FkQmFsYW5jZXIubG9hZEJhbGFuY2VyQ2Fub25pY2FsSG9zdGVkWm9uZU5hbWVJZCxcbiAgICAgIGRuc05hbWU6IGBkdWFsc3RhY2suJHt0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJEbnNOYW1lfWAsXG4gICAgfTtcbiAgfVxufVxuIl19