import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as route53 from '@aws-cdk/aws-route53';
/**
 * Use an ELBv2 as an alias record target.
 *
 * @stability stable
 */
export declare class LoadBalancerTarget implements route53.IAliasRecordTarget {
    private readonly loadBalancer;
    /**
     * @stability stable
     */
    constructor(loadBalancer: elbv2.ILoadBalancerV2);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
