# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAgentResult',
    'AwaitableGetAgentResult',
    'get_agent',
    'get_agent_output',
]

@pulumi.output_type
class GetAgentResult:
    """
    A collection of values returned by getAgent.
    """
    def __init__(__self__, agent_id=None, agent_pub_key=None, agent_type=None, agent_version=None, compartment_id=None, defined_tags=None, display_name=None, environment_id=None, freeform_tags=None, heart_beat_status=None, id=None, lifecycle_details=None, os_version=None, plugin_lists=None, state=None, system_tags=None, time_created=None, time_expire_agent_key_in_ms=None, time_last_sync_received=None, time_updated=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if agent_pub_key and not isinstance(agent_pub_key, str):
            raise TypeError("Expected argument 'agent_pub_key' to be a str")
        pulumi.set(__self__, "agent_pub_key", agent_pub_key)
        if agent_type and not isinstance(agent_type, str):
            raise TypeError("Expected argument 'agent_type' to be a str")
        pulumi.set(__self__, "agent_type", agent_type)
        if agent_version and not isinstance(agent_version, str):
            raise TypeError("Expected argument 'agent_version' to be a str")
        pulumi.set(__self__, "agent_version", agent_version)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if heart_beat_status and not isinstance(heart_beat_status, str):
            raise TypeError("Expected argument 'heart_beat_status' to be a str")
        pulumi.set(__self__, "heart_beat_status", heart_beat_status)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)
        if plugin_lists and not isinstance(plugin_lists, list):
            raise TypeError("Expected argument 'plugin_lists' to be a list")
        pulumi.set(__self__, "plugin_lists", plugin_lists)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expire_agent_key_in_ms and not isinstance(time_expire_agent_key_in_ms, str):
            raise TypeError("Expected argument 'time_expire_agent_key_in_ms' to be a str")
        pulumi.set(__self__, "time_expire_agent_key_in_ms", time_expire_agent_key_in_ms)
        if time_last_sync_received and not isinstance(time_last_sync_received, str):
            raise TypeError("Expected argument 'time_last_sync_received' to be a str")
        pulumi.set(__self__, "time_last_sync_received", time_last_sync_received)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="agentPubKey")
    def agent_pub_key(self) -> str:
        """
        Resource principal public key.
        """
        return pulumi.get(self, "agent_pub_key")

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> str:
        """
        Type of the Agent.
        """
        return pulumi.get(self, "agent_type")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Agent identifier, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        Environment identifier.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="heartBeatStatus")
    def heart_beat_status(self) -> str:
        """
        The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        """
        return pulumi.get(self, "heart_beat_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        OS version.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Sequence['outputs.GetAgentPluginListResult']:
        """
        List of plugins associated with the agent.
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpireAgentKeyInMs")
    def time_expire_agent_key_in_ms(self) -> str:
        """
        The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expire_agent_key_in_ms")

    @property
    @pulumi.getter(name="timeLastSyncReceived")
    def time_last_sync_received(self) -> str:
        """
        The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_sync_received")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAgentResult(GetAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentResult(
            agent_id=self.agent_id,
            agent_pub_key=self.agent_pub_key,
            agent_type=self.agent_type,
            agent_version=self.agent_version,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            environment_id=self.environment_id,
            freeform_tags=self.freeform_tags,
            heart_beat_status=self.heart_beat_status,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            os_version=self.os_version,
            plugin_lists=self.plugin_lists,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_expire_agent_key_in_ms=self.time_expire_agent_key_in_ms,
            time_last_sync_received=self.time_last_sync_received,
            time_updated=self.time_updated)


def get_agent(agent_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentResult:
    """
    This data source provides details about a specific Agent resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an Agent by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent = oci.CloudBridge.get_agent(agent_id=test_agent_oci_cloud_bridge_agent["id"])
    ```


    :param str agent_id: Unique Agent identifier path parameter.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAgent:getAgent', __args__, opts=opts, typ=GetAgentResult).value

    return AwaitableGetAgentResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        agent_pub_key=pulumi.get(__ret__, 'agent_pub_key'),
        agent_type=pulumi.get(__ret__, 'agent_type'),
        agent_version=pulumi.get(__ret__, 'agent_version'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        heart_beat_status=pulumi.get(__ret__, 'heart_beat_status'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        os_version=pulumi.get(__ret__, 'os_version'),
        plugin_lists=pulumi.get(__ret__, 'plugin_lists'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expire_agent_key_in_ms=pulumi.get(__ret__, 'time_expire_agent_key_in_ms'),
        time_last_sync_received=pulumi.get(__ret__, 'time_last_sync_received'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_agent_output(agent_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentResult]:
    """
    This data source provides details about a specific Agent resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an Agent by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent = oci.CloudBridge.get_agent(agent_id=test_agent_oci_cloud_bridge_agent["id"])
    ```


    :param str agent_id: Unique Agent identifier path parameter.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudBridge/getAgent:getAgent', __args__, opts=opts, typ=GetAgentResult)
    return __ret__.apply(lambda __response__: GetAgentResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        agent_pub_key=pulumi.get(__response__, 'agent_pub_key'),
        agent_type=pulumi.get(__response__, 'agent_type'),
        agent_version=pulumi.get(__response__, 'agent_version'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        heart_beat_status=pulumi.get(__response__, 'heart_beat_status'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        os_version=pulumi.get(__response__, 'os_version'),
        plugin_lists=pulumi.get(__response__, 'plugin_lists'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_expire_agent_key_in_ms=pulumi.get(__response__, 'time_expire_agent_key_in_ms'),
        time_last_sync_received=pulumi.get(__response__, 'time_last_sync_received'),
        time_updated=pulumi.get(__response__, 'time_updated')))
