# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSchedulingPlanResult',
    'AwaitableGetSchedulingPlanResult',
    'get_scheduling_plan',
    'get_scheduling_plan_output',
]

@pulumi.output_type
class GetSchedulingPlanResult:
    """
    A collection of values returned by getSchedulingPlan.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, estimated_time_in_mins=None, freeform_tags=None, id=None, is_using_recommended_scheduled_actions=None, lifecycle_details=None, plan_intent=None, resource_id=None, scheduling_plan_id=None, scheduling_policy_id=None, service_type=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins and not isinstance(estimated_time_in_mins, int):
            raise TypeError("Expected argument 'estimated_time_in_mins' to be a int")
        pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_using_recommended_scheduled_actions and not isinstance(is_using_recommended_scheduled_actions, bool):
            raise TypeError("Expected argument 'is_using_recommended_scheduled_actions' to be a bool")
        pulumi.set(__self__, "is_using_recommended_scheduled_actions", is_using_recommended_scheduled_actions)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if plan_intent and not isinstance(plan_intent, str):
            raise TypeError("Expected argument 'plan_intent' to be a str")
        pulumi.set(__self__, "plan_intent", plan_intent)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if scheduling_plan_id and not isinstance(scheduling_plan_id, str):
            raise TypeError("Expected argument 'scheduling_plan_id' to be a str")
        pulumi.set(__self__, "scheduling_plan_id", scheduling_plan_id)
        if scheduling_policy_id and not isinstance(scheduling_policy_id, str):
            raise TypeError("Expected argument 'scheduling_policy_id' to be a str")
        pulumi.set(__self__, "scheduling_policy_id", scheduling_policy_id)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the Scheduling Plan.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> int:
        """
        The estimated time for the Scheduling Plan.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUsingRecommendedScheduledActions")
    def is_using_recommended_scheduled_actions(self) -> bool:
        """
        If true, recommended scheduled actions will be generated for the scheduling plan.
        """
        return pulumi.get(self, "is_using_recommended_scheduled_actions")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="planIntent")
    def plan_intent(self) -> str:
        """
        The current intent the Scheduling Plan. Valid states is EXADATA_INFRASTRUCTURE_FULL_SOFTWARE_UPDATE.
        """
        return pulumi.get(self, "plan_intent")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> str:
        return pulumi.get(self, "scheduling_plan_id")

    @property
    @pulumi.getter(name="schedulingPolicyId")
    def scheduling_policy_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Policy.
        """
        return pulumi.get(self, "scheduling_policy_id")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> str:
        """
        The service type of the Scheduling Plan.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Scheduling Plan. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Scheduling Plan Resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the Scheduling Plan Resource was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSchedulingPlanResult(GetSchedulingPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulingPlanResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            estimated_time_in_mins=self.estimated_time_in_mins,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_using_recommended_scheduled_actions=self.is_using_recommended_scheduled_actions,
            lifecycle_details=self.lifecycle_details,
            plan_intent=self.plan_intent,
            resource_id=self.resource_id,
            scheduling_plan_id=self.scheduling_plan_id,
            scheduling_policy_id=self.scheduling_policy_id,
            service_type=self.service_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_scheduling_plan(scheduling_plan_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulingPlanResult:
    """
    This data source provides details about a specific Scheduling Plan resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_plan = oci.Database.get_scheduling_plan(scheduling_plan_id=test_scheduling_plan_oci_database_scheduling_plan["id"])
    ```


    :param str scheduling_plan_id: The Schedule Plan [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPlanId'] = scheduling_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSchedulingPlan:getSchedulingPlan', __args__, opts=opts, typ=GetSchedulingPlanResult).value

    return AwaitableGetSchedulingPlanResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__ret__, 'estimated_time_in_mins'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_using_recommended_scheduled_actions=pulumi.get(__ret__, 'is_using_recommended_scheduled_actions'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        plan_intent=pulumi.get(__ret__, 'plan_intent'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        scheduling_plan_id=pulumi.get(__ret__, 'scheduling_plan_id'),
        scheduling_policy_id=pulumi.get(__ret__, 'scheduling_policy_id'),
        service_type=pulumi.get(__ret__, 'service_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_scheduling_plan_output(scheduling_plan_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulingPlanResult]:
    """
    This data source provides details about a specific Scheduling Plan resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_plan = oci.Database.get_scheduling_plan(scheduling_plan_id=test_scheduling_plan_oci_database_scheduling_plan["id"])
    ```


    :param str scheduling_plan_id: The Schedule Plan [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPlanId'] = scheduling_plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSchedulingPlan:getSchedulingPlan', __args__, opts=opts, typ=GetSchedulingPlanResult)
    return __ret__.apply(lambda __response__: GetSchedulingPlanResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_time_in_mins=pulumi.get(__response__, 'estimated_time_in_mins'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_using_recommended_scheduled_actions=pulumi.get(__response__, 'is_using_recommended_scheduled_actions'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        plan_intent=pulumi.get(__response__, 'plan_intent'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        scheduling_plan_id=pulumi.get(__response__, 'scheduling_plan_id'),
        scheduling_policy_id=pulumi.get(__response__, 'scheduling_policy_id'),
        service_type=pulumi.get(__response__, 'service_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
