# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSensitiveTypeGroupResult',
    'AwaitableGetSensitiveTypeGroupResult',
    'get_sensitive_type_group',
    'get_sensitive_type_group_output',
]

@pulumi.output_type
class GetSensitiveTypeGroupResult:
    """
    A collection of values returned by getSensitiveTypeGroup.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, sensitive_type_count=None, sensitive_type_group_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sensitive_type_count and not isinstance(sensitive_type_count, int):
            raise TypeError("Expected argument 'sensitive_type_count' to be a int")
        pulumi.set(__self__, "sensitive_type_count", sensitive_type_count)
        if sensitive_type_group_id and not isinstance(sensitive_type_group_id, str):
            raise TypeError("Expected argument 'sensitive_type_group_id' to be a str")
        pulumi.set(__self__, "sensitive_type_group_id", sensitive_type_group_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the sensitive type group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the sensitive type group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the sensitive type group.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the sensitive type group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sensitiveTypeCount")
    def sensitive_type_count(self) -> int:
        """
        The number of sensitive types in the specified sensitive type group.
        """
        return pulumi.get(self, "sensitive_type_count")

    @property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> str:
        return pulumi.get(self, "sensitive_type_group_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the sensitive type group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the sensitive type group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the sensitive type group was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSensitiveTypeGroupResult(GetSensitiveTypeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveTypeGroupResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            sensitive_type_count=self.sensitive_type_count,
            sensitive_type_group_id=self.sensitive_type_group_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_sensitive_type_group(sensitive_type_group_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveTypeGroupResult:
    """
    This data source provides details about a specific Sensitive Type Group resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified sensitive type group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_type_group = oci.DataSafe.get_sensitive_type_group(sensitive_type_group_id=test_sensitive_type_group_oci_data_safe_sensitive_type_group["id"])
    ```


    :param str sensitive_type_group_id: The OCID of the sensitive type group.
    """
    __args__ = dict()
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveTypeGroup:getSensitiveTypeGroup', __args__, opts=opts, typ=GetSensitiveTypeGroupResult).value

    return AwaitableGetSensitiveTypeGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        sensitive_type_count=pulumi.get(__ret__, 'sensitive_type_count'),
        sensitive_type_group_id=pulumi.get(__ret__, 'sensitive_type_group_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_sensitive_type_group_output(sensitive_type_group_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveTypeGroupResult]:
    """
    This data source provides details about a specific Sensitive Type Group resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified sensitive type group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_type_group = oci.DataSafe.get_sensitive_type_group(sensitive_type_group_id=test_sensitive_type_group_oci_data_safe_sensitive_type_group["id"])
    ```


    :param str sensitive_type_group_id: The OCID of the sensitive type group.
    """
    __args__ = dict()
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveTypeGroup:getSensitiveTypeGroup', __args__, opts=opts, typ=GetSensitiveTypeGroupResult)
    return __ret__.apply(lambda __response__: GetSensitiveTypeGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        sensitive_type_count=pulumi.get(__response__, 'sensitive_type_count'),
        sensitive_type_group_id=pulumi.get(__response__, 'sensitive_type_group_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
