# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RecordArgs', 'Record']

@pulumi.input_type
class RecordArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 rtype: pulumi.Input[str],
                 zone_name_or_id: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 rdata: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Record resource.
        :param pulumi.Input[str] domain: The fully qualified domain name where the record can be located. Domain value is case insensitive.
        :param pulumi.Input[str] rtype: The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        :param pulumi.Input[str] zone_name_or_id: The name or OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        :param pulumi.Input[str] rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param pulumi.Input[int] ttl: (Updatable) The Time To Live for the record, in seconds.
        """
        if domain is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        pulumi.set(__self__, "domain", domain)
        if rtype is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""rtype is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        pulumi.set(__self__, "rtype", rtype)
        if zone_name_or_id is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""zone_name_or_id is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        pulumi.set(__self__, "zone_name_or_id", zone_name_or_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def domain(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name where the record can be located. Domain value is case insensitive.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def rtype(self) -> pulumi.Input[str]:
        """
        The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        """
        return pulumi.get(self, "rtype")

    @rtype.setter
    def rtype(self, value: pulumi.Input[str]):
        pulumi.set(self, "rtype", value)

    @property
    @pulumi.getter(name="zoneNameOrId")
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def zone_name_or_id(self) -> pulumi.Input[str]:
        """
        The name or OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_name_or_id")

    @zone_name_or_id.setter
    def zone_name_or_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_name_or_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def rdata(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @rdata.setter
    def rdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdata", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _RecordState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 is_protected: Optional[pulumi.Input[bool]] = None,
                 rdata: Optional[pulumi.Input[str]] = None,
                 record_hash: Optional[pulumi.Input[str]] = None,
                 rrset_version: Optional[pulumi.Input[str]] = None,
                 rtype: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_name_or_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Record resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        :param pulumi.Input[str] domain: The fully qualified domain name where the record can be located. Domain value is case insensitive.
        :param pulumi.Input[bool] is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param pulumi.Input[str] rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param pulumi.Input[str] record_hash: A unique identifier for the record within its zone.
        :param pulumi.Input[str] rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        :param pulumi.Input[str] rtype: The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        :param pulumi.Input[int] ttl: (Updatable) The Time To Live for the record, in seconds.
        :param pulumi.Input[str] zone_name_or_id: The name or OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if domain is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if is_protected is not None:
            pulumi.set(__self__, "is_protected", is_protected)
        if rdata is not None:
            pulumi.set(__self__, "rdata", rdata)
        if record_hash is not None:
            pulumi.set(__self__, "record_hash", record_hash)
        if rrset_version is not None:
            pulumi.set(__self__, "rrset_version", rrset_version)
        if rtype is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""rtype is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        if rtype is not None:
            pulumi.set(__self__, "rtype", rtype)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone_name_or_id is not None:
            warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
            pulumi.log.warn("""zone_name_or_id is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
        if zone_name_or_id is not None:
            pulumi.set(__self__, "zone_name_or_id", zone_name_or_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name where the record can be located. Domain value is case insensitive.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @is_protected.setter
    def is_protected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_protected", value)

    @property
    @pulumi.getter
    def rdata(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @rdata.setter
    def rdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rdata", value)

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @record_hash.setter
    def record_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_hash", value)

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> Optional[pulumi.Input[str]]:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @rrset_version.setter
    def rrset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rrset_version", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def rtype(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        """
        return pulumi.get(self, "rtype")

    @rtype.setter
    def rtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rtype", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="zoneNameOrId")
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def zone_name_or_id(self) -> Optional[pulumi.Input[str]]:
        """
        The name or OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_name_or_id")

    @zone_name_or_id.setter
    def zone_name_or_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_name_or_id", value)


class Record(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 rdata: Optional[pulumi.Input[str]] = None,
                 rtype: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        **Deprecated. Use Dns.Rrset instead.**

        This resource provides the Record resource in Oracle Cloud Infrastructure DNS service.

          Updates a collection of records in the specified zone.

        You can update one record or all records for the specified zone depending on the changes provided in the
        request body. You can also add or remove records using this function. When the zone name is provided as
        a path parameter and `PRIVATE` is used for the scope query parameter then the viewId query parameter is
        required.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_record = oci.dns.Record("test_record",
            zone_name_or_id=test_zone_name_or["id"],
            domain=record_items_domain,
            rtype=record_items_rtype,
            rdata=record_items_rdata,
            ttl=record_items_ttl)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        :param pulumi.Input[str] domain: The fully qualified domain name where the record can be located. Domain value is case insensitive.
        :param pulumi.Input[str] rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param pulumi.Input[str] rtype: The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        :param pulumi.Input[int] ttl: (Updatable) The Time To Live for the record, in seconds.
        :param pulumi.Input[str] zone_name_or_id: The name or OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Deprecated. Use Dns.Rrset instead.**

        This resource provides the Record resource in Oracle Cloud Infrastructure DNS service.

          Updates a collection of records in the specified zone.

        You can update one record or all records for the specified zone depending on the changes provided in the
        request body. You can also add or remove records using this function. When the zone name is provided as
        a path parameter and `PRIVATE` is used for the scope query parameter then the viewId query parameter is
        required.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_record = oci.dns.Record("test_record",
            zone_name_or_id=test_zone_name_or["id"],
            domain=record_items_domain,
            rtype=record_items_rtype,
            rdata=record_items_rdata,
            ttl=record_items_ttl)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 rdata: Optional[pulumi.Input[str]] = None,
                 rtype: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordArgs.__new__(RecordArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["rdata"] = rdata
            if rtype is None and not opts.urn:
                raise TypeError("Missing required property 'rtype'")
            __props__.__dict__["rtype"] = rtype
            __props__.__dict__["ttl"] = ttl
            if zone_name_or_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_name_or_id'")
            __props__.__dict__["zone_name_or_id"] = zone_name_or_id
            __props__.__dict__["is_protected"] = None
            __props__.__dict__["record_hash"] = None
            __props__.__dict__["rrset_version"] = None
        super(Record, __self__).__init__(
            'oci:Dns/record:Record',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            is_protected: Optional[pulumi.Input[bool]] = None,
            rdata: Optional[pulumi.Input[str]] = None,
            record_hash: Optional[pulumi.Input[str]] = None,
            rrset_version: Optional[pulumi.Input[str]] = None,
            rtype: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            zone_name_or_id: Optional[pulumi.Input[str]] = None) -> 'Record':
        """
        Get an existing Record resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        :param pulumi.Input[str] domain: The fully qualified domain name where the record can be located. Domain value is case insensitive.
        :param pulumi.Input[bool] is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param pulumi.Input[str] rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param pulumi.Input[str] record_hash: A unique identifier for the record within its zone.
        :param pulumi.Input[str] rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        :param pulumi.Input[str] rtype: The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        :param pulumi.Input[int] ttl: (Updatable) The Time To Live for the record, in seconds.
        :param pulumi.Input[str] zone_name_or_id: The name or OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordState.__new__(_RecordState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["is_protected"] = is_protected
        __props__.__dict__["rdata"] = rdata
        __props__.__dict__["record_hash"] = record_hash
        __props__.__dict__["rrset_version"] = rrset_version
        __props__.__dict__["rtype"] = rtype
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["zone_name_or_id"] = zone_name_or_id
        return Record(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The OCID of the compartment the resource belongs to. If supplied, it must match the Zone's compartment ocid.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def domain(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name where the record can be located. Domain value is case insensitive.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> pulumi.Output[bool]:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def rdata(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> pulumi.Output[str]:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> pulumi.Output[str]:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def rtype(self) -> pulumi.Output[str]:
        """
        The canonical name for the record's type, such as A or CNAME. For more information, see [Resource Record (RR) TYPEs](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4).
        """
        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="zoneNameOrId")
    @_utilities.deprecated("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")
    def zone_name_or_id(self) -> pulumi.Output[str]:
        """
        The name or OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_name_or_id")

