# This file is part of Karabo.
#
# http://www.karabo.eu
#
# Copyright (C) European XFEL GmbH Schenefeld. All rights reserved.
#
# Karabo is free software: you can redistribute it and/or modify it under
# the terms of the MPL-2 Mozilla Public License.
#
# You should have received a copy of the MPL-2 Public License along with
# Karabo. If not, see <https://www.mozilla.org/en-US/MPL/2.0/>.
#
# Karabo is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.
import os.path as op
import subprocess
import sys

import karabo.middlelayer as middlelayer


def test_code_quality_flake8():
    # Just run flake8 as if from the commandline
    command = [sys.executable, '-m', 'flake8',
               op.dirname(op.abspath(middlelayer.__file__))]
    subprocess.check_call(command)
