# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class DocumentEmpty(TLObject):
    """Attributes:
        LAYER: ``116``

    Attributes:
        ID: ``0x36f8c871``

    Parameters:
        id: ``int`` ``64-bit``

    See Also:
        This object can be returned by :obj:`account.UploadTheme <pyrogram.api.functions.account.UploadTheme>` and :obj:`messages.GetDocumentByHash <pyrogram.api.functions.messages.GetDocumentByHash>`.
    """

    __slots__ = ["id"]

    ID = 0x36f8c871
    QUALNAME = "types.DocumentEmpty"

    def __init__(self, *, id: int):
        self.id = id  # long

    @staticmethod
    def read(b: BytesIO, *args) -> "DocumentEmpty":
        # No flags
        
        id = Long.read(b)
        
        return DocumentEmpty(id=id)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Long(self.id))
        
        return b.getvalue()
