// Bardell's hierarchical functions

// Number of terms: 28

#include <stdlib.h>
#include <math.h>

#if defined(_WIN32) || defined(__WIN32__)
  #define EXPORTIT __declspec(dllexport)
#else
  #define EXPORTIT
#endif

EXPORTIT void vec_fuv(double *f, double xi, double xi1t, double xi2t) {
    f[0] = xi1t*(1.0/2.0 - 1.0/2.0*xi);
    f[1] = xi2t*((1.0/2.0)*xi + 1.0/2.0);
    f[2] = 0.125*pow(xi, 4) - 0.25*pow(xi, 2) + 0.125;
    f[3] = 0.125*pow(xi, 5) - 0.25*pow(xi, 3) + 0.125*xi;
    f[4] = 0.14583333333333334*pow(xi, 6) - 0.3125*pow(xi, 4) + 0.1875*pow(xi, 2) - 0.020833333333333332;
    f[5] = 0.1875*pow(xi, 7) - 0.4375*pow(xi, 5) + 0.3125*pow(xi, 3) - 0.0625*xi;
    f[6] = 0.2578125*pow(xi, 8) - 0.65625*pow(xi, 6) + 0.546875*pow(xi, 4) - 0.15625*pow(xi, 2) + 0.0078125;
    f[7] = 0.37239583333333331*pow(xi, 9) - 1.03125*pow(xi, 7) + 0.984375*pow(xi, 5) - 0.36458333333333331*pow(xi, 3) + 0.0390625*xi;
    f[8] = 0.55859375*pow(xi, 10) - 1.67578125*pow(xi, 8) + 1.8046875*pow(xi, 6) - 0.8203125*pow(xi, 4) + 0.13671875*pow(xi, 2) - 0.00390625;
    f[9] = 0.86328125*pow(xi, 11) - 2.79296875*pow(xi, 9) + 3.3515625*pow(xi, 7) - 1.8046875*pow(xi, 5) + 0.41015625*pow(xi, 3) - 0.02734375*xi;
    f[10] = 1.3668619791666667*pow(xi, 12) - 4.748046875*pow(xi, 10) + 6.2841796875*pow(xi, 8) - 3.91015625*pow(xi, 6) + 1.1279296875*pow(xi, 4) - 0.123046875*pow(xi, 2) + 0.0022786458333333335;
    f[11] = 2.2080078125*pow(xi, 13) - 8.201171875*pow(xi, 11) + 11.8701171875*pow(xi, 9) - 8.37890625*pow(xi, 7) + 2.9326171875*pow(xi, 5) - 0.451171875*pow(xi, 3) + 0.0205078125*xi;
    f[12] = 3.62744140625*pow(xi, 14) - 14.35205078125*pow(xi, 12) + 22.55322265625*pow(xi, 10) - 17.80517578125*pow(xi, 8) + 7.33154296875*pow(xi, 6) - 1.46630859375*pow(xi, 4) + 0.11279296875*pow(xi, 2) - 0.00146484375;
    f[13] = 6.045735677083333*pow(xi, 15) - 25.39208984375*pow(xi, 13) + 43.05615234375*pow(xi, 11) - 37.588704427083336*pow(xi, 9) + 17.80517578125*pow(xi, 7) - 4.39892578125*pow(xi, 5) + 0.48876953125*pow(xi, 3) - 0.01611328125*xi;
    f[14] = 10.202178955078125*pow(xi, 16) - 45.343017578125*pow(xi, 14) + 82.5242919921875*pow(xi, 12) - 78.936279296875*pow(xi, 10) + 42.28729248046875*pow(xi, 8) - 12.463623046875*pow(xi, 6) + 1.8328857421875*pow(xi, 4) - 0.104736328125*pow(xi, 2) + 0.001007080078125;
    f[15] = 17.403717041015625*pow(xi, 17) - 81.617431640625*pow(xi, 15) + 158.7005615234375*pow(xi, 13) - 165.048583984375*pow(xi, 11) + 98.67034912109375*pow(xi, 9) - 33.829833984375*pow(xi, 7) + 6.2318115234375*pow(xi, 5) - 0.523681640625*pow(xi, 3) + 0.013092041015625*xi;
    f[16] = 29.973068237304688*pow(xi, 18) - 147.93159484863281*pow(xi, 16) + 306.06536865234375*pow(xi, 14) - 343.85121663411456*pow(xi, 12) + 226.94180297851563*pow(xi, 10) - 88.803314208984375*pow(xi, 8) + 19.73406982421875*pow(xi, 6) - 2.22564697265625*pow(xi, 4) + 0.0981903076171875*pow(xi, 2) - 0.00072733561197916663;
    f[17] = 52.058486938476563*pow(xi, 19) - 269.75761413574219*pow(xi, 17) + 591.72637939453125*pow(xi, 15) - 714.15252685546875*pow(xi, 13) + 515.77682495117188*pow(xi, 11) - 226.94180297851563*pow(xi, 9) + 59.20220947265625*pow(xi, 7) - 8.45745849609375*pow(xi, 5) + 0.5564117431640625*pow(xi, 3) - 0.0109100341796875*xi;
    f[18] = 91.102352142333984*pow(xi, 20) - 494.55562591552734*pow(xi, 18) + 1146.4698600769043*pow(xi, 16) - 1479.3159484863281*pow(xi, 14) + 1160.4978561401367*pow(xi, 12) - 567.35450744628906*pow(xi, 10) + 170.20635223388672*pow(xi, 8) - 29.601104736328125*pow(xi, 6) + 2.6429557800292969*pow(xi, 4) - 0.09273529052734375*pow(xi, 2) + 0.000545501708984375;
    f[19] = 160.51366806030273*pow(xi, 21) - 911.02352142333984*pow(xi, 19) + 2225.500316619873*pow(xi, 17) - 3057.2529602050781*pow(xi, 15) + 2588.8029098510742*pow(xi, 13) - 1392.5974273681641*pow(xi, 11) + 472.79542287190753*pow(xi, 9) - 97.260772705078125*pow(xi, 7) + 11.100414276123047*pow(xi, 5) - 0.58732350667317712*pow(xi, 3) + 0.009273529052734375*xi;
    f[20] = 284.54695701599121*pow(xi, 22) - 1685.3935146331787*pow(xi, 20) + 4327.3617267608643*pow(xi, 18) - 6305.5842304229736*pow(xi, 16) + 5732.3493003845215*pow(xi, 14) - 3365.4437828063965*pow(xi, 12) + 1276.5476417541504*pow(xi, 10) - 303.93991470336914*pow(xi, 8) + 42.55158805847168*pow(xi, 6) - 3.0834484100341797*pow(xi, 4) + 0.088098526000976563*pow(xi, 2) - 0.0004215240478515625;
    f[21] = 507.23587989807129*pow(xi, 23) - 3130.0165271759033*pow(xi, 21) + 8426.9675731658936*pow(xi, 19) - 12982.085180282593*pow(xi, 17) + 12611.168460845947*pow(xi, 15) - 8025.2890205383301*pow(xi, 13) + 3365.4437828063965*pow(xi, 11) - 911.81974411010742*pow(xi, 9) + 151.96995735168457*pow(xi, 7) - 14.183862686157227*pow(xi, 5) + 0.61668968200683594*pow(xi, 3) - 0.0080089569091796875*xi;
    f[22] = 908.79761815071106*pow(xi, 24) - 5833.2126188278198*pow(xi, 22) + 16432.586767673492*pow(xi, 20) - 26685.39731502533*pow(xi, 18) + 27586.93100810051*pow(xi, 16) - 18916.752691268921*pow(xi, 14) + 8694.0631055831909*pow(xi, 12) - 2644.2772579193115*pow(xi, 10) + 512.89860606193542*pow(xi, 8) - 59.099427858988442*pow(xi, 6) + 3.5459656715393066*pow(xi, 4) - 0.084094047546386719*pow(xi, 2) + 0.000333706537882487;
    f[23] = 1635.8357126712799*pow(xi, 25) - 10905.571417808533*pow(xi, 23) + 32082.669403553009*pow(xi, 21) - 54775.289225578308*pow(xi, 19) + 60042.143958806992*pow(xi, 17) - 44139.089612960815*pow(xi, 15) + 22069.544806480408*pow(xi, 13) - 7452.0540904998779*pow(xi, 11) + 1652.6732861995697*pow(xi, 9) - 227.95493602752686*pow(xi, 7) + 17.729828357696533*pow(xi, 5) - 0.64472103118896484*pow(xi, 3) + 0.0070078372955322266*xi;
    f[24] = 2957.0876344442368*pow(xi, 26) - 20447.946408390999*pow(xi, 24) + 62707.035652399063*pow(xi, 22) - 112289.34291243553*pow(xi, 20) + 130091.31191074848*pow(xi, 18) - 102071.64472997189*pow(xi, 16) + 55173.862016201019*pow(xi, 14) - 20493.148748874664*pow(xi, 12) + 5123.2871872186661*pow(xi, 10) - 826.33664309978485*pow(xi, 8) + 79.784227609634399*pow(xi, 6) - 4.0295064449310303*pow(xi, 4) + 0.080590128898620605*pow(xi, 2) - 0.00026953220367431641;
    f[25] = 5366.566447695096*pow(xi, 27) - 38442.139247775078*pow(xi, 25) + 122687.67845034599*pow(xi, 23) - 229925.7973921299*pow(xi, 21) + 280723.35728108883*pow(xi, 19) - 234164.36143934727*pow(xi, 17) + 136095.52630662918*pow(xi, 15) - 55173.862016201019*pow(xi, 13) + 15369.861561655998*pow(xi, 11) - 2846.2706595659256*pow(xi, 9) + 330.53465723991394*pow(xi, 7) - 21.759334802627563*pow(xi, 5) + 0.67158440748850501*pow(xi, 3) - 0.0061992406845092773*xi;
    f[26] = 9774.8174583017826*pow(xi, 28) - 72448.647043883801*pow(xi, 26) + 240263.37029859424*pow(xi, 24) - 470302.76739299297*pow(xi, 22) + 603555.21815434098*pow(xi, 20) - 533374.37883406878*pow(xi, 18) + 331732.84537240863*pow(xi, 16) - 145816.63532853127*pow(xi, 14) + 44828.762888163328*pow(xi, 12) - 9392.6931765675545*pow(xi, 10) + 1280.8217968046665*pow(xi, 8) - 105.17011821269989*pow(xi, 6) + 4.5331947505474091*pow(xi, 4) - 0.077490508556365967*pow(xi, 2) + 0.00022140145301818848;
    f[27] = 17864.321561723948*pow(xi, 29) - 136847.44441622496*pow(xi, 27) + 470916.2057852447*pow(xi, 25) - 961053.48119437695*pow(xi, 23) + 1293332.6103307307*pow(xi, 21) - 1207110.436308682*pow(xi, 19) + 800061.56825110316*pow(xi, 17) - 379123.25185418129*pow(xi, 15) + 127589.55591246486*pow(xi, 13) - 29885.841925442219*pow(xi, 11) + 4696.3465882837772*pow(xi, 9) - 465.75338065624237*pow(xi, 7) + 26.292529553174973*pow(xi, 5) - 0.6974145770072937*pow(xi, 3) + 0.0055350363254547119*xi;
}


EXPORTIT void vec_fuv_x(double *fxi, double xi, double xi1t, double xi2t) {
    fxi[0] = xi1t*(-1.0/2.0);
    fxi[1] = xi2t*(1.0/2.0);
    fxi[2] = 0.5*pow(xi, 3) - 0.5*xi;
    fxi[3] = 0.625*pow(xi, 4) - 0.75*pow(xi, 2) + 0.125;
    fxi[4] = 0.875*pow(xi, 5) - 1.25*pow(xi, 3) + 0.375*xi;
    fxi[5] = 1.3125*pow(xi, 6) - 2.1875*pow(xi, 4) + 0.9375*pow(xi, 2) - 0.0625;
    fxi[6] = 2.0625*pow(xi, 7) - 3.9375*pow(xi, 5) + 2.1875*pow(xi, 3) - 0.3125*xi;
    fxi[7] = 3.3515625*pow(xi, 8) - 7.21875*pow(xi, 6) + 4.921875*pow(xi, 4) - 1.09375*pow(xi, 2) + 0.0390625;
    fxi[8] = 5.5859375*pow(xi, 9) - 13.40625*pow(xi, 7) + 10.828125*pow(xi, 5) - 3.28125*pow(xi, 3) + 0.2734375*xi;
    fxi[9] = 9.49609375*pow(xi, 10) - 25.13671875*pow(xi, 8) + 23.4609375*pow(xi, 6) - 9.0234375*pow(xi, 4) + 1.23046875*pow(xi, 2) - 0.02734375;
    fxi[10] = 16.40234375*pow(xi, 11) - 47.48046875*pow(xi, 9) + 50.2734375*pow(xi, 7) - 23.4609375*pow(xi, 5) + 4.51171875*pow(xi, 3) - 0.24609375*xi;
    fxi[11] = 28.7041015625*pow(xi, 12) - 90.212890625*pow(xi, 10) + 106.8310546875*pow(xi, 8) - 58.65234375*pow(xi, 6) + 14.6630859375*pow(xi, 4) - 1.353515625*pow(xi, 2) + 0.0205078125;
    fxi[12] = 50.7841796875*pow(xi, 13) - 172.224609375*pow(xi, 11) + 225.5322265625*pow(xi, 9) - 142.44140625*pow(xi, 7) + 43.9892578125*pow(xi, 5) - 5.865234375*pow(xi, 3) + 0.2255859375*xi;
    fxi[13] = 90.68603515625*pow(xi, 14) - 330.09716796875*pow(xi, 12) + 473.61767578125*pow(xi, 10) - 338.29833984375*pow(xi, 8) + 124.63623046875*pow(xi, 6) - 21.99462890625*pow(xi, 4) + 1.46630859375*pow(xi, 2) - 0.01611328125;
    fxi[14] = 163.23486328125*pow(xi, 15) - 634.80224609375*pow(xi, 13) + 990.29150390625*pow(xi, 11) - 789.36279296875*pow(xi, 9) + 338.29833984375*pow(xi, 7) - 74.78173828125*pow(xi, 5) + 7.33154296875*pow(xi, 3) - 0.20947265625*xi;
    fxi[15] = 295.86318969726563*pow(xi, 16) - 1224.261474609375*pow(xi, 14) + 2063.1072998046875*pow(xi, 12) - 1815.534423828125*pow(xi, 10) + 888.03314208984375*pow(xi, 8) - 236.808837890625*pow(xi, 6) + 31.1590576171875*pow(xi, 4) - 1.571044921875*pow(xi, 2) + 0.013092041015625;
    fxi[16] = 539.51522827148438*pow(xi, 17) - 2366.905517578125*pow(xi, 15) + 4284.9151611328125*pow(xi, 13) - 4126.214599609375*pow(xi, 11) + 2269.4180297851563*pow(xi, 9) - 710.426513671875*pow(xi, 7) + 118.4044189453125*pow(xi, 5) - 8.902587890625*pow(xi, 3) + 0.196380615234375*xi;
    fxi[17] = 989.11125183105469*pow(xi, 18) - 4585.8794403076172*pow(xi, 16) + 8875.8956909179688*pow(xi, 14) - 9283.9828491210938*pow(xi, 12) + 5673.5450744628906*pow(xi, 10) - 2042.4762268066406*pow(xi, 8) + 414.41546630859375*pow(xi, 6) - 42.28729248046875*pow(xi, 4) + 1.6692352294921875*pow(xi, 2) - 0.0109100341796875;
    fxi[18] = 1822.0470428466797*pow(xi, 19) - 8902.0012664794922*pow(xi, 17) + 18343.517761230469*pow(xi, 15) - 20710.423278808594*pow(xi, 13) + 13925.974273681641*pow(xi, 11) - 5673.5450744628906*pow(xi, 9) + 1361.6508178710938*pow(xi, 7) - 177.60662841796875*pow(xi, 5) + 10.571823120117188*pow(xi, 3) - 0.1854705810546875*xi;
    fxi[19] = 3370.7870292663574*pow(xi, 20) - 17309.446907043457*pow(xi, 18) + 37833.505382537842*pow(xi, 16) - 45858.794403076172*pow(xi, 14) + 33654.437828063965*pow(xi, 12) - 15318.571701049805*pow(xi, 10) + 4255.158805847168*pow(xi, 8) - 680.82540893554688*pow(xi, 6) + 55.502071380615234*pow(xi, 4) - 1.7619705200195313*pow(xi, 2) + 0.009273529052734375;
    fxi[20] = 6260.0330543518066*pow(xi, 21) - 33707.870292663574*pow(xi, 19) + 77892.511081695557*pow(xi, 17) - 100889.34768676758*pow(xi, 15) + 80252.890205383301*pow(xi, 13) - 40385.325393676758*pow(xi, 11) + 12765.476417541504*pow(xi, 9) - 2431.5193176269531*pow(xi, 7) + 255.30952835083008*pow(xi, 5) - 12.333793640136719*pow(xi, 3) + 0.17619705200195313*xi;
    fxi[21] = 11666.42523765564*pow(xi, 22) - 65730.34707069397*pow(xi, 20) + 160112.38389015198*pow(xi, 18) - 220695.44806480408*pow(xi, 16) + 189167.52691268921*pow(xi, 14) - 104328.75726699829*pow(xi, 12) + 37019.881610870361*pow(xi, 10) - 8206.3776969909668*pow(xi, 8) + 1063.789701461792*pow(xi, 6) - 70.919313430786133*pow(xi, 4) + 1.8500690460205078*pow(xi, 2) - 0.0080089569091796875;
    fxi[22] = 21811.142835617065*pow(xi, 23) - 128330.67761421204*pow(xi, 21) + 328651.73535346985*pow(xi, 19) - 480337.15167045593*pow(xi, 17) + 441390.89612960815*pow(xi, 15) - 264834.53767776489*pow(xi, 13) + 104328.75726699829*pow(xi, 11) - 26442.772579193115*pow(xi, 9) + 4103.1888484954834*pow(xi, 7) - 354.59656715393066*pow(xi, 5) + 14.183862686157227*pow(xi, 3) - 0.16818809509277344*xi;
    fxi[23] = 40895.892816781998*pow(xi, 24) - 250828.14260959625*pow(xi, 22) + 673736.05747461319*pow(xi, 20) - 1040730.4952859879*pow(xi, 18) + 1020716.4472997189*pow(xi, 16) - 662086.34419441223*pow(xi, 14) + 286904.0824842453*pow(xi, 12) - 81972.594995498657*pow(xi, 10) + 14874.059575796127*pow(xi, 8) - 1595.684552192688*pow(xi, 6) + 88.649141788482666*pow(xi, 4) - 1.9341630935668945*pow(xi, 2) + 0.0070078372955322266;
    fxi[24] = 76884.278495550156*pow(xi, 25) - 490750.71380138397*pow(xi, 23) + 1379554.7843527794*pow(xi, 21) - 2245786.8582487106*pow(xi, 19) + 2341643.6143934727*pow(xi, 17) - 1633146.3156795502*pow(xi, 15) + 772434.06822681427*pow(xi, 13) - 245917.78498649597*pow(xi, 11) + 51232.871872186661*pow(xi, 9) - 6610.6931447982788*pow(xi, 7) + 478.7053656578064*pow(xi, 5) - 16.118025779724121*pow(xi, 3) + 0.16118025779724121*xi;
    fxi[25] = 144897.2940877676*pow(xi, 26) - 961053.48119437695*pow(xi, 24) + 2821816.6043579578*pow(xi, 22) - 4828441.7452347279*pow(xi, 20) + 5333743.7883406878*pow(xi, 18) - 3980794.1444689035*pow(xi, 16) + 2041432.8945994377*pow(xi, 14) - 717260.20621061325*pow(xi, 12) + 169068.47717821598*pow(xi, 10) - 25616.43593609333*pow(xi, 8) + 2313.7426006793976*pow(xi, 6) - 108.79667401313782*pow(xi, 4) + 2.0147532224655151*pow(xi, 2) - 0.0061992406845092773;
    fxi[26] = 273694.88883244991*pow(xi, 27) - 1883664.8231409788*pow(xi, 25) + 5766320.8871662617*pow(xi, 23) - 10346660.882645845*pow(xi, 21) + 12071104.36308682*pow(xi, 19) - 9600738.819013238*pow(xi, 17) + 5307725.5259585381*pow(xi, 15) - 2041432.8945994377*pow(xi, 13) + 537945.15465795994*pow(xi, 11) - 93926.931765675545*pow(xi, 9) + 10246.574374437332*pow(xi, 7) - 631.02070927619934*pow(xi, 5) + 18.132779002189636*pow(xi, 3) - 0.15498101711273193*xi;
    fxi[27] = 518065.32528999448*pow(xi, 28) - 3694880.9992380738*pow(xi, 26) + 11772905.144631118*pow(xi, 24) - 22104230.06747067*pow(xi, 22) + 27159984.816945344*pow(xi, 20) - 22935098.289864957*pow(xi, 18) + 13601046.660268754*pow(xi, 16) - 5686848.7778127193*pow(xi, 14) + 1658664.2268620431*pow(xi, 12) - 328744.26117986441*pow(xi, 10) + 42267.119294553995*pow(xi, 8) - 3260.2736645936966*pow(xi, 6) + 131.46264776587486*pow(xi, 4) - 2.0922437310218811*pow(xi, 2) + 0.0055350363254547119;
}


EXPORTIT void vec_fuv_xx(double *fxixi, double xi, double xi1t, double xi2t) {
    fxixi[0] = xi1t*(0);
    fxixi[1] = xi2t*(0);
    fxixi[2] = 1.5*pow(xi, 2) - 0.5;
    fxixi[3] = xi*(2.5*pow(xi, 2) - 1.5);
    fxixi[4] = 4.375*pow(xi, 4) - 3.75*pow(xi, 2) + 0.375;
    fxixi[5] = xi*(7.875*pow(xi, 4) - 8.75*pow(xi, 2) + 1.875);
    fxixi[6] = 14.4375*pow(xi, 6) - 19.6875*pow(xi, 4) + 6.5625*pow(xi, 2) - 0.3125;
    fxixi[7] = xi*(26.8125*pow(xi, 6) - 43.3125*pow(xi, 4) + 19.6875*pow(xi, 2) - 2.1875);
    fxixi[8] = 50.2734375*pow(xi, 8) - 93.84375*pow(xi, 6) + 54.140625*pow(xi, 4) - 9.84375*pow(xi, 2) + 0.2734375;
    fxixi[9] = xi*(94.9609375*pow(xi, 8) - 201.09375*pow(xi, 6) + 140.765625*pow(xi, 4) - 36.09375*pow(xi, 2) + 2.4609375);
    fxixi[10] = 180.42578125*pow(xi, 10) - 427.32421875*pow(xi, 8) + 351.9140625*pow(xi, 6) - 117.3046875*pow(xi, 4) + 13.53515625*pow(xi, 2) - 0.24609375;
    fxixi[11] = xi*(344.44921875*pow(xi, 10) - 902.12890625*pow(xi, 8) + 854.6484375*pow(xi, 6) - 351.9140625*pow(xi, 4) + 58.65234375*pow(xi, 2) - 2.70703125);
    fxixi[12] = 660.1943359375*pow(xi, 12) - 1894.470703125*pow(xi, 10) + 2029.7900390625*pow(xi, 8) - 997.08984375*pow(xi, 6) + 219.9462890625*pow(xi, 4) - 17.595703125*pow(xi, 2) + 0.2255859375;
    fxixi[13] = xi*(1269.6044921875*pow(xi, 12) - 3961.166015625*pow(xi, 10) + 4736.1767578125*pow(xi, 8) - 2706.38671875*pow(xi, 6) + 747.8173828125*pow(xi, 4) - 87.978515625*pow(xi, 2) + 2.9326171875);
    fxixi[14] = 2448.52294921875*pow(xi, 14) - 8252.42919921875*pow(xi, 12) + 10893.20654296875*pow(xi, 10) - 7104.26513671875*pow(xi, 8) + 2368.08837890625*pow(xi, 6) - 373.90869140625*pow(xi, 4) + 21.99462890625*pow(xi, 2) - 0.20947265625;
    fxixi[15] = xi*(4733.81103515625*pow(xi, 14) - 17139.66064453125*pow(xi, 12) + 24757.28759765625*pow(xi, 10) - 18155.34423828125*pow(xi, 8) + 7104.26513671875*pow(xi, 6) - 1420.85302734375*pow(xi, 4) + 124.63623046875*pow(xi, 2) - 3.14208984375);
    fxixi[16] = 9171.7588806152344*pow(xi, 16) - 35503.582763671875*pow(xi, 14) + 55703.897094726563*pow(xi, 12) - 45388.360595703125*pow(xi, 10) + 20424.762268066406*pow(xi, 8) - 4972.985595703125*pow(xi, 6) + 592.0220947265625*pow(xi, 4) - 26.707763671875*pow(xi, 2) + 0.196380615234375;
    fxixi[17] = xi*(17804.002532958984*pow(xi, 16) - 73374.071044921875*pow(xi, 14) + 124262.53967285156*pow(xi, 12) - 111407.79418945313*pow(xi, 10) + 56735.450744628906*pow(xi, 8) - 16339.809814453125*pow(xi, 6) + 2486.4927978515625*pow(xi, 4) - 169.149169921875*pow(xi, 2) + 3.338470458984375);
    fxixi[18] = 34618.893814086914*pow(xi, 18) - 151334.02153015137*pow(xi, 16) + 275152.76641845703*pow(xi, 14) - 269235.50262451172*pow(xi, 12) + 153185.71701049805*pow(xi, 10) - 51061.905670166016*pow(xi, 8) + 9531.5557250976563*pow(xi, 6) - 888.03314208984375*pow(xi, 4) + 31.715469360351563*pow(xi, 2) - 0.1854705810546875;
    fxixi[19] = xi*(67415.740585327148*pow(xi, 18) - 311570.04432678223*pow(xi, 16) + 605336.08612060547*pow(xi, 14) - 642023.12164306641*pow(xi, 12) + 403853.25393676758*pow(xi, 10) - 153185.71701049805*pow(xi, 8) + 34041.270446777344*pow(xi, 6) - 4084.9524536132813*pow(xi, 4) + 222.00828552246094*pow(xi, 2) - 3.5239410400390625);
    fxixi[20] = 131460.69414138794*pow(xi, 20) - 640449.53556060791*pow(xi, 18) + 1324172.6883888245*pow(xi, 16) - 1513340.2153015137*pow(xi, 14) + 1043287.5726699829*pow(xi, 12) - 444238.57933044434*pow(xi, 10) + 114889.28775787354*pow(xi, 8) - 17020.635223388672*pow(xi, 6) + 1276.5476417541504*pow(xi, 4) - 37.001380920410156*pow(xi, 2) + 0.17619705200195313;
    fxixi[21] = xi*(256661.35522842407*pow(xi, 20) - 1314606.9414138794*pow(xi, 18) + 2882022.9100227356*pow(xi, 16) - 3531127.1690368652*pow(xi, 14) + 2648345.3767776489*pow(xi, 12) - 1251945.0872039795*pow(xi, 10) + 370198.81610870361*pow(xi, 8) - 65651.021575927734*pow(xi, 6) + 6382.738208770752*pow(xi, 4) - 283.67725372314453*pow(xi, 2) + 3.7001380920410156);
    fxixi[22] = 501656.2852191925*pow(xi, 22) - 2694944.2298984528*pow(xi, 20) + 6244382.9717159271*pow(xi, 18) - 8165731.5783977509*pow(xi, 16) + 6620863.4419441223*pow(xi, 14) - 3442848.9898109436*pow(xi, 12) + 1147616.3299369812*pow(xi, 10) - 237984.95321273804*pow(xi, 8) + 28722.321939468384*pow(xi, 6) - 1772.9828357696533*pow(xi, 4) + 42.55158805847168*pow(xi, 2) - 0.16818809509277344;
    fxixi[23] = xi*(981501.42760276794*pow(xi, 22) - 5518219.1374111176*pow(xi, 20) + 13474721.149492264*pow(xi, 18) - 18733148.915147781*pow(xi, 16) + 16331463.156795502*pow(xi, 14) - 9269208.8187217712*pow(xi, 12) + 3442848.9898109436*pow(xi, 10) - 819725.94995498657*pow(xi, 8) + 118992.47660636902*pow(xi, 6) - 9574.1073131561279*pow(xi, 4) + 354.59656715393066*pow(xi, 2) - 3.8683261871337891);
    fxixi[24] = 1922106.9623887539*pow(xi, 24) - 11287266.417431831*pow(xi, 22) + 28970650.471408367*pow(xi, 20) - 42669950.306725502*pow(xi, 18) + 39807941.444689035*pow(xi, 16) - 24497194.735193253*pow(xi, 14) + 10041642.886948586*pow(xi, 12) - 2705095.6348514557*pow(xi, 10) + 461095.84684967995*pow(xi, 8) - 46274.852013587952*pow(xi, 6) + 2393.526828289032*pow(xi, 4) - 48.354077339172363*pow(xi, 2) + 0.16118025779724121;
    fxixi[25] = xi*(3767329.6462819576*pow(xi, 24) - 23065283.548665047*pow(xi, 22) + 62079965.295875072*pow(xi, 20) - 96568834.904694557*pow(xi, 18) + 96007388.19013238*pow(xi, 16) - 63692706.311502457*pow(xi, 14) + 28580060.524392128*pow(xi, 12) - 8607122.474527359*pow(xi, 10) + 1690684.7717821598*pow(xi, 8) - 204931.48748874664*pow(xi, 6) + 13882.455604076385*pow(xi, 4) - 435.18669605255127*pow(xi, 2) + 4.0295064449310303);
    fxixi[26] = 7389761.9984761477*pow(xi, 26) - 47091620.57852447*pow(xi, 24) + 132625380.40482402*pow(xi, 22) - 217279878.53556275*pow(xi, 20) + 229350982.89864957*pow(xi, 18) - 163212559.92322505*pow(xi, 16) + 79615882.889378071*pow(xi, 14) - 26538627.62979269*pow(xi, 12) + 5917396.7012375593*pow(xi, 10) - 845342.3858910799*pow(xi, 8) + 71726.020621061325*pow(xi, 6) - 3155.1035463809967*pow(xi, 4) + 54.398337006568909*pow(xi, 2) - 0.15498101711273193;
    fxixi[27] = xi*(14505829.108119845*pow(xi, 26) - 96066905.980189919*pow(xi, 24) + 282549723.47114682*pow(xi, 22) - 486293061.48435473*pow(xi, 20) + 543199696.33890688*pow(xi, 18) - 412831769.21756923*pow(xi, 16) + 217616746.56430006*pow(xi, 14) - 79615882.889378071*pow(xi, 12) + 19903970.722344518*pow(xi, 10) - 3287442.6117986441*pow(xi, 8) + 338136.95435643196*pow(xi, 6) - 19561.64198756218*pow(xi, 4) + 525.85059106349945*pow(xi, 2) - 4.1844874620437622);
}


EXPORTIT double fuv(int i, double xi, double xi1t, double xi2t) {
    switch(i) {
    case 0:
        return xi1t*(1.0/2.0 - 1.0/2.0*xi);
    case 1:
        return xi2t*((1.0/2.0)*xi + 1.0/2.0);
    case 2:
        return 0.125*pow(xi, 4) - 0.25*pow(xi, 2) + 0.125;
    case 3:
        return 0.125*pow(xi, 5) - 0.25*pow(xi, 3) + 0.125*xi;
    case 4:
        return 0.14583333333333334*pow(xi, 6) - 0.3125*pow(xi, 4) + 0.1875*pow(xi, 2) - 0.020833333333333332;
    case 5:
        return 0.1875*pow(xi, 7) - 0.4375*pow(xi, 5) + 0.3125*pow(xi, 3) - 0.0625*xi;
    case 6:
        return 0.2578125*pow(xi, 8) - 0.65625*pow(xi, 6) + 0.546875*pow(xi, 4) - 0.15625*pow(xi, 2) + 0.0078125;
    case 7:
        return 0.37239583333333331*pow(xi, 9) - 1.03125*pow(xi, 7) + 0.984375*pow(xi, 5) - 0.36458333333333331*pow(xi, 3) + 0.0390625*xi;
    case 8:
        return 0.55859375*pow(xi, 10) - 1.67578125*pow(xi, 8) + 1.8046875*pow(xi, 6) - 0.8203125*pow(xi, 4) + 0.13671875*pow(xi, 2) - 0.00390625;
    case 9:
        return 0.86328125*pow(xi, 11) - 2.79296875*pow(xi, 9) + 3.3515625*pow(xi, 7) - 1.8046875*pow(xi, 5) + 0.41015625*pow(xi, 3) - 0.02734375*xi;
    case 10:
        return 1.3668619791666667*pow(xi, 12) - 4.748046875*pow(xi, 10) + 6.2841796875*pow(xi, 8) - 3.91015625*pow(xi, 6) + 1.1279296875*pow(xi, 4) - 0.123046875*pow(xi, 2) + 0.0022786458333333335;
    case 11:
        return 2.2080078125*pow(xi, 13) - 8.201171875*pow(xi, 11) + 11.8701171875*pow(xi, 9) - 8.37890625*pow(xi, 7) + 2.9326171875*pow(xi, 5) - 0.451171875*pow(xi, 3) + 0.0205078125*xi;
    case 12:
        return 3.62744140625*pow(xi, 14) - 14.35205078125*pow(xi, 12) + 22.55322265625*pow(xi, 10) - 17.80517578125*pow(xi, 8) + 7.33154296875*pow(xi, 6) - 1.46630859375*pow(xi, 4) + 0.11279296875*pow(xi, 2) - 0.00146484375;
    case 13:
        return 6.045735677083333*pow(xi, 15) - 25.39208984375*pow(xi, 13) + 43.05615234375*pow(xi, 11) - 37.588704427083336*pow(xi, 9) + 17.80517578125*pow(xi, 7) - 4.39892578125*pow(xi, 5) + 0.48876953125*pow(xi, 3) - 0.01611328125*xi;
    case 14:
        return 10.202178955078125*pow(xi, 16) - 45.343017578125*pow(xi, 14) + 82.5242919921875*pow(xi, 12) - 78.936279296875*pow(xi, 10) + 42.28729248046875*pow(xi, 8) - 12.463623046875*pow(xi, 6) + 1.8328857421875*pow(xi, 4) - 0.104736328125*pow(xi, 2) + 0.001007080078125;
    case 15:
        return 17.403717041015625*pow(xi, 17) - 81.617431640625*pow(xi, 15) + 158.7005615234375*pow(xi, 13) - 165.048583984375*pow(xi, 11) + 98.67034912109375*pow(xi, 9) - 33.829833984375*pow(xi, 7) + 6.2318115234375*pow(xi, 5) - 0.523681640625*pow(xi, 3) + 0.013092041015625*xi;
    case 16:
        return 29.973068237304688*pow(xi, 18) - 147.93159484863281*pow(xi, 16) + 306.06536865234375*pow(xi, 14) - 343.85121663411456*pow(xi, 12) + 226.94180297851563*pow(xi, 10) - 88.803314208984375*pow(xi, 8) + 19.73406982421875*pow(xi, 6) - 2.22564697265625*pow(xi, 4) + 0.0981903076171875*pow(xi, 2) - 0.00072733561197916663;
    case 17:
        return 52.058486938476563*pow(xi, 19) - 269.75761413574219*pow(xi, 17) + 591.72637939453125*pow(xi, 15) - 714.15252685546875*pow(xi, 13) + 515.77682495117188*pow(xi, 11) - 226.94180297851563*pow(xi, 9) + 59.20220947265625*pow(xi, 7) - 8.45745849609375*pow(xi, 5) + 0.5564117431640625*pow(xi, 3) - 0.0109100341796875*xi;
    case 18:
        return 91.102352142333984*pow(xi, 20) - 494.55562591552734*pow(xi, 18) + 1146.4698600769043*pow(xi, 16) - 1479.3159484863281*pow(xi, 14) + 1160.4978561401367*pow(xi, 12) - 567.35450744628906*pow(xi, 10) + 170.20635223388672*pow(xi, 8) - 29.601104736328125*pow(xi, 6) + 2.6429557800292969*pow(xi, 4) - 0.09273529052734375*pow(xi, 2) + 0.000545501708984375;
    case 19:
        return 160.51366806030273*pow(xi, 21) - 911.02352142333984*pow(xi, 19) + 2225.500316619873*pow(xi, 17) - 3057.2529602050781*pow(xi, 15) + 2588.8029098510742*pow(xi, 13) - 1392.5974273681641*pow(xi, 11) + 472.79542287190753*pow(xi, 9) - 97.260772705078125*pow(xi, 7) + 11.100414276123047*pow(xi, 5) - 0.58732350667317712*pow(xi, 3) + 0.009273529052734375*xi;
    case 20:
        return 284.54695701599121*pow(xi, 22) - 1685.3935146331787*pow(xi, 20) + 4327.3617267608643*pow(xi, 18) - 6305.5842304229736*pow(xi, 16) + 5732.3493003845215*pow(xi, 14) - 3365.4437828063965*pow(xi, 12) + 1276.5476417541504*pow(xi, 10) - 303.93991470336914*pow(xi, 8) + 42.55158805847168*pow(xi, 6) - 3.0834484100341797*pow(xi, 4) + 0.088098526000976563*pow(xi, 2) - 0.0004215240478515625;
    case 21:
        return 507.23587989807129*pow(xi, 23) - 3130.0165271759033*pow(xi, 21) + 8426.9675731658936*pow(xi, 19) - 12982.085180282593*pow(xi, 17) + 12611.168460845947*pow(xi, 15) - 8025.2890205383301*pow(xi, 13) + 3365.4437828063965*pow(xi, 11) - 911.81974411010742*pow(xi, 9) + 151.96995735168457*pow(xi, 7) - 14.183862686157227*pow(xi, 5) + 0.61668968200683594*pow(xi, 3) - 0.0080089569091796875*xi;
    case 22:
        return 908.79761815071106*pow(xi, 24) - 5833.2126188278198*pow(xi, 22) + 16432.586767673492*pow(xi, 20) - 26685.39731502533*pow(xi, 18) + 27586.93100810051*pow(xi, 16) - 18916.752691268921*pow(xi, 14) + 8694.0631055831909*pow(xi, 12) - 2644.2772579193115*pow(xi, 10) + 512.89860606193542*pow(xi, 8) - 59.099427858988442*pow(xi, 6) + 3.5459656715393066*pow(xi, 4) - 0.084094047546386719*pow(xi, 2) + 0.000333706537882487;
    case 23:
        return 1635.8357126712799*pow(xi, 25) - 10905.571417808533*pow(xi, 23) + 32082.669403553009*pow(xi, 21) - 54775.289225578308*pow(xi, 19) + 60042.143958806992*pow(xi, 17) - 44139.089612960815*pow(xi, 15) + 22069.544806480408*pow(xi, 13) - 7452.0540904998779*pow(xi, 11) + 1652.6732861995697*pow(xi, 9) - 227.95493602752686*pow(xi, 7) + 17.729828357696533*pow(xi, 5) - 0.64472103118896484*pow(xi, 3) + 0.0070078372955322266*xi;
    case 24:
        return 2957.0876344442368*pow(xi, 26) - 20447.946408390999*pow(xi, 24) + 62707.035652399063*pow(xi, 22) - 112289.34291243553*pow(xi, 20) + 130091.31191074848*pow(xi, 18) - 102071.64472997189*pow(xi, 16) + 55173.862016201019*pow(xi, 14) - 20493.148748874664*pow(xi, 12) + 5123.2871872186661*pow(xi, 10) - 826.33664309978485*pow(xi, 8) + 79.784227609634399*pow(xi, 6) - 4.0295064449310303*pow(xi, 4) + 0.080590128898620605*pow(xi, 2) - 0.00026953220367431641;
    case 25:
        return 5366.566447695096*pow(xi, 27) - 38442.139247775078*pow(xi, 25) + 122687.67845034599*pow(xi, 23) - 229925.7973921299*pow(xi, 21) + 280723.35728108883*pow(xi, 19) - 234164.36143934727*pow(xi, 17) + 136095.52630662918*pow(xi, 15) - 55173.862016201019*pow(xi, 13) + 15369.861561655998*pow(xi, 11) - 2846.2706595659256*pow(xi, 9) + 330.53465723991394*pow(xi, 7) - 21.759334802627563*pow(xi, 5) + 0.67158440748850501*pow(xi, 3) - 0.0061992406845092773*xi;
    case 26:
        return 9774.8174583017826*pow(xi, 28) - 72448.647043883801*pow(xi, 26) + 240263.37029859424*pow(xi, 24) - 470302.76739299297*pow(xi, 22) + 603555.21815434098*pow(xi, 20) - 533374.37883406878*pow(xi, 18) + 331732.84537240863*pow(xi, 16) - 145816.63532853127*pow(xi, 14) + 44828.762888163328*pow(xi, 12) - 9392.6931765675545*pow(xi, 10) + 1280.8217968046665*pow(xi, 8) - 105.17011821269989*pow(xi, 6) + 4.5331947505474091*pow(xi, 4) - 0.077490508556365967*pow(xi, 2) + 0.00022140145301818848;
    case 27:
        return 17864.321561723948*pow(xi, 29) - 136847.44441622496*pow(xi, 27) + 470916.2057852447*pow(xi, 25) - 961053.48119437695*pow(xi, 23) + 1293332.6103307307*pow(xi, 21) - 1207110.436308682*pow(xi, 19) + 800061.56825110316*pow(xi, 17) - 379123.25185418129*pow(xi, 15) + 127589.55591246486*pow(xi, 13) - 29885.841925442219*pow(xi, 11) + 4696.3465882837772*pow(xi, 9) - 465.75338065624237*pow(xi, 7) + 26.292529553174973*pow(xi, 5) - 0.6974145770072937*pow(xi, 3) + 0.0055350363254547119*xi;
    default:
        return 0.;
    }
}


EXPORTIT double fuv_x(int i, double xi, double xi1t, double xi2t) {
    switch(i) {
    case 0:
        return xi1t*(-1.0/2.0);
    case 1:
        return xi2t*(1.0/2.0);
    case 2:
        return 0.5*pow(xi, 3) - 0.5*xi;
    case 3:
        return 0.625*pow(xi, 4) - 0.75*pow(xi, 2) + 0.125;
    case 4:
        return 0.875*pow(xi, 5) - 1.25*pow(xi, 3) + 0.375*xi;
    case 5:
        return 1.3125*pow(xi, 6) - 2.1875*pow(xi, 4) + 0.9375*pow(xi, 2) - 0.0625;
    case 6:
        return 2.0625*pow(xi, 7) - 3.9375*pow(xi, 5) + 2.1875*pow(xi, 3) - 0.3125*xi;
    case 7:
        return 3.3515625*pow(xi, 8) - 7.21875*pow(xi, 6) + 4.921875*pow(xi, 4) - 1.09375*pow(xi, 2) + 0.0390625;
    case 8:
        return 5.5859375*pow(xi, 9) - 13.40625*pow(xi, 7) + 10.828125*pow(xi, 5) - 3.28125*pow(xi, 3) + 0.2734375*xi;
    case 9:
        return 9.49609375*pow(xi, 10) - 25.13671875*pow(xi, 8) + 23.4609375*pow(xi, 6) - 9.0234375*pow(xi, 4) + 1.23046875*pow(xi, 2) - 0.02734375;
    case 10:
        return 16.40234375*pow(xi, 11) - 47.48046875*pow(xi, 9) + 50.2734375*pow(xi, 7) - 23.4609375*pow(xi, 5) + 4.51171875*pow(xi, 3) - 0.24609375*xi;
    case 11:
        return 28.7041015625*pow(xi, 12) - 90.212890625*pow(xi, 10) + 106.8310546875*pow(xi, 8) - 58.65234375*pow(xi, 6) + 14.6630859375*pow(xi, 4) - 1.353515625*pow(xi, 2) + 0.0205078125;
    case 12:
        return 50.7841796875*pow(xi, 13) - 172.224609375*pow(xi, 11) + 225.5322265625*pow(xi, 9) - 142.44140625*pow(xi, 7) + 43.9892578125*pow(xi, 5) - 5.865234375*pow(xi, 3) + 0.2255859375*xi;
    case 13:
        return 90.68603515625*pow(xi, 14) - 330.09716796875*pow(xi, 12) + 473.61767578125*pow(xi, 10) - 338.29833984375*pow(xi, 8) + 124.63623046875*pow(xi, 6) - 21.99462890625*pow(xi, 4) + 1.46630859375*pow(xi, 2) - 0.01611328125;
    case 14:
        return 163.23486328125*pow(xi, 15) - 634.80224609375*pow(xi, 13) + 990.29150390625*pow(xi, 11) - 789.36279296875*pow(xi, 9) + 338.29833984375*pow(xi, 7) - 74.78173828125*pow(xi, 5) + 7.33154296875*pow(xi, 3) - 0.20947265625*xi;
    case 15:
        return 295.86318969726563*pow(xi, 16) - 1224.261474609375*pow(xi, 14) + 2063.1072998046875*pow(xi, 12) - 1815.534423828125*pow(xi, 10) + 888.03314208984375*pow(xi, 8) - 236.808837890625*pow(xi, 6) + 31.1590576171875*pow(xi, 4) - 1.571044921875*pow(xi, 2) + 0.013092041015625;
    case 16:
        return 539.51522827148438*pow(xi, 17) - 2366.905517578125*pow(xi, 15) + 4284.9151611328125*pow(xi, 13) - 4126.214599609375*pow(xi, 11) + 2269.4180297851563*pow(xi, 9) - 710.426513671875*pow(xi, 7) + 118.4044189453125*pow(xi, 5) - 8.902587890625*pow(xi, 3) + 0.196380615234375*xi;
    case 17:
        return 989.11125183105469*pow(xi, 18) - 4585.8794403076172*pow(xi, 16) + 8875.8956909179688*pow(xi, 14) - 9283.9828491210938*pow(xi, 12) + 5673.5450744628906*pow(xi, 10) - 2042.4762268066406*pow(xi, 8) + 414.41546630859375*pow(xi, 6) - 42.28729248046875*pow(xi, 4) + 1.6692352294921875*pow(xi, 2) - 0.0109100341796875;
    case 18:
        return 1822.0470428466797*pow(xi, 19) - 8902.0012664794922*pow(xi, 17) + 18343.517761230469*pow(xi, 15) - 20710.423278808594*pow(xi, 13) + 13925.974273681641*pow(xi, 11) - 5673.5450744628906*pow(xi, 9) + 1361.6508178710938*pow(xi, 7) - 177.60662841796875*pow(xi, 5) + 10.571823120117188*pow(xi, 3) - 0.1854705810546875*xi;
    case 19:
        return 3370.7870292663574*pow(xi, 20) - 17309.446907043457*pow(xi, 18) + 37833.505382537842*pow(xi, 16) - 45858.794403076172*pow(xi, 14) + 33654.437828063965*pow(xi, 12) - 15318.571701049805*pow(xi, 10) + 4255.158805847168*pow(xi, 8) - 680.82540893554688*pow(xi, 6) + 55.502071380615234*pow(xi, 4) - 1.7619705200195313*pow(xi, 2) + 0.009273529052734375;
    case 20:
        return 6260.0330543518066*pow(xi, 21) - 33707.870292663574*pow(xi, 19) + 77892.511081695557*pow(xi, 17) - 100889.34768676758*pow(xi, 15) + 80252.890205383301*pow(xi, 13) - 40385.325393676758*pow(xi, 11) + 12765.476417541504*pow(xi, 9) - 2431.5193176269531*pow(xi, 7) + 255.30952835083008*pow(xi, 5) - 12.333793640136719*pow(xi, 3) + 0.17619705200195313*xi;
    case 21:
        return 11666.42523765564*pow(xi, 22) - 65730.34707069397*pow(xi, 20) + 160112.38389015198*pow(xi, 18) - 220695.44806480408*pow(xi, 16) + 189167.52691268921*pow(xi, 14) - 104328.75726699829*pow(xi, 12) + 37019.881610870361*pow(xi, 10) - 8206.3776969909668*pow(xi, 8) + 1063.789701461792*pow(xi, 6) - 70.919313430786133*pow(xi, 4) + 1.8500690460205078*pow(xi, 2) - 0.0080089569091796875;
    case 22:
        return 21811.142835617065*pow(xi, 23) - 128330.67761421204*pow(xi, 21) + 328651.73535346985*pow(xi, 19) - 480337.15167045593*pow(xi, 17) + 441390.89612960815*pow(xi, 15) - 264834.53767776489*pow(xi, 13) + 104328.75726699829*pow(xi, 11) - 26442.772579193115*pow(xi, 9) + 4103.1888484954834*pow(xi, 7) - 354.59656715393066*pow(xi, 5) + 14.183862686157227*pow(xi, 3) - 0.16818809509277344*xi;
    case 23:
        return 40895.892816781998*pow(xi, 24) - 250828.14260959625*pow(xi, 22) + 673736.05747461319*pow(xi, 20) - 1040730.4952859879*pow(xi, 18) + 1020716.4472997189*pow(xi, 16) - 662086.34419441223*pow(xi, 14) + 286904.0824842453*pow(xi, 12) - 81972.594995498657*pow(xi, 10) + 14874.059575796127*pow(xi, 8) - 1595.684552192688*pow(xi, 6) + 88.649141788482666*pow(xi, 4) - 1.9341630935668945*pow(xi, 2) + 0.0070078372955322266;
    case 24:
        return 76884.278495550156*pow(xi, 25) - 490750.71380138397*pow(xi, 23) + 1379554.7843527794*pow(xi, 21) - 2245786.8582487106*pow(xi, 19) + 2341643.6143934727*pow(xi, 17) - 1633146.3156795502*pow(xi, 15) + 772434.06822681427*pow(xi, 13) - 245917.78498649597*pow(xi, 11) + 51232.871872186661*pow(xi, 9) - 6610.6931447982788*pow(xi, 7) + 478.7053656578064*pow(xi, 5) - 16.118025779724121*pow(xi, 3) + 0.16118025779724121*xi;
    case 25:
        return 144897.2940877676*pow(xi, 26) - 961053.48119437695*pow(xi, 24) + 2821816.6043579578*pow(xi, 22) - 4828441.7452347279*pow(xi, 20) + 5333743.7883406878*pow(xi, 18) - 3980794.1444689035*pow(xi, 16) + 2041432.8945994377*pow(xi, 14) - 717260.20621061325*pow(xi, 12) + 169068.47717821598*pow(xi, 10) - 25616.43593609333*pow(xi, 8) + 2313.7426006793976*pow(xi, 6) - 108.79667401313782*pow(xi, 4) + 2.0147532224655151*pow(xi, 2) - 0.0061992406845092773;
    case 26:
        return 273694.88883244991*pow(xi, 27) - 1883664.8231409788*pow(xi, 25) + 5766320.8871662617*pow(xi, 23) - 10346660.882645845*pow(xi, 21) + 12071104.36308682*pow(xi, 19) - 9600738.819013238*pow(xi, 17) + 5307725.5259585381*pow(xi, 15) - 2041432.8945994377*pow(xi, 13) + 537945.15465795994*pow(xi, 11) - 93926.931765675545*pow(xi, 9) + 10246.574374437332*pow(xi, 7) - 631.02070927619934*pow(xi, 5) + 18.132779002189636*pow(xi, 3) - 0.15498101711273193*xi;
    case 27:
        return 518065.32528999448*pow(xi, 28) - 3694880.9992380738*pow(xi, 26) + 11772905.144631118*pow(xi, 24) - 22104230.06747067*pow(xi, 22) + 27159984.816945344*pow(xi, 20) - 22935098.289864957*pow(xi, 18) + 13601046.660268754*pow(xi, 16) - 5686848.7778127193*pow(xi, 14) + 1658664.2268620431*pow(xi, 12) - 328744.26117986441*pow(xi, 10) + 42267.119294553995*pow(xi, 8) - 3260.2736645936966*pow(xi, 6) + 131.46264776587486*pow(xi, 4) - 2.0922437310218811*pow(xi, 2) + 0.0055350363254547119;
    default:
        return 0.;
    }
}


EXPORTIT double fuv_xx(int i, double xi, double xi1t, double xi2t) {
    switch(i) {
    case 0:
        return xi1t*(0);
    case 1:
        return xi2t*(0);
    case 2:
        return 1.5*pow(xi, 2) - 0.5;
    case 3:
        return xi*(2.5*pow(xi, 2) - 1.5);
    case 4:
        return 4.375*pow(xi, 4) - 3.75*pow(xi, 2) + 0.375;
    case 5:
        return xi*(7.875*pow(xi, 4) - 8.75*pow(xi, 2) + 1.875);
    case 6:
        return 14.4375*pow(xi, 6) - 19.6875*pow(xi, 4) + 6.5625*pow(xi, 2) - 0.3125;
    case 7:
        return xi*(26.8125*pow(xi, 6) - 43.3125*pow(xi, 4) + 19.6875*pow(xi, 2) - 2.1875);
    case 8:
        return 50.2734375*pow(xi, 8) - 93.84375*pow(xi, 6) + 54.140625*pow(xi, 4) - 9.84375*pow(xi, 2) + 0.2734375;
    case 9:
        return xi*(94.9609375*pow(xi, 8) - 201.09375*pow(xi, 6) + 140.765625*pow(xi, 4) - 36.09375*pow(xi, 2) + 2.4609375);
    case 10:
        return 180.42578125*pow(xi, 10) - 427.32421875*pow(xi, 8) + 351.9140625*pow(xi, 6) - 117.3046875*pow(xi, 4) + 13.53515625*pow(xi, 2) - 0.24609375;
    case 11:
        return xi*(344.44921875*pow(xi, 10) - 902.12890625*pow(xi, 8) + 854.6484375*pow(xi, 6) - 351.9140625*pow(xi, 4) + 58.65234375*pow(xi, 2) - 2.70703125);
    case 12:
        return 660.1943359375*pow(xi, 12) - 1894.470703125*pow(xi, 10) + 2029.7900390625*pow(xi, 8) - 997.08984375*pow(xi, 6) + 219.9462890625*pow(xi, 4) - 17.595703125*pow(xi, 2) + 0.2255859375;
    case 13:
        return xi*(1269.6044921875*pow(xi, 12) - 3961.166015625*pow(xi, 10) + 4736.1767578125*pow(xi, 8) - 2706.38671875*pow(xi, 6) + 747.8173828125*pow(xi, 4) - 87.978515625*pow(xi, 2) + 2.9326171875);
    case 14:
        return 2448.52294921875*pow(xi, 14) - 8252.42919921875*pow(xi, 12) + 10893.20654296875*pow(xi, 10) - 7104.26513671875*pow(xi, 8) + 2368.08837890625*pow(xi, 6) - 373.90869140625*pow(xi, 4) + 21.99462890625*pow(xi, 2) - 0.20947265625;
    case 15:
        return xi*(4733.81103515625*pow(xi, 14) - 17139.66064453125*pow(xi, 12) + 24757.28759765625*pow(xi, 10) - 18155.34423828125*pow(xi, 8) + 7104.26513671875*pow(xi, 6) - 1420.85302734375*pow(xi, 4) + 124.63623046875*pow(xi, 2) - 3.14208984375);
    case 16:
        return 9171.7588806152344*pow(xi, 16) - 35503.582763671875*pow(xi, 14) + 55703.897094726563*pow(xi, 12) - 45388.360595703125*pow(xi, 10) + 20424.762268066406*pow(xi, 8) - 4972.985595703125*pow(xi, 6) + 592.0220947265625*pow(xi, 4) - 26.707763671875*pow(xi, 2) + 0.196380615234375;
    case 17:
        return xi*(17804.002532958984*pow(xi, 16) - 73374.071044921875*pow(xi, 14) + 124262.53967285156*pow(xi, 12) - 111407.79418945313*pow(xi, 10) + 56735.450744628906*pow(xi, 8) - 16339.809814453125*pow(xi, 6) + 2486.4927978515625*pow(xi, 4) - 169.149169921875*pow(xi, 2) + 3.338470458984375);
    case 18:
        return 34618.893814086914*pow(xi, 18) - 151334.02153015137*pow(xi, 16) + 275152.76641845703*pow(xi, 14) - 269235.50262451172*pow(xi, 12) + 153185.71701049805*pow(xi, 10) - 51061.905670166016*pow(xi, 8) + 9531.5557250976563*pow(xi, 6) - 888.03314208984375*pow(xi, 4) + 31.715469360351563*pow(xi, 2) - 0.1854705810546875;
    case 19:
        return xi*(67415.740585327148*pow(xi, 18) - 311570.04432678223*pow(xi, 16) + 605336.08612060547*pow(xi, 14) - 642023.12164306641*pow(xi, 12) + 403853.25393676758*pow(xi, 10) - 153185.71701049805*pow(xi, 8) + 34041.270446777344*pow(xi, 6) - 4084.9524536132813*pow(xi, 4) + 222.00828552246094*pow(xi, 2) - 3.5239410400390625);
    case 20:
        return 131460.69414138794*pow(xi, 20) - 640449.53556060791*pow(xi, 18) + 1324172.6883888245*pow(xi, 16) - 1513340.2153015137*pow(xi, 14) + 1043287.5726699829*pow(xi, 12) - 444238.57933044434*pow(xi, 10) + 114889.28775787354*pow(xi, 8) - 17020.635223388672*pow(xi, 6) + 1276.5476417541504*pow(xi, 4) - 37.001380920410156*pow(xi, 2) + 0.17619705200195313;
    case 21:
        return xi*(256661.35522842407*pow(xi, 20) - 1314606.9414138794*pow(xi, 18) + 2882022.9100227356*pow(xi, 16) - 3531127.1690368652*pow(xi, 14) + 2648345.3767776489*pow(xi, 12) - 1251945.0872039795*pow(xi, 10) + 370198.81610870361*pow(xi, 8) - 65651.021575927734*pow(xi, 6) + 6382.738208770752*pow(xi, 4) - 283.67725372314453*pow(xi, 2) + 3.7001380920410156);
    case 22:
        return 501656.2852191925*pow(xi, 22) - 2694944.2298984528*pow(xi, 20) + 6244382.9717159271*pow(xi, 18) - 8165731.5783977509*pow(xi, 16) + 6620863.4419441223*pow(xi, 14) - 3442848.9898109436*pow(xi, 12) + 1147616.3299369812*pow(xi, 10) - 237984.95321273804*pow(xi, 8) + 28722.321939468384*pow(xi, 6) - 1772.9828357696533*pow(xi, 4) + 42.55158805847168*pow(xi, 2) - 0.16818809509277344;
    case 23:
        return xi*(981501.42760276794*pow(xi, 22) - 5518219.1374111176*pow(xi, 20) + 13474721.149492264*pow(xi, 18) - 18733148.915147781*pow(xi, 16) + 16331463.156795502*pow(xi, 14) - 9269208.8187217712*pow(xi, 12) + 3442848.9898109436*pow(xi, 10) - 819725.94995498657*pow(xi, 8) + 118992.47660636902*pow(xi, 6) - 9574.1073131561279*pow(xi, 4) + 354.59656715393066*pow(xi, 2) - 3.8683261871337891);
    case 24:
        return 1922106.9623887539*pow(xi, 24) - 11287266.417431831*pow(xi, 22) + 28970650.471408367*pow(xi, 20) - 42669950.306725502*pow(xi, 18) + 39807941.444689035*pow(xi, 16) - 24497194.735193253*pow(xi, 14) + 10041642.886948586*pow(xi, 12) - 2705095.6348514557*pow(xi, 10) + 461095.84684967995*pow(xi, 8) - 46274.852013587952*pow(xi, 6) + 2393.526828289032*pow(xi, 4) - 48.354077339172363*pow(xi, 2) + 0.16118025779724121;
    case 25:
        return xi*(3767329.6462819576*pow(xi, 24) - 23065283.548665047*pow(xi, 22) + 62079965.295875072*pow(xi, 20) - 96568834.904694557*pow(xi, 18) + 96007388.19013238*pow(xi, 16) - 63692706.311502457*pow(xi, 14) + 28580060.524392128*pow(xi, 12) - 8607122.474527359*pow(xi, 10) + 1690684.7717821598*pow(xi, 8) - 204931.48748874664*pow(xi, 6) + 13882.455604076385*pow(xi, 4) - 435.18669605255127*pow(xi, 2) + 4.0295064449310303);
    case 26:
        return 7389761.9984761477*pow(xi, 26) - 47091620.57852447*pow(xi, 24) + 132625380.40482402*pow(xi, 22) - 217279878.53556275*pow(xi, 20) + 229350982.89864957*pow(xi, 18) - 163212559.92322505*pow(xi, 16) + 79615882.889378071*pow(xi, 14) - 26538627.62979269*pow(xi, 12) + 5917396.7012375593*pow(xi, 10) - 845342.3858910799*pow(xi, 8) + 71726.020621061325*pow(xi, 6) - 3155.1035463809967*pow(xi, 4) + 54.398337006568909*pow(xi, 2) - 0.15498101711273193;
    case 27:
        return xi*(14505829.108119845*pow(xi, 26) - 96066905.980189919*pow(xi, 24) + 282549723.47114682*pow(xi, 22) - 486293061.48435473*pow(xi, 20) + 543199696.33890688*pow(xi, 18) - 412831769.21756923*pow(xi, 16) + 217616746.56430006*pow(xi, 14) - 79615882.889378071*pow(xi, 12) + 19903970.722344518*pow(xi, 10) - 3287442.6117986441*pow(xi, 8) + 338136.95435643196*pow(xi, 6) - 19561.64198756218*pow(xi, 4) + 525.85059106349945*pow(xi, 2) - 4.1844874620437622);
    default:
        return 0.;
    }
}
