// Legendre-Gauss Quadrature Points and Weights

#if defined(_WIN32) || defined(__WIN32__)
  #define EXPORTIT __declspec(dllexport)
#else
  #define EXPORTIT
#endif

EXPORTIT void leggauss_quad(int n, double *points, double *weights) {
    switch(n) {
    case 2:
        points[0] = -0.577350269189625764509148780501957455647601751270126876;
        points[1] = 0.577350269189625764509148780501957455647601751270126876;
        weights[0] = 1.;
        weights[1] = 1.;
        return;
    case 3:
        points[0] = -0.774596669241483377035853079956479922166584341058318165;
        points[1] = 0;
        points[2] = 0.774596669241483377035853079956479922166584341058318165;
        weights[0] = 0.555555555555555555555555555555555555555555555555555556;
        weights[1] = 0.888888888888888888888888888888888888888888888888888889;
        weights[2] = 0.555555555555555555555555555555555555555555555555555556;
        return;
    case 4:
        points[0] = -0.861136311594052575223946488892809505095725379629717638;
        points[1] = -0.339981043584856264802665759103244687200575869770914353;
        points[2] = 0.339981043584856264802665759103244687200575869770914353;
        points[3] = 0.861136311594052575223946488892809505095725379629717638;
        weights[0] = 0.34785484513745385737306394922199940723534869583389354;
        weights[1] = 0.65214515486254614262693605077800059276465130416610646;
        weights[2] = 0.65214515486254614262693605077800059276465130416610646;
        weights[3] = 0.34785484513745385737306394922199940723534869583389354;
        return;
    case 5:
        points[0] = -0.906179845938663992797626878299392965125651910762530863;
        points[1] = -0.538469310105683091036314420700208804967286606905559956;
        points[2] = 0;
        points[3] = 0.538469310105683091036314420700208804967286606905559956;
        points[4] = 0.906179845938663992797626878299392965125651910762530863;
        weights[0] = 0.236926885056189087514264040719917362643260002212414016;
        weights[1] = 0.47862867049936646804129151483563819291229555334314154;
        weights[2] = 0.568888888888888888888888888888888888888888888888888889;
        weights[3] = 0.47862867049936646804129151483563819291229555334314154;
        weights[4] = 0.236926885056189087514264040719917362643260002212414016;
        return;
    case 6:
        points[0] = -0.932469514203152027812301554493994609134765737712289825;
        points[1] = -0.661209386466264513661399595019905347006448564395170071;
        points[2] = -0.23861918608319690863050172168071193541861063014002135;
        points[3] = 0.23861918608319690863050172168071193541861063014002135;
        points[4] = 0.661209386466264513661399595019905347006448564395170071;
        points[5] = 0.932469514203152027812301554493994609134765737712289825;
        weights[0] = 0.171324492379170345040296142172732893526822501484043982;
        weights[1] = 0.360761573048138607569833513837716111661521892746745482;
        weights[2] = 0.467913934572691047389870343989550994811655605769210535;
        weights[3] = 0.467913934572691047389870343989550994811655605769210535;
        weights[4] = 0.360761573048138607569833513837716111661521892746745482;
        weights[5] = 0.171324492379170345040296142172732893526822501484043982;
        return;
    case 7:
        points[0] = -0.949107912342758524526189684047851262400770937670617784;
        points[1] = -0.74153118559939443986386477328078840707414764714139026;
        points[2] = -0.405845151377397166906606412076961463347382014099370126;
        points[3] = 0;
        points[4] = 0.405845151377397166906606412076961463347382014099370126;
        points[5] = 0.74153118559939443986386477328078840707414764714139026;
        points[6] = 0.949107912342758524526189684047851262400770937670617784;
        weights[0] = 0.129484966168869693270611432679082018328587402259946664;
        weights[1] = 0.279705391489276667901467771423779582486925065226598765;
        weights[2] = 0.381830050505118944950369775488975133878365083533862735;
        weights[3] = 0.417959183673469387755102040816326530612244897959183673;
        weights[4] = 0.381830050505118944950369775488975133878365083533862735;
        weights[5] = 0.279705391489276667901467771423779582486925065226598765;
        weights[6] = 0.129484966168869693270611432679082018328587402259946664;
        return;
    case 8:
        points[0] = -0.960289856497536231683560868569472990428235234301452038;
        points[1] = -0.796666477413626739591553936475830436837171731615964832;
        points[2] = -0.525532409916328985817739049189246349041964243120392858;
        points[3] = -0.183434642495649804939476142360183980666757812912973782;
        points[4] = 0.183434642495649804939476142360183980666757812912973782;
        points[5] = 0.525532409916328985817739049189246349041964243120392858;
        points[6] = 0.796666477413626739591553936475830436837171731615964832;
        points[7] = 0.960289856497536231683560868569472990428235234301452038;
        weights[0] = 0.1012285362903762591525313543099621901153940910516849571;
        weights[1] = 0.222381034453374470544355994426240884430130870051249565;
        weights[2] = 0.313706645877887287337962201986601313260328999002734938;
        weights[3] = 0.362683783378361982965150449277195612194146039894330541;
        weights[4] = 0.362683783378361982965150449277195612194146039894330541;
        weights[5] = 0.313706645877887287337962201986601313260328999002734938;
        weights[6] = 0.222381034453374470544355994426240884430130870051249565;
        weights[7] = 0.1012285362903762591525313543099621901153940910516849571;
        return;
    case 9:
        points[0] = -0.96816023950762608983557620290367287004940480049192533;
        points[1] = -0.836031107326635794299429788069734876544106718124675996;
        points[2] = -0.613371432700590397308702039341474184785720604940564693;
        points[3] = -0.324253423403808929038538014643336608571956260736973089;
        points[4] = 0;
        points[5] = 0.324253423403808929038538014643336608571956260736973089;
        points[6] = 0.613371432700590397308702039341474184785720604940564693;
        points[7] = 0.836031107326635794299429788069734876544106718124675996;
        points[8] = 0.96816023950762608983557620290367287004940480049192533;
        weights[0] = 0.0812743883615744119718921581105236506756617207824107507;
        weights[1] = 0.180648160694857404058472031242912809514337821732040484;
        weights[2] = 0.260610696402935462318742869418632849771840204437299952;
        weights[3] = 0.312347077040002840068630406584443665598754861261904646;
        weights[4] = 0.330239355001259763164525069286974048878810783572688335;
        weights[5] = 0.312347077040002840068630406584443665598754861261904646;
        weights[6] = 0.260610696402935462318742869418632849771840204437299952;
        weights[7] = 0.180648160694857404058472031242912809514337821732040484;
        weights[8] = 0.0812743883615744119718921581105236506756617207824107507;
        return;
    case 10:
        points[0] = -0.973906528517171720077964012084452053428269946692382119;
        points[1] = -0.865063366688984510732096688423493048527543014965330453;
        points[2] = -0.679409568299024406234327365114873575769294711834809468;
        points[3] = -0.433395394129247190799265943165784162200071837656246497;
        points[4] = -0.148874338981631210884826001129719984617564859420691696;
        points[5] = 0.148874338981631210884826001129719984617564859420691696;
        points[6] = 0.433395394129247190799265943165784162200071837656246497;
        points[7] = 0.679409568299024406234327365114873575769294711834809468;
        points[8] = 0.865063366688984510732096688423493048527543014965330453;
        points[9] = 0.973906528517171720077964012084452053428269946692382119;
        weights[0] = 0.0666713443086881375935688098933317928578648343201581451;
        weights[1] = 0.149451349150580593145776339657697332402556639669427368;
        weights[2] = 0.21908636251598204399553493422816319245877187052267709;
        weights[3] = 0.269266719309996355091226921569469352859759938460883796;
        weights[4] = 0.295524224714752870173892994651338329421046717026853601;
        weights[5] = 0.295524224714752870173892994651338329421046717026853601;
        weights[6] = 0.269266719309996355091226921569469352859759938460883796;
        weights[7] = 0.21908636251598204399553493422816319245877187052267709;
        weights[8] = 0.149451349150580593145776339657697332402556639669427368;
        weights[9] = 0.0666713443086881375935688098933317928578648343201581451;
        return;
    case 11:
        points[0] = -0.978228658146056992803938001122857390771422408919784415;
        points[1] = -0.887062599768095299075157769303927266631675751225314385;
        points[2] = -0.730152005574049324093416252031153458049643062026130312;
        points[3] = -0.519096129206811815925725669458609554480227115119928489;
        points[4] = -0.269543155952344972331531985400861524679621862439052282;
        points[5] = 0;
        points[6] = 0.269543155952344972331531985400861524679621862439052282;
        points[7] = 0.519096129206811815925725669458609554480227115119928489;
        points[8] = 0.730152005574049324093416252031153458049643062026130312;
        points[9] = 0.887062599768095299075157769303927266631675751225314385;
        points[10] = 0.978228658146056992803938001122857390771422408919784415;
        weights[0] = 0.0556685671161736664827537204425485787285156256968981483;
        weights[1] = 0.125580369464904624634694299223940100197615791395403501;
        weights[2] = 0.186290210927734251426097641431655891691284748040203412;
        weights[3] = 0.233193764591990479918523704843175139431798172316958509;
        weights[4] = 0.262804544510246662180688869890509195372764677603144556;
        weights[5] = 0.272925086777900630714483528336342189156041969894783748;
        weights[6] = 0.262804544510246662180688869890509195372764677603144556;
        weights[7] = 0.233193764591990479918523704843175139431798172316958509;
        weights[8] = 0.186290210927734251426097641431655891691284748040203412;
        weights[9] = 0.125580369464904624634694299223940100197615791395403501;
        weights[10] = 0.0556685671161736664827537204425485787285156256968981483;
        return;
    case 12:
        points[0] = -0.98156063424671925069054909014928082296015519981373151;
        points[1] = -0.904117256370474856678465866119096192537596709213297547;
        points[2] = -0.769902674194304687036893833212818075984925750018931638;
        points[3] = -0.587317954286617447296702418940534280369098514048052482;
        points[4] = -0.367831498998180193752691536643717561256360141335409621;
        points[5] = -0.125233408511468915472441369463853129983396916305444273;
        points[6] = 0.125233408511468915472441369463853129983396916305444273;
        points[7] = 0.367831498998180193752691536643717561256360141335409621;
        points[8] = 0.587317954286617447296702418940534280369098514048052482;
        points[9] = 0.769902674194304687036893833212818075984925750018931638;
        points[10] = 0.904117256370474856678465866119096192537596709213297547;
        points[11] = 0.98156063424671925069054909014928082296015519981373151;
        weights[0] = 0.0471753363865118271946159614850170603170290739948470896;
        weights[1] = 0.10693932599531843096025471819399622421457017347032488;
        weights[2] = 0.160078328543346226334652529543359071872011730490864178;
        weights[3] = 0.203167426723065921749064455809798376506518147274590146;
        weights[4] = 0.233492536538354808760849898924878056259409972199754875;
        weights[5] = 0.249147045813402785000562436042951210830460902569618831;
        weights[6] = 0.249147045813402785000562436042951210830460902569618831;
        weights[7] = 0.233492536538354808760849898924878056259409972199754875;
        weights[8] = 0.203167426723065921749064455809798376506518147274590146;
        weights[9] = 0.160078328543346226334652529543359071872011730490864178;
        weights[10] = 0.10693932599531843096025471819399622421457017347032488;
        weights[11] = 0.0471753363865118271946159614850170603170290739948470896;
        return;
    case 13:
        points[0] = -0.984183054718588149472829448807109611064990561925874909;
        points[1] = -0.917598399222977965206547836500719512390474790111683296;
        points[2] = -0.80157809073330991279420648958285989030561572479050003;
        points[3] = -0.642349339440340220643984606995515650071697398261576857;
        points[4] = -0.448492751036446852877912852127639867801921667441757879;
        points[5] = -0.230458315955134794065528121097988835211542375883531163;
        points[6] = 0;
        points[7] = 0.230458315955134794065528121097988835211542375883531163;
        points[8] = 0.448492751036446852877912852127639867801921667441757879;
        points[9] = 0.642349339440340220643984606995515650071697398261576857;
        points[10] = 0.80157809073330991279420648958285989030561572479050003;
        points[11] = 0.917598399222977965206547836500719512390474790111683296;
        points[12] = 0.984183054718588149472829448807109611064990561925874909;
        weights[0] = 0.0404840047653158795200215922009860600419865457449888681;
        weights[1] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[2] = 0.138873510219787238463601776868871467621862718263298228;
        weights[3] = 0.178145980761945738280046691996097995512812650661016503;
        weights[4] = 0.207816047536888502312523219306052763386582609199503549;
        weights[5] = 0.22628318026289723841209018603977661843475773761555702;
        weights[6] = 0.232551553230873910194589515268835948156627477306797986;
        weights[7] = 0.22628318026289723841209018603977661843475773761555702;
        weights[8] = 0.207816047536888502312523219306052763386582609199503549;
        weights[9] = 0.178145980761945738280046691996097995512812650661016503;
        weights[10] = 0.138873510219787238463601776868871467621862718263298228;
        weights[11] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[12] = 0.0404840047653158795200215922009860600419865457449888681;
        return;
    case 14:
        points[0] = -0.986283808696812338841597266704052801676091407239225882;
        points[1] = -0.928434883663573517336391139377874264477039210409837619;
        points[2] = -0.827201315069764993189794742650394961039701101475081182;
        points[3] = -0.687292904811685470148019803019334137538401212747170676;
        points[4] = -0.515248636358154091965290718551188662308885282569306037;
        points[5] = -0.319112368927889760435671824168475466834261203533843957;
        points[6] = -0.108054948707343662066244650219834747611951605474237557;
        points[7] = 0.108054948707343662066244650219834747611951605474237557;
        points[8] = 0.319112368927889760435671824168475466834261203533843957;
        points[9] = 0.515248636358154091965290718551188662308885282569306037;
        points[10] = 0.687292904811685470148019803019334137538401212747170676;
        points[11] = 0.827201315069764993189794742650394961039701101475081182;
        points[12] = 0.928434883663573517336391139377874264477039210409837619;
        points[13] = 0.986283808696812338841597266704052801676091407239225882;
        weights[0] = 0.0351194603317518630318328761381917806197056092771272766;
        weights[1] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[2] = 0.121518570687903184689414809072476625956669345690074672;
        weights[3] = 0.157203167158193534569601938623842156605668037337323375;
        weights[4] = 0.185538397477937813741716590125157036248922602937331659;
        weights[5] = 0.205198463721295603965924065661218055710339061309419452;
        weights[6] = 0.2152638534631577901958764433162600352749975580541288;
        weights[7] = 0.2152638534631577901958764433162600352749975580541288;
        weights[8] = 0.205198463721295603965924065661218055710339061309419452;
        weights[9] = 0.185538397477937813741716590125157036248922602937331659;
        weights[10] = 0.157203167158193534569601938623842156605668037337323375;
        weights[11] = 0.121518570687903184689414809072476625956669345690074672;
        weights[12] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[13] = 0.0351194603317518630318328761381917806197056092771272766;
        return;
    case 15:
        points[0] = -0.98799251802048542848956571858661258114697281712376149;
        points[1] = -0.937273392400705904307758947710209471243996273515304458;
        points[2] = -0.848206583410427216200648320774216851366256174736992634;
        points[3] = -0.724417731360170047416186054613938009630899294584102564;
        points[4] = -0.570972172608538847537226737253910641238386396282749605;
        points[5] = -0.394151347077563369897207370981045468362752776158698255;
        points[6] = -0.20119409399743452230062830339459620781283645446263768;
        points[7] = 0;
        points[8] = 0.20119409399743452230062830339459620781283645446263768;
        points[9] = 0.394151347077563369897207370981045468362752776158698255;
        points[10] = 0.570972172608538847537226737253910641238386396282749605;
        points[11] = 0.724417731360170047416186054613938009630899294584102564;
        points[12] = 0.848206583410427216200648320774216851366256174736992634;
        points[13] = 0.937273392400705904307758947710209471243996273515304458;
        points[14] = 0.98799251802048542848956571858661258114697281712376149;
        weights[0] = 0.0307532419961172683546283935772044177217481448334340743;
        weights[1] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[2] = 0.107159220467171935011869546685869303415543715758101981;
        weights[3] = 0.139570677926154314447804794511028322520850275315511243;
        weights[4] = 0.166269205816993933553200860481208811130900180098412907;
        weights[5] = 0.186161000015562211026800561866422824506226012277928403;
        weights[6] = 0.198431485327111576456118326443839324818692559957541993;
        weights[7] = 0.202578241925561272880620199967519314838662158009477357;
        weights[8] = 0.198431485327111576456118326443839324818692559957541993;
        weights[9] = 0.186161000015562211026800561866422824506226012277928403;
        weights[10] = 0.166269205816993933553200860481208811130900180098412907;
        weights[11] = 0.139570677926154314447804794511028322520850275315511243;
        weights[12] = 0.107159220467171935011869546685869303415543715758101981;
        weights[13] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[14] = 0.0307532419961172683546283935772044177217481448334340743;
        return;
    case 16:
        points[0] = -0.98940093499164993259615417345033262742627407165764513;
        points[1] = -0.944575023073232576077988415534608345091139272591072601;
        points[2] = -0.865631202387831743880467897712393132387335384847526708;
        points[3] = -0.75540440835500303389510119484744226835381365645750301;
        points[4] = -0.617876244402643748446671764048791018991882217765657794;
        points[5] = -0.458016777657227386342419442983577573540031613035523491;
        points[6] = -0.281603550779258913230460501460496106486069490770599801;
        points[7] = -0.0950125098376374401853193354249580631303530556890654567;
        points[8] = 0.0950125098376374401853193354249580631303530556890654567;
        points[9] = 0.281603550779258913230460501460496106486069490770599801;
        points[10] = 0.458016777657227386342419442983577573540031613035523491;
        points[11] = 0.617876244402643748446671764048791018991882217765657794;
        points[12] = 0.75540440835500303389510119484744226835381365645750301;
        points[13] = 0.865631202387831743880467897712393132387335384847526708;
        points[14] = 0.944575023073232576077988415534608345091139272591072601;
        points[15] = 0.98940093499164993259615417345033262742627407165764513;
        weights[0] = 0.027152459411754094851780572456018103512267375566760798;
        weights[1] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[2] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[3] = 0.12462897125553387205247628219201642014488685922220268;
        weights[4] = 0.149595988816576732081501730547478548970491068207836467;
        weights[5] = 0.169156519395002538189312079030359962211639473416028282;
        weights[6] = 0.182603415044923588866763667969219939383556223654649282;
        weights[7] = 0.189450610455068496285396723208283105146908988395902975;
        weights[8] = 0.189450610455068496285396723208283105146908988395902975;
        weights[9] = 0.182603415044923588866763667969219939383556223654649282;
        weights[10] = 0.169156519395002538189312079030359962211639473416028282;
        weights[11] = 0.149595988816576732081501730547478548970491068207836467;
        weights[12] = 0.12462897125553387205247628219201642014488685922220268;
        weights[13] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[14] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[15] = 0.027152459411754094851780572456018103512267375566760798;
        return;
    case 17:
        points[0] = -0.990575475314417335675434019940665276507789850459564303;
        points[1] = -0.950675521768767761222716957895803021443385046559108708;
        points[2] = -0.8802391537269859021229556944881556926234168179344279;
        points[3] = -0.781514003896801406925230055520476050223972472740568513;
        points[4] = -0.657671159216690765850302216643002335147805891475973244;
        points[5] = -0.512690537086476967886246568629551874582923722411172906;
        points[6] = -0.351231763453876315297185517095346005040539751575675023;
        points[7] = -0.178484181495847855850677493654065557475419332691525644;
        points[8] = 0;
        points[9] = 0.178484181495847855850677493654065557475419332691525644;
        points[10] = 0.351231763453876315297185517095346005040539751575675023;
        points[11] = 0.512690537086476967886246568629551874582923722411172906;
        points[12] = 0.657671159216690765850302216643002335147805891475973244;
        points[13] = 0.781514003896801406925230055520476050223972472740568513;
        points[14] = 0.8802391537269859021229556944881556926234168179344279;
        points[15] = 0.950675521768767761222716957895803021443385046559108708;
        points[16] = 0.990575475314417335675434019940665276507789850459564303;
        weights[0] = 0.0241483028685479319601100262875653246916973159450252783;
        weights[1] = 0.055459529373987201129440165358244660512846251953228847;
        weights[2] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[3] = 0.11188384719340397109478838562635592673584342426307705;
        weights[4] = 0.13513636846852547328631998170235019737212585323448902;
        weights[5] = 0.154045761076810288081431594801958611940483058471017934;
        weights[6] = 0.168004102156450044509970663788323155021198128965074014;
        weights[7] = 0.176562705366992646325270990113197239150924418000748118;
        weights[8] = 0.179446470356206525458265644261885621448780319897668524;
        weights[9] = 0.176562705366992646325270990113197239150924418000748118;
        weights[10] = 0.168004102156450044509970663788323155021198128965074014;
        weights[11] = 0.154045761076810288081431594801958611940483058471017934;
        weights[12] = 0.13513636846852547328631998170235019737212585323448902;
        weights[13] = 0.11188384719340397109478838562635592673584342426307705;
        weights[14] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[15] = 0.055459529373987201129440165358244660512846251953228847;
        weights[16] = 0.0241483028685479319601100262875653246916973159450252783;
        return;
    case 18:
        points[0] = -0.991565168420930946730016004706150770252578936845439693;
        points[1] = -0.955823949571397755181195892929776309972844134811306479;
        points[2] = -0.892602466497555739206060591127145515407895271352298214;
        points[3] = -0.803704958972523115682417455014590797103298921611922482;
        points[4] = -0.691687043060353207874891081288848389452270572817507759;
        points[5] = -0.559770831073947534607871548525329136927626485770709417;
        points[6] = -0.411751161462842646035931793833051637078989682120025511;
        points[7] = -0.251886225691505509588972854877911230162861765659640458;
        points[8] = -0.08477501304173530124226185293578381173331738690608992;
        points[9] = 0.08477501304173530124226185293578381173331738690608992;
        points[10] = 0.251886225691505509588972854877911230162861765659640458;
        points[11] = 0.411751161462842646035931793833051637078989682120025511;
        points[12] = 0.559770831073947534607871548525329136927626485770709417;
        points[13] = 0.691687043060353207874891081288848389452270572817507759;
        points[14] = 0.803704958972523115682417455014590797103298921611922482;
        points[15] = 0.892602466497555739206060591127145515407895271352298214;
        points[16] = 0.955823949571397755181195892929776309972844134811306479;
        points[17] = 0.991565168420930946730016004706150770252578936845439693;
        weights[0] = 0.0216160135264833103133427102664524693876852314755899455;
        weights[1] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[2] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[3] = 0.100942044106287165562813984924834607062801138887678902;
        weights[4] = 0.122555206711478460184519126800201555228163897333439097;
        weights[5] = 0.14064291467065065120473130375194722809550241033097256;
        weights[6] = 0.154684675126265244925418003836374772193218396267354173;
        weights[7] = 0.164276483745832722986053776465927590412338953997352953;
        weights[8] = 0.16914238296314359184065647013498661033410581937034388;
        weights[9] = 0.16914238296314359184065647013498661033410581937034388;
        weights[10] = 0.164276483745832722986053776465927590412338953997352953;
        weights[11] = 0.154684675126265244925418003836374772193218396267354173;
        weights[12] = 0.14064291467065065120473130375194722809550241033097256;
        weights[13] = 0.122555206711478460184519126800201555228163897333439097;
        weights[14] = 0.100942044106287165562813984924834607062801138887678902;
        weights[15] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[16] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[17] = 0.0216160135264833103133427102664524693876852314755899455;
        return;
    case 19:
        points[0] = -0.992406843843584403189017670253260493589316401403210787;
        points[1] = -0.960208152134830030852778840687651526615091503274138106;
        points[2] = -0.903155903614817901642660928532312487809393934057355818;
        points[3] = -0.822714656537142824978922486712713901774538486206830041;
        points[4] = -0.720966177335229378617095860823781629657141832908666775;
        points[5] = -0.600545304661681023469638164946239279868322082732292568;
        points[6] = -0.464570741375960945717267148104102367976285714624136597;
        points[7] = -0.316564099963629831990117328849844917892285219132887245;
        points[8] = -0.160358645640225375868096115740743549504873500470875379;
        points[9] = 0;
        points[10] = 0.160358645640225375868096115740743549504873500470875379;
        points[11] = 0.316564099963629831990117328849844917892285219132887245;
        points[12] = 0.464570741375960945717267148104102367976285714624136597;
        points[13] = 0.600545304661681023469638164946239279868322082732292568;
        points[14] = 0.720966177335229378617095860823781629657141832908666775;
        points[15] = 0.822714656537142824978922486712713901774538486206830041;
        points[16] = 0.903155903614817901642660928532312487809393934057355818;
        points[17] = 0.960208152134830030852778840687651526615091503274138106;
        points[18] = 0.992406843843584403189017670253260493589316401403210787;
        weights[0] = 0.0194617882297264770363120414644384357529066090692866408;
        weights[1] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[2] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[3] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[4] = 0.111566645547333994716023901681765997481331853839893776;
        weights[5] = 0.128753962539336227675515784856877117055839577093463035;
        weights[6] = 0.142606702173606611775746109441902972475668344824473861;
        weights[7] = 0.152766042065859666778855400897662998461008267236428624;
        weights[8] = 0.158968843393954347649956439465047201678780158195126096;
        weights[9] = 0.161054449848783695979163625320916735039902558578516902;
        weights[10] = 0.158968843393954347649956439465047201678780158195126096;
        weights[11] = 0.152766042065859666778855400897662998461008267236428624;
        weights[12] = 0.142606702173606611775746109441902972475668344824473861;
        weights[13] = 0.128753962539336227675515784856877117055839577093463035;
        weights[14] = 0.111566645547333994716023901681765997481331853839893776;
        weights[15] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[16] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[17] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[18] = 0.0194617882297264770363120414644384357529066090692866408;
        return;
    case 20:
        points[0] = -0.993128599185094924786122388471320278222647130901655896;
        points[1] = -0.963971927277913791267666131197277221912060327806188856;
        points[2] = -0.912234428251325905867752441203298113049184797423691775;
        points[3] = -0.839116971822218823394529061701520685329629365065637373;
        points[4] = -0.746331906460150792614305070355641590310730679569176444;
        points[5] = -0.636053680726515025452836696226285936743389116799368464;
        points[6] = -0.510867001950827098004364050955250998425491329202426833;
        points[7] = -0.373706088715419560672548177024927237395746321705682712;
        points[8] = -0.227785851141645078080496195368574624743088937682927472;
        points[9] = -0.0765265211334973337546404093988382110047962668134975008;
        points[10] = 0.0765265211334973337546404093988382110047962668134975008;
        points[11] = 0.227785851141645078080496195368574624743088937682927472;
        points[12] = 0.373706088715419560672548177024927237395746321705682712;
        points[13] = 0.510867001950827098004364050955250998425491329202426833;
        points[14] = 0.636053680726515025452836696226285936743389116799368464;
        points[15] = 0.746331906460150792614305070355641590310730679569176444;
        points[16] = 0.839116971822218823394529061701520685329629365065637373;
        points[17] = 0.912234428251325905867752441203298113049184797423691775;
        points[18] = 0.963971927277913791267666131197277221912060327806188856;
        points[19] = 0.993128599185094924786122388471320278222647130901655896;
        weights[0] = 0.0176140071391521183118619623518528163621431055433367325;
        weights[1] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[2] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[3] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[4] = 0.101930119817240435036750135480349876166691656023392556;
        weights[5] = 0.118194531961518417312377377711382287005041219548968775;
        weights[6] = 0.131688638449176626898494499748163134916110511146983527;
        weights[7] = 0.142096109318382051329298325067164933034515413392020303;
        weights[8] = 0.149172986472603746787828737001969436692679904081368316;
        weights[9] = 0.152753387130725850698084331955097593491948645112378597;
        weights[10] = 0.152753387130725850698084331955097593491948645112378597;
        weights[11] = 0.149172986472603746787828737001969436692679904081368316;
        weights[12] = 0.142096109318382051329298325067164933034515413392020303;
        weights[13] = 0.131688638449176626898494499748163134916110511146983527;
        weights[14] = 0.118194531961518417312377377711382287005041219548968775;
        weights[15] = 0.101930119817240435036750135480349876166691656023392556;
        weights[16] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[17] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[18] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[19] = 0.0176140071391521183118619623518528163621431055433367325;
        return;
    case 21:
        points[0] = -0.993752170620389500260242035937940929193338454782329186;
        points[1] = -0.96722683856630629431662221490769516142469368732984685;
        points[2] = -0.920099334150400828790187133714968894159147609648221697;
        points[3] = -0.853363364583317283647250638587567670276105803179343971;
        points[4] = -0.768439963475677908615877851306228034820976705771369551;
        points[5] = -0.667138804197412319305966669990339162597029343311402842;
        points[6] = -0.551618835887219807059018796724313286622060224230679665;
        points[7] = -0.424342120207438783573668888543788052096445231839634584;
        points[8] = -0.288021316802401096600792516064600319909018263646033229;
        points[9] = -0.145561854160895090937030982338686330116326024437937757;
        points[10] = 0;
        points[11] = 0.145561854160895090937030982338686330116326024437937757;
        points[12] = 0.288021316802401096600792516064600319909018263646033229;
        points[13] = 0.424342120207438783573668888543788052096445231839634584;
        points[14] = 0.551618835887219807059018796724313286622060224230679665;
        points[15] = 0.667138804197412319305966669990339162597029343311402842;
        points[16] = 0.768439963475677908615877851306228034820976705771369551;
        points[17] = 0.853363364583317283647250638587567670276105803179343971;
        points[18] = 0.920099334150400828790187133714968894159147609648221697;
        points[19] = 0.96722683856630629431662221490769516142469368732984685;
        points[20] = 0.993752170620389500260242035937940929193338454782329186;
        weights[0] = 0.0160172282577743333242246168584710152658904221179024825;
        weights[1] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[2] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[3] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[4] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[5] = 0.108797299167148377663474578070105642033699595793856331;
        weights[6] = 0.12183141605372853419536717712573359835633762556153745;
        weights[7] = 0.132268938633337461781052574496775604329011540143156823;
        weights[8] = 0.139887394791073154722133423867583110892793160954919604;
        weights[9] = 0.144524403989970059063827166553752543609949962197099835;
        weights[10] = 0.146081133649690427191985147683371188244809576941965444;
        weights[11] = 0.144524403989970059063827166553752543609949962197099835;
        weights[12] = 0.139887394791073154722133423867583110892793160954919604;
        weights[13] = 0.132268938633337461781052574496775604329011540143156823;
        weights[14] = 0.12183141605372853419536717712573359835633762556153745;
        weights[15] = 0.108797299167148377663474578070105642033699595793856331;
        weights[16] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[17] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[18] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[19] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[20] = 0.0160172282577743333242246168584710152658904221179024825;
        return;
    case 22:
        points[0] = -0.994294585482399292073031421161298980393054198396031535;
        points[1] = -0.97006049783542872712395098676526871080596892313780297;
        points[2] = -0.926956772187174000520692939259053196635329653372051982;
        points[3] = -0.865812577720300136536425637019378729084796755588446156;
        points[4] = -0.787816805979208162004277955408351521388178671331563158;
        points[5] = -0.694487263186682780050689835762256771267342289977435161;
        points[6] = -0.58764040350691159295887692763864734887761560357371784;
        points[7] = -0.469355837986757026406330710966406346095343791130736548;
        points[8] = -0.341935820892084225158147420427379619559173299170687344;
        points[9] = -0.20786042668822128547884653391954573421567510909793365;
        points[10] = -0.0697392733197222212138417961186280818222962994802314747;
        points[11] = 0.0697392733197222212138417961186280818222962994802314747;
        points[12] = 0.20786042668822128547884653391954573421567510909793365;
        points[13] = 0.341935820892084225158147420427379619559173299170687344;
        points[14] = 0.469355837986757026406330710966406346095343791130736548;
        points[15] = 0.58764040350691159295887692763864734887761560357371784;
        points[16] = 0.694487263186682780050689835762256771267342289977435161;
        points[17] = 0.787816805979208162004277955408351521388178671331563158;
        points[18] = 0.865812577720300136536425637019378729084796755588446156;
        points[19] = 0.926956772187174000520692939259053196635329653372051982;
        points[20] = 0.97006049783542872712395098676526871080596892313780297;
        points[21] = 0.994294585482399292073031421161298980393054198396031535;
        weights[0] = 0.0146279952982722006849910980471854451902119491243237309;
        weights[1] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[2] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[3] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[4] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[5] = 0.100414144442880964932078837830536282350811088767699626;
        weights[6] = 0.112932296080539218393400607421784319114263332120994704;
        weights[7] = 0.123252376810512424285560986154814471959444999004967972;
        weights[8] = 0.131173504787062370732964992530307445875741894188030653;
        weights[9] = 0.136541498346015171352573831231517396586367652988686168;
        weights[10] = 0.139251872855631993375410248341809957873920217457425858;
        weights[11] = 0.139251872855631993375410248341809957873920217457425858;
        weights[12] = 0.136541498346015171352573831231517396586367652988686168;
        weights[13] = 0.131173504787062370732964992530307445875741894188030653;
        weights[14] = 0.123252376810512424285560986154814471959444999004967972;
        weights[15] = 0.112932296080539218393400607421784319114263332120994704;
        weights[16] = 0.100414144442880964932078837830536282350811088767699626;
        weights[17] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[18] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[19] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[20] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[21] = 0.0146279952982722006849910980471854451902119491243237309;
        return;
    case 23:
        points[0] = -0.994769334997552123523925715445574360573627372458870421;
        points[1] = -0.972542471218115231956024076820777375181613795353973942;
        points[2] = -0.932971086826016102349196989038422978235701820151390771;
        points[3] = -0.876752358270441667378156885934145671638929029960650635;
        points[4] = -0.804888401618839892151118406996778557941430139730308023;
        points[5] = -0.718661363131950194461624483748618848329929745131292796;
        points[6] = -0.619609875763646156385097311649595653387180658807092296;
        points[7] = -0.509501477846007549689793047866846430544842769184857623;
        points[8] = -0.390301038030290831421488872880605458578050850692503481;
        points[9] = -0.264135680970344930533869538283309602979013250194139605;
        points[10] = -0.133256824298466110931742682241766137010405276253382157;
        points[11] = 0;
        points[12] = 0.133256824298466110931742682241766137010405276253382157;
        points[13] = 0.264135680970344930533869538283309602979013250194139605;
        points[14] = 0.390301038030290831421488872880605458578050850692503481;
        points[15] = 0.509501477846007549689793047866846430544842769184857623;
        points[16] = 0.619609875763646156385097311649595653387180658807092296;
        points[17] = 0.718661363131950194461624483748618848329929745131292796;
        points[18] = 0.804888401618839892151118406996778557941430139730308023;
        points[19] = 0.876752358270441667378156885934145671638929029960650635;
        points[20] = 0.932971086826016102349196989038422978235701820151390771;
        points[21] = 0.972542471218115231956024076820777375181613795353973942;
        points[22] = 0.994769334997552123523925715445574360573627372458870421;
        weights[0] = 0.0134118594871417720813094934586150649766183341057372334;
        weights[1] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[2] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[3] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[4] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[5] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[6] = 0.104892091464541410074086185014743854858471583193975006;
        weights[7] = 0.114996640222411364941643512933961301491410522929585607;
        weights[8] = 0.123049084306729530467578400672009654815852812546470574;
        weights[9] = 0.128905722188082149978595339399793653259715497191783492;
        weights[10] = 0.132462039404696617371642464703316925805035669474223524;
        weights[11] = 0.133654572186106175351457110545844338583152807636883317;
        weights[12] = 0.132462039404696617371642464703316925805035669474223524;
        weights[13] = 0.128905722188082149978595339399793653259715497191783492;
        weights[14] = 0.123049084306729530467578400672009654815852812546470574;
        weights[15] = 0.114996640222411364941643512933961301491410522929585607;
        weights[16] = 0.104892091464541410074086185014743854858471583193975006;
        weights[17] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[18] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[19] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[20] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[21] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[22] = 0.0134118594871417720813094934586150649766183341057372334;
        return;
    case 24:
        points[0] = -0.995187219997021360179997409700736811874597692596002877;
        points[1] = -0.97472855597130949819839199300816906174118305304017872;
        points[2] = -0.938274552002732758523649001708721449654819658077451347;
        points[3] = -0.88641552700440103421315434198219675508733304330892004;
        points[4] = -0.820001985973902921953949872669745208076126477667855587;
        points[5] = -0.740124191578554364243828103099978425523292487014185457;
        points[6] = -0.64809365193697556925249578691074762666965829861895678;
        points[7] = -0.545421471388839535658375617218372370010783992587618175;
        points[8] = -0.433793507626045138487084231913349712452421510927968808;
        points[9] = -0.315042679696163374386793291319810240786478260824817269;
        points[10] = -0.191118867473616309158639820757069631840405103314753356;
        points[11] = -0.0640568928626056260850430826247450385909991954207473934;
        points[12] = 0.0640568928626056260850430826247450385909991954207473934;
        points[13] = 0.191118867473616309158639820757069631840405103314753356;
        points[14] = 0.315042679696163374386793291319810240786478260824817269;
        points[15] = 0.433793507626045138487084231913349712452421510927968808;
        points[16] = 0.545421471388839535658375617218372370010783992587618175;
        points[17] = 0.64809365193697556925249578691074762666965829861895678;
        points[18] = 0.740124191578554364243828103099978425523292487014185457;
        points[19] = 0.820001985973902921953949872669745208076126477667855587;
        points[20] = 0.88641552700440103421315434198219675508733304330892004;
        points[21] = 0.938274552002732758523649001708721449654819658077451347;
        points[22] = 0.97472855597130949819839199300816906174118305304017872;
        points[23] = 0.995187219997021360179997409700736811874597692596002877;
        weights[0] = 0.0123412297999871995468056670700372915759100408913665168;
        weights[1] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[2] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[3] = 0.059298584915436780746367758500108584541200126565213491;
        weights[4] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[5] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[6] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[7] = 0.107444270115965634782577342446606222794628690134220022;
        weights[8] = 0.115505668053725601353344483906783559862270311376496471;
        weights[9] = 0.121670472927803391204463153476262425607029559203805779;
        weights[10] = 0.125837456346828296121375382511183688726403325581345404;
        weights[11] = 0.127938195346752156974056165224695371851711239541667882;
        weights[12] = 0.127938195346752156974056165224695371851711239541667882;
        weights[13] = 0.125837456346828296121375382511183688726403325581345404;
        weights[14] = 0.121670472927803391204463153476262425607029559203805779;
        weights[15] = 0.115505668053725601353344483906783559862270311376496471;
        weights[16] = 0.107444270115965634782577342446606222794628690134220022;
        weights[17] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[18] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[19] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[20] = 0.059298584915436780746367758500108584541200126565213491;
        weights[21] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[22] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[23] = 0.0123412297999871995468056670700372915759100408913665168;
        return;
    case 25:
        points[0] = -0.995556969790498097908784946893901617257562649404808171;
        points[1] = -0.976663921459517511498315386479594067745370555314406745;
        points[2] = -0.942974571228974339414011169658470531905201570608990142;
        points[3] = -0.894991997878275368851042006782804954174554849753583903;
        points[4] = -0.833442628760834001421021108693569569460964113823520786;
        points[5] = -0.759259263037357630577282865204360976387522018898334121;
        points[6] = -0.673566368473468364485120633247622175883416728072749317;
        points[7] = -0.577662930241222967723689841612654067395735039291518257;
        points[8] = -0.473002731445714960522182115009192041331817738461627291;
        points[9] = -0.36117230580938783773582173012764066742207834704337507;
        points[10] = -0.243866883720988432045190362797451586405633156325984476;
        points[11] = -0.122864692610710396387359818808036805532205346049783738;
        points[12] = 0;
        points[13] = 0.122864692610710396387359818808036805532205346049783738;
        points[14] = 0.243866883720988432045190362797451586405633156325984476;
        points[15] = 0.36117230580938783773582173012764066742207834704337507;
        points[16] = 0.473002731445714960522182115009192041331817738461627291;
        points[17] = 0.577662930241222967723689841612654067395735039291518257;
        points[18] = 0.673566368473468364485120633247622175883416728072749317;
        points[19] = 0.759259263037357630577282865204360976387522018898334121;
        points[20] = 0.833442628760834001421021108693569569460964113823520786;
        points[21] = 0.894991997878275368851042006782804954174554849753583903;
        points[22] = 0.942974571228974339414011169658470531905201570608990142;
        points[23] = 0.976663921459517511498315386479594067745370555314406745;
        points[24] = 0.995556969790498097908784946893901617257562649404808171;
        weights[0] = 0.0113937985010262879479029641132347736033205262929096964;
        weights[1] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[2] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[3] = 0.054904695975835191925936891540473324160109985553111349;
        weights[4] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[5] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[6] = 0.091028261982963649811497220702891653380992558959334311;
        weights[7] = 0.100535949067050644202206890392685826988466094528141907;
        weights[8] = 0.108519624474263653116093957050116619340077587986722016;
        weights[9] = 0.11485825914571164833932554586955580864093619166818015;
        weights[10] = 0.119455763535784772228178126512901047390176701413726426;
        weights[11] = 0.122242442990310041688959518945851505835059247563059041;
        weights[12] = 0.123176053726715451203902873079050142438233627518151665;
        weights[13] = 0.122242442990310041688959518945851505835059247563059041;
        weights[14] = 0.119455763535784772228178126512901047390176701413726426;
        weights[15] = 0.11485825914571164833932554586955580864093619166818015;
        weights[16] = 0.108519624474263653116093957050116619340077587986722016;
        weights[17] = 0.100535949067050644202206890392685826988466094528141907;
        weights[18] = 0.091028261982963649811497220702891653380992558959334311;
        weights[19] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[20] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[21] = 0.054904695975835191925936891540473324160109985553111349;
        weights[22] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[23] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[24] = 0.0113937985010262879479029641132347736033205262929096964;
        return;
    case 26:
        points[0] = -0.995885701145616929003216959322906025956857855119559667;
        points[1] = -0.978385445956470991100580354311926305446916563747318502;
        points[2] = -0.94715906666171425013591528351803675452071033768431527;
        points[3] = -0.902637861984307074217665599231210251341124005372905373;
        points[4] = -0.845445942788498018797507061467838161572075102091329569;
        points[5] = -0.776385948820678856192967247242283866976218256255194872;
        points[6] = -0.696427260419957264863813913729424697860753317790819152;
        points[7] = -0.60669229301761806323197874691688705443526457226590989;
        points[8] = -0.508440714824505717695703064725569175376306754185750814;
        points[9] = -0.403051755123486306481077377098883103659937409699316183;
        points[10] = -0.292004839485956895142835382077830296884719386962990378;
        points[11] = -0.176858820356890183969057748418344749977383763801264261;
        points[12] = -0.0592300934293132070937185751984033607902347353890355822;
        points[13] = 0.0592300934293132070937185751984033607902347353890355822;
        points[14] = 0.176858820356890183969057748418344749977383763801264261;
        points[15] = 0.292004839485956895142835382077830296884719386962990378;
        points[16] = 0.403051755123486306481077377098883103659937409699316183;
        points[17] = 0.508440714824505717695703064725569175376306754185750814;
        points[18] = 0.60669229301761806323197874691688705443526457226590989;
        points[19] = 0.696427260419957264863813913729424697860753317790819152;
        points[20] = 0.776385948820678856192967247242283866976218256255194872;
        points[21] = 0.845445942788498018797507061467838161572075102091329569;
        points[22] = 0.902637861984307074217665599231210251341124005372905373;
        points[23] = 0.94715906666171425013591528351803675452071033768431527;
        points[24] = 0.978385445956470991100580354311926305446916563747318502;
        points[25] = 0.995885701145616929003216959322906025956857855119559667;
        weights[0] = 0.0105513726173430071556511876852519779043457371796946146;
        weights[1] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[2] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[3] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[4] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[5] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[6] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[7] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[8] = 0.10205916109442542323841407025343079232720881135424201;
        weights[9] = 0.108471840528576590656579426727997582289438203421306645;
        weights[10] = 0.113361816546319666549440718442598145245950362925015214;
        weights[11] = 0.116660443485296582044662507540362213631964881221924216;
        weights[12] = 0.118321415279262276516371085700468684649890270828905318;
        weights[13] = 0.118321415279262276516371085700468684649890270828905318;
        weights[14] = 0.116660443485296582044662507540362213631964881221924216;
        weights[15] = 0.113361816546319666549440718442598145245950362925015214;
        weights[16] = 0.108471840528576590656579426727997582289438203421306645;
        weights[17] = 0.10205916109442542323841407025343079232720881135424201;
        weights[18] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[19] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[20] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[21] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[22] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[23] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[24] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[25] = 0.0105513726173430071556511876852519779043457371796946146;
        return;
    case 27:
        points[0] = -0.996179262888988566938887208381229990260688055565871188;
        points[1] = -0.979923475961501222855873355661047184567642221389950763;
        points[2] = -0.950900557814705006851908030643882893092589933484417651;
        points[3] = -0.909482320677491104300645018209689254948044335594960959;
        points[4] = -0.856207908018294490302737222706842797764286998603505827;
        points[5] = -0.791771639070508227144397344107270732919401065747863512;
        points[6] = -0.717013473739423699294816211642339549750672052098563143;
        points[7] = -0.632907971946495140927734637634488612103076017569336697;
        points[8] = -0.54055156457945689490030094155998282095918044898718169;
        points[9] = -0.441148251750026880585974155689281452447684595163099388;
        points[10] = -0.335993903638508899730319034207284541790020018907594191;
        points[11] = -0.226459365439536858857239107360230171179446732928203677;
        points[12] = -0.113972585609529966932894983869976627173280533978140995;
        points[13] = 0;
        points[14] = 0.113972585609529966932894983869976627173280533978140995;
        points[15] = 0.226459365439536858857239107360230171179446732928203677;
        points[16] = 0.335993903638508899730319034207284541790020018907594191;
        points[17] = 0.441148251750026880585974155689281452447684595163099388;
        points[18] = 0.54055156457945689490030094155998282095918044898718169;
        points[19] = 0.632907971946495140927734637634488612103076017569336697;
        points[20] = 0.717013473739423699294816211642339549750672052098563143;
        points[21] = 0.791771639070508227144397344107270732919401065747863512;
        points[22] = 0.856207908018294490302737222706842797764286998603505827;
        points[23] = 0.909482320677491104300645018209689254948044335594960959;
        points[24] = 0.950900557814705006851908030643882893092589933484417651;
        points[25] = 0.979923475961501222855873355661047184567642221389950763;
        points[26] = 0.996179262888988566938887208381229990260688055565871188;
        weights[0] = 0.00979899605129436026115005509125909809822581893509159217;
        weights[1] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[2] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[3] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[4] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[5] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[6] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[7] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[8] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[9] = 0.10250163781774579867124771153266380932440989491471733;
        weights[10] = 0.107578285788533187212162984426657404818966099063764666;
        weights[11] = 0.111252488356845192672163096042848674832920380085083267;
        weights[12] = 0.113476346108965148620369948092099257920524518810472026;
        weights[13] = 0.11422086737895698904504573690183524868072144335016533;
        weights[14] = 0.113476346108965148620369948092099257920524518810472026;
        weights[15] = 0.111252488356845192672163096042848674832920380085083267;
        weights[16] = 0.107578285788533187212162984426657404818966099063764666;
        weights[17] = 0.10250163781774579867124771153266380932440989491471733;
        weights[18] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[19] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[20] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[21] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[22] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[23] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[24] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[25] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[26] = 0.00979899605129436026115005509125909809822581893509159217;
        return;
    case 28:
        points[0] = -0.996442497573954449950436390483310991750130432096425905;
        points[1] = -0.98130316537087275369455994580783027644415495325313831;
        points[2] = -0.954259280628938197254101839705215589003403874087951675;
        points[3] = -0.915633026392132073869689423329927146352496795209121509;
        points[4] = -0.865892522574395048942254567379686804341862830784226337;
        points[5] = -0.805641370917179171447885955425277658671701414808311668;
        points[6] = -0.735610878013631772028144510292534368016061019993041893;
        points[7] = -0.656651094038864961219898176506742821569601690249929962;
        points[8] = -0.569720471811401719308003283356430933124712685656647228;
        points[9] = -0.475874224955118261034411847667434042627216145378655951;
        points[10] = -0.37625151608907871022135720955608698287169397704322291;
        points[11] = -0.272061627635178077676826356125769734824761296693522952;
        points[12] = -0.164569282133380771281471777891165457145725415601168176;
        points[13] = -0.0550792898840342704265165273418799778507959910608336837;
        points[14] = 0.0550792898840342704265165273418799778507959910608336837;
        points[15] = 0.164569282133380771281471777891165457145725415601168176;
        points[16] = 0.272061627635178077676826356125769734824761296693522952;
        points[17] = 0.37625151608907871022135720955608698287169397704322291;
        points[18] = 0.475874224955118261034411847667434042627216145378655951;
        points[19] = 0.569720471811401719308003283356430933124712685656647228;
        points[20] = 0.656651094038864961219898176506742821569601690249929962;
        points[21] = 0.735610878013631772028144510292534368016061019993041893;
        points[22] = 0.805641370917179171447885955425277658671701414808311668;
        points[23] = 0.865892522574395048942254567379686804341862830784226337;
        points[24] = 0.915633026392132073869689423329927146352496795209121509;
        points[25] = 0.954259280628938197254101839705215589003403874087951675;
        points[26] = 0.98130316537087275369455994580783027644415495325313831;
        points[27] = 0.996442497573954449950436390483310991750130432096425905;
        weights[0] = 0.00912428259309451773881615392295170624034449109829099942;
        weights[1] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[2] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[3] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[4] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[5] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[6] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[7] = 0.083113417228901218390396498244332479861134413443851333;
        weights[8] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[9] = 0.096930657997929915850489006095440601765033123356461605;
        weights[10] = 0.102112967578060769814216638505712135046580002357920541;
        weights[11] = 0.106055765922846417910416436996810828789922962685159517;
        weights[12] = 0.108711192258294135253571519303673367875278454666043968;
        weights[13] = 0.110047013016475196282376265601817613956625529491231633;
        weights[14] = 0.110047013016475196282376265601817613956625529491231633;
        weights[15] = 0.108711192258294135253571519303673367875278454666043968;
        weights[16] = 0.106055765922846417910416436996810828789922962685159517;
        weights[17] = 0.102112967578060769814216638505712135046580002357920541;
        weights[18] = 0.096930657997929915850489006095440601765033123356461605;
        weights[19] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[20] = 0.083113417228901218390396498244332479861134413443851333;
        weights[21] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[22] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[23] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[24] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[25] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[26] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[27] = 0.00912428259309451773881615392295170624034449109829099942;
        return;
    case 29:
        points[0] = -0.996679442260596586163191532549353885651773453250880002;
        points[1] = -0.982545505261413174870926015786376956106781948906431559;
        points[2] = -0.957285595778087725798208036980823563737559553954097071;
        points[3] = -0.921180232953058785093753436083106425408839343312293598;
        points[4] = -0.874637804920102790417793421256578546910616863119041371;
        points[5] = -0.818185487615252444989572214578784975630021561882293771;
        points[6] = -0.752462851734477133912610077212138190212591968228986608;
        points[7] = -0.678214537602686515156185005391985926388262930014645163;
        points[8] = -0.596281797138227820379586211188989780078186810385577638;
        points[9] = -0.507592955124227642102627919627520153351223840384584164;
        points[10] = -0.41315288817400866389070658603161682332343851873631392;
        points[11] = -0.314031637867639934948195923191047448258448819090827481;
        points[12] = -0.211352286166001074506375728902937499056650817712095148;
        points[13] = -0.106278230132679230170982392430376980917195439295607136;
        points[14] = 0;
        points[15] = 0.106278230132679230170982392430376980917195439295607136;
        points[16] = 0.211352286166001074506375728902937499056650817712095148;
        points[17] = 0.314031637867639934948195923191047448258448819090827481;
        points[18] = 0.41315288817400866389070658603161682332343851873631392;
        points[19] = 0.507592955124227642102627919627520153351223840384584164;
        points[20] = 0.596281797138227820379586211188989780078186810385577638;
        points[21] = 0.678214537602686515156185005391985926388262930014645163;
        points[22] = 0.752462851734477133912610077212138190212591968228986608;
        points[23] = 0.818185487615252444989572214578784975630021561882293771;
        points[24] = 0.874637804920102790417793421256578546910616863119041371;
        points[25] = 0.921180232953058785093753436083106425408839343312293598;
        points[26] = 0.957285595778087725798208036980823563737559553954097071;
        points[27] = 0.982545505261413174870926015786376956106781948906431559;
        points[28] = 0.996679442260596586163191532549353885651773453250880002;
        weights[0] = 0.00851690387874640965426381330224980300239888979851848605;
        weights[1] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[2] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[3] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[4] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[5] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[6] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[7] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[8] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[9] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[10] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[11] = 0.101091273759914966121820546907497363647567278852525199;
        weights[12] = 0.104073310077729373913328471285120068910652220675467692;
        weights[13] = 0.10587615509732094140659132785218789307483131374227804;
        weights[14] = 0.10647938171831424424651112690967756833018503161299598;
        weights[15] = 0.10587615509732094140659132785218789307483131374227804;
        weights[16] = 0.104073310077729373913328471285120068910652220675467692;
        weights[17] = 0.101091273759914966121820546907497363647567278852525199;
        weights[18] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[19] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[20] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[21] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[22] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[23] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[24] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[25] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[26] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[27] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[28] = 0.00851690387874640965426381330224980300239888979851848605;
        return;
    case 30:
        points[0] = -0.99689348407464954027163005091869528334088203811775079;
        points[1] = -0.983668123279747209970032581605662801940317854709711364;
        points[2] = -0.960021864968307512216871025581797662930359217403923399;
        points[3] = -0.926200047429274325879324277080474004086474536825329061;
        points[4] = -0.882560535792052681543116462530225590056689147146484232;
        points[5] = -0.829565762382768397442898119732501916439068696170341679;
        points[6] = -0.767777432104826194917977340974503131694883617232908453;
        points[7] = -0.697850494793315796932292388026640068382353800653954656;
        points[8] = -0.620526182989242861140477556431189299207364692829528133;
        points[9] = -0.536624148142019899264169793311072794164178006930297105;
        points[10] = -0.44703376953808917678060990032285400016240759386142441;
        points[11] = -0.352704725530878113471037207089373860653631008021425627;
        points[12] = -0.254636926167889846439805129817805107882789303302518426;
        points[13] = -0.153869913608583546963794672743255920418551971244338462;
        points[14] = -0.0514718425553176958330252131667225737491414536665695643;
        points[15] = 0.0514718425553176958330252131667225737491414536665695643;
        points[16] = 0.153869913608583546963794672743255920418551971244338462;
        points[17] = 0.254636926167889846439805129817805107882789303302518426;
        points[18] = 0.352704725530878113471037207089373860653631008021425627;
        points[19] = 0.44703376953808917678060990032285400016240759386142441;
        points[20] = 0.536624148142019899264169793311072794164178006930297105;
        points[21] = 0.620526182989242861140477556431189299207364692829528133;
        points[22] = 0.697850494793315796932292388026640068382353800653954656;
        points[23] = 0.767777432104826194917977340974503131694883617232908453;
        points[24] = 0.829565762382768397442898119732501916439068696170341679;
        points[25] = 0.882560535792052681543116462530225590056689147146484232;
        points[26] = 0.926200047429274325879324277080474004086474536825329061;
        points[27] = 0.960021864968307512216871025581797662930359217403923399;
        points[28] = 0.983668123279747209970032581605662801940317854709711364;
        points[29] = 0.99689348407464954027163005091869528334088203811775079;
        weights[0] = 0.00796819249616660561546588347467362245048069658715172123;
        weights[1] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[2] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[3] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[4] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[5] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[6] = 0.065974229882180495128128515115962361237442953656660379;
        weights[7] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[8] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[9] = 0.086899787201082979802387530715125702576753328743545344;
        weights[10] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[11] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[12] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[13] = 0.101762389748405504596428952168554044632706289487126841;
        weights[14] = 0.102852652893558840341285636705415043868375557064928223;
        weights[15] = 0.102852652893558840341285636705415043868375557064928223;
        weights[16] = 0.101762389748405504596428952168554044632706289487126841;
        weights[17] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[18] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[19] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[20] = 0.086899787201082979802387530715125702576753328743545344;
        weights[21] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[22] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[23] = 0.065974229882180495128128515115962361237442953656660379;
        weights[24] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[25] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[26] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[27] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[28] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[29] = 0.00796819249616660561546588347467362245048069658715172123;
        return;
    case 31:
        points[0] = -0.997087481819477074055626554223102508251445334117069631;
        points[1] = -0.984685909665152484002465166734684710938518269514643671;
        points[2] = -0.962503925092949661789052404105858301897219485152558377;
        points[3] = -0.930756997896648164956945759729263512813397687258082036;
        points[4] = -0.88976002994827104337419200898215926154359741186519095;
        points[5] = -0.839920320146267340086904535940178356054737301074749523;
        points[6] = -0.78173314841662494040636002019468449109541037201339888;
        points[7] = -0.715776784586853283905970865366485955890193476169588433;
        points[8] = -0.642706722924260346184418203232501453991690683336206757;
        points[9] = -0.563249161407149262720944923595161427948602273166887031;
        points[10] = -0.478193782044902480440594039356485748439523371497423125;
        points[11] = -0.388385901608232943061351461287520101985106267893544036;
        points[12] = -0.294718069981701616617903897671704338752855185278358557;
        points[13] = -0.19812119933557062877241299603283393777479481216155488;
        points[14] = -0.0995553121523415203251747901189407338389953587775273061;
        points[15] = 0;
        points[16] = 0.0995553121523415203251747901189407338389953587775273061;
        points[17] = 0.19812119933557062877241299603283393777479481216155488;
        points[18] = 0.294718069981701616617903897671704338752855185278358557;
        points[19] = 0.388385901608232943061351461287520101985106267893544036;
        points[20] = 0.478193782044902480440594039356485748439523371497423125;
        points[21] = 0.563249161407149262720944923595161427948602273166887031;
        points[22] = 0.642706722924260346184418203232501453991690683336206757;
        points[23] = 0.715776784586853283905970865366485955890193476169588433;
        points[24] = 0.78173314841662494040636002019468449109541037201339888;
        points[25] = 0.839920320146267340086904535940178356054737301074749523;
        points[26] = 0.88976002994827104337419200898215926154359741186519095;
        points[27] = 0.930756997896648164956945759729263512813397687258082036;
        points[28] = 0.962503925092949661789052404105858301897219485152558377;
        points[29] = 0.984685909665152484002465166734684710938518269514643671;
        points[30] = 0.997087481819477074055626554223102508251445334117069631;
        weights[0] = 0.0074708315792487758586968750322124070221508524840480397;
        weights[1] = 0.0173186207903105824631579960868211413662728627679957766;
        weights[2] = 0.0270090191849794218006087080919321561423566460021166459;
        weights[3] = 0.0364322739123854640243920104678034423271453320476676859;
        weights[4] = 0.0454937075272011029023158578946296772635527193100289649;
        weights[5] = 0.0541030824249168537116662590866200427203894625962118077;
        weights[6] = 0.0621747865610284269103435436866966671587287993646513153;
        weights[7] = 0.0696285832354103661677561262551257105150857073973433937;
        weights[8] = 0.0763903865987766164263576749013306449257569136942086541;
        weights[9] = 0.0823929917615892639038233674319617706157682665566462778;
        weights[10] = 0.0875767406084778761261980696953330922292581597712042515;
        weights[11] = 0.0918901138936414782153628716071501254973108253791578042;
        weights[12] = 0.0952902429123195128072041974875966845413247382469590227;
        weights[13] = 0.0977433353863287250934740109789967038357287886760951145;
        weights[14] = 0.0992250112266723078748755144286150140175432199555630698;
        weights[15] = 0.0997205447934264514275338337343494396432534115002043515;
        weights[16] = 0.0992250112266723078748755144286150140175432199555630698;
        weights[17] = 0.0977433353863287250934740109789967038357287886760951145;
        weights[18] = 0.0952902429123195128072041974875966845413247382469590227;
        weights[19] = 0.0918901138936414782153628716071501254973108253791578042;
        weights[20] = 0.0875767406084778761261980696953330922292581597712042515;
        weights[21] = 0.0823929917615892639038233674319617706157682665566462778;
        weights[22] = 0.0763903865987766164263576749013306449257569136942086541;
        weights[23] = 0.0696285832354103661677561262551257105150857073973433937;
        weights[24] = 0.0621747865610284269103435436866966671587287993646513153;
        weights[25] = 0.0541030824249168537116662590866200427203894625962118077;
        weights[26] = 0.0454937075272011029023158578946296772635527193100289649;
        weights[27] = 0.0364322739123854640243920104678034423271453320476676859;
        weights[28] = 0.0270090191849794218006087080919321561423566460021166459;
        weights[29] = 0.0173186207903105824631579960868211413662728627679957766;
        weights[30] = 0.0074708315792487758586968750322124070221508524840480397;
        return;
    case 32:
        points[0] = -0.997263861849481563544981128665040727138537663729461159;
        points[1] = -0.985611511545268335400175044630901978632395714335806318;
        points[2] = -0.964762255587506430773811928118274960388895220443018719;
        points[3] = -0.934906075937739689170919134835409325528671432282837218;
        points[4] = -0.896321155766052123965307243719212268478996496795759577;
        points[5] = -0.849367613732569970133693004967742538954886793049759233;
        points[6] = -0.794483795967942406963097298970428902095479401638835453;
        points[7] = -0.732182118740289680387426665091267146630270483506629101;
        points[8] = -0.663044266930215200975115168663238368977022285960505301;
        points[9] = -0.587715757240762329040745476401826858450940115454420573;
        points[10] = -0.506899908932229390023747474377821230180283699599435464;
        points[11] = -0.421351276130635345364119436172426478335877288632443331;
        points[12] = -0.331868602282127649779916805730187996195775136805059836;
        points[13] = -0.239287362252137074544603209165501520608855421960253016;
        points[14] = -0.144471961582796493485186373598810652203845991315635552;
        points[15] = -0.0483076656877383162348125704405021636908472517308488972;
        points[16] = 0.0483076656877383162348125704405021636908472517308488972;
        points[17] = 0.144471961582796493485186373598810652203845991315635552;
        points[18] = 0.239287362252137074544603209165501520608855421960253016;
        points[19] = 0.331868602282127649779916805730187996195775136805059836;
        points[20] = 0.421351276130635345364119436172426478335877288632443331;
        points[21] = 0.506899908932229390023747474377821230180283699599435464;
        points[22] = 0.587715757240762329040745476401826858450940115454420573;
        points[23] = 0.663044266930215200975115168663238368977022285960505301;
        points[24] = 0.732182118740289680387426665091267146630270483506629101;
        points[25] = 0.794483795967942406963097298970428902095479401638835453;
        points[26] = 0.849367613732569970133693004967742538954886793049759233;
        points[27] = 0.896321155766052123965307243719212268478996496795759577;
        points[28] = 0.934906075937739689170919134835409325528671432282837218;
        points[29] = 0.964762255587506430773811928118274960388895220443018719;
        points[30] = 0.985611511545268335400175044630901978632395714335806318;
        points[31] = 0.997263861849481563544981128665040727138537663729461159;
        weights[0] = 0.00701861000947009660040706373885318251337722072893960323;
        weights[1] = 0.0162743947309056706051705622063866181795429637952095664;
        weights[2] = 0.0253920653092620594557525897892240292875540475469487209;
        weights[3] = 0.0342738629130214331026877322523727069948402029116274338;
        weights[4] = 0.0428358980222266806568786466061255284928108575989407396;
        weights[5] = 0.0509980592623761761961632446895216952601847767397628437;
        weights[6] = 0.0586840934785355471452836373001708867501204674575467587;
        weights[7] = 0.0658222227763618468376500637069387728775364473732465154;
        weights[8] = 0.0723457941088485062253993564784877916043369833018248707;
        weights[9] = 0.0781938957870703064717409188283066710397867984821591903;
        weights[10] = 0.0833119242269467552221990746043486115387468839428344598;
        weights[11] = 0.0876520930044038111427714627518022875484497217017572223;
        weights[12] = 0.0911738786957638847128685771116370625448614132753900053;
        weights[13] = 0.0938443990808045656391802376681172600361000757462364501;
        weights[14] = 0.095638720079274859419082002204131100594890508162005551;
        weights[15] = 0.0965400885147278005667648300635757947368606312355700687;
        weights[16] = 0.0965400885147278005667648300635757947368606312355700687;
        weights[17] = 0.095638720079274859419082002204131100594890508162005551;
        weights[18] = 0.0938443990808045656391802376681172600361000757462364501;
        weights[19] = 0.0911738786957638847128685771116370625448614132753900053;
        weights[20] = 0.0876520930044038111427714627518022875484497217017572223;
        weights[21] = 0.0833119242269467552221990746043486115387468839428344598;
        weights[22] = 0.0781938957870703064717409188283066710397867984821591903;
        weights[23] = 0.0723457941088485062253993564784877916043369833018248707;
        weights[24] = 0.0658222227763618468376500637069387728775364473732465154;
        weights[25] = 0.0586840934785355471452836373001708867501204674575467587;
        weights[26] = 0.0509980592623761761961632446895216952601847767397628437;
        weights[27] = 0.0428358980222266806568786466061255284928108575989407396;
        weights[28] = 0.0342738629130214331026877322523727069948402029116274338;
        weights[29] = 0.0253920653092620594557525897892240292875540475469487209;
        weights[30] = 0.0162743947309056706051705622063866181795429637952095664;
        weights[31] = 0.00701861000947009660040706373885318251337722072893960323;
        return;
    case 33:
        points[0] = -0.997424694246455217266168017580404161078229010881361921;
        points[1] = -0.9864557262306424881103756982646259215891711142156511;
        points[2] = -0.9668229096899927689283777066785922452183143365799866;
        points[3] = -0.938694372611168350355835124363553712614434484096546826;
        points[4] = -0.902316767743433583040531331518761607475205558190918115;
        points[5] = -0.858009652676504064643061480146068473327351068896720066;
        points[6] = -0.806162356274166589796200870782777175697710618135446112;
        points[7] = -0.747230496449562157859055124897948268854288086463824479;
        points[8] = -0.681731959969742786268215946919328134668935180714294029;
        points[9] = -0.610242345836379027307287513538097431406342930888033949;
        points[10] = -0.533389904786347643548894264995492125452665092224422469;
        points[11] = -0.451850017272450695725993277240767053798771734390531177;
        points[12] = -0.366339257748073341070220623253871111296934681100140172;
        points[13] = -0.277609097152497029403248067298321005754758329278243219;
        points[14] = -0.186439298827991572335798759218823987837344302823165342;
        points[15] = -0.0936310658547333856707429241225377213215057781526368813;
        points[16] = 0;
        points[17] = 0.0936310658547333856707429241225377213215057781526368813;
        points[18] = 0.186439298827991572335798759218823987837344302823165342;
        points[19] = 0.277609097152497029403248067298321005754758329278243219;
        points[20] = 0.366339257748073341070220623253871111296934681100140172;
        points[21] = 0.451850017272450695725993277240767053798771734390531177;
        points[22] = 0.533389904786347643548894264995492125452665092224422469;
        points[23] = 0.610242345836379027307287513538097431406342930888033949;
        points[24] = 0.681731959969742786268215946919328134668935180714294029;
        points[25] = 0.747230496449562157859055124897948268854288086463824479;
        points[26] = 0.806162356274166589796200870782777175697710618135446112;
        points[27] = 0.858009652676504064643061480146068473327351068896720066;
        points[28] = 0.902316767743433583040531331518761607475205558190918115;
        points[29] = 0.938694372611168350355835124363553712614434484096546826;
        points[30] = 0.9668229096899927689283777066785922452183143365799866;
        points[31] = 0.9864557262306424881103756982646259215891711142156511;
        points[32] = 0.997424694246455217266168017580404161078229010881361921;
        weights[0] = 0.00660622784758737805864923520847385503105916250321107135;
        weights[1] = 0.0153217015129346761279457685336618667575353547807562368;
        weights[2] = 0.0239155481017494803505332575291862420660083611445149192;
        weights[3] = 0.0323003586323289532815614472494312880682527230506729272;
        weights[4] = 0.0404015413316695915634097905273984961668627883826539169;
        weights[5] = 0.0481477428187116956701468801381196497417511486769690613;
        weights[6] = 0.0554708466316635612849444954392591104205084071502204403;
        weights[7] = 0.0623064825303174800316277257708976114217684275793131068;
        weights[8] = 0.0685945728186567128059550730149586524873610929403886977;
        weights[9] = 0.0742798548439541493424721759184720467100983931962553235;
        weights[10] = 0.0793123647948867383639083849419975880886880293922986427;
        weights[11] = 0.0836478760670387076139280145176605974203276865458260165;
        weights[12] = 0.0872482876188443376072816709454464565666960712939022884;
        weights[13] = 0.090081958660638577239743705500223621187370682079491485;
        weights[14] = 0.0921239866433168462132409777173630607214710032039817206;
        weights[15] = 0.093356426065596116160999126274275464952003986088630805;
        weights[16] = 0.0937684461602099965673045415463487843844733639818266813;
        weights[17] = 0.093356426065596116160999126274275464952003986088630805;
        weights[18] = 0.0921239866433168462132409777173630607214710032039817206;
        weights[19] = 0.090081958660638577239743705500223621187370682079491485;
        weights[20] = 0.0872482876188443376072816709454464565666960712939022884;
        weights[21] = 0.0836478760670387076139280145176605974203276865458260165;
        weights[22] = 0.0793123647948867383639083849419975880886880293922986427;
        weights[23] = 0.0742798548439541493424721759184720467100983931962553235;
        weights[24] = 0.0685945728186567128059550730149586524873610929403886977;
        weights[25] = 0.0623064825303174800316277257708976114217684275793131068;
        weights[26] = 0.0554708466316635612849444954392591104205084071502204403;
        weights[27] = 0.0481477428187116956701468801381196497417511486769690613;
        weights[28] = 0.0404015413316695915634097905273984961668627883826539169;
        weights[29] = 0.0323003586323289532815614472494312880682527230506729272;
        weights[30] = 0.0239155481017494803505332575291862420660083611445149192;
        weights[31] = 0.0153217015129346761279457685336618667575353547807562368;
        weights[32] = 0.00660622784758737805864923520847385503105916250321107135;
        return;
    case 34:
        points[0] = -0.997571753790841919243372437454629231400509882684929773;
        points[1] = -0.987227816406309485049750431099684972948770148660132219;
        points[2] = -0.968708262533344281764646573055993510967808745353473336;
        points[3] = -0.942162397405107091631676025460572903006205692337117558;
        points[4] = -0.907809677718324468800899889019287460162397572803152094;
        points[5] = -0.865934638334564469263572090671299844696635301736783069;
        points[6] = -0.816884227900933664591578906586973258393149910974253902;
        points[7] = -0.761064876629873014187408968978736833604499366726196922;
        points[8] = -0.69893911321626290793300010657577718263776403145575631;
        points[9] = -0.631021727080528545317775755519008277810897254073443531;
        points[10] = -0.557875500669746642736459886216274581337441378045353895;
        points[11] = -0.480106545190327034194102680507397108587354948903905784;
        points[12] = -0.398359277758645940631494752932351529342462129655648215;
        points[13] = -0.313311081339463247458316765650977994771229865584492941;
        points[14] = -0.225666691616449483868641180934347244352189721047980553;
        points[15] = -0.136152357259182975894428824331117831497280617764536282;
        points[16] = -0.045509821953102542749075670851930163831084150187205402;
        points[17] = 0.045509821953102542749075670851930163831084150187205402;
        points[18] = 0.136152357259182975894428824331117831497280617764536282;
        points[19] = 0.225666691616449483868641180934347244352189721047980553;
        points[20] = 0.313311081339463247458316765650977994771229865584492941;
        points[21] = 0.398359277758645940631494752932351529342462129655648215;
        points[22] = 0.480106545190327034194102680507397108587354948903905784;
        points[23] = 0.557875500669746642736459886216274581337441378045353895;
        points[24] = 0.631021727080528545317775755519008277810897254073443531;
        points[25] = 0.69893911321626290793300010657577718263776403145575631;
        points[26] = 0.761064876629873014187408968978736833604499366726196922;
        points[27] = 0.816884227900933664591578906586973258393149910974253902;
        points[28] = 0.865934638334564469263572090671299844696635301736783069;
        points[29] = 0.907809677718324468800899889019287460162397572803152094;
        points[30] = 0.942162397405107091631676025460572903006205692337117558;
        points[31] = 0.968708262533344281764646573055993510967808745353473336;
        points[32] = 0.987227816406309485049750431099684972948770148660132219;
        points[33] = 0.997571753790841919243372437454629231400509882684929773;
        weights[0] = 0.00622914055590868471860646107143778612452732842980484594;
        weights[1] = 0.0144501627485950354152022103287469906875404335846560601;
        weights[2] = 0.0225637219854949700840940887149542612490345883881878338;
        weights[3] = 0.0304913806384461318094423876813175910306268453895807875;
        weights[4] = 0.0381665937963875163217659202899765588239470061266673516;
        weights[5] = 0.0455256115233532724538225633952706029982384189963153821;
        weights[6] = 0.0525074145726781061682459748424675996587196809469698659;
        weights[7] = 0.059054135827524493193960972350526190828486182346504483;
        weights[8] = 0.0651115215540764113785444300648937735836372460728131919;
        weights[9] = 0.0706293758142557249990387965676853550011627204909059651;
        weights[10] = 0.0755619746600319312708339742284357240588192694813414625;
        weights[11] = 0.0798684443397718447388188328064379935505558719721942996;
        weights[12] = 0.0835130996998456551870202280461493905807155938575466916;
        weights[13] = 0.0864657397470357497842468562807475803140706909018175725;
        weights[14] = 0.088701897835693869287076457364880712744283006703804131;
        weights[15] = 0.0902030443706407295739422420174939288410295000506306357;
        weights[16] = 0.0909567403302598736153376039485779599246056162602594401;
        weights[17] = 0.0909567403302598736153376039485779599246056162602594401;
        weights[18] = 0.0902030443706407295739422420174939288410295000506306357;
        weights[19] = 0.088701897835693869287076457364880712744283006703804131;
        weights[20] = 0.0864657397470357497842468562807475803140706909018175725;
        weights[21] = 0.0835130996998456551870202280461493905807155938575466916;
        weights[22] = 0.0798684443397718447388188328064379935505558719721942996;
        weights[23] = 0.0755619746600319312708339742284357240588192694813414625;
        weights[24] = 0.0706293758142557249990387965676853550011627204909059651;
        weights[25] = 0.0651115215540764113785444300648937735836372460728131919;
        weights[26] = 0.059054135827524493193960972350526190828486182346504483;
        weights[27] = 0.0525074145726781061682459748424675996587196809469698659;
        weights[28] = 0.0455256115233532724538225633952706029982384189963153821;
        weights[29] = 0.0381665937963875163217659202899765588239470061266673516;
        weights[30] = 0.0304913806384461318094423876813175910306268453895807875;
        weights[31] = 0.0225637219854949700840940887149542612490345883881878338;
        weights[32] = 0.0144501627485950354152022103287469906875404335846560601;
        weights[33] = 0.00622914055590868471860646107143778612452732842980484594;
        return;
    case 35:
        points[0] = -0.997706569099600297260163139312094725193274637171013317;
        points[1] = -0.987935764443851498035117089185485985313008295714174355;
        points[2] = -0.970437616039229833215070482584770142524881239312376607;
        points[3] = -0.945345148207827329538725985529974644862811251247873154;
        points[4] = -0.912854261359317614464937063555764230488061013625558005;
        points[5] = -0.873219125025222331523282349141385266644338902279374947;
        points[6] = -0.826749899092225406834050612748557579046890617982307341;
        points[7] = -0.773810252286912555267423009209887481011810072971545926;
        points[8] = -0.714814501556628783264408631224446746962043968521730512;
        points[9] = -0.650224364665890388675792808984559263369762325928374001;
        points[10] = -0.580545344749764509934502008189690070932070203564332434;
        points[11] = -0.506322773241488615024297555837327376586087938636369248;
        points[12] = -0.428137541517814254187620613001479858784718446488533844;
        points[13] = -0.346601554430813945876979834930238231808408769377292109;
        points[14] = -0.262352941209296057970895200455580513486304398645781284;
        points[15] = -0.176051061165989569974303656445059929675429712329757047;
        points[16] = -0.0883713432756592636009294334975488034241174347650981414;
        points[17] = 0;
        points[18] = 0.0883713432756592636009294334975488034241174347650981414;
        points[19] = 0.176051061165989569974303656445059929675429712329757047;
        points[20] = 0.262352941209296057970895200455580513486304398645781284;
        points[21] = 0.346601554430813945876979834930238231808408769377292109;
        points[22] = 0.428137541517814254187620613001479858784718446488533844;
        points[23] = 0.506322773241488615024297555837327376586087938636369248;
        points[24] = 0.580545344749764509934502008189690070932070203564332434;
        points[25] = 0.650224364665890388675792808984559263369762325928374001;
        points[26] = 0.714814501556628783264408631224446746962043968521730512;
        points[27] = 0.773810252286912555267423009209887481011810072971545926;
        points[28] = 0.826749899092225406834050612748557579046890617982307341;
        points[29] = 0.873219125025222331523282349141385266644338902279374947;
        points[30] = 0.912854261359317614464937063555764230488061013625558005;
        points[31] = 0.945345148207827329538725985529974644862811251247873154;
        points[32] = 0.970437616039229833215070482584770142524881239312376607;
        points[33] = 0.987935764443851498035117089185485985313008295714174355;
        points[34] = 0.997706569099600297260163139312094725193274637171013317;
        weights[0] = 0.00588343342044308497575389624011262403075431779823297371;
        weights[1] = 0.013650828348361492266404002920516383973994037841424921;
        weights[2] = 0.0213229799114835808834379839662050783238096447199362073;
        weights[3] = 0.0288292601088942540487160397144849162615277266295949997;
        weights[4] = 0.0361101158634633805327169696475499383085357789699869432;
        weights[5] = 0.0431084223261702187823064593749082034228065871639902087;
        weights[6] = 0.0497693704013535298051996760849949585944949531945731637;
        weights[7] = 0.0560408162123701285783277471651009644403485349045563455;
        weights[8] = 0.0618736719660801888870141387886886522653712258040964351;
        weights[9] = 0.0672222852690869039643055087481485585470931191496048085;
        weights[10] = 0.0720447947725600646654619097852777561472673930274272606;
        weights[11] = 0.0763034571554420535386585378842262255270800818956365344;
        weights[12] = 0.0799649422423242629326620809850457563288354994300888474;
        weights[13] = 0.08300059372885658837992652821617700348517450381345112;
        weights[14] = 0.0853866533920991252259439873911175676411909882837507511;
        weights[15] = 0.0871044469971835342433220316055409366850567150938549314;
        weights[16] = 0.0881405304302754629707388075930966414254543172744908372;
        weights[17] = 0.0884867949071042906382073877776156691824091500106054233;
        weights[18] = 0.0881405304302754629707388075930966414254543172744908372;
        weights[19] = 0.0871044469971835342433220316055409366850567150938549314;
        weights[20] = 0.0853866533920991252259439873911175676411909882837507511;
        weights[21] = 0.08300059372885658837992652821617700348517450381345112;
        weights[22] = 0.0799649422423242629326620809850457563288354994300888474;
        weights[23] = 0.0763034571554420535386585378842262255270800818956365344;
        weights[24] = 0.0720447947725600646654619097852777561472673930274272606;
        weights[25] = 0.0672222852690869039643055087481485585470931191496048085;
        weights[26] = 0.0618736719660801888870141387886886522653712258040964351;
        weights[27] = 0.0560408162123701285783277471651009644403485349045563455;
        weights[28] = 0.0497693704013535298051996760849949585944949531945731637;
        weights[29] = 0.0431084223261702187823064593749082034228065871639902087;
        weights[30] = 0.0361101158634633805327169696475499383085357789699869432;
        weights[31] = 0.0288292601088942540487160397144849162615277266295949997;
        weights[32] = 0.0213229799114835808834379839662050783238096447199362073;
        weights[33] = 0.013650828348361492266404002920516383973994037841424921;
        weights[34] = 0.00588343342044308497575389624011262403075431779823297371;
        return;
    case 36:
        points[0] = -0.997830462484085836198828345580750238649816462396631313;
        points[1] = -0.988586478902212238073395107877107446607162520065287056;
        points[2] = -0.972027691049697949335605048431108327616046396265951741;
        points[3] = -0.948272984399507545202474114945227846289376525333673633;
        points[4] = -0.917497774515659066075867223026156399936909467813654856;
        points[5] = -0.879929800890397131982427337465835588773292842080756928;
        points[6] = -0.835847166992475306418820872498600653346779379392325144;
        points[7] = -0.785576230132206512827768965080292603302330505839601361;
        points[8] = -0.729489171593556582090260479006108985565843046905197004;
        points[9] = -0.668001236585521062097191344340917639164702490212637653;
        points[10] = -0.60156765813598053507994497507359475174295415598675191;
        points[11] = -0.530680285926245161640709080121569817661222872646822076;
        points[12] = -0.455863944433420267207217669327440925957842388296857473;
        points[13] = -0.377672547119689216322736389669907622166172804885287866;
        points[14] = -0.296684995344028270503239047745170452700241822959825327;
        points[15] = -0.213500892316865578943226228902713916758461731272768195;
        points[16] = -0.128736103809384788651993388005152301177289724599373134;
        points[17] = -0.0430181984737086072269689782283634345542947948060091898;
        points[18] = 0.0430181984737086072269689782283634345542947948060091898;
        points[19] = 0.128736103809384788651993388005152301177289724599373134;
        points[20] = 0.213500892316865578943226228902713916758461731272768195;
        points[21] = 0.296684995344028270503239047745170452700241822959825327;
        points[22] = 0.377672547119689216322736389669907622166172804885287866;
        points[23] = 0.455863944433420267207217669327440925957842388296857473;
        points[24] = 0.530680285926245161640709080121569817661222872646822076;
        points[25] = 0.60156765813598053507994497507359475174295415598675191;
        points[26] = 0.668001236585521062097191344340917639164702490212637653;
        points[27] = 0.729489171593556582090260479006108985565843046905197004;
        points[28] = 0.785576230132206512827768965080292603302330505839601361;
        points[29] = 0.835847166992475306418820872498600653346779379392325144;
        points[30] = 0.879929800890397131982427337465835588773292842080756928;
        points[31] = 0.917497774515659066075867223026156399936909467813654856;
        points[32] = 0.948272984399507545202474114945227846289376525333673633;
        points[33] = 0.972027691049697949335605048431108327616046396265951741;
        points[34] = 0.988586478902212238073395107877107446607162520065287056;
        points[35] = 0.997830462484085836198828345580750238649816462396631313;
        weights[0] = 0.00556571966424504536125598439054783741722459189417851018;
        weights[1] = 0.0129159472840655744045034114977916491919612128514796719;
        weights[2] = 0.0201815152977354715320989289582211274195865102408615653;
        weights[3] = 0.0272986214985687790944171808679833579904568281420508554;
        weights[4] = 0.0342138107703072299212450615627145540700969113267764835;
        weights[5] = 0.0408757509236448954741145451432631915479370611190781462;
        weights[6] = 0.0472350834902659784166168296166748320731517874343696303;
        weights[7] = 0.0532447139777599190920256282862196496889296110589429207;
        weights[8] = 0.0588601442453248173096753998189200359427540957825592892;
        weights[9] = 0.0640397973550154895563847986258563397460214705508407249;
        weights[10] = 0.0687453238357364426136896393636132083417307646421384912;
        weights[11] = 0.0729418850056530613538733769412742182869469526169905444;
        weights[12] = 0.0765984106458706745287577337215016417279275568319918338;
        weights[13] = 0.0796878289120716019087246655018639073275341575147260202;
        weights[14] = 0.082187266704339709517223473544942302864963072934622121;
        weights[15] = 0.0840782189796619349334576242915958212039359139576060455;
        weights[16] = 0.0853466857393386274918505430764897709987865854972912941;
        weights[17] = 0.0859832756703947474900851747905265541600549156034958523;
        weights[18] = 0.0859832756703947474900851747905265541600549156034958523;
        weights[19] = 0.0853466857393386274918505430764897709987865854972912941;
        weights[20] = 0.0840782189796619349334576242915958212039359139576060455;
        weights[21] = 0.082187266704339709517223473544942302864963072934622121;
        weights[22] = 0.0796878289120716019087246655018639073275341575147260202;
        weights[23] = 0.0765984106458706745287577337215016417279275568319918338;
        weights[24] = 0.0729418850056530613538733769412742182869469526169905444;
        weights[25] = 0.0687453238357364426136896393636132083417307646421384912;
        weights[26] = 0.0640397973550154895563847986258563397460214705508407249;
        weights[27] = 0.0588601442453248173096753998189200359427540957825592892;
        weights[28] = 0.0532447139777599190920256282862196496889296110589429207;
        weights[29] = 0.0472350834902659784166168296166748320731517874343696303;
        weights[30] = 0.0408757509236448954741145451432631915479370611190781462;
        weights[31] = 0.0342138107703072299212450615627145540700969113267764835;
        weights[32] = 0.0272986214985687790944171808679833579904568281420508554;
        weights[33] = 0.0201815152977354715320989289582211274195865102408615653;
        weights[34] = 0.0129159472840655744045034114977916491919612128514796719;
        weights[35] = 0.00556571966424504536125598439054783741722459189417851018;
        return;
    case 37:
        points[0] = -0.997944582477913648940803074317363283669007849486729154;
        points[1] = -0.98918596321431918668409906058427230896245291758067398;
        points[2] = -0.973493030056485744328890475665759344815384616708608268;
        points[3] = -0.950972343262094821328576096816325933997548579804577386;
        points[4] = -0.921781437412463742668143686700713488781595267162329661;
        points[5] = -0.886124962155486078946149509016886440106813234826896308;
        points[6] = -0.844252987340555967987456276174860231690634495897622184;
        points[7] = -0.796459200509902293393046335500324523485631158940521608;
        points[8] = -0.743078833981965262547047417473812879089901853263012602;
        points[9] = -0.684486309130959357445523212431153708044343810970077687;
        points[10] = -0.621092608408924483148152591595057310041726400604135159;
        points[11] = -0.553342391861581781235098358229264473472286552240982324;
        points[12] = -0.481710877803205554147192868882639171989522434347350396;
        points[13] = -0.4067005093183261101009315916139666085224712793505589;
        points[14] = -0.328837429883706999498471801339940483680022575292308038;
        points[15] = -0.248667792791365758805567751487716218531677651682945158;
        points[16] = -0.166753930239851976968671730411824437466648396031276349;
        points[17] = -0.0836704089547699019430483317363991775635216320351522936;
        points[18] = 0;
        points[19] = 0.0836704089547699019430483317363991775635216320351522936;
        points[20] = 0.166753930239851976968671730411824437466648396031276349;
        points[21] = 0.248667792791365758805567751487716218531677651682945158;
        points[22] = 0.328837429883706999498471801339940483680022575292308038;
        points[23] = 0.4067005093183261101009315916139666085224712793505589;
        points[24] = 0.481710877803205554147192868882639171989522434347350396;
        points[25] = 0.553342391861581781235098358229264473472286552240982324;
        points[26] = 0.621092608408924483148152591595057310041726400604135159;
        points[27] = 0.684486309130959357445523212431153708044343810970077687;
        points[28] = 0.743078833981965262547047417473812879089901853263012602;
        points[29] = 0.796459200509902293393046335500324523485631158940521608;
        points[30] = 0.844252987340555967987456276174860231690634495897622184;
        points[31] = 0.886124962155486078946149509016886440106813234826896308;
        points[32] = 0.921781437412463742668143686700713488781595267162329661;
        points[33] = 0.950972343262094821328576096816325933997548579804577386;
        points[34] = 0.973493030056485744328890475665759344815384616708608268;
        points[35] = 0.98918596321431918668409906058427230896245291758067398;
        points[36] = 0.997944582477913648940803074317363283669007849486729154;
        weights[0] = 0.00527305727949793935172205423353038918308830590652726543;
        weights[1] = 0.0122387801003075565263048524363465759422909531112660823;
        weights[2] = 0.0191290444890839660435019479401061741302952357462103257;
        weights[3] = 0.0258860369905589335227594813624872980294841825751032704;
        weights[4] = 0.0324616398475214810672342535014587287990945591225246664;
        weights[5] = 0.0388096025019345444889623703284760199673891892736854008;
        weights[6] = 0.044885364662437166657410304110196360194723306514413933;
        weights[7] = 0.0506462976548246016038758630867163440527057629453541097;
        weights[8] = 0.0560519879982749178085392396642526664267538552877670788;
        weights[9] = 0.0610645165232259861309881045004965856779940090623631049;
        weights[10] = 0.0656487228727512494840237662979712181966773211497249265;
        weights[11] = 0.0697724515557003448850813567930192911860236786977560874;
        weights[12] = 0.0734067772484881727246266315197954649834699421976482146;
        weights[13] = 0.0765262075705292378858879912066225154953633155315440516;
        weights[14] = 0.079108861837529380767212187396645238516006935064182366;
        weights[15] = 0.0811366245084650305098776017997922635664600449746249385;
        weights[16] = 0.0825952722364372508912303011528384707733064526020397682;
        weights[17] = 0.0834745736258627872522530094845186990204353102030260501;
        weights[18] = 0.0837683609931389047970173663694593917168752800684767192;
        weights[19] = 0.0834745736258627872522530094845186990204353102030260501;
        weights[20] = 0.0825952722364372508912303011528384707733064526020397682;
        weights[21] = 0.0811366245084650305098776017997922635664600449746249385;
        weights[22] = 0.079108861837529380767212187396645238516006935064182366;
        weights[23] = 0.0765262075705292378858879912066225154953633155315440516;
        weights[24] = 0.0734067772484881727246266315197954649834699421976482146;
        weights[25] = 0.0697724515557003448850813567930192911860236786977560874;
        weights[26] = 0.0656487228727512494840237662979712181966773211497249265;
        weights[27] = 0.0610645165232259861309881045004965856779940090623631049;
        weights[28] = 0.0560519879982749178085392396642526664267538552877670788;
        weights[29] = 0.0506462976548246016038758630867163440527057629453541097;
        weights[30] = 0.044885364662437166657410304110196360194723306514413933;
        weights[31] = 0.0388096025019345444889623703284760199673891892736854008;
        weights[32] = 0.0324616398475214810672342535014587287990945591225246664;
        weights[33] = 0.0258860369905589335227594813624872980294841825751032704;
        weights[34] = 0.0191290444890839660435019479401061741302952357462103257;
        weights[35] = 0.0122387801003075565263048524363465759422909531112660823;
        weights[36] = 0.00527305727949793935172205423353038918308830590652726543;
        return;
    case 38:
        points[0] = -0.99804993053568761981284707655158099749046537027458809;
        points[1] = -0.989739454266385571944425891105679347324381246908022206;
        points[2] = -0.974846328590153507640885540946388642591975358766073516;
        points[3] = -0.95346633093352959567054215311744121738577897072292871;
        points[4] = -0.925741332048584396825109562213050911480917876481105521;
        points[5] = -0.891855739004632216794937031973917511579899053234515361;
        points[6] = -0.852035021932362188859649711247276280440385037327630969;
        points[7] = -0.806544167605316815551565375979698325731772981329319621;
        points[8] = -0.755685903753970680737738096779387413503837570746703927;
        points[9] = -0.699798680379184355912825840627415875638207015300590438;
        points[10] = -0.639254415829681707180344869500260271701170395409661429;
        points[11] = -0.574456021047807081132927500924472510210199597853798765;
        points[12] = -0.505834717927931103240533716467652002793846550637187645;
        points[13] = -0.433847169432376484373256162517842204005923800406839124;
        points[14] = -0.358972440479435013256717621456534291796062949211368074;
        points[15] = -0.281708809790165261360114071418700076769670508783611332;
        points[16] = -0.202570453892116703203977781514607057371655085753703517;
        points[17] = -0.122084025337867419869612381329407116568118141499300009;
        points[18] = -0.0407851479045782399133164323297849207847736426836548117;
        points[19] = 0.0407851479045782399133164323297849207847736426836548117;
        points[20] = 0.122084025337867419869612381329407116568118141499300009;
        points[21] = 0.202570453892116703203977781514607057371655085753703517;
        points[22] = 0.281708809790165261360114071418700076769670508783611332;
        points[23] = 0.358972440479435013256717621456534291796062949211368074;
        points[24] = 0.433847169432376484373256162517842204005923800406839124;
        points[25] = 0.505834717927931103240533716467652002793846550637187645;
        points[26] = 0.574456021047807081132927500924472510210199597853798765;
        points[27] = 0.639254415829681707180344869500260271701170395409661429;
        points[28] = 0.699798680379184355912825840627415875638207015300590438;
        points[29] = 0.755685903753970680737738096779387413503837570746703927;
        points[30] = 0.806544167605316815551565375979698325731772981329319621;
        points[31] = 0.852035021932362188859649711247276280440385037327630969;
        points[32] = 0.891855739004632216794937031973917511579899053234515361;
        points[33] = 0.925741332048584396825109562213050911480917876481105521;
        points[34] = 0.95346633093352959567054215311744121738577897072292871;
        points[35] = 0.974846328590153507640885540946388642591975358766073516;
        points[36] = 0.989739454266385571944425891105679347324381246908022206;
        points[37] = 0.99804993053568761981284707655158099749046537027458809;
        weights[0] = 0.00500288074963934567589954209189937046383927186262170591;
        weights[1] = 0.0116134447164686741776683012004374273572367478601123297;
        weights[2] = 0.0181565777096132368988761257547822022629123390397971224;
        weights[3] = 0.0245797397382323758952012054467062874459591622272020467;
        weights[4] = 0.0308395005451750546587310863133086889204118954971985188;
        weights[5] = 0.03689408159402473816494016233681495034735611724058349;
        weights[6] = 0.0427031585046744342358784343588077086784174845681521442;
        weights[7] = 0.0482280618607586833743521799114202241893610027852761323;
        weights[8] = 0.0534320199103323199737569906312487560769153103387560856;
        weights[9] = 0.0582803991469972060223058682581400559151277021585559865;
        weights[10] = 0.0627409333921330540529696715251370643209038889969087583;
        weights[11] = 0.0667839379791404119350461515290192599559521560352792417;
        weights[12] = 0.0703825070668989547392829675936588408392617017624612065;
        weights[13] = 0.0735126925847434571452064448483364785766371950924317554;
        weights[14] = 0.0761536635484463960659935411044725279963452188325545188;
        weights[15] = 0.0782878446582109480753754033357362625649037448578418256;
        weights[16] = 0.079901033243527821586027683925185696550301239589681579;
        weights[17] = 0.0809824937705971006232694699490581419365151697840887541;
        weights[18] = 0.0815250292803857866992187698858300556016426514704967984;
        weights[19] = 0.0815250292803857866992187698858300556016426514704967984;
        weights[20] = 0.0809824937705971006232694699490581419365151697840887541;
        weights[21] = 0.079901033243527821586027683925185696550301239589681579;
        weights[22] = 0.0782878446582109480753754033357362625649037448578418256;
        weights[23] = 0.0761536635484463960659935411044725279963452188325545188;
        weights[24] = 0.0735126925847434571452064448483364785766371950924317554;
        weights[25] = 0.0703825070668989547392829675936588408392617017624612065;
        weights[26] = 0.0667839379791404119350461515290192599559521560352792417;
        weights[27] = 0.0627409333921330540529696715251370643209038889969087583;
        weights[28] = 0.0582803991469972060223058682581400559151277021585559865;
        weights[29] = 0.0534320199103323199737569906312487560769153103387560856;
        weights[30] = 0.0482280618607586833743521799114202241893610027852761323;
        weights[31] = 0.0427031585046744342358784343588077086784174845681521442;
        weights[32] = 0.03689408159402473816494016233681495034735611724058349;
        weights[33] = 0.0308395005451750546587310863133086889204118954971985188;
        weights[34] = 0.0245797397382323758952012054467062874459591622272020467;
        weights[35] = 0.0181565777096132368988761257547822022629123390397971224;
        weights[36] = 0.0116134447164686741776683012004374273572367478601123297;
        weights[37] = 0.00500288074963934567589954209189937046383927186262170591;
        return;
    case 39:
        points[0] = -0.998147383066432906005472302851820441832009740049664212;
        points[1] = -0.990251536854685983639775117247078204709693821040191796;
        points[2] = -0.976098709333471053844850319889518494290747412680101703;
        points[3] = -0.955775212324652277110891897191082203001771790638876136;
        points[4] = -0.929409148486738229697816964357734561844102809507703527;
        points[5] = -0.897167119292992887848291090860813651065692077975623002;
        points[6] = -0.859252937999906153913797439126042370535084445319822061;
        points[7] = -0.815906297430143104353232678409629827727814060520923857;
        points[8] = -0.767401242931063499832272404228342945472834113459010662;
        points[9] = -0.714044435894534679133867036151830789664345281893698215;
        points[10] = -0.656173213432010910734425934976256184880107611576970431;
        points[11] = -0.594153454957277988692890074619106068165591544678126535;
        points[12] = -0.528377268660437473896343635808222505340717653485424776;
        points[13] = -0.459260512309136048663246633109572362938749153696017238;
        points[14] = -0.387240163971561455853881965636962696012576172716826616;
        points[15] = -0.31277155924818592253599691178562873960190560997753935;
        points[16] = -0.236325512461835767336006327332650448065719224794057596;
        points[17] = -0.15838533999783779992270106136139938446682623686514314;
        points[18] = -0.0794438046087554775819170831926406468850031651067419333;
        points[19] = 0;
        points[20] = 0.0794438046087554775819170831926406468850031651067419333;
        points[21] = 0.15838533999783779992270106136139938446682623686514314;
        points[22] = 0.236325512461835767336006327332650448065719224794057596;
        points[23] = 0.31277155924818592253599691178562873960190560997753935;
        points[24] = 0.387240163971561455853881965636962696012576172716826616;
        points[25] = 0.459260512309136048663246633109572362938749153696017238;
        points[26] = 0.528377268660437473896343635808222505340717653485424776;
        points[27] = 0.594153454957277988692890074619106068165591544678126535;
        points[28] = 0.656173213432010910734425934976256184880107611576970431;
        points[29] = 0.714044435894534679133867036151830789664345281893698215;
        points[30] = 0.767401242931063499832272404228342945472834113459010662;
        points[31] = 0.815906297430143104353232678409629827727814060520923857;
        points[32] = 0.859252937999906153913797439126042370535084445319822061;
        points[33] = 0.897167119292992887848291090860813651065692077975623002;
        points[34] = 0.929409148486738229697816964357734561844102809507703527;
        points[35] = 0.955775212324652277110891897191082203001771790638876136;
        points[36] = 0.976098709333471053844850319889518494290747412680101703;
        points[37] = 0.990251536854685983639775117247078204709693821040191796;
        points[38] = 0.998147383066432906005472302851820441832009740049664212;
        weights[0] = 0.00475294469163510137077621315490694198569508454183706144;
        weights[1] = 0.0110347889391645942426768054521772894535071393731181559;
        weights[2] = 0.0172562290937249190408054711833550472137159018904623154;
        weights[3] = 0.0233693848321781645947123444429246988911975554637566659;
        weights[4] = 0.0293349559839033785921559863562514256114114671016045653;
        weights[5] = 0.0351151114981313307610651852972328163666614876197266856;
        weights[6] = 0.0406732768479338439390565560822614036875724359960629048;
        weights[7] = 0.0459743011089166318841766393992327805988616930339994639;
        weights[8] = 0.0509846652921294052140210336765813350176130838812849053;
        weights[9] = 0.0556726903409162999073911397896814827069609480735800684;
        weights[10] = 0.0600087360885961495749417735488194997366782270918463043;
        weights[11] = 0.0639653881386823889867064044100636448557769168899798797;
        weights[12] = 0.0675176309662312653630213280464485937751527080834770358;
        weights[13] = 0.0706430059706087607701149315281311364674296841590281693;
        weights[14] = 0.0733217534142686173811539328650483064478934242509751308;
        weights[15] = 0.0755369373228360577047844469908093990941879785900218443;
        weights[16] = 0.0772745525446820167285116367331172991204952514887911509;
        weights[17] = 0.0785236132873711767250633009855234715225814764092488609;
        weights[18] = 0.0792762225683684710101557717545079305238041486782664247;
        weights[19] = 0.0795276221394428524174181966058509938456067747658648143;
        weights[20] = 0.0792762225683684710101557717545079305238041486782664247;
        weights[21] = 0.0785236132873711767250633009855234715225814764092488609;
        weights[22] = 0.0772745525446820167285116367331172991204952514887911509;
        weights[23] = 0.0755369373228360577047844469908093990941879785900218443;
        weights[24] = 0.0733217534142686173811539328650483064478934242509751308;
        weights[25] = 0.0706430059706087607701149315281311364674296841590281693;
        weights[26] = 0.0675176309662312653630213280464485937751527080834770358;
        weights[27] = 0.0639653881386823889867064044100636448557769168899798797;
        weights[28] = 0.0600087360885961495749417735488194997366782270918463043;
        weights[29] = 0.0556726903409162999073911397896814827069609480735800684;
        weights[30] = 0.0509846652921294052140210336765813350176130838812849053;
        weights[31] = 0.0459743011089166318841766393992327805988616930339994639;
        weights[32] = 0.0406732768479338439390565560822614036875724359960629048;
        weights[33] = 0.0351151114981313307610651852972328163666614876197266856;
        weights[34] = 0.0293349559839033785921559863562514256114114671016045653;
        weights[35] = 0.0233693848321781645947123444429246988911975554637566659;
        weights[36] = 0.0172562290937249190408054711833550472137159018904623154;
        weights[37] = 0.0110347889391645942426768054521772894535071393731181559;
        weights[38] = 0.00475294469163510137077621315490694198569508454183706144;
        return;
    case 40:
        points[0] = -0.998237709710559200349622702420586492335770381595045907;
        points[1] = -0.990726238699457006453054352221372154962222081351086538;
        points[2] = -0.977259949983774262663370283712903806978667932037986096;
        points[3] = -0.957916819213791655804540999452759285094883490602747032;
        points[4] = -0.932812808278676533360852166845205716434753575282692449;
        points[5] = -0.902098806968874296728253330868493103584488081057669468;
        points[6] = -0.865959503212259503820781808354619963570546553011101649;
        points[7] = -0.8246122308333116631963202306660987739072403842429878;
        points[8] = -0.778305651426519387694971545506494848020691316126891794;
        points[9] = -0.727318255189927103280996451754930548557378673533328138;
        points[10] = -0.67195668461417954837935451496149410997032598138385115;
        points[11] = -0.612553889667980237952612450230694877380123781683149611;
        points[12] = -0.549467125095128202075931305529517970233975101595651465;
        points[13] = -0.483075801686178712908566574244823004599022395533114101;
        points[14] = -0.413779204371605001524879745803713682974099624052918238;
        points[15] = -0.341994090825758473007492481179194310066953620027325796;
        points[16] = -0.268152185007253681141184344808596183424804373236246981;
        points[17] = -0.192697580701371099715516852065149894814092021105208875;
        points[18] = -0.116084070675255208483451284408024113768728530854215949;
        points[19] = -0.0387724175060508219331934440246232946793646343831415992;
        points[20] = 0.0387724175060508219331934440246232946793646343831415992;
        points[21] = 0.116084070675255208483451284408024113768728530854215949;
        points[22] = 0.192697580701371099715516852065149894814092021105208875;
        points[23] = 0.268152185007253681141184344808596183424804373236246981;
        points[24] = 0.341994090825758473007492481179194310066953620027325796;
        points[25] = 0.413779204371605001524879745803713682974099624052918238;
        points[26] = 0.483075801686178712908566574244823004599022395533114101;
        points[27] = 0.549467125095128202075931305529517970233975101595651465;
        points[28] = 0.612553889667980237952612450230694877380123781683149611;
        points[29] = 0.67195668461417954837935451496149410997032598138385115;
        points[30] = 0.727318255189927103280996451754930548557378673533328138;
        points[31] = 0.778305651426519387694971545506494848020691316126891794;
        points[32] = 0.8246122308333116631963202306660987739072403842429878;
        points[33] = 0.865959503212259503820781808354619963570546553011101649;
        points[34] = 0.902098806968874296728253330868493103584488081057669468;
        points[35] = 0.932812808278676533360852166845205716434753575282692449;
        points[36] = 0.957916819213791655804540999452759285094883490602747032;
        points[37] = 0.977259949983774262663370283712903806978667932037986096;
        points[38] = 0.990726238699457006453054352221372154962222081351086538;
        points[39] = 0.998237709710559200349622702420586492335770381595045907;
        weights[0] = 0.0045212770985331912584717328781853327278311101997059907;
        weights[1] = 0.0104982845311528136147421710672796523767926213157967797;
        weights[2] = 0.016421058381907888712863484882363927292342293346957762;
        weights[3] = 0.0222458491941669572615043241842085732070331966793544279;
        weights[4] = 0.0279370069800234010984891575077210773025508620507663984;
        weights[5] = 0.0334601952825478473926781830864108489772417866537643504;
        weights[6] = 0.0387821679744720176399720312904461622534592112320258578;
        weights[7] = 0.0438709081856732719916746860417154958110068371702368898;
        weights[8] = 0.0486958076350722320614341604481463880678430273771197751;
        weights[9] = 0.0532278469839368243549964797722605045553211718220064508;
        weights[10] = 0.0574397690993915513666177309104259856001048358544536265;
        weights[11] = 0.061306242492928939166537996408398595902593763511174322;
        weights[12] = 0.0648040134566010380745545295667527300326929642084889064;
        weights[13] = 0.0679120458152339038256901082319239859841972383792859547;
        weights[14] = 0.0706116473912867796954836308552868323595591039955860973;
        weights[15] = 0.0728865823958040590605106834425178358575590809857986305;
        weights[16] = 0.0747231690579682642001893362613246731912029344203598217;
        weights[17] = 0.0761103619006262423715580759224948230125595538450711071;
        weights[18] = 0.0770398181642479655883075342838102485244397541639404155;
        weights[19] = 0.0775059479784248112637239629583263269636686527881064357;
        weights[20] = 0.0775059479784248112637239629583263269636686527881064357;
        weights[21] = 0.0770398181642479655883075342838102485244397541639404155;
        weights[22] = 0.0761103619006262423715580759224948230125595538450711071;
        weights[23] = 0.0747231690579682642001893362613246731912029344203598217;
        weights[24] = 0.0728865823958040590605106834425178358575590809857986305;
        weights[25] = 0.0706116473912867796954836308552868323595591039955860973;
        weights[26] = 0.0679120458152339038256901082319239859841972383792859547;
        weights[27] = 0.0648040134566010380745545295667527300326929642084889064;
        weights[28] = 0.061306242492928939166537996408398595902593763511174322;
        weights[29] = 0.0574397690993915513666177309104259856001048358544536265;
        weights[30] = 0.0532278469839368243549964797722605045553211718220064508;
        weights[31] = 0.0486958076350722320614341604481463880678430273771197751;
        weights[32] = 0.0438709081856732719916746860417154958110068371702368898;
        weights[33] = 0.0387821679744720176399720312904461622534592112320258578;
        weights[34] = 0.0334601952825478473926781830864108489772417866537643504;
        weights[35] = 0.0279370069800234010984891575077210773025508620507663984;
        weights[36] = 0.0222458491941669572615043241842085732070331966793544279;
        weights[37] = 0.016421058381907888712863484882363927292342293346957762;
        weights[38] = 0.0104982845311528136147421710672796523767926213157967797;
        weights[39] = 0.0045212770985331912584717328781853327278311101997059907;
        return;
    case 41:
        points[0] = -0.998321588574771441519188508088377567931504351513670166;
        points[1] = -0.991167109699016308250158894573169657692756013570003047;
        points[2] = -0.978338673561083384469170706673967198375636781918654282;
        points[3] = -0.959906891730346226099441696068686582066951090829466351;
        points[4] = -0.935976987497853825682318275284766266271237118087344775;
        points[5] = -0.906685944758101172958340413230722973354307185322284854;
        points[6] = -0.872201511692441408833670574234329460282042655539533002;
        points[7] = -0.832721200401361331244272779048543799976975992978582133;
        points[8] = -0.78847114504740937273622178146677028899471207909872721;
        points[9] = -0.739704803069926181060168744468559000395254439052568965;
        points[10] = -0.686701502034951289584603856529134812066438460149673129;
        points[11] = -0.629764839072196320488649091695103501078514780739470874;
        points[12] = -0.569220941610215869654747215282980251610456923979545244;
        points[13] = -0.505416599199406032708336070202694764951075546015180246;
        points[14] = -0.438717277051407088517119856728039248421785758759468643;
        points[15] = -0.369505022640481441428366913299935205624086971331876079;
        points[16] = -0.298176277341824865922982880478924304139955868446148526;
        points[17] = -0.225139605633422775605786256655472330299912420644243222;
        points[18] = -0.150813354863992163574377967884582375775630945329497831;
        points[19] = -0.0756232589891629969237661936512002674810506356066569488;
        points[20] = 0;
        points[21] = 0.0756232589891629969237661936512002674810506356066569488;
        points[22] = 0.150813354863992163574377967884582375775630945329497831;
        points[23] = 0.225139605633422775605786256655472330299912420644243222;
        points[24] = 0.298176277341824865922982880478924304139955868446148526;
        points[25] = 0.369505022640481441428366913299935205624086971331876079;
        points[26] = 0.438717277051407088517119856728039248421785758759468643;
        points[27] = 0.505416599199406032708336070202694764951075546015180246;
        points[28] = 0.569220941610215869654747215282980251610456923979545244;
        points[29] = 0.629764839072196320488649091695103501078514780739470874;
        points[30] = 0.686701502034951289584603856529134812066438460149673129;
        points[31] = 0.739704803069926181060168744468559000395254439052568965;
        points[32] = 0.78847114504740937273622178146677028899471207909872721;
        points[33] = 0.832721200401361331244272779048543799976975992978582133;
        points[34] = 0.872201511692441408833670574234329460282042655539533002;
        points[35] = 0.906685944758101172958340413230722973354307185322284854;
        points[36] = 0.935976987497853825682318275284766266271237118087344775;
        points[37] = 0.959906891730346226099441696068686582066951090829466351;
        points[38] = 0.978338673561083384469170706673967198375636781918654282;
        points[39] = 0.991167109699016308250158894573169657692756013570003047;
        points[40] = 0.998321588574771441519188508088377567931504351513670166;
        weights[0] = 0.00430614035816488768400447790465448618636220399530170482;
        weights[1] = 0.00999993877390594533849629662969883955022493577115020595;
        weights[2] = 0.0156449384078185885308268444795336774408178893696463564;
        weights[3] = 0.0212010633687795530756970334933766265717170543273583082;
        weights[4] = 0.026635899207110445467548575258713277044690492005248138;
        weights[5] = 0.0319182117316992817870669468571455437011877532975110126;
        weights[6] = 0.0370177167035079884352612515801606686062715463218675428;
        weights[7] = 0.0419051951959096894293402743110488379362663774320223833;
        weights[8] = 0.046552648369014342060756586864611423130990198580590185;
        weights[9] = 0.0509334542946174947811703571156886314208034467868703288;
        weights[10] = 0.0550225192425787418801468101714222699737753366053695905;
        weights[11] = 0.0587964209498719449911858533807342740008812386027269409;
        weights[12] = 0.0622335425809663164715734170833464854301598699449434294;
        weights[13] = 0.0653141964535274104361637126537963404198592367210681263;
        weights[14] = 0.0680207367608767667355332397262489282566991201385941654;
        weights[15] = 0.0703376606208174974816589899698814560012333801678102797;
        weights[16] = 0.0722516968610230733963463983487873548852947705248725489;
        weights[17] = 0.0737518820272234699392808183248486794779162804283396427;
        weights[18] = 0.0748296231762215518913050726335053229456830673780307176;
        weights[19] = 0.0754787470927158240272470626746167490736063609030627762;
        weights[20] = 0.0756955356472983723187799610763602558911188813952312331;
        weights[21] = 0.0754787470927158240272470626746167490736063609030627762;
        weights[22] = 0.0748296231762215518913050726335053229456830673780307176;
        weights[23] = 0.0737518820272234699392808183248486794779162804283396427;
        weights[24] = 0.0722516968610230733963463983487873548852947705248725489;
        weights[25] = 0.0703376606208174974816589899698814560012333801678102797;
        weights[26] = 0.0680207367608767667355332397262489282566991201385941654;
        weights[27] = 0.0653141964535274104361637126537963404198592367210681263;
        weights[28] = 0.0622335425809663164715734170833464854301598699449434294;
        weights[29] = 0.0587964209498719449911858533807342740008812386027269409;
        weights[30] = 0.0550225192425787418801468101714222699737753366053695905;
        weights[31] = 0.0509334542946174947811703571156886314208034467868703288;
        weights[32] = 0.046552648369014342060756586864611423130990198580590185;
        weights[33] = 0.0419051951959096894293402743110488379362663774320223833;
        weights[34] = 0.0370177167035079884352612515801606686062715463218675428;
        weights[35] = 0.0319182117316992817870669468571455437011877532975110126;
        weights[36] = 0.026635899207110445467548575258713277044690492005248138;
        weights[37] = 0.0212010633687795530756970334933766265717170543273583082;
        weights[38] = 0.0156449384078185885308268444795336774408178893696463564;
        weights[39] = 0.00999993877390594533849629662969883955022493577115020595;
        weights[40] = 0.00430614035816488768400447790465448618636220399530170482;
        return;
    case 42:
        points[0] = -0.998399618990062415022868126847050276177876083522781252;
        points[1] = -0.991577288340860919792361253280868833452693264737104018;
        points[2] = -0.979342508063748193708982566542856095586474980129062929;
        points[3] = -0.961759365338204488746927157853322681171721288914031999;
        points[4] = -0.938923557354988178533173433625591970251387818450171871;
        points[5] = -0.910959724904127452583847879208506542318900351339455604;
        points[6] = -0.878020569812172742711985103478623534062819716243918599;
        points[7] = -0.840285983261816900925439995086099817823398575193568357;
        points[8] = -0.797962053255487413232705952546376660132375511290654134;
        points[9] = -0.751279935689480489568472175914658655502564519829540925;
        points[10] = -0.700494590556171213741569929055465534300175941800093181;
        points[11] = -0.645883388869247833957496303718411701169086543840143865;
        points[12] = -0.587744597485109322840711345473995719905431304828001646;
        points[13] = -0.526395749931192287592867558791901461435739764929909929;
        points[14] = -0.462171912070421929759075029930635985109664908473608631;
        points[15] = -0.395423852042975057677093954594371980799178576486353488;
        points[16] = -0.326516124465411512197156589375465669058411470498584524;
        points[17] = -0.255825079342879083966414791018708448768766456465400955;
        points[18] = -0.1837368065648545508527556393807429409333239616225151;
        points[19] = -0.110645027208519868349122545002641004867344024483630807;
        points[20] = -0.0369489431653517758130959800375594266417084522492225313;
        points[21] = 0.0369489431653517758130959800375594266417084522492225313;
        points[22] = 0.110645027208519868349122545002641004867344024483630807;
        points[23] = 0.1837368065648545508527556393807429409333239616225151;
        points[24] = 0.255825079342879083966414791018708448768766456465400955;
        points[25] = 0.326516124465411512197156589375465669058411470498584524;
        points[26] = 0.395423852042975057677093954594371980799178576486353488;
        points[27] = 0.462171912070421929759075029930635985109664908473608631;
        points[28] = 0.526395749931192287592867558791901461435739764929909929;
        points[29] = 0.587744597485109322840711345473995719905431304828001646;
        points[30] = 0.645883388869247833957496303718411701169086543840143865;
        points[31] = 0.700494590556171213741569929055465534300175941800093181;
        points[32] = 0.751279935689480489568472175914658655502564519829540925;
        points[33] = 0.797962053255487413232705952546376660132375511290654134;
        points[34] = 0.840285983261816900925439995086099817823398575193568357;
        points[35] = 0.878020569812172742711985103478623534062819716243918599;
        points[36] = 0.910959724904127452583847879208506542318900351339455604;
        points[37] = 0.938923557354988178533173433625591970251387818450171871;
        points[38] = 0.961759365338204488746927157853322681171721288914031999;
        points[39] = 0.979342508063748193708982566542856095586474980129062929;
        points[40] = 0.991577288340860919792361253280868833452693264737104018;
        points[41] = 0.998399618990062415022868126847050276177876083522781252;
        weights[0] = 0.00410599860464908461060277949683596265701677337480229036;
        weights[1] = 0.00953622030174850241182010029269799818868479873501257251;
        weights[2] = 0.0149224436973574941446776781058657676200927474901078966;
        weights[3] = 0.0202278695690526447570557190793541850826714265524220962;
        weights[4] = 0.0254229595261130478867424429094308643861354103739789549;
        weights[5] = 0.0304792406996034683629047335233923977917696542444008948;
        weights[6] = 0.0353690710975921108326621811265075419057485217806414501;
        weights[7] = 0.0400657351806922617605961248300369345537337018657456151;
        weights[8] = 0.0445435777719658778743163659852342413185954660371275812;
        weights[9] = 0.048778140792803245027449363128402723921117696934226903;
        weights[10] = 0.0527462956991740703439425390440974770315659878271861196;
        weights[11] = 0.0564263693580183816464268551396956893988731585762885074;
        weights[12] = 0.0597982622275866543128315457535348515098534186959439095;
        weights[13] = 0.0628435580450025764093182513237798891527970439218897387;
        weights[14] = 0.0655456243649089789270051078517944256097822940857930823;
        weights[15] = 0.0678897033765219448553634022137663072661347346585931979;
        weights[16] = 0.0698629924925941597661547863814822044439273130474320937;
        weights[17] = 0.0714547142651709829218104441174621550225898638775037186;
        weights[18] = 0.07265617524380410488790576149253303127678368396842723;
        weights[19] = 0.0734608134534675282640282570543039387336557834504052394;
        weights[20] = 0.0738642342321728799963855611497914131284705205020709081;
        weights[21] = 0.0738642342321728799963855611497914131284705205020709081;
        weights[22] = 0.0734608134534675282640282570543039387336557834504052394;
        weights[23] = 0.07265617524380410488790576149253303127678368396842723;
        weights[24] = 0.0714547142651709829218104441174621550225898638775037186;
        weights[25] = 0.0698629924925941597661547863814822044439273130474320937;
        weights[26] = 0.0678897033765219448553634022137663072661347346585931979;
        weights[27] = 0.0655456243649089789270051078517944256097822940857930823;
        weights[28] = 0.0628435580450025764093182513237798891527970439218897387;
        weights[29] = 0.0597982622275866543128315457535348515098534186959439095;
        weights[30] = 0.0564263693580183816464268551396956893988731585762885074;
        weights[31] = 0.0527462956991740703439425390440974770315659878271861196;
        weights[32] = 0.048778140792803245027449363128402723921117696934226903;
        weights[33] = 0.0445435777719658778743163659852342413185954660371275812;
        weights[34] = 0.0400657351806922617605961248300369345537337018657456151;
        weights[35] = 0.0353690710975921108326621811265075419057485217806414501;
        weights[36] = 0.0304792406996034683629047335233923977917696542444008948;
        weights[37] = 0.0254229595261130478867424429094308643861354103739789549;
        weights[38] = 0.0202278695690526447570557190793541850826714265524220962;
        weights[39] = 0.0149224436973574941446776781058657676200927474901078966;
        weights[40] = 0.00953622030174850241182010029269799818868479873501257251;
        weights[41] = 0.00410599860464908461060277949683596265701677337480229036;
        return;
    case 43:
        points[0] = -0.998472332242507713517636187318392411962050717847609143;
        points[1] = -0.991959557593244146420718341329618016387053225958952728;
        points[2] = -0.980278220980255331505529382181136390180867596519573484;
        points[3] = -0.963486613014079993410194963574243939867618912278712546;
        points[4] = -0.941671956847637861818477390397938271466476089813827758;
        points[5] = -0.914947907206138729456102870799285616745780103108423057;
        points[6] = -0.883453765218616863337678011642167417862166694242451599;
        points[7] = -0.847353716209315048999086085821792517512596547477239884;
        points[8] = -0.806835964136938635279074740877512126060886243481752597;
        points[9] = -0.762111747194955121460328463029046187807595258685957756;
        points[10] = -0.713414235268957054851920877990904102642529167113636116;
        points[11] = -0.660997313751498133165134763741345394113156812534213293;
        points[12] = -0.605134259639600935725083071123955221438369807894527289;
        points[13] = -0.546116316660084719140405047179660836654854224124755803;
        points[14] = -0.484251176785734724069633434748513777993577081871723296;
        points[15] = -0.419861376029269252487279394560568026074988907714570948;
        points[16] = -0.353282612864303806645476364143467871780445030142565542;
        points[17] = -0.28486199803291362710572289483833793178587981775426117;
        points[18] = -0.214956244860518209014878381473674953737224286385453044;
        points[19] = -0.143929809510713310770299937610744688682788883471342648;
        points[20] = -0.0721529908745862354223272509555610948576552766606143055;
        points[21] = 0;
        points[22] = 0.0721529908745862354223272509555610948576552766606143055;
        points[23] = 0.143929809510713310770299937610744688682788883471342648;
        points[24] = 0.214956244860518209014878381473674953737224286385453044;
        points[25] = 0.28486199803291362710572289483833793178587981775426117;
        points[26] = 0.353282612864303806645476364143467871780445030142565542;
        points[27] = 0.419861376029269252487279394560568026074988907714570948;
        points[28] = 0.484251176785734724069633434748513777993577081871723296;
        points[29] = 0.546116316660084719140405047179660836654854224124755803;
        points[30] = 0.605134259639600935725083071123955221438369807894527289;
        points[31] = 0.660997313751498133165134763741345394113156812534213293;
        points[32] = 0.713414235268957054851920877990904102642529167113636116;
        points[33] = 0.762111747194955121460328463029046187807595258685957756;
        points[34] = 0.806835964136938635279074740877512126060886243481752597;
        points[35] = 0.847353716209315048999086085821792517512596547477239884;
        points[36] = 0.883453765218616863337678011642167417862166694242451599;
        points[37] = 0.914947907206138729456102870799285616745780103108423057;
        points[38] = 0.941671956847637861818477390397938271466476089813827758;
        points[39] = 0.963486613014079993410194963574243939867618912278712546;
        points[40] = 0.980278220980255331505529382181136390180867596519573484;
        points[41] = 0.991959557593244146420718341329618016387053225958952728;
        points[42] = 0.998472332242507713517636187318392411962050717847609143;
        weights[0] = 0.00391949025384412728296716519257643543366036457269087234;
        weights[1] = 0.00910399663740140331886860829589672381301797555982670408;
        weights[2] = 0.0142487564315764861085416017220041935720739931441623353;
        weights[3] = 0.0193199014236839003961246108920713523170235590882569686;
        weights[4] = 0.0242904566138388159020183242542492484552370393358121375;
        weights[5] = 0.029134413261498494915940424825781193787550569840192032;
        weights[6] = 0.0338264920868602923449684757538020910533016106471323669;
        weights[7] = 0.0383422221941326575721284246628491148800725628683971755;
        weights[8] = 0.0426580571979820837638072053385138941049470912367672507;
        weights[9] = 0.0467514947543465800106467663371029339328630959356638568;
        weights[10] = 0.050601192784390156523850398953014745749898009098012191;
        weights[11] = 0.0541870803188817868633731783262654135883905526707112847;
        weights[12] = 0.0574904619569105194276089168444165119278688681945654327;
        weights[13] = 0.0604941152499912945196787419913627933585088798704285874;
        weights[14] = 0.0631823804493961123256298177734082642566962346394688467;
        weights[15] = 0.0655412421263227974912337642492078302249625337784548263;
        weights[16] = 0.0675584022293651691924079047562655921429462925857296083;
        weights[17] = 0.0692233441936566842822994791226351478093049895709278238;
        weights[18] = 0.0705273877650850281262863554779407431837361667849641501;
        weights[19] = 0.0714637342525141412975811177029102485809000193677956732;
        weights[20] = 0.0720275019714219743453075516708570877535042459474147016;
        weights[21] = 0.072215751693798987977462331713736880147070690525250349;
        weights[22] = 0.0720275019714219743453075516708570877535042459474147016;
        weights[23] = 0.0714637342525141412975811177029102485809000193677956732;
        weights[24] = 0.0705273877650850281262863554779407431837361667849641501;
        weights[25] = 0.0692233441936566842822994791226351478093049895709278238;
        weights[26] = 0.0675584022293651691924079047562655921429462925857296083;
        weights[27] = 0.0655412421263227974912337642492078302249625337784548263;
        weights[28] = 0.0631823804493961123256298177734082642566962346394688467;
        weights[29] = 0.0604941152499912945196787419913627933585088798704285874;
        weights[30] = 0.0574904619569105194276089168444165119278688681945654327;
        weights[31] = 0.0541870803188817868633731783262654135883905526707112847;
        weights[32] = 0.050601192784390156523850398953014745749898009098012191;
        weights[33] = 0.0467514947543465800106467663371029339328630959356638568;
        weights[34] = 0.0426580571979820837638072053385138941049470912367672507;
        weights[35] = 0.0383422221941326575721284246628491148800725628683971755;
        weights[36] = 0.0338264920868602923449684757538020910533016106471323669;
        weights[37] = 0.029134413261498494915940424825781193787550569840192032;
        weights[38] = 0.0242904566138388159020183242542492484552370393358121375;
        weights[39] = 0.0193199014236839003961246108920713523170235590882569686;
        weights[40] = 0.0142487564315764861085416017220041935720739931441623353;
        weights[41] = 0.00910399663740140331886860829589672381301797555982670408;
        weights[42] = 0.00391949025384412728296716519257643543366036457269087234;
        return;
    case 44:
        points[0] = -0.998540200636774224936056720606650349056030033175414598;
        points[1] = -0.992316392138515808483338003613538568811897784352210077;
        points[2] = -0.98115183307791396666274900535048782880567555553965774;
        points[3] = -0.965099650422493139394398050580234974716877138589885093;
        points[4] = -0.944239509118194099203254653026989251072454934759922975;
        points[5] = -0.918675259984175774323001086694252048937985263045053006;
        points[6] = -0.8885342382860432023383679101903223247583324582094259;
        points[7] = -0.85396659500471037872830224129268389036116906202906845;
        points[8] = -0.815144539645135010487437635751940550299400574508594244;
        points[9] = -0.77226147924875589901775854923198801372809643956544711;
        points[10] = -0.72553105366071700260696493671995361101246580020809526;
        points[11] = -0.675186070666122365333699038563899923328255401123770875;
        points[12] = -0.621477345903575847802424699121766747144405880017163559;
        points[13] = -0.564672453185470768424636819382075219490745479604266115;
        points[14] = -0.505054391388202317982798352291177238612073295505348613;
        points[15] = -0.442920174525411483834826593647313549538478460308117949;
        points[16] = -0.378579352014707132511764672772197856742820848495670373;
        points[17] = -0.312352466502785812236545163572978535519263621753288636;
        points[18] = -0.244569456928201251507302434740518620530487259280049604;
        points[19] = -0.175568014775516785746507749380976590647374506724513315;
        points[20] = -0.105691901708653247117305848915121752383385998859597614;
        points[21] = -0.0352892369641353590581967046314163558850021975895270768;
        points[22] = 0.0352892369641353590581967046314163558850021975895270768;
        points[23] = 0.105691901708653247117305848915121752383385998859597614;
        points[24] = 0.175568014775516785746507749380976590647374506724513315;
        points[25] = 0.244569456928201251507302434740518620530487259280049604;
        points[26] = 0.312352466502785812236545163572978535519263621753288636;
        points[27] = 0.378579352014707132511764672772197856742820848495670373;
        points[28] = 0.442920174525411483834826593647313549538478460308117949;
        points[29] = 0.505054391388202317982798352291177238612073295505348613;
        points[30] = 0.564672453185470768424636819382075219490745479604266115;
        points[31] = 0.621477345903575847802424699121766747144405880017163559;
        points[32] = 0.675186070666122365333699038563899923328255401123770875;
        points[33] = 0.72553105366071700260696493671995361101246580020809526;
        points[34] = 0.77226147924875589901775854923198801372809643956544711;
        points[35] = 0.815144539645135010487437635751940550299400574508594244;
        points[36] = 0.85396659500471037872830224129268389036116906202906845;
        points[37] = 0.8885342382860432023383679101903223247583324582094259;
        points[38] = 0.918675259984175774323001086694252048937985263045053006;
        points[39] = 0.944239509118194099203254653026989251072454934759922975;
        points[40] = 0.965099650422493139394398050580234974716877138589885093;
        points[41] = 0.98115183307791396666274900535048782880567555553965774;
        points[42] = 0.992316392138515808483338003613538568811897784352210077;
        points[43] = 0.998540200636774224936056720606650349056030033175414598;
        weights[0] = 0.00374540480311277751517377883176153847769791634328217317;
        weights[1] = 0.00870048136752484412256562342431314020846842115836189609;
        weights[2] = 0.0136195867555799855202050663900613788732667197548707233;
        weights[3] = 0.0184714817368147491720422237433998441155207383139018773;
        weights[4] = 0.0232314819020192106289582629387314174882219020356579972;
        weights[5] = 0.0278757828212810100811142917793870643220588398929903486;
        weights[6] = 0.0323812228120698208808469395401116011469480517800294205;
        weights[7] = 0.0367253478138088736429092923487017997107087879997468729;
        weights[8] = 0.040886512310346218908447169283068486854079289026702596;
        weights[9] = 0.0448439840819700314462431864030511071809630216557339997;
        weights[10] = 0.0485780464483520375276394366912927376150513991068246759;
        weights[11] = 0.0520700960917044618812318029931987510562641747411169266;
        weights[12] = 0.0553027355637280525487466326431529914715348464176177601;
        weights[13] = 0.0582598598775954953342106898442771680047561691033535674;
        weights[14] = 0.0609267367015619680385578368743741006725724894816501122;
        weights[15] = 0.0632900797332038549501388710197149306380242882440941854;
        weights[16] = 0.0653381148791814349842408948456221894960108011296769286;
        weights[17] = 0.067060638906293652395704919351719350780713013072761568;
        weights[18] = 0.0684490702693666609854586607043498724451555436359000409;
        weights[19] = 0.0694964918615725780370840909250112567820934753811742274;
        weights[20] = 0.0701976854735582125871420419443993876688266862156284579;
        weights[21] = 0.0705491577893540688113382874802998849910634255089236448;
        weights[22] = 0.0705491577893540688113382874802998849910634255089236448;
        weights[23] = 0.0701976854735582125871420419443993876688266862156284579;
        weights[24] = 0.0694964918615725780370840909250112567820934753811742274;
        weights[25] = 0.0684490702693666609854586607043498724451555436359000409;
        weights[26] = 0.067060638906293652395704919351719350780713013072761568;
        weights[27] = 0.0653381148791814349842408948456221894960108011296769286;
        weights[28] = 0.0632900797332038549501388710197149306380242882440941854;
        weights[29] = 0.0609267367015619680385578368743741006725724894816501122;
        weights[30] = 0.0582598598775954953342106898442771680047561691033535674;
        weights[31] = 0.0553027355637280525487466326431529914715348464176177601;
        weights[32] = 0.0520700960917044618812318029931987510562641747411169266;
        weights[33] = 0.0485780464483520375276394366912927376150513991068246759;
        weights[34] = 0.0448439840819700314462431864030511071809630216557339997;
        weights[35] = 0.040886512310346218908447169283068486854079289026702596;
        weights[36] = 0.0367253478138088736429092923487017997107087879997468729;
        weights[37] = 0.0323812228120698208808469395401116011469480517800294205;
        weights[38] = 0.0278757828212810100811142917793870643220588398929903486;
        weights[39] = 0.0232314819020192106289582629387314174882219020356579972;
        weights[40] = 0.0184714817368147491720422237433998441155207383139018773;
        weights[41] = 0.0136195867555799855202050663900613788732667197548707233;
        weights[42] = 0.00870048136752484412256562342431314020846842115836189609;
        weights[43] = 0.00374540480311277751517377883176153847769791634328217317;
        return;
    case 45:
        points[0] = -0.998603645181936638156547676900820548092288527214475417;
        points[1] = -0.992649998447203741748617120597735344975001643303639351;
        points[2] = -0.981968715034540568239318473634341481538365249220461808;
        points[3] = -0.966608310396894604736425160892478097116679030609415414;
        points[4] = -0.946641690995629061784720596953837078450468344167135051;
        points[5] = -0.922163936719000388097467360960527319265362877250661168;
        points[6] = -0.893291671753241738464649051493057346365401240413792686;
        points[7] = -0.860162475960664225339078870567134387783414423577022101;
        points[8] = -0.822934220502086337035775260026502029993415258056270434;
        points[9] = -0.781784312593906291312363188098602817660273516839061523;
        points[10] = -0.736908848945490352623738848594892019879605680837617081;
        points[11] = -0.688521680771200525232019825880438235955233005618527781;
        points[12] = -0.636853394453223359271223845903383150692031243465676441;
        points[13] = -0.582150212569353186680967334444177131000088825983227146;
        points[14] = -0.524672820462916067091134100460162402607108270800282587;
        points[15] = -0.464695123919635098579601502309748510839812667237190883;
        points[16] = -0.402502943858541914077974508548346455970299357569396439;
        points[17] = -0.338392654250602161643404100031872989532341443137422698;
        points[18] = -0.27266976975237756060876539161564518189821175427664206;
        points[19] = -0.205647489783263745719787225471543930703236385699429831;
        points[20] = -0.13764520598325302875659004142306555310676555654152506;
        points[21] = -0.0689869801631441724904146141038117296939206669309696827;
        points[22] = 0;
        points[23] = 0.0689869801631441724904146141038117296939206669309696827;
        points[24] = 0.13764520598325302875659004142306555310676555654152506;
        points[25] = 0.205647489783263745719787225471543930703236385699429831;
        points[26] = 0.27266976975237756060876539161564518189821175427664206;
        points[27] = 0.338392654250602161643404100031872989532341443137422698;
        points[28] = 0.402502943858541914077974508548346455970299357569396439;
        points[29] = 0.464695123919635098579601502309748510839812667237190883;
        points[30] = 0.524672820462916067091134100460162402607108270800282587;
        points[31] = 0.582150212569353186680967334444177131000088825983227146;
        points[32] = 0.636853394453223359271223845903383150692031243465676441;
        points[33] = 0.688521680771200525232019825880438235955233005618527781;
        points[34] = 0.736908848945490352623738848594892019879605680837617081;
        points[35] = 0.781784312593906291312363188098602817660273516839061523;
        points[36] = 0.822934220502086337035775260026502029993415258056270434;
        points[37] = 0.860162475960664225339078870567134387783414423577022101;
        points[38] = 0.893291671753241738464649051493057346365401240413792686;
        points[39] = 0.922163936719000388097467360960527319265362877250661168;
        points[40] = 0.946641690995629061784720596953837078450468344167135051;
        points[41] = 0.966608310396894604736425160892478097116679030609415414;
        points[42] = 0.981968715034540568239318473634341481538365249220461808;
        points[43] = 0.992649998447203741748617120597735344975001643303639351;
        points[44] = 0.998603645181936638156547676900820548092288527214475417;
        weights[0] = 0.00358266315528355893114302865935139257058563635818394461;
        weights[1] = 0.00832318929621824164573585312223385375615793129294822189;
        weights[2] = 0.0130311049915827843206310824696869260271411715826389911;
        weights[3] = 0.017677535257937590617092546669577088520651278126465788;
        weights[4] = 0.0222398475505787323939507585521689933448757087012999707;
        weights[5] = 0.0266962139675776648056747787931075277878249105658915236;
        weights[6] = 0.0310253749345154671625079388937680638859211521239748004;
        weights[7] = 0.0352066922016090162476997982615750908100880747127146413;
        weights[8] = 0.0392202367293024475641871853439293382181301245963066698;
        weights[9] = 0.0430468807091649711516911130811669417883192361631913202;
        weights[10] = 0.0466683877183733652677684757416541012049861414878535825;
        weights[11] = 0.0500674992379520297991321024748743173914986929351464372;
        weights[12] = 0.053228016731268951945904044019310403798482216940175516;
        weights[13] = 0.0561348787597864766439239403748697632414801849461630158;
        weights[14] = 0.0587742327188417385743615176318314225312657254609802081;
        weights[15] = 0.0611335008310665225018863705363255732601242342652421201;
        weights[16] = 0.063201440073819937749963730290666881866300237275822817;
        weights[17] = 0.0649681957507234308538265703590756950838497254875832731;
        weights[18] = 0.066425348449842528082914715639103737613174546750674816;
        weights[19] = 0.067565954163607536270910223873648630979472580923946462;
        weights[20] = 0.0683845773786696745316920993343160970734849130546449464;
        weights[21] = 0.0688773169776613228820028482980557888845241301106485452;
        weights[22] = 0.0690418248292320201107985551594047407233228922750047781;
        weights[23] = 0.0688773169776613228820028482980557888845241301106485452;
        weights[24] = 0.0683845773786696745316920993343160970734849130546449464;
        weights[25] = 0.067565954163607536270910223873648630979472580923946462;
        weights[26] = 0.066425348449842528082914715639103737613174546750674816;
        weights[27] = 0.0649681957507234308538265703590756950838497254875832731;
        weights[28] = 0.063201440073819937749963730290666881866300237275822817;
        weights[29] = 0.0611335008310665225018863705363255732601242342652421201;
        weights[30] = 0.0587742327188417385743615176318314225312657254609802081;
        weights[31] = 0.0561348787597864766439239403748697632414801849461630158;
        weights[32] = 0.053228016731268951945904044019310403798482216940175516;
        weights[33] = 0.0500674992379520297991321024748743173914986929351464372;
        weights[34] = 0.0466683877183733652677684757416541012049861414878535825;
        weights[35] = 0.0430468807091649711516911130811669417883192361631913202;
        weights[36] = 0.0392202367293024475641871853439293382181301245963066698;
        weights[37] = 0.0352066922016090162476997982615750908100880747127146413;
        weights[38] = 0.0310253749345154671625079388937680638859211521239748004;
        weights[39] = 0.0266962139675776648056747787931075277878249105658915236;
        weights[40] = 0.0222398475505787323939507585521689933448757087012999707;
        weights[41] = 0.017677535257937590617092546669577088520651278126465788;
        weights[42] = 0.0130311049915827843206310824696869260271411715826389911;
        weights[43] = 0.00832318929621824164573585312223385375615793129294822189;
        weights[44] = 0.00358266315528355893114302865935139257058563635818394461;
        return;
    case 46:
        points[0] = -0.998663042133817981128268417390888774584155607434631726;
        points[1] = -0.992962348906174364073095444666193409121102830908384025;
        points[2] = -0.982733669804166863477979579659188720219563370298428801;
        points[3] = -0.968021391853991942737748066371815508522311826353630101;
        points[4] = -0.948892363446089795622213539436914139525771383293245333;
        points[5] = -0.925433798806753950977491357699124258882343756438955848;
        points[6] = -0.89775271153394196570131995131978128945462964530135109;
        points[7] = -0.865975394866858062915888776816598438687304744337904484;
        points[8] = -0.830246837066066053032385304790806117995806253970380608;
        points[9] = -0.79073005707527425518914414742030241114796951308471111;
        points[10] = -0.747605359615666054000336505268002868905722180002546495;
        points[11] = -0.701069512020405697512122089426500450249575983149938646;
        points[12] = -0.651334846201997715106477155816859367227604057318475939;
        points[13] = -0.598628289712715153177172533600167310148466334564629948;
        points[14] = -0.543190330261802635270962691028876836033978470384916085;
        points[15] = -0.485273918388164662772320193708454808319667559283038704;
        points[16] = -0.425143313282828397322146863428567419169337769107934692;
        points[17] = -0.363072877020995710123706978514651689847388842857642471;
        points[18] = -0.299345822701870015483439256577903929356092317554238349;
        points[19] = -0.234252922206269768626056115573792492574088821990498026;
        points[20] = -0.168091179467103528606796737427702127447489281836469397;
        points[21] = -0.10116247530558423951585965700864939088187136050149374;
        points[22] = -0.0337721900160520415195578318914397638159161159962019207;
        points[23] = 0.0337721900160520415195578318914397638159161159962019207;
        points[24] = 0.10116247530558423951585965700864939088187136050149374;
        points[25] = 0.168091179467103528606796737427702127447489281836469397;
        points[26] = 0.234252922206269768626056115573792492574088821990498026;
        points[27] = 0.299345822701870015483439256577903929356092317554238349;
        points[28] = 0.363072877020995710123706978514651689847388842857642471;
        points[29] = 0.425143313282828397322146863428567419169337769107934692;
        points[30] = 0.485273918388164662772320193708454808319667559283038704;
        points[31] = 0.543190330261802635270962691028876836033978470384916085;
        points[32] = 0.598628289712715153177172533600167310148466334564629948;
        points[33] = 0.651334846201997715106477155816859367227604057318475939;
        points[34] = 0.701069512020405697512122089426500450249575983149938646;
        points[35] = 0.747605359615666054000336505268002868905722180002546495;
        points[36] = 0.79073005707527425518914414742030241114796951308471111;
        points[37] = 0.830246837066066053032385304790806117995806253970380608;
        points[38] = 0.865975394866858062915888776816598438687304744337904484;
        points[39] = 0.89775271153394196570131995131978128945462964530135109;
        points[40] = 0.925433798806753950977491357699124258882343756438955848;
        points[41] = 0.948892363446089795622213539436914139525771383293245333;
        points[42] = 0.968021391853991942737748066371815508522311826353630101;
        points[43] = 0.982733669804166863477979579659188720219563370298428801;
        points[44] = 0.992962348906174364073095444666193409121102830908384025;
        points[45] = 0.998663042133817981128268417390888774584155607434631726;
        weights[0] = 0.00343030086810704828601878314804340444117294580521133124;
        weights[1] = 0.00796989822972462245161303892632496542628877099259653938;
        weights[2] = 0.0124798837709886842067345717509833751775225473853508905;
        weights[3] = 0.0169335140078362380462307136717604313337264438256941511;
        weights[4] = 0.0213099987541365010544793610708784018288437765205240164;
        weights[5] = 0.025589286397130010634699512200344028102879560738616994;
        weights[6] = 0.0297518295522027557990517292357229370930287538189488675;
        weights[7] = 0.033778627999106896520603893881145328727799480475200311;
        weights[8] = 0.037651305357386071327660799228459117026955119454260672;
        weights[9] = 0.0413521901096787297042201758702314784242062241137726262;
        weights[10] = 0.0448643952773181267670946135627748564422867005184251784;
        weights[11] = 0.0481718951017122005304688632232209366819754923674621692;
        weights[12] = 0.0512595980071430213353652993714480334641815016265305325;
        weights[13] = 0.0541134153858567544916376432592230752598974690411350662;
        weights[14] = 0.0567203258439912358168744036032867145864270226091147547;
        weights[15] = 0.0590684345955463148075507226369077370982169484922302968;
        weights[16] = 0.0611470277246504810153566079041910377727816328578536076;
        weights[17] = 0.0629466210643945081789519522471109312332461650317862209;
        weights[18] = 0.0644590034671390695882794391082550639237956450450184925;
        weights[19] = 0.0656772742677812073787575656855557676217161397738117155;
        weights[20] = 0.0665958747684548873757619664227337019443637088009921093;
        weights[21] = 0.0672106136006781758623741548270975961765396811656452022;
        weights[22] = 0.0675186858490364588202141891643010802121482695398182551;
        weights[23] = 0.0675186858490364588202141891643010802121482695398182551;
        weights[24] = 0.0672106136006781758623741548270975961765396811656452022;
        weights[25] = 0.0665958747684548873757619664227337019443637088009921093;
        weights[26] = 0.0656772742677812073787575656855557676217161397738117155;
        weights[27] = 0.0644590034671390695882794391082550639237956450450184925;
        weights[28] = 0.0629466210643945081789519522471109312332461650317862209;
        weights[29] = 0.0611470277246504810153566079041910377727816328578536076;
        weights[30] = 0.0590684345955463148075507226369077370982169484922302968;
        weights[31] = 0.0567203258439912358168744036032867145864270226091147547;
        weights[32] = 0.0541134153858567544916376432592230752598974690411350662;
        weights[33] = 0.0512595980071430213353652993714480334641815016265305325;
        weights[34] = 0.0481718951017122005304688632232209366819754923674621692;
        weights[35] = 0.0448643952773181267670946135627748564422867005184251784;
        weights[36] = 0.0413521901096787297042201758702314784242062241137726262;
        weights[37] = 0.037651305357386071327660799228459117026955119454260672;
        weights[38] = 0.033778627999106896520603893881145328727799480475200311;
        weights[39] = 0.0297518295522027557990517292357229370930287538189488675;
        weights[40] = 0.025589286397130010634699512200344028102879560738616994;
        weights[41] = 0.0213099987541365010544793610708784018288437765205240164;
        weights[42] = 0.0169335140078362380462307136717604313337264438256941511;
        weights[43] = 0.0124798837709886842067345717509833751775225473853508905;
        weights[44] = 0.00796989822972462245161303892632496542628877099259653938;
        weights[45] = 0.00343030086810704828601878314804340444117294580521133124;
        return;
    case 47:
        points[0] = -0.998718728584212109183947714787108491627090651231490809;
        points[1] = -0.993255210987768634692189684632463608145712084110630735;
        points[2] = -0.983451003071623708764901034036169851931654219108093774;
        points[3] = -0.969346787326564497145744277560270805338302946979504136;
        points[4] = -0.951003969257708442589802923851442422653601515387379029;
        points[5] = -0.92850269301236064819718492461132098137541878694303399;
        points[6] = -0.90194132943852535686717130197743563963863448643228478;
        points[7] = -0.871436015796896316940985464555606171051926526115779609;
        points[8] = -0.837120139899902121277598948566352364181868949463442594;
        points[9] = -0.799143754167741942915562069203593012040520856198734943;
        points[10] = -0.757672918445438633573996523569682201213419910433653433;
        points[11] = -0.712888973409064301661879327771018811704250245755917143;
        points[12] = -0.664987747390332729136702648572089061430514814533270926;
        points[13] = -0.61417869995637360859546254260425368624817994509020475;
        points[14] = -0.560684005934664194483058317418268791143523454591137439;
        points[15] = -0.504737583863577919774289025351301090273203119224602529;
        points[16] = -0.446584073104855702725182142349407959393417005198721099;
        points[17] = -0.386477764084667139583302387606023270201837608014830015;
        points[18] = -0.324681486337735902210761299179996836399628916007062326;
        points[19] = -0.261465459214974570306982966205170974233322733796879725;
        points[20] = -0.197106110279111807961491358370504617554862870422339665;
        points[21] = -0.131884866554514897053823530724127241363335153438488913;
        points[22] = -0.0660869239163556751604737774741337085922762739362204089;
        points[23] = 0;
        points[24] = 0.0660869239163556751604737774741337085922762739362204089;
        points[25] = 0.131884866554514897053823530724127241363335153438488913;
        points[26] = 0.197106110279111807961491358370504617554862870422339665;
        points[27] = 0.261465459214974570306982966205170974233322733796879725;
        points[28] = 0.324681486337735902210761299179996836399628916007062326;
        points[29] = 0.386477764084667139583302387606023270201837608014830015;
        points[30] = 0.446584073104855702725182142349407959393417005198721099;
        points[31] = 0.504737583863577919774289025351301090273203119224602529;
        points[32] = 0.560684005934664194483058317418268791143523454591137439;
        points[33] = 0.61417869995637360859546254260425368624817994509020475;
        points[34] = 0.664987747390332729136702648572089061430514814533270926;
        points[35] = 0.712888973409064301661879327771018811704250245755917143;
        points[36] = 0.757672918445438633573996523569682201213419910433653433;
        points[37] = 0.799143754167741942915562069203593012040520856198734943;
        points[38] = 0.837120139899902121277598948566352364181868949463442594;
        points[39] = 0.871436015796896316940985464555606171051926526115779609;
        points[40] = 0.90194132943852535686717130197743563963863448643228478;
        points[41] = 0.92850269301236064819718492461132098137541878694303399;
        points[42] = 0.951003969257708442589802923851442422653601515387379029;
        points[43] = 0.969346787326564497145744277560270805338302946979504136;
        points[44] = 0.983451003071623708764901034036169851931654219108093774;
        points[45] = 0.993255210987768634692189684632463608145712084110630735;
        points[46] = 0.998718728584212109183947714787108491627090651231490809;
        weights[0] = 0.00328745384252801488324996420833617985136062240707094616;
        weights[1] = 0.00763861629584883361410435677113165550442058982256510536;
        weights[2] = 0.0119628484643123209639434548499485125233929083624680225;
        weights[3] = 0.0162353331464330596707256874078986210158929190439750067;
        weights[4] = 0.0204369381476684276420347606862553864272310490241569037;
        weights[5] = 0.0245492116596588185378341571525057671376631521648313099;
        weights[6] = 0.0285541507006433865047399246258110816068752178326918684;
        weights[7] = 0.0324342355151847567676174631741701586930886808732865899;
        weights[8] = 0.0361724965841749516134599297663112486734452822013805724;
        weights[9] = 0.0397525861225310037809013801419610165916494688156830593;
        weights[10] = 0.0431588486484795382683017934465031395477193777824471417;
        weights[11] = 0.0463763890865059112044018482427450925486960452628959105;
        weights[12] = 0.049391137747361169604570485862004923119994023790494317;
        weights[13] = 0.0521899117800571448722119417096760777217349799620321767;
        weights[14] = 0.054760472781530225957125176888504805903795366348507213;
        weights[15] = 0.0570915802932315402220166053083827729103294259652469968;
        weights[16] = 0.0591730409423388759761545563857412924638323514930740505;
        weights[17] = 0.0609957530087396453307105781334375211810932043020158768;
        weights[18] = 0.0625517462209216626405643814499535367534158434584604253;
        weights[19] = 0.0638342166057170306312937798558135334823363436906859726;
        weights[20] = 0.0648375562389457267026039391108060188849947526018283188;
        weights[21] = 0.0655573777665497402511430023260759122819998908087335979;
        weights[22] = 0.0659905335888104745335706553304982595773582776265029979;
        weights[23] = 0.0661351296236554796534403543310549711953604527179312406;
        weights[24] = 0.0659905335888104745335706553304982595773582776265029979;
        weights[25] = 0.0655573777665497402511430023260759122819998908087335979;
        weights[26] = 0.0648375562389457267026039391108060188849947526018283188;
        weights[27] = 0.0638342166057170306312937798558135334823363436906859726;
        weights[28] = 0.0625517462209216626405643814499535367534158434584604253;
        weights[29] = 0.0609957530087396453307105781334375211810932043020158768;
        weights[30] = 0.0591730409423388759761545563857412924638323514930740505;
        weights[31] = 0.0570915802932315402220166053083827729103294259652469968;
        weights[32] = 0.054760472781530225957125176888504805903795366348507213;
        weights[33] = 0.0521899117800571448722119417096760777217349799620321767;
        weights[34] = 0.049391137747361169604570485862004923119994023790494317;
        weights[35] = 0.0463763890865059112044018482427450925486960452628959105;
        weights[36] = 0.0431588486484795382683017934465031395477193777824471417;
        weights[37] = 0.0397525861225310037809013801419610165916494688156830593;
        weights[38] = 0.0361724965841749516134599297663112486734452822013805724;
        weights[39] = 0.0324342355151847567676174631741701586930886808732865899;
        weights[40] = 0.0285541507006433865047399246258110816068752178326918684;
        weights[41] = 0.0245492116596588185378341571525057671376631521648313099;
        weights[42] = 0.0204369381476684276420347606862553864272310490241569037;
        weights[43] = 0.0162353331464330596707256874078986210158929190439750067;
        weights[44] = 0.0119628484643123209639434548499485125233929083624680225;
        weights[45] = 0.00763861629584883361410435677113165550442058982256510536;
        weights[46] = 0.00328745384252801488324996420833617985136062240707094616;
        return;
    case 48:
        points[0] = -0.998771007252426118600541491563113640088937650276721039;
        points[1] = -0.99353017226635075754792875084907411835661474959467193;
        points[2] = -0.98412458372282685774458360002659883058923922341738473;
        points[3] = -0.970591592546247250461411983800660057302433911630883706;
        points[4] = -0.952987703160430860722960666025718343208541331823918737;
        points[5] = -0.93138669070655433311417438010160126771999708561895043;
        points[6] = -0.905879136715569672822074835671011788312262199827410845;
        points[7] = -0.876572020274247885905693554805096754561648533729961993;
        points[8] = -0.843588261624393530711089844519656049870887011737552402;
        points[9] = -0.807066204029442627082553043024538445973013029460415387;
        points[10] = -0.767159032515740339253855437522969053622642330848207372;
        points[11] = -0.724034130923814654674482233493665246585092812280722363;
        points[12] = -0.677872379632663905211851280675909058849954679026048613;
        points[13] = -0.628867396776513623995164933069994652024908999790161771;
        points[14] = -0.577224726083972703817809238540478772853997286140195528;
        points[15] = -0.523160974722233033678225869137508526289187621811884108;
        points[16] = -0.466902904750958404544928861650798509236812104258516944;
        points[17] = -0.408686481990716729916225495814633286459922842994888065;
        points[18] = -0.348755886292160738159817937270407916134309649968392576;
        points[19] = -0.287362487355455576735886461316797687851558305801039779;
        points[20] = -0.224763790394689061224865440174692277438561804041654806;
        points[21] = -0.161222356068891718056437390783497694774374379741895118;
        points[22] = -0.0970046992094626989300539558536245201527362293009369864;
        points[23] = -0.0323801709628693620333222431521344420459628023615180924;
        points[24] = 0.0323801709628693620333222431521344420459628023615180924;
        points[25] = 0.0970046992094626989300539558536245201527362293009369864;
        points[26] = 0.161222356068891718056437390783497694774374379741895118;
        points[27] = 0.224763790394689061224865440174692277438561804041654806;
        points[28] = 0.287362487355455576735886461316797687851558305801039779;
        points[29] = 0.348755886292160738159817937270407916134309649968392576;
        points[30] = 0.408686481990716729916225495814633286459922842994888065;
        points[31] = 0.466902904750958404544928861650798509236812104258516944;
        points[32] = 0.523160974722233033678225869137508526289187621811884108;
        points[33] = 0.577224726083972703817809238540478772853997286140195528;
        points[34] = 0.628867396776513623995164933069994652024908999790161771;
        points[35] = 0.677872379632663905211851280675909058849954679026048613;
        points[36] = 0.724034130923814654674482233493665246585092812280722363;
        points[37] = 0.767159032515740339253855437522969053622642330848207372;
        points[38] = 0.807066204029442627082553043024538445973013029460415387;
        points[39] = 0.843588261624393530711089844519656049870887011737552402;
        points[40] = 0.876572020274247885905693554805096754561648533729961993;
        points[41] = 0.905879136715569672822074835671011788312262199827410845;
        points[42] = 0.93138669070655433311417438010160126771999708561895043;
        points[43] = 0.952987703160430860722960666025718343208541331823918737;
        points[44] = 0.970591592546247250461411983800660057302433911630883706;
        points[45] = 0.98412458372282685774458360002659883058923922341738473;
        points[46] = 0.99353017226635075754792875084907411835661474959467193;
        points[47] = 0.998771007252426118600541491563113640088937650276721039;
        weights[0] = 0.0031533460523058386326773115438914875782839388316936223;
        weights[1] = 0.00732755390127626210238397962178655005870790255920135327;
        weights[2] = 0.0114772345792345394895926676090916280864205063087476407;
        weights[3] = 0.0155793157229438487281769558344603139763762689915524695;
        weights[4] = 0.0196161604573555278144607196522127096958130377341322392;
        weights[5] = 0.0235707608393243791405193013784492302217297385221885987;
        weights[6] = 0.027426509708356948200073836262505820451184155161650976;
        weights[7] = 0.0311672278327980889020657568463544194542853414835695355;
        weights[8] = 0.0347772225647704388925485859638024105972813969070680987;
        weights[9] = 0.0382413510658307063172172565237156178638239683549822889;
        weights[10] = 0.0415450829434647492140588223610647977534728260340380631;
        weights[11] = 0.0446745608566942804194485871258503949884627868625020084;
        weights[12] = 0.0476166584924904748259066234789298301579980667434496854;
        weights[13] = 0.0503590355538544749578076190878656060329940930259063307;
        weights[14] = 0.0528901894851936670955050562646989146617264856331091864;
        weights[15] = 0.0551995036999841628682034951916354390044509256075610005;
        weights[16] = 0.0572772921004032157051502346847005762415271230041120775;
        weights[17] = 0.0591148396983956357464748174335199106596556025570549986;
        weights[18] = 0.0607044391658938800529692320278204778852608642564777551;
        weights[19] = 0.0620394231598926639041977841375985183063833996650914616;
        weights[20] = 0.0631141922862540256571260227502333181274136433711007912;
        weights[21] = 0.0639242385846481866239062018255154089189740849826429999;
        weights[22] = 0.0644661644359500822065041936577050657256919244555303088;
        weights[23] = 0.06473769681268392250302493873659155355208191894663651;
        weights[24] = 0.06473769681268392250302493873659155355208191894663651;
        weights[25] = 0.0644661644359500822065041936577050657256919244555303088;
        weights[26] = 0.0639242385846481866239062018255154089189740849826429999;
        weights[27] = 0.0631141922862540256571260227502333181274136433711007912;
        weights[28] = 0.0620394231598926639041977841375985183063833996650914616;
        weights[29] = 0.0607044391658938800529692320278204778852608642564777551;
        weights[30] = 0.0591148396983956357464748174335199106596556025570549986;
        weights[31] = 0.0572772921004032157051502346847005762415271230041120775;
        weights[32] = 0.0551995036999841628682034951916354390044509256075610005;
        weights[33] = 0.0528901894851936670955050562646989146617264856331091864;
        weights[34] = 0.0503590355538544749578076190878656060329940930259063307;
        weights[35] = 0.0476166584924904748259066234789298301579980667434496854;
        weights[36] = 0.0446745608566942804194485871258503949884627868625020084;
        weights[37] = 0.0415450829434647492140588223610647977534728260340380631;
        weights[38] = 0.0382413510658307063172172565237156178638239683549822889;
        weights[39] = 0.0347772225647704388925485859638024105972813969070680987;
        weights[40] = 0.0311672278327980889020657568463544194542853414835695355;
        weights[41] = 0.027426509708356948200073836262505820451184155161650976;
        weights[42] = 0.0235707608393243791405193013784492302217297385221885987;
        weights[43] = 0.0196161604573555278144607196522127096958130377341322392;
        weights[44] = 0.0155793157229438487281769558344603139763762689915524695;
        weights[45] = 0.0114772345792345394895926676090916280864205063087476407;
        weights[46] = 0.00732755390127626210238397962178655005870790255920135327;
        weights[47] = 0.0031533460523058386326773115438914875782839388316936223;
        return;
    case 49:
        points[0] = -0.998820150606635379361831272704110655123680997864501964;
        points[1] = -0.993788661944167790760113859257953618841307394938650168;
        points[2] = -0.984757895914213004359298995368574710353307462145252953;
        points[3] = -0.971762200901555380139972421504774133497862547180905693;
        points[4] = -0.954853658674137233555243679668184419054694451900273792;
        points[5] = -0.934100294755810149058982460636544902460422952810191994;
        points[6] = -0.909585655828073285213019640355800071042771231116718039;
        points[7] = -0.88140844557300891003703153581700492615924003726239134;
        points[8] = -0.849682119844165701034881872242979333326604332464716249;
        points[9] = -0.814534427359855431539500787764777044494672135822753352;
        points[10] = -0.776106894345446635018142812248456071264450461829181865;
        points[11] = -0.734554254237402696213674212858524884652835453323701834;
        points[12] = -0.690043824425132113504751807274941927633505126189035751;
        points[13] = -0.642754832419237664056856948583900109540335472253277533;
        points[14] = -0.59287769410890071245586433679262853463300101531884759;
        points[15] = -0.540613246991726066558225467229435916924101346238365847;
        points[16] = -0.486171941452492042176976096058575062075115194334936605;
        points[17] = -0.42977299334157652465858414180742303306341789787807201;
        points[18] = -0.371643501262284888863734540946960527614744786733926977;
        points[19] = -0.31201753211974876220786067650641626509683340799438725;
        points[20] = -0.251135178612577273507155942824611274582984174573664251;
        points[21] = -0.189241592461813586485310173859986511179678877678819089;
        points[22] = -0.126585997269672051067985288575536190324487121066866714;
        points[23] = -0.0634206849826867860288348208784849731527868727788803875;
        points[24] = 0;
        points[25] = 0.0634206849826867860288348208784849731527868727788803875;
        points[26] = 0.126585997269672051067985288575536190324487121066866714;
        points[27] = 0.189241592461813586485310173859986511179678877678819089;
        points[28] = 0.251135178612577273507155942824611274582984174573664251;
        points[29] = 0.31201753211974876220786067650641626509683340799438725;
        points[30] = 0.371643501262284888863734540946960527614744786733926977;
        points[31] = 0.42977299334157652465858414180742303306341789787807201;
        points[32] = 0.486171941452492042176976096058575062075115194334936605;
        points[33] = 0.540613246991726066558225467229435916924101346238365847;
        points[34] = 0.59287769410890071245586433679262853463300101531884759;
        points[35] = 0.642754832419237664056856948583900109540335472253277533;
        points[36] = 0.690043824425132113504751807274941927633505126189035751;
        points[37] = 0.734554254237402696213674212858524884652835453323701834;
        points[38] = 0.776106894345446635018142812248456071264450461829181865;
        points[39] = 0.814534427359855431539500787764777044494672135822753352;
        points[40] = 0.849682119844165701034881872242979333326604332464716249;
        points[41] = 0.88140844557300891003703153581700492615924003726239134;
        points[42] = 0.909585655828073285213019640355800071042771231116718039;
        points[43] = 0.934100294755810149058982460636544902460422952810191994;
        points[44] = 0.954853658674137233555243679668184419054694451900273792;
        points[45] = 0.971762200901555380139972421504774133497862547180905693;
        points[46] = 0.984757895914213004359298995368574710353307462145252953;
        points[47] = 0.993788661944167790760113859257953618841307394938650168;
        points[48] = 0.998820150606635379361831272704110655123680997864501964;
        weights[0] = 0.00302727898892290507748069817582714097283004200383177339;
        weights[1] = 0.00703509959008645147345067831134841086286385703902733685;
        weights[2] = 0.011020551031593580497508288166833332752193560544957745;
        weights[3] = 0.0149621449356246510295843191202015040362810163727672786;
        weights[4] = 0.0188435958530894584444506533911073492677499020192522803;
        weights[5] = 0.022649201587446676498770964216042887326797499023264776;
        weights[6] = 0.0263636189270660169609457452397420476944609717657405082;
        weights[7] = 0.0299718846205838253506905580741472100620720359508768289;
        weights[8] = 0.0334594667916221743424871508916892018494798678602284556;
        weights[9] = 0.0368123209630006898194672366988822950013615524059829569;
        weights[10] = 0.0400169457663730213686050367431033214278646074650014685;
        weights[11] = 0.0430604369812595979883454840010384958067135812398217601;
        weights[12] = 0.0459305393555958535424996199721276710088243223546234087;
        weights[13] = 0.0486156958878282402776511972878685308813689286185930726;
        weights[14] = 0.0511050943301445906746228060493185613896124493297433889;
        weights[15] = 0.0533887107082589685279429337301762061655860694482272094;
        weights[16] = 0.0554573496748035886904315814826980672042515240737943838;
        weights[17] = 0.0573026815301874754851645923508165363505804388031196816;
        weights[18] = 0.0589172757600272660245276507424925162624961138594794598;
        weights[19] = 0.0602946309531520173031061168755415904977765089197254878;
        weights[20] = 0.0614292009791929362968266461403010749431900091920979337;
        weights[21] = 0.0623164173200572674010768252159497042241335362213208338;
        weights[22] = 0.0629527074651956994743995557828910063637254277695700414;
        weights[23] = 0.0633355092964917485908369274000905201479714165648258204;
        weights[24] = 0.0634632814047905977182534678795296349996295223082522192;
        weights[25] = 0.0633355092964917485908369274000905201479714165648258204;
        weights[26] = 0.0629527074651956994743995557828910063637254277695700414;
        weights[27] = 0.0623164173200572674010768252159497042241335362213208338;
        weights[28] = 0.0614292009791929362968266461403010749431900091920979337;
        weights[29] = 0.0602946309531520173031061168755415904977765089197254878;
        weights[30] = 0.0589172757600272660245276507424925162624961138594794598;
        weights[31] = 0.0573026815301874754851645923508165363505804388031196816;
        weights[32] = 0.0554573496748035886904315814826980672042515240737943838;
        weights[33] = 0.0533887107082589685279429337301762061655860694482272094;
        weights[34] = 0.0511050943301445906746228060493185613896124493297433889;
        weights[35] = 0.0486156958878282402776511972878685308813689286185930726;
        weights[36] = 0.0459305393555958535424996199721276710088243223546234087;
        weights[37] = 0.0430604369812595979883454840010384958067135812398217601;
        weights[38] = 0.0400169457663730213686050367431033214278646074650014685;
        weights[39] = 0.0368123209630006898194672366988822950013615524059829569;
        weights[40] = 0.0334594667916221743424871508916892018494798678602284556;
        weights[41] = 0.0299718846205838253506905580741472100620720359508768289;
        weights[42] = 0.0263636189270660169609457452397420476944609717657405082;
        weights[43] = 0.022649201587446676498770964216042887326797499023264776;
        weights[44] = 0.0188435958530894584444506533911073492677499020192522803;
        weights[45] = 0.0149621449356246510295843191202015040362810163727672786;
        weights[46] = 0.011020551031593580497508288166833332752193560544957745;
        weights[47] = 0.00703509959008645147345067831134841086286385703902733685;
        weights[48] = 0.00302727898892290507748069817582714097283004200383177339;
        return;
    case 50:
        points[0] = -0.998866404420071050185459444974218505996243512904078525;
        points[1] = -0.99403196943209071258510820042069472815747797106832359;
        points[2] = -0.985354084048005882309009625632489404015592630945405809;
        points[3] = -0.972864385106692073713344104606252053669173407049954202;
        points[4] = -0.956610955242807942997745644156622094051434124626046543;
        points[5] = -0.936656618944877933780874947272496602153731598095202922;
        points[6] = -0.91307855665579189308973564277165709478418819169778239;
        points[7] = -0.885967979523613048637540982466753634194290310755808362;
        points[8] = -0.855429769429946084611362643934757467654833039486905963;
        points[9] = -0.821582070859335948356254110873939537760741383343485749;
        points[10] = -0.784555832900399263905305196340991200847316272556444353;
        points[11] = -0.744494302226068538260536252682194242870187931329584579;
        points[12] = -0.701552468706822251089546257883655728149719228484695643;
        points[13] = -0.655896465685439360781624864003679819041410528382331827;
        points[14] = -0.607702927184950239180381796391832893604205020675994356;
        points[15] = -0.557158304514650054315522909625801607815898382237750261;
        points[16] = -0.504458144907464201651459131849141192635378678270679238;
        points[17] = -0.449806334974038789147131467778375817315064513465173666;
        points[18] = -0.393414311897565127394229253823817270246139468672656003;
        points[19] = -0.335500245419437356836988257291071697841218593036795762;
        points[20] = -0.276288193779531990327645278521130185714801587131996151;
        points[21] = -0.216007236876041756847284532617101333705755972510133273;
        points[22] = -0.154890589998145902071628620941109501201850220054937632;
        points[23] = -0.0931747015600861408544503776396003478856713839221386147;
        points[24] = -0.031098338327188876112328989665949194247296222959998043;
        points[25] = 0.031098338327188876112328989665949194247296222959998043;
        points[26] = 0.0931747015600861408544503776396003478856713839221386147;
        points[27] = 0.154890589998145902071628620941109501201850220054937632;
        points[28] = 0.216007236876041756847284532617101333705755972510133273;
        points[29] = 0.276288193779531990327645278521130185714801587131996151;
        points[30] = 0.335500245419437356836988257291071697841218593036795762;
        points[31] = 0.393414311897565127394229253823817270246139468672656003;
        points[32] = 0.449806334974038789147131467778375817315064513465173666;
        points[33] = 0.504458144907464201651459131849141192635378678270679238;
        points[34] = 0.557158304514650054315522909625801607815898382237750261;
        points[35] = 0.607702927184950239180381796391832893604205020675994356;
        points[36] = 0.655896465685439360781624864003679819041410528382331827;
        points[37] = 0.701552468706822251089546257883655728149719228484695643;
        points[38] = 0.744494302226068538260536252682194242870187931329584579;
        points[39] = 0.784555832900399263905305196340991200847316272556444353;
        points[40] = 0.821582070859335948356254110873939537760741383343485749;
        points[41] = 0.855429769429946084611362643934757467654833039486905963;
        points[42] = 0.885967979523613048637540982466753634194290310755808362;
        points[43] = 0.91307855665579189308973564277165709478418819169778239;
        points[44] = 0.936656618944877933780874947272496602153731598095202922;
        points[45] = 0.956610955242807942997745644156622094051434124626046543;
        points[46] = 0.972864385106692073713344104606252053669173407049954202;
        points[47] = 0.985354084048005882309009625632489404015592630945405809;
        points[48] = 0.99403196943209071258510820042069472815747797106832359;
        points[49] = 0.998866404420071050185459444974218505996243512904078525;
        weights[0] = 0.00290862255315514095840072434285548080667299645994632062;
        weights[1] = 0.00675979919574540150277887817798503180187383240646681055;
        weights[2] = 0.0105905483836509692635696814992410223394018190864591295;
        weights[3] = 0.0143808227614855744193789089273243499370317861705878928;
        weights[4] = 0.0181155607134893903512599434223546198446673170497340354;
        weights[5] = 0.021780243170124792981592069062690341227313462357934296;
        weights[6] = 0.0253606735700123904401948783854427234601612599757121373;
        weights[7] = 0.0288429935805351980299063731132324325178468655935374578;
        weights[8] = 0.0322137282235780166481658273230039534485890588334252172;
        weights[9] = 0.0354598356151461541607346110009757970969600004969844709;
        weights[10] = 0.0385687566125876752447701502363859348647717050005189265;
        weights[11] = 0.0415284630901476974224119789640670178089779754858409901;
        weights[12] = 0.0443275043388032754920222868303941974607612983554531657;
        weights[13] = 0.04695505130394843296563301363498768251406430618605273;
        weights[14] = 0.0494009384494663149212435807514327286922870509666131248;
        weights[15] = 0.0516557030695811384899052958400952796498254493954396451;
        weights[16] = 0.053710621888996246523458797255664552768023213529922153;
        weights[17] = 0.0555577448062125176235674256122694975951352999839026758;
        weights[18] = 0.0571899256477283837230293150659931630115753722570917549;
        weights[19] = 0.0586008498132224458351224366308484662097675134440254733;
        weights[20] = 0.0597850587042654575095764053125852307966660420726690046;
        weights[21] = 0.0607379708417702160317500153848110016097992732354035357;
        weights[22] = 0.0614558995903166637564067860839153750972675757640075143;
        weights[23] = 0.0619360674206832433840875097808306885728770566912449049;
        weights[24] = 0.0621766166553472623210331073606134308676824692010266331;
        weights[25] = 0.0621766166553472623210331073606134308676824692010266331;
        weights[26] = 0.0619360674206832433840875097808306885728770566912449049;
        weights[27] = 0.0614558995903166637564067860839153750972675757640075143;
        weights[28] = 0.0607379708417702160317500153848110016097992732354035357;
        weights[29] = 0.0597850587042654575095764053125852307966660420726690046;
        weights[30] = 0.0586008498132224458351224366308484662097675134440254733;
        weights[31] = 0.0571899256477283837230293150659931630115753722570917549;
        weights[32] = 0.0555577448062125176235674256122694975951352999839026758;
        weights[33] = 0.053710621888996246523458797255664552768023213529922153;
        weights[34] = 0.0516557030695811384899052958400952796498254493954396451;
        weights[35] = 0.0494009384494663149212435807514327286922870509666131248;
        weights[36] = 0.04695505130394843296563301363498768251406430618605273;
        weights[37] = 0.0443275043388032754920222868303941974607612983554531657;
        weights[38] = 0.0415284630901476974224119789640670178089779754858409901;
        weights[39] = 0.0385687566125876752447701502363859348647717050005189265;
        weights[40] = 0.0354598356151461541607346110009757970969600004969844709;
        weights[41] = 0.0322137282235780166481658273230039534485890588334252172;
        weights[42] = 0.0288429935805351980299063731132324325178468655935374578;
        weights[43] = 0.0253606735700123904401948783854427234601612599757121373;
        weights[44] = 0.021780243170124792981592069062690341227313462357934296;
        weights[45] = 0.0181155607134893903512599434223546198446673170497340354;
        weights[46] = 0.0143808227614855744193789089273243499370317861705878928;
        weights[47] = 0.0105905483836509692635696814992410223394018190864591295;
        weights[48] = 0.00675979919574540150277887817798503180187383240646681055;
        weights[49] = 0.00290862255315514095840072434285548080667299645994632062;
        return;
    case 51:
        points[0] = -0.99890999084890349516899587727338563708424992188818879;
        points[1] = -0.994261260436752574621084897949263128231784390279014997;
        points[2] = -0.985915991735902996583885707558309632652115778087196917;
        points[3] = -0.973903368019323867231755486394186639013106506315712867;
        points[4] = -0.958267848613908194557707038316323727612444018555868847;
        points[5] = -0.939067544002962383435367806390905144165163822150168441;
        points[6] = -0.916373862309780230823571294251475879366042671731375653;
        points[7] = -0.890271218029527303277795370736726893557799798870588831;
        points[8] = -0.860856711182292371473495743716111323577344925510962628;
        points[9] = -0.82823976382306483285481842401656236426238778158632526;
        points[10] = -0.792541712099381205234410878375875730157322463748367714;
        points[11] = -0.753895354485375525763960025452473987630637363814676515;
        points[12] = -0.712444457577036644580524855400145643036944790217248147;
        points[13] = -0.668343221175370086864460419403988875929608511773375996;
        points[14] = -0.621755704600723273755042745403315950054387566870162836;
        points[15] = -0.572855216351303836522394702590190907420943120723799457;
        points[16] = -0.521823669366185842514087784826818024569350245869358049;
        points[17] = -0.46885090428604106361045725881162246880672263543008758;
        points[18] = -0.414133983226303877936871809744657907923977170469394563;
        points[19] = -0.357876456688409509775201088519666356896383922095968334;
        points[20] = -0.300287606335331939530245649644420333331338380513049916;
        points[21] = -0.241581666447798703846733114869262423738793246472413578;
        points[22] = -0.181977026957077545323998701169214449923920116534003313;
        points[23] = -0.121695421018888766963820420963181108745303287484469844;
        points[24] = -0.0609611001505787247341947068432054046970304642695197844;
        points[25] = 0;
        points[26] = 0.0609611001505787247341947068432054046970304642695197844;
        points[27] = 0.121695421018888766963820420963181108745303287484469844;
        points[28] = 0.181977026957077545323998701169214449923920116534003313;
        points[29] = 0.241581666447798703846733114869262423738793246472413578;
        points[30] = 0.300287606335331939530245649644420333331338380513049916;
        points[31] = 0.357876456688409509775201088519666356896383922095968334;
        points[32] = 0.414133983226303877936871809744657907923977170469394563;
        points[33] = 0.46885090428604106361045725881162246880672263543008758;
        points[34] = 0.521823669366185842514087784826818024569350245869358049;
        points[35] = 0.572855216351303836522394702590190907420943120723799457;
        points[36] = 0.621755704600723273755042745403315950054387566870162836;
        points[37] = 0.668343221175370086864460419403988875929608511773375996;
        points[38] = 0.712444457577036644580524855400145643036944790217248147;
        points[39] = 0.753895354485375525763960025452473987630637363814676515;
        points[40] = 0.792541712099381205234410878375875730157322463748367714;
        points[41] = 0.82823976382306483285481842401656236426238778158632526;
        points[42] = 0.860856711182292371473495743716111323577344925510962628;
        points[43] = 0.890271218029527303277795370736726893557799798870588831;
        points[44] = 0.916373862309780230823571294251475879366042671731375653;
        points[45] = 0.939067544002962383435367806390905144165163822150168441;
        points[46] = 0.958267848613908194557707038316323727612444018555868847;
        points[47] = 0.973903368019323867231755486394186639013106506315712867;
        points[48] = 0.985915991735902996583885707558309632652115778087196917;
        points[49] = 0.994261260436752574621084897949263128231784390279014997;
        points[50] = 0.99890999084890349516899587727338563708424992188818879;
        weights[0] = 0.00279680717108989557554421688180904822421769963401154217;
        weights[1] = 0.00650033778325260029210937519853752883309494300542583879;
        weights[2] = 0.0101851912978217299392375917866067283858116360842121004;
        weights[3] = 0.0138326340064778222966884530218564159560185520765720385;
        weights[4] = 0.0174287147234010522595036464332924355683567782936189403;
        weights[5] = 0.0209599884017032105797926184015141720730404851884300961;
        weights[6] = 0.0244133005737814342731415654168982087436831704720281841;
        weights[7] = 0.0277757985941624771959956656322089163683512486485378396;
        weights[8] = 0.0310349712901600084544255029565473772961089781662175129;
        weights[9] = 0.0341786932041883362362093385947675290488258635830977047;
        weights[10] = 0.03719526892326029284290827581187102513411271037373731;
        weights[11] = 0.0400734762854964531868091159213959112011643310287352421;
        weights[12] = 0.0428026079978800866536095142442857008371752740218520776;
        weights[13] = 0.0453725114076500687481668149884378513138299567195096436;
        weights[14] = 0.0477736262406231019999953537073536173405392804756578877;
        weights[15] = 0.0499970201500574097795488553620057855687367493859867075;
        weights[16] = 0.052034421936697087564136447468662373215483974714382203;
        weights[17] = 0.0538782523130455614340993016969719837600599677404453317;
        weights[18] = 0.0555216520957386930167370590936241607808637054155963884;
        weights[19] = 0.0569585077202586621000777267342771648784094503250927945;
        weights[20] = 0.0581834739825921405984378776617759326678012576445445826;
        weights[21] = 0.0591919939229615437835390077491546088709300460360711795;
        weights[22] = 0.0599803157775032520900639879965171161730620955454330036;
        weights[23] = 0.0605455069347377951381252514677541627536849343772409734;
        weights[24] = 0.0608854648448563438811986142226962197280760102802736524;
        weights[25] = 0.0609989248412058801597976430983560505571218015265784498;
        weights[26] = 0.0608854648448563438811986142226962197280760102802736524;
        weights[27] = 0.0605455069347377951381252514677541627536849343772409734;
        weights[28] = 0.0599803157775032520900639879965171161730620955454330036;
        weights[29] = 0.0591919939229615437835390077491546088709300460360711795;
        weights[30] = 0.0581834739825921405984378776617759326678012576445445826;
        weights[31] = 0.0569585077202586621000777267342771648784094503250927945;
        weights[32] = 0.0555216520957386930167370590936241607808637054155963884;
        weights[33] = 0.0538782523130455614340993016969719837600599677404453317;
        weights[34] = 0.052034421936697087564136447468662373215483974714382203;
        weights[35] = 0.0499970201500574097795488553620057855687367493859867075;
        weights[36] = 0.0477736262406231019999953537073536173405392804756578877;
        weights[37] = 0.0453725114076500687481668149884378513138299567195096436;
        weights[38] = 0.0428026079978800866536095142442857008371752740218520776;
        weights[39] = 0.0400734762854964531868091159213959112011643310287352421;
        weights[40] = 0.03719526892326029284290827581187102513411271037373731;
        weights[41] = 0.0341786932041883362362093385947675290488258635830977047;
        weights[42] = 0.0310349712901600084544255029565473772961089781662175129;
        weights[43] = 0.0277757985941624771959956656322089163683512486485378396;
        weights[44] = 0.0244133005737814342731415654168982087436831704720281841;
        weights[45] = 0.0209599884017032105797926184015141720730404851884300961;
        weights[46] = 0.0174287147234010522595036464332924355683567782936189403;
        weights[47] = 0.0138326340064778222966884530218564159560185520765720385;
        weights[48] = 0.0101851912978217299392375917866067283858116360842121004;
        weights[49] = 0.00650033778325260029210937519853752883309494300542583879;
        weights[50] = 0.00279680717108989557554421688180904822421769963401154217;
        return;
    case 52:
        points[0] = -0.998951111103950278090961440716592561278013261115357562;
        points[1] = -0.994477590929216029245043271799571706631911776097882171;
        points[2] = -0.986446195651549840645322859118397368022739035827326233;
        points[3] = -0.974883884221744503140706470399645554459923663945938398;
        points[4] = -0.959831826933086552532025153425065442787847476037677415;
        points[5] = -0.9413438536413590568435791838505670058287655454363192;
        points[6] = -0.919486128916424539893596376541881585029520272702472057;
        points[7] = -0.894336890534495322520844088263527555345580995562376493;
        points[8] = -0.865986162846067585244358517624206940898338952624290824;
        points[9] = -0.834535432326734534961726389621238685245936312669226053;
        points[10] = -0.800097283430468324334758754225807651197641858607701581;
        points[11] = -0.762794995193744960279211163089050840791830574507621547;
        points[12] = -0.72276209974998319367681667607193595478399390521472002;
        points[13] = -0.680141904227167702092238779736641007900996710165775916;
        points[14] = -0.635086977695245924298124579288809653593598988954989663;
        points[15] = -0.58775860497957906990202578155720422388122016653804349;
        points[16] = -0.538326209285827438375951167975356763823490141403080973;
        points[17] = -0.486966745698096077782458241346465556850455039719023688;
        points[18] = -0.433864067718761670309086568209780260743745852418403386;
        points[19] = -0.379208269116093669246681766939448880462121591351196609;
        points[20] = -0.323195003434807825501099066601447179054047533806579458;
        points[21] = -0.266024783605001827472971730598839884455924374962184668;
        points[22] = -0.207902264156366059686466128122345518272662810828204647;
        points[23] = -0.149035508606949180488634040018113570322269761888233532;
        points[24] = -0.0896352446489005654888546911223993031698512871901984205;
        points[25] = -0.0299141097973387660436807760707999268188436082499469816;
        points[26] = 0.0299141097973387660436807760707999268188436082499469816;
        points[27] = 0.0896352446489005654888546911223993031698512871901984205;
        points[28] = 0.149035508606949180488634040018113570322269761888233532;
        points[29] = 0.207902264156366059686466128122345518272662810828204647;
        points[30] = 0.266024783605001827472971730598839884455924374962184668;
        points[31] = 0.323195003434807825501099066601447179054047533806579458;
        points[32] = 0.379208269116093669246681766939448880462121591351196609;
        points[33] = 0.433864067718761670309086568209780260743745852418403386;
        points[34] = 0.486966745698096077782458241346465556850455039719023688;
        points[35] = 0.538326209285827438375951167975356763823490141403080973;
        points[36] = 0.58775860497957906990202578155720422388122016653804349;
        points[37] = 0.635086977695245924298124579288809653593598988954989663;
        points[38] = 0.680141904227167702092238779736641007900996710165775916;
        points[39] = 0.72276209974998319367681667607193595478399390521472002;
        points[40] = 0.762794995193744960279211163089050840791830574507621547;
        points[41] = 0.800097283430468324334758754225807651197641858607701581;
        points[42] = 0.834535432326734534961726389621238685245936312669226053;
        points[43] = 0.865986162846067585244358517624206940898338952624290824;
        points[44] = 0.894336890534495322520844088263527555345580995562376493;
        points[45] = 0.919486128916424539893596376541881585029520272702472057;
        points[46] = 0.9413438536413590568435791838505670058287655454363192;
        points[47] = 0.959831826933086552532025153425065442787847476037677415;
        points[48] = 0.974883884221744503140706470399645554459923663945938398;
        points[49] = 0.986446195651549840645322859118397368022739035827326233;
        points[50] = 0.994477590929216029245043271799571706631911776097882171;
        points[51] = 0.998951111103950278090961440716592561278013261115357562;
        weights[0] = 0.00269131695004711111895217986884521802366937376106490042;
        weights[1] = 0.00625552396297327689971610216981454661641170465313125936;
        weights[2] = 0.00980263457946275206195116811668950232783841185727930527;
        weights[3] = 0.0133151149823409606566003444777991485546764997333043912;
        weights[4] = 0.016780023396300735677921536870520162083415809163818516;
        weights[5] = 0.0201848915079807922029890342094782372367124670848078202;
        weights[6] = 0.0235175135539844615903225199100546094292291290029855012;
        weights[7] = 0.0267659537465040134494930802860183788552618844990582873;
        weights[8] = 0.0299185811471439466412820687399708879321233155105875175;
        weights[9] = 0.0329641090897187979150100447786951961767273925745843488;
        weights[10] = 0.0358916348350972329419423932852807387853385030651726363;
        weights[11] = 0.0386906783104239789851012067403526469280782659935645861;
        weights[12] = 0.0413512195005602716790402864239551629382699693154642277;
        weights[13] = 0.043863734259000407995129665578764450164160666530204816;
        weights[14] = 0.0462192283727847935076457053352846392239010216264228405;
        weights[15] = 0.0484092697440748968539602492860462780097495217284633973;
        weights[16] = 0.050426018566342377218211254082858754462577958765539797;
        weights[17] = 0.0522622553839069930343941444263921437081990780858669849;
        weights[18] = 0.0539114069327572647508368248937999595766012469593051259;
        weights[19] = 0.0553675696693026525490410934512185822901540032510420234;
        weights[20] = 0.0566255309023685971908082404783701505672200728147146762;
        weights[21] = 0.0576807874525268276539319976634035195394398350513375845;
        weights[22] = 0.0585295617718138685502905989716236936380687327423255988;
        weights[23] = 0.0591688154660429703693320023948709783254170522175978798;
        weights[24] = 0.0595962601712481582583108787484149536622772803819419155;
        weights[25] = 0.0598103657452918602477853788114774609444808036304140629;
        weights[26] = 0.0598103657452918602477853788114774609444808036304140629;
        weights[27] = 0.0595962601712481582583108787484149536622772803819419155;
        weights[28] = 0.0591688154660429703693320023948709783254170522175978798;
        weights[29] = 0.0585295617718138685502905989716236936380687327423255988;
        weights[30] = 0.0576807874525268276539319976634035195394398350513375845;
        weights[31] = 0.0566255309023685971908082404783701505672200728147146762;
        weights[32] = 0.0553675696693026525490410934512185822901540032510420234;
        weights[33] = 0.0539114069327572647508368248937999595766012469593051259;
        weights[34] = 0.0522622553839069930343941444263921437081990780858669849;
        weights[35] = 0.050426018566342377218211254082858754462577958765539797;
        weights[36] = 0.0484092697440748968539602492860462780097495217284633973;
        weights[37] = 0.0462192283727847935076457053352846392239010216264228405;
        weights[38] = 0.043863734259000407995129665578764450164160666530204816;
        weights[39] = 0.0413512195005602716790402864239551629382699693154642277;
        weights[40] = 0.0386906783104239789851012067403526469280782659935645861;
        weights[41] = 0.0358916348350972329419423932852807387853385030651726363;
        weights[42] = 0.0329641090897187979150100447786951961767273925745843488;
        weights[43] = 0.0299185811471439466412820687399708879321233155105875175;
        weights[44] = 0.0267659537465040134494930802860183788552618844990582873;
        weights[45] = 0.0235175135539844615903225199100546094292291290029855012;
        weights[46] = 0.0201848915079807922029890342094782372367124670848078202;
        weights[47] = 0.016780023396300735677921536870520162083415809163818516;
        weights[48] = 0.0133151149823409606566003444777991485546764997333043912;
        weights[49] = 0.00980263457946275206195116811668950232783841185727930527;
        weights[50] = 0.00625552396297327689971610216981454661641170465313125936;
        weights[51] = 0.00269131695004711111895217986884521802366937376106490042;
        return;
    case 53:
        points[0] = -0.998989947776328227121054267032199522587309515651732544;
        points[1] = -0.994681919308007078636035893483993904182826594387975161;
        points[2] = -0.986947035023371521720373081310578188412199510179296258;
        points[3] = -0.975810233714984581632983858106362093512798003573911897;
        points[4] = -0.961309694623136332369858193682639747050422671972138;
        points[5] = -0.943495353464441879021070667696192775681857500148015665;
        points[6] = -0.922428603042812128267819100082516551349942542412314707;
        points[7] = -0.898182057875426625925520029973081195567045739001750682;
        points[8] = -0.870839297558241351601700086888594089821280167981174041;
        points[9] = -0.840494576545801375430127509829946796899962493735098169;
        points[10] = -0.807252498416895478220485638025907210177632560655530226;
        points[11] = -0.771227654925532307866035875626039741261354413619946772;
        points[12] = -0.73254423080751025378213558672175023156563327376066931;
        points[13] = -0.691335575601366723540748823138944565415495376404183951;
        points[14] = -0.647743743916510068751106189938633421813560044836402242;
        points[15] = -0.601919005713769327464294371964623613092953365731746375;
        points[16] = -0.554019328277067881014734990810049287255760837824321594;
        points[17] = -0.504209831657133437039116972887958033395462227703774726;
        points[18] = -0.452662219461845791383144760753315883620479588499372561;
        points[19] = -0.399554186953952977392563136238397571894511656706946257;
        points[20] = -0.345068808495722356694310646069500914856093345832935451;
        points[21] = -0.289393906451626206426547006594012767796057401466450231;
        points[22] = -0.232721403724272593643363642199916218526209311521638329;
        points[23] = -0.175246662155325750729791009132895245828916149942189115;
        points[24] = -0.117167809071955150140256808779323767923321052344431879;
        points[25] = -0.0586850543002594650227119458332315377355912839026442383;
        points[26] = 0;
        points[27] = 0.0586850543002594650227119458332315377355912839026442383;
        points[28] = 0.117167809071955150140256808779323767923321052344431879;
        points[29] = 0.175246662155325750729791009132895245828916149942189115;
        points[30] = 0.232721403724272593643363642199916218526209311521638329;
        points[31] = 0.289393906451626206426547006594012767796057401466450231;
        points[32] = 0.345068808495722356694310646069500914856093345832935451;
        points[33] = 0.399554186953952977392563136238397571894511656706946257;
        points[34] = 0.452662219461845791383144760753315883620479588499372561;
        points[35] = 0.504209831657133437039116972887958033395462227703774726;
        points[36] = 0.554019328277067881014734990810049287255760837824321594;
        points[37] = 0.601919005713769327464294371964623613092953365731746375;
        points[38] = 0.647743743916510068751106189938633421813560044836402242;
        points[39] = 0.691335575601366723540748823138944565415495376404183951;
        points[40] = 0.73254423080751025378213558672175023156563327376066931;
        points[41] = 0.771227654925532307866035875626039741261354413619946772;
        points[42] = 0.807252498416895478220485638025907210177632560655530226;
        points[43] = 0.840494576545801375430127509829946796899962493735098169;
        points[44] = 0.870839297558241351601700086888594089821280167981174041;
        points[45] = 0.898182057875426625925520029973081195567045739001750682;
        points[46] = 0.922428603042812128267819100082516551349942542412314707;
        points[47] = 0.943495353464441879021070667696192775681857500148015665;
        points[48] = 0.961309694623136332369858193682639747050422671972138;
        points[49] = 0.975810233714984581632983858106362093512798003573911897;
        points[50] = 0.986947035023371521720373081310578188412199510179296258;
        points[51] = 0.994681919308007078636035893483993904182826594387975161;
        points[52] = 0.998989947776328227121054267032199522587309515651732544;
        weights[0] = 0.00259168372056703181159923943851093098476299769302276968;
        weights[1] = 0.00602427622694867328124170681629985910095415207448441756;
        weights[2] = 0.00944120228494034438666217882032514328370781491404681093;
        weights[3] = 0.0128260261442403791791501829692037317681640087345531042;
        weights[4] = 0.0161667252566874639280608284040399014377347313970191805;
        weights[5] = 0.0194517211076368953880469222274969404194473647164936671;
        weights[6] = 0.0226696730570702083987892752398278094682488078051167845;
        weights[7] = 0.0258094825107575177139618881666294409037504184422655036;
        weights[8] = 0.0288603236178237362627995530435832618626692062898485273;
        weights[9] = 0.0318116784590193230632358620310809202606800700870432844;
        weights[10] = 0.034653372583534237958387720513010713571317935430580936;
        weights[11] = 0.0373756098034829156741719727853942222098480943725185586;
        weights[12] = 0.0399690058435403821270935457878636259190084633749648655;
        weights[13] = 0.0424246206345200135922816375684503988065642079754230073;
        weights[14] = 0.0447339891036728102127656459185636061376018837171479008;
        weights[15] = 0.0468891503407503140218726395651049478658255358333036262;
        weights[16] = 0.0488826750326991404204484075835840834065845146462682929;
        weights[17] = 0.0507076910692927152964854826345305375999903733365938147;
        weights[18] = 0.0523579072298727181997015209893607044544197086972156836;
        weights[19] = 0.0538276348687310290420814416354026743128101996789120203;
        weights[20] = 0.0551118075239335990023497047658673875514124884898266221;
        weights[21] = 0.0562059983817397098086550620914449937514572251748036418;
        weights[22] = 0.0571064355362671917733833392984188413388344954246130617;
        weights[23] = 0.057810014991713196319683076097252062860029011238475865;
        weights[24] = 0.0583143113622560075562757563376972560520799512442547357;
        weights[25] = 0.0586175862327202633180719370499889415345994806622769869;
        weights[26] = 0.0587187941511643645254869444421341262749937170978526623;
        weights[27] = 0.0586175862327202633180719370499889415345994806622769869;
        weights[28] = 0.0583143113622560075562757563376972560520799512442547357;
        weights[29] = 0.057810014991713196319683076097252062860029011238475865;
        weights[30] = 0.0571064355362671917733833392984188413388344954246130617;
        weights[31] = 0.0562059983817397098086550620914449937514572251748036418;
        weights[32] = 0.0551118075239335990023497047658673875514124884898266221;
        weights[33] = 0.0538276348687310290420814416354026743128101996789120203;
        weights[34] = 0.0523579072298727181997015209893607044544197086972156836;
        weights[35] = 0.0507076910692927152964854826345305375999903733365938147;
        weights[36] = 0.0488826750326991404204484075835840834065845146462682929;
        weights[37] = 0.0468891503407503140218726395651049478658255358333036262;
        weights[38] = 0.0447339891036728102127656459185636061376018837171479008;
        weights[39] = 0.0424246206345200135922816375684503988065642079754230073;
        weights[40] = 0.0399690058435403821270935457878636259190084633749648655;
        weights[41] = 0.0373756098034829156741719727853942222098480943725185586;
        weights[42] = 0.034653372583534237958387720513010713571317935430580936;
        weights[43] = 0.0318116784590193230632358620310809202606800700870432844;
        weights[44] = 0.0288603236178237362627995530435832618626692062898485273;
        weights[45] = 0.0258094825107575177139618881666294409037504184422655036;
        weights[46] = 0.0226696730570702083987892752398278094682488078051167845;
        weights[47] = 0.0194517211076368953880469222274969404194473647164936671;
        weights[48] = 0.0161667252566874639280608284040399014377347313970191805;
        weights[49] = 0.0128260261442403791791501829692037317681640087345531042;
        weights[50] = 0.00944120228494034438666217882032514328370781491404681093;
        weights[51] = 0.00602427622694867328124170681629985910095415207448441756;
        weights[52] = 0.00259168372056703181159923943851093098476299769302276968;
        return;
    case 54:
        points[0] = -0.999026666867340983851071106983958493198042785796960332;
        points[1] = -0.994875117018338884918889995948702659484126758886999829;
        points[2] = -0.987420637397343558552145720403546261534036290839238588;
        points[3] = -0.976686328857903237200010071988306857467805973240003412;
        points[4] = -0.96270764578592358325699392690538994353691817470203757;
        points[5] = -0.945530975164995853763837022906180412563436588500986407;
        points[6] = -0.925213359866651486256276060479791386855584193566834244;
        points[7] = -0.901822286284701580757467231388427964363928404788918474;
        points[8] = -0.875435454065568939417909335722610822486547484807016172;
        points[9] = -0.846140515970772949425887510872842500396632380214141657;
        points[10] = -0.814034785913567835469638304075198944827590183233613975;
        points[11] = -0.779224915346254021535948614840532655748889094829050259;
        points[12] = -0.741826538809184316285766268753578000939729144982815603;
        points[13] = -0.701963889719172919385570976969670601268811110489679439;
        points[14] = -0.659769387631983124692289822856220474788958248594975049;
        points[15] = -0.615383198331127370729937820161728300595972694129498622;
        points[16] = -0.568952768195209429731624834177153942773841437174211619;
        points[17] = -0.52063233438593307332701713874976411887936685525087922;
        points[18] = -0.470582412481382283683212136327742602431446639814420044;
        points[19] = -0.418969263255204528036102697462510005200790183425047583;
        points[20] = -0.3659643403721911819843321081654874061220373897036416;
        points[21] = -0.311743720834468228882550390152123771392948497110182017;
        points[22] = -0.256487520069997300077411214453008302726921873090774152;
        points[23] = -0.200379293606213569778602462829298030454143186091550919;
        points[24] = -0.143605427316256153947089762898789161294705016260067741;
        points[25] = -0.0863545182632482152854431777687496363694015374870635879;
        points[26] = -0.0288167481993417776562358475002270529894545421779078484;
        points[27] = 0.0288167481993417776562358475002270529894545421779078484;
        points[28] = 0.0863545182632482152854431777687496363694015374870635879;
        points[29] = 0.143605427316256153947089762898789161294705016260067741;
        points[30] = 0.200379293606213569778602462829298030454143186091550919;
        points[31] = 0.256487520069997300077411214453008302726921873090774152;
        points[32] = 0.311743720834468228882550390152123771392948497110182017;
        points[33] = 0.3659643403721911819843321081654874061220373897036416;
        points[34] = 0.418969263255204528036102697462510005200790183425047583;
        points[35] = 0.470582412481382283683212136327742602431446639814420044;
        points[36] = 0.52063233438593307332701713874976411887936685525087922;
        points[37] = 0.568952768195209429731624834177153942773841437174211619;
        points[38] = 0.615383198331127370729937820161728300595972694129498622;
        points[39] = 0.659769387631983124692289822856220474788958248594975049;
        points[40] = 0.701963889719172919385570976969670601268811110489679439;
        points[41] = 0.741826538809184316285766268753578000939729144982815603;
        points[42] = 0.779224915346254021535948614840532655748889094829050259;
        points[43] = 0.814034785913567835469638304075198944827590183233613975;
        points[44] = 0.846140515970772949425887510872842500396632380214141657;
        points[45] = 0.875435454065568939417909335722610822486547484807016172;
        points[46] = 0.901822286284701580757467231388427964363928404788918474;
        points[47] = 0.925213359866651486256276060479791386855584193566834244;
        points[48] = 0.945530975164995853763837022906180412563436588500986407;
        points[49] = 0.96270764578592358325699392690538994353691817470203757;
        points[50] = 0.976686328857903237200010071988306857467805973240003412;
        points[51] = 0.987420637397343558552145720403546261534036290839238588;
        points[52] = 0.994875117018338884918889995948702659484126758886999829;
        points[53] = 0.999026666867340983851071106983958493198042785796960332;
        weights[0] = 0.00249748183576158577594603875726602987918509746682711194;
        weights[1] = 0.00580561101523998487882588774587527341152465198940366679;
        weights[2] = 0.00909936945550939694803352106241926172187472240798218021;
        weights[3] = 0.012363328128847644166467824260188096463994498948433693;
        weights[4] = 0.0155863030359241317029689097058367654685878223576398962;
        weights[5] = 0.0187575276214693779120079842840711626886355747427113428;
        weights[6] = 0.0218664514228530859455104265388793009815703165629724421;
        weights[7] = 0.0249027414672087730500549712733890425756231328791233604;
        weights[8] = 0.0278563093105958702870020347639151512373099356257426966;
        weights[9] = 0.0307173424978706760540046099161549110199622120771604655;
        weights[10] = 0.033476336464372645716040444835610792714878607423683773;
        weights[11] = 0.0361241258403835525828870742074248459785730799301673299;
        weights[12] = 0.038651914782102516836857139051579876239011509355728554;
        weights[13] = 0.0410513061366449742217182108776043341937827974464546888;
        weights[14] = 0.0433143293095970154419257603705081181962891240438496887;
        weights[15] = 0.0454334667282767139748521807515445715337756390176710815;
        weights[16] = 0.0474016788064449910585764101153236036382065889832506088;
        weights[17] = 0.0492124273245288860687906303688116280775041129800626816;
        weights[18] = 0.0508596971461881443197092069761187459120602653893317148;
        weights[19] = 0.0523380161982987446655886947526850131804317669734681029;
        weights[20] = 0.0536424736475536112721006277252465768628158596085654399;
        weights[21] = 0.0547687362130579863062226347171090207246210665623550486;
        weights[22] = 0.0557130625605899876833698174273711106847117171157984779;
        weights[23] = 0.0564723157306259650310442646817612479537373621270836423;
        weights[24] = 0.0570439735587945985678284342542272120992117362125463539;
        weights[25] = 0.0574261370541121148592901317732068293892190570504253857;
        weights[26] = 0.0576175367071470246723761288058714771729017447215605723;
        weights[27] = 0.0576175367071470246723761288058714771729017447215605723;
        weights[28] = 0.0574261370541121148592901317732068293892190570504253857;
        weights[29] = 0.0570439735587945985678284342542272120992117362125463539;
        weights[30] = 0.0564723157306259650310442646817612479537373621270836423;
        weights[31] = 0.0557130625605899876833698174273711106847117171157984779;
        weights[32] = 0.0547687362130579863062226347171090207246210665623550486;
        weights[33] = 0.0536424736475536112721006277252465768628158596085654399;
        weights[34] = 0.0523380161982987446655886947526850131804317669734681029;
        weights[35] = 0.0508596971461881443197092069761187459120602653893317148;
        weights[36] = 0.0492124273245288860687906303688116280775041129800626816;
        weights[37] = 0.0474016788064449910585764101153236036382065889832506088;
        weights[38] = 0.0454334667282767139748521807515445715337756390176710815;
        weights[39] = 0.0433143293095970154419257603705081181962891240438496887;
        weights[40] = 0.0410513061366449742217182108776043341937827974464546888;
        weights[41] = 0.038651914782102516836857139051579876239011509355728554;
        weights[42] = 0.0361241258403835525828870742074248459785730799301673299;
        weights[43] = 0.033476336464372645716040444835610792714878607423683773;
        weights[44] = 0.0307173424978706760540046099161549110199622120771604655;
        weights[45] = 0.0278563093105958702870020347639151512373099356257426966;
        weights[46] = 0.0249027414672087730500549712733890425756231328791233604;
        weights[47] = 0.0218664514228530859455104265388793009815703165629724421;
        weights[48] = 0.0187575276214693779120079842840711626886355747427113428;
        weights[49] = 0.0155863030359241317029689097058367654685878223576398962;
        weights[50] = 0.012363328128847644166467824260188096463994498948433693;
        weights[51] = 0.00909936945550939694803352106241926172187472240798218021;
        weights[52] = 0.00580561101523998487882588774587527341152465198940366679;
        weights[53] = 0.00249748183576158577594603875726602987918509746682711194;
        return;
    case 55:
        points[0] = -0.999061419564818541479431839519384423155541278929420157;
        points[1] = -0.99505797784741187504318911650620237159410074640539225;
        points[2] = -0.98786894119888919852238568447347353064860155505648643;
        points[3] = -0.977515735503989208859216606340730211542135462755569801;
        points[4] = -0.964031328593135198778536631377369222637489674164126656;
        points[5] = -0.947458868041210741859979847645291837175186326297240787;
        points[6] = -0.927851424720791696816271269232586379194499280569601184;
        points[7] = -0.905271800744000025781911424629624392227608588470290593;
        points[8] = -0.879792322419895506067590906824086395299913621625734477;
        points[9] = -0.851494606617154471460245320967007027816463989402732402;
        points[10] = -0.820469298559320912454241285034722365392967480105130606;
        points[11] = -0.786815781127622365897636250938041383509091146272250529;
        points[12] = -0.750641856348021908674987682707310917922063464462257535;
        points[13] = -0.712063399986637838909350192121167515172653723145173514;
        points[14] = -0.671203990319826395796326728006015600573927277436610607;
        points[15] = -0.628194512249928140090636215032975432911010309006757968;
        points[16] = -0.583172738026032102974304815587686486221861136254785674;
        points[17] = -0.536282885908343296720599572843597553538275608838743915;
        points[18] = -0.487675158187474097208263673539355611507554019569348864;
        points[19] = -0.437505260037174591808481024297466584242516289220592545;
        points[20] = -0.385933900740979429755848543912589975450407086515743056;
        points[21] = -0.333126278890023885189471490232961963047398261922712874;
        points[22] = -0.279251553200806538549862451175671025558185946282972635;
        points[23] = -0.22448230064784548340018906240292645440811700470895206;
        points[24] = -0.168993963646873208282842493511702229345893529573876111;
        points[25] = -0.112964288059329266588437923888712184012038893009333007;
        points[26] = -0.0565727538183367763273376108931084341626757424523121837;
        points[27] = 0;
        points[28] = 0.0565727538183367763273376108931084341626757424523121837;
        points[29] = 0.112964288059329266588437923888712184012038893009333007;
        points[30] = 0.168993963646873208282842493511702229345893529573876111;
        points[31] = 0.22448230064784548340018906240292645440811700470895206;
        points[32] = 0.279251553200806538549862451175671025558185946282972635;
        points[33] = 0.333126278890023885189471490232961963047398261922712874;
        points[34] = 0.385933900740979429755848543912589975450407086515743056;
        points[35] = 0.437505260037174591808481024297466584242516289220592545;
        points[36] = 0.487675158187474097208263673539355611507554019569348864;
        points[37] = 0.536282885908343296720599572843597553538275608838743915;
        points[38] = 0.583172738026032102974304815587686486221861136254785674;
        points[39] = 0.628194512249928140090636215032975432911010309006757968;
        points[40] = 0.671203990319826395796326728006015600573927277436610607;
        points[41] = 0.712063399986637838909350192121167515172653723145173514;
        points[42] = 0.750641856348021908674987682707310917922063464462257535;
        points[43] = 0.786815781127622365897636250938041383509091146272250529;
        points[44] = 0.820469298559320912454241285034722365392967480105130606;
        points[45] = 0.851494606617154471460245320967007027816463989402732402;
        points[46] = 0.879792322419895506067590906824086395299913621625734477;
        points[47] = 0.905271800744000025781911424629624392227608588470290593;
        points[48] = 0.927851424720791696816271269232586379194499280569601184;
        points[49] = 0.947458868041210741859979847645291837175186326297240787;
        points[50] = 0.964031328593135198778536631377369222637489674164126656;
        points[51] = 0.977515735503989208859216606340730211542135462755569801;
        points[52] = 0.98786894119888919852238568447347353064860155505648643;
        points[53] = 0.99505797784741187504318911650620237159410074640539225;
        points[54] = 0.999061419564818541479431839519384423155541278929420157;
        weights[0] = 0.00240832361997978881917019348912527870416962754170570552;
        weights[1] = 0.00559863226656076735408341687185985724515129524166676;
        weights[2] = 0.0087757461070585281773896006833178381644564407606959352;
        weights[3] = 0.0119251607198486121707525531575898882926403474479889492;
        weights[4] = 0.0150364583335117882131508989019372817118222494995358176;
        weights[5] = 0.0180996145207290624079682026434122304027784945375529721;
        weights[6] = 0.0211048016680164541202093056236983344809343740619170514;
        weights[7] = 0.0240423880097256220077915729286034584992461505618308091;
        weights[8] = 0.0269029614563962706671200286537790971433766611326800207;
        weights[9] = 0.0296773577651610412212965061868853602298586405943297351;
        weights[10] = 0.0323566892261858316847055918757768657576683950311935041;
        weights[11] = 0.034932372873589887407268226802706487974287461289662762;
        weights[12] = 0.037396157867965545282915598582457549515103401503920991;
        weights[13] = 0.0397401518743371796094638319033998358680268513816859788;
        weights[14] = 0.0419568463177187623952073166921441225765663582207783523;
        weights[15] = 0.0440391404216065898951680856532928731346290449452904751;
        weights[16] = 0.0459803639462838381039048608720746681221111540908620405;
        weights[17] = 0.0477742985512006955500367147160559256338183071442882368;
        weights[18] = 0.0494151977115517394807585390160392756818815553283152874;
        weights[19] = 0.0508978051244939792247752742880834388216855409146710738;
        weights[20] = 0.0522173715456320845643935632812950099667420858053508795;
        weights[21] = 0.0533696700016054727235705156360978537270000631466828584;
        weights[22] = 0.0543510093299111020703221181537721488058133091086900951;
        weights[23] = 0.0551582460025086875966511395606667214325306373972057271;
        weights[24] = 0.0557887941952840871029360071099197146724675353885833224;
        weights[25] = 0.0562406340710843680282790880901978272760612597138630147;
        weights[26] = 0.0565123182497720014006583676351890541396881831582519156;
        weights[27] = 0.0566029764445604254401057619812440040389691501015994589;
        weights[28] = 0.0565123182497720014006583676351890541396881831582519156;
        weights[29] = 0.0562406340710843680282790880901978272760612597138630147;
        weights[30] = 0.0557887941952840871029360071099197146724675353885833224;
        weights[31] = 0.0551582460025086875966511395606667214325306373972057271;
        weights[32] = 0.0543510093299111020703221181537721488058133091086900951;
        weights[33] = 0.0533696700016054727235705156360978537270000631466828584;
        weights[34] = 0.0522173715456320845643935632812950099667420858053508795;
        weights[35] = 0.0508978051244939792247752742880834388216855409146710738;
        weights[36] = 0.0494151977115517394807585390160392756818815553283152874;
        weights[37] = 0.0477742985512006955500367147160559256338183071442882368;
        weights[38] = 0.0459803639462838381039048608720746681221111540908620405;
        weights[39] = 0.0440391404216065898951680856532928731346290449452904751;
        weights[40] = 0.0419568463177187623952073166921441225765663582207783523;
        weights[41] = 0.0397401518743371796094638319033998358680268513816859788;
        weights[42] = 0.037396157867965545282915598582457549515103401503920991;
        weights[43] = 0.034932372873589887407268226802706487974287461289662762;
        weights[44] = 0.0323566892261858316847055918757768657576683950311935041;
        weights[45] = 0.0296773577651610412212965061868853602298586405943297351;
        weights[46] = 0.0269029614563962706671200286537790971433766611326800207;
        weights[47] = 0.0240423880097256220077915729286034584992461505618308091;
        weights[48] = 0.0211048016680164541202093056236983344809343740619170514;
        weights[49] = 0.0180996145207290624079682026434122304027784945375529721;
        weights[50] = 0.0150364583335117882131508989019372817118222494995358176;
        weights[51] = 0.0119251607198486121707525531575898882926403474479889492;
        weights[52] = 0.0087757461070585281773896006833178381644564407606959352;
        weights[53] = 0.00559863226656076735408341687185985724515129524166676;
        weights[54] = 0.00240832361997978881917019348912527870416962754170570552;
        return;
    case 56:
        points[0] = -0.99909434380146558435315382509090426217601897845975637;
        points[1] = -0.995231226081069747216308760098940945548538455233990375;
        points[2] = -0.988293715540161511089925163523486216764541143224616165;
        points[3] = -0.978301709140256383376990551538188131227013897750228424;
        points[4] = -0.965285901905490183626194976055095698217551218657663428;
        points[5] = -0.949286479561962635646737602794928066889563522588144522;
        points[6] = -0.930352880247496300547272723291600853026814305996895027;
        points[7] = -0.908543620420655490846107289957241779532211068809586916;
        points[8] = -0.883926108327827540789012285809286727505981410232089252;
        points[9] = -0.856576433762748635402991386766870604073674174709864281;
        points[10] = -0.826579132142881651672126974456850323343042175963860086;
        points[11] = -0.794026922893866498030008308486000477657203301683242045;
        points[12] = -0.759020422705128902202413294445893867364837249273649469;
        points[13] = -0.721667834450188083522593787047553457344048519285738254;
        points[14] = -0.682084612694470455501561477969836333105109367461210194;
        points[15] = -0.640393106807006894267938596062813078923806572947805831;
        points[16] = -0.596722182770663320104135217138408383220500869241944365;
        points[17] = -0.551206824855534618754363514576316602525662578352490243;
        points[18] = -0.503987718384381714195224401218638137709305949354017502;
        points[19] = -0.45521081487845957894883158132460955990722690550390788;
        points[20] = -0.405026880927091278118866962602922894655371382368290726;
        points[21] = -0.353591032174954520969707327033232405634678794381171976;
        points[22] = -0.301062253867220669053094233125234343925071846124383471;
        points[23] = -0.247602909434337203972966554970526972879663243142767006;
        points[24] = -0.193378238635275258240184723012684161816167392763801259;
        points[25] = -0.138555846810376242012886580438490595351490508462528551;
        points[26] = -0.0833051868224353744402873554406624481839874141890305459;
        points[27] = -0.0277970352872754370940611967749205218883766031467744878;
        points[28] = 0.0277970352872754370940611967749205218883766031467744878;
        points[29] = 0.0833051868224353744402873554406624481839874141890305459;
        points[30] = 0.138555846810376242012886580438490595351490508462528551;
        points[31] = 0.193378238635275258240184723012684161816167392763801259;
        points[32] = 0.247602909434337203972966554970526972879663243142767006;
        points[33] = 0.301062253867220669053094233125234343925071846124383471;
        points[34] = 0.353591032174954520969707327033232405634678794381171976;
        points[35] = 0.405026880927091278118866962602922894655371382368290726;
        points[36] = 0.45521081487845957894883158132460955990722690550390788;
        points[37] = 0.503987718384381714195224401218638137709305949354017502;
        points[38] = 0.551206824855534618754363514576316602525662578352490243;
        points[39] = 0.596722182770663320104135217138408383220500869241944365;
        points[40] = 0.640393106807006894267938596062813078923806572947805831;
        points[41] = 0.682084612694470455501561477969836333105109367461210194;
        points[42] = 0.721667834450188083522593787047553457344048519285738254;
        points[43] = 0.759020422705128902202413294445893867364837249273649469;
        points[44] = 0.794026922893866498030008308486000477657203301683242045;
        points[45] = 0.826579132142881651672126974456850323343042175963860086;
        points[46] = 0.856576433762748635402991386766870604073674174709864281;
        points[47] = 0.883926108327827540789012285809286727505981410232089252;
        points[48] = 0.908543620420655490846107289957241779532211068809586916;
        points[49] = 0.930352880247496300547272723291600853026814305996895027;
        points[50] = 0.949286479561962635646737602794928066889563522588144522;
        points[51] = 0.965285901905490183626194976055095698217551218657663428;
        points[52] = 0.978301709140256383376990551538188131227013897750228424;
        points[53] = 0.988293715540161511089925163523486216764541143224616165;
        points[54] = 0.995231226081069747216308760098940945548538455233990375;
        points[55] = 0.99909434380146558435315382509090426217601897845975637;
        weights[0] = 0.00232385537577321550110227644339586473759320991735859403;
        weights[1] = 0.00540252224601533776131126094412087284162781818411397736;
        weights[2] = 0.00846906316330788766162711237500816017607748757412691595;
        weights[3] = 0.0115098243403833821737727593244971192748559048179691436;
        weights[4] = 0.0145150892780214718077707405330129910240961984992442576;
        weights[5] = 0.01747551291140094650495936890545715023078028057687649;
        weights[6] = 0.0203819298824025726348059836669333475071194643986120085;
        weights[7] = 0.0232253515625653169372581575767885265557220198245790044;
        weights[8] = 0.0259969870583919521918194322072723514480102520506943594;
        weights[9] = 0.0286882684738227417298858844303942726041341370468452294;
        weights[10] = 0.0312908767473104478678354777930253469778460131872277166;
        weights[11] = 0.0337967671156117612954266312254470498176070716782671452;
        weights[12] = 0.0361981938723151860358844682888862454006302346723142169;
        weights[13] = 0.0384877342592476624868255916233812793438196346814820133;
        weights[14] = 0.0406583113847445178801250227788527630755422730490527223;
        weights[15] = 0.0427032160846670865110385723624770808934709459666175749;
        weights[16] = 0.0446161276526922832134151929276237403258464384162967042;
        weights[17] = 0.0463911333730018967621901910664960342346098061005004903;
        weights[18] = 0.0480227467936002581207355056669997121440168767700242701;
        weights[19] = 0.049505924683047578919966046430845556418718849071317996;
        weights[20] = 0.0508360826177984805601240184701986559829916379320842155;
        weights[21] = 0.0520091091517413998430522648274847216705325853129013584;
        weights[22] = 0.0530213785240107639679915586076914687273814340810240065;
        weights[23] = 0.0538697618657144857089544104066979942479245356718882474;
        weights[24] = 0.0545516368708894210617506548900901799440607237809163526;
        weights[25] = 0.0550648959017624257963045975478503253413555128006590126;
        weights[26] = 0.055407952503245123217793391843910018909562031380663018;
        weights[27] = 0.055579746306514395846273426835161170144066622556342959;
        weights[28] = 0.055579746306514395846273426835161170144066622556342959;
        weights[29] = 0.055407952503245123217793391843910018909562031380663018;
        weights[30] = 0.0550648959017624257963045975478503253413555128006590126;
        weights[31] = 0.0545516368708894210617506548900901799440607237809163526;
        weights[32] = 0.0538697618657144857089544104066979942479245356718882474;
        weights[33] = 0.0530213785240107639679915586076914687273814340810240065;
        weights[34] = 0.0520091091517413998430522648274847216705325853129013584;
        weights[35] = 0.0508360826177984805601240184701986559829916379320842155;
        weights[36] = 0.049505924683047578919966046430845556418718849071317996;
        weights[37] = 0.0480227467936002581207355056669997121440168767700242701;
        weights[38] = 0.0463911333730018967621901910664960342346098061005004903;
        weights[39] = 0.0446161276526922832134151929276237403258464384162967042;
        weights[40] = 0.0427032160846670865110385723624770808934709459666175749;
        weights[41] = 0.0406583113847445178801250227788527630755422730490527223;
        weights[42] = 0.0384877342592476624868255916233812793438196346814820133;
        weights[43] = 0.0361981938723151860358844682888862454006302346723142169;
        weights[44] = 0.0337967671156117612954266312254470498176070716782671452;
        weights[45] = 0.0312908767473104478678354777930253469778460131872277166;
        weights[46] = 0.0286882684738227417298858844303942726041341370468452294;
        weights[47] = 0.0259969870583919521918194322072723514480102520506943594;
        weights[48] = 0.0232253515625653169372581575767885265557220198245790044;
        weights[49] = 0.0203819298824025726348059836669333475071194643986120085;
        weights[50] = 0.01747551291140094650495936890545715023078028057687649;
        weights[51] = 0.0145150892780214718077707405330129910240961984992442576;
        weights[52] = 0.0115098243403833821737727593244971192748559048179691436;
        weights[53] = 0.00846906316330788766162711237500816017607748757412691595;
        weights[54] = 0.00540252224601533776131126094412087284162781818411397736;
        weights[55] = 0.00232385537577321550110227644339586473759320991735859403;
        return;
    case 57:
        points[0] = -0.999125565625262850572009849554249884999127586007013575;
        points[1] = -0.995395523678430311135125027362419005975068868913413964;
        points[2] = -0.988696577650222048849758398383855438510084086698944006;
        points[3] = -0.979047226709468713798820875366507757360931223767780685;
        points[4] = -0.96647608517188667911485858394233318896849009450238562;
        points[5] = -0.951020626447876741911904110605190328637799339662690428;
        points[6] = -0.932726961067101696100754154297356638067488635116634849;
        points[7] = -0.911649678521391212728430561619670310918248410397413302;
        points[8] = -0.887851678882221329513000147641861716134275787267035282;
        points[9] = -0.861403983262046944722241881805214754221933005613239618;
        points[10] = -0.832385521150439120829010895865203218252265650096639455;
        points[11] = -0.800882894547218242076008718794948567701803620155421602;
        points[12] = -0.766990119359450195491716144018132355236648415822398243;
        points[13] = -0.730808344744523322827344670736778316263122119509612203;
        points[14] = -0.69244555119951773904048368844401044565667663461414289;
        points[15] = -0.65201622828097689124936184079570828367066055697215481;
        points[16] = -0.609641032908715365423848901924740624324000572923964614;
        points[17] = -0.565446429269236759018985552805240429370022074221579729;
        points[18] = -0.519564311391187606315153819806214351080631108269511806;
        points[19] = -0.472131609517975709588060082049234749822237925699326685;
        points[20] = -0.42328988145156395096002435347152437901405095213458829;
        points[21] = -0.373184890086594458552134396144889010556460146092633534;
        points[22] = -0.321966168395378640590207915805397239372739467662806316;
        points[23] = -0.269786573161838765763345609799643344299057994351474759;
        points[24] = -0.216801828796124036413613975979559274256583295504472438;
        points[25] = -0.163170062591264251043280378321512062185909989303105714;
        points[26] = -0.109051332808787800978526521310979049455045137501671027;
        points[27] = -0.0546071510016468242198305597373324454104423343597207808;
        points[28] = 0;
        points[29] = 0.0546071510016468242198305597373324454104423343597207808;
        points[30] = 0.109051332808787800978526521310979049455045137501671027;
        points[31] = 0.163170062591264251043280378321512062185909989303105714;
        points[32] = 0.216801828796124036413613975979559274256583295504472438;
        points[33] = 0.269786573161838765763345609799643344299057994351474759;
        points[34] = 0.321966168395378640590207915805397239372739467662806316;
        points[35] = 0.373184890086594458552134396144889010556460146092633534;
        points[36] = 0.42328988145156395096002435347152437901405095213458829;
        points[37] = 0.472131609517975709588060082049234749822237925699326685;
        points[38] = 0.519564311391187606315153819806214351080631108269511806;
        points[39] = 0.565446429269236759018985552805240429370022074221579729;
        points[40] = 0.609641032908715365423848901924740624324000572923964614;
        points[41] = 0.65201622828097689124936184079570828367066055697215481;
        points[42] = 0.69244555119951773904048368844401044565667663461414289;
        points[43] = 0.730808344744523322827344670736778316263122119509612203;
        points[44] = 0.766990119359450195491716144018132355236648415822398243;
        points[45] = 0.800882894547218242076008718794948567701803620155421602;
        points[46] = 0.832385521150439120829010895865203218252265650096639455;
        points[47] = 0.861403983262046944722241881805214754221933005613239618;
        points[48] = 0.887851678882221329513000147641861716134275787267035282;
        points[49] = 0.911649678521391212728430561619670310918248410397413302;
        points[50] = 0.932726961067101696100754154297356638067488635116634849;
        points[51] = 0.951020626447876741911904110605190328637799339662690428;
        points[52] = 0.96647608517188667911485858394233318896849009450238562;
        points[53] = 0.979047226709468713798820875366507757360931223767780685;
        points[54] = 0.988696577650222048849758398383855438510084086698944006;
        points[55] = 0.995395523678430311135125027362419005975068868913413964;
        points[56] = 0.999125565625262850572009849554249884999127586007013575;
        weights[0] = 0.00224375387225066290973478682263501388626751860515453919;
        weights[1] = 0.00521653347471877939050662987142008532303141539042764462;
        weights[2] = 0.00817816006782123262621099813037940186470942609118705156;
        weights[3] = 0.0111157637323359901456754487681900391395904333631786221;
        weights[4] = 0.0140202707907535561702471513381502513228268482238128456;
        weights[5] = 0.0168829590234415490350008215668332764463059650200004404;
        weights[6] = 0.0196952706994885203824224522735148584246970405778395012;
        weights[7] = 0.0224488078907764380796892388450908804387962019606627317;
        weights[8] = 0.0251353509909181226472737881409554879758809126073346053;
        weights[9] = 0.0277468814021801923212579500383637591696208463159952618;
        weights[10] = 0.0302756048426939994584905988331372111851184545053376682;
        weights[11] = 0.0327139743663715685424901099103934982845747686389306711;
        weights[12] = 0.0350547127823126175057509705965500644569012556759409018;
        weights[13] = 0.0372908343244173173547352639956989655539698724087680564;
        weights[14] = 0.0394156654754801140899527208010555042508151727322945731;
        weights[15] = 0.0414228648708011103631969052736104309601351140912015419;
        weights[16] = 0.0433064422162151965964321083284261257043646513427258084;
        weights[17] = 0.0450607761613811577972135295258329703541113366416026742;
        weights[18] = 0.0466806310736415037838408927788335708830549965242929779;
        weights[19] = 0.0481611726616877512688510517568167367162428543195299778;
        weights[20] = 0.0494979824020196789938379444993879262646728960762586854;
        weights[21] = 0.0506870707249274086566404255636365795531047987116499536;
        weights[22] = 0.0517248889205178247206239086651469806258692764894542553;
        weights[23] = 0.0526083397291774324402313816408841896252559164289825928;
        weights[24] = 0.0533347865848191584265769779914406250959470462378439373;
        weights[25] = 0.0539020614832985746428094817306014534866276745873407168;
        weights[26] = 0.0543084714524986431387467729547915602633775761284777724;
        weights[27] = 0.0545528036047618864801389953641965144760153482295025391;
        weights[28] = 0.0546343287565840240628413879880520765362287641485429065;
        weights[29] = 0.0545528036047618864801389953641965144760153482295025391;
        weights[30] = 0.0543084714524986431387467729547915602633775761284777724;
        weights[31] = 0.0539020614832985746428094817306014534866276745873407168;
        weights[32] = 0.0533347865848191584265769779914406250959470462378439373;
        weights[33] = 0.0526083397291774324402313816408841896252559164289825928;
        weights[34] = 0.0517248889205178247206239086651469806258692764894542553;
        weights[35] = 0.0506870707249274086566404255636365795531047987116499536;
        weights[36] = 0.0494979824020196789938379444993879262646728960762586854;
        weights[37] = 0.0481611726616877512688510517568167367162428543195299778;
        weights[38] = 0.0466806310736415037838408927788335708830549965242929779;
        weights[39] = 0.0450607761613811577972135295258329703541113366416026742;
        weights[40] = 0.0433064422162151965964321083284261257043646513427258084;
        weights[41] = 0.0414228648708011103631969052736104309601351140912015419;
        weights[42] = 0.0394156654754801140899527208010555042508151727322945731;
        weights[43] = 0.0372908343244173173547352639956989655539698724087680564;
        weights[44] = 0.0350547127823126175057509705965500644569012556759409018;
        weights[45] = 0.0327139743663715685424901099103934982845747686389306711;
        weights[46] = 0.0302756048426939994584905988331372111851184545053376682;
        weights[47] = 0.0277468814021801923212579500383637591696208463159952618;
        weights[48] = 0.0251353509909181226472737881409554879758809126073346053;
        weights[49] = 0.0224488078907764380796892388450908804387962019606627317;
        weights[50] = 0.0196952706994885203824224522735148584246970405778395012;
        weights[51] = 0.0168829590234415490350008215668332764463059650200004404;
        weights[52] = 0.0140202707907535561702471513381502513228268482238128456;
        weights[53] = 0.0111157637323359901456754487681900391395904333631786221;
        weights[54] = 0.00817816006782123262621099813037940186470942609118705156;
        weights[55] = 0.00521653347471877939050662987142008532303141539042764462;
        weights[56] = 0.00224375387225066290973478682263501388626751860515453919;
        return;
    case 58:
        points[0] = -0.999155200407386606442737044184605761045813585872715631;
        points[1] = -0.995551476597290902602771526179946141276967280242974881;
        points[2] = -0.989079008248442636499910255275442056883205365501321505;
        points[3] = -0.979755014694350309107816334392598034869875945691289139;
        points[4] = -0.96760620250292409015330078462120619491287277499442596;
        points[5] = -0.952667557518869091442845510022930333705587628975491226;
        points[6] = -0.934982137588259348480843234766247495409147422744563944;
        points[7] = -0.914600928564352540686505649897521820495615095425406115;
        points[8] = -0.891582692022030176399882820812797546482551849941030649;
        points[9] = -0.865993794074807479275071232512087657694274148605561063;
        points[10] = -0.837908013339373316352097920621624361286867305697942394;
        points[11] = -0.807406327913088141048997152207395227983283424010130542;
        points[12] = -0.774576681749652745266140046496826665648970000627280787;
        points[13] = -0.73951373102004226784661723485103279097065744804820353;
        points[14] = -0.702318571153908113479757301458201383660685816647606889;
        points[15] = -0.663098445332125266433016299753565691960643624304121991;
        points[16] = -0.621966435263079111033984058745491120232235253849255085;
        points[17] = -0.579041135130225030489977117136083403820176816683960341;
        points[18] = -0.534446309648847586399802417425204355788763287356337084;
        points[19] = -0.488310537216718463615552572736785420894228720802451279;
        points[20] = -0.440766839186839565193703062214304414122414801908176397;
        points[21] = -0.391952296330753150371216941213010702185017624423004215;
        points[22] = -0.342007653597995261248368267483996950877672821629287289;
        points[23] = -0.291076914311109189533025268314303302189517100857549348;
        points[24] = -0.239306924966153454428948509085334787700528828035330307;
        points[25] = -0.186846951835761321374383881464022406061547888441217035;
        points[26] = -0.13384825059546685702237684787454091195295752427056042;
        points[27] = -0.0804636302141427293098477923805031948893348968318648099;
        points[28] = -0.02684701236594235580333868951737998584342117663189361;
        points[29] = 0.02684701236594235580333868951737998584342117663189361;
        points[30] = 0.0804636302141427293098477923805031948893348968318648099;
        points[31] = 0.13384825059546685702237684787454091195295752427056042;
        points[32] = 0.186846951835761321374383881464022406061547888441217035;
        points[33] = 0.239306924966153454428948509085334787700528828035330307;
        points[34] = 0.291076914311109189533025268314303302189517100857549348;
        points[35] = 0.342007653597995261248368267483996950877672821629287289;
        points[36] = 0.391952296330753150371216941213010702185017624423004215;
        points[37] = 0.440766839186839565193703062214304414122414801908176397;
        points[38] = 0.488310537216718463615552572736785420894228720802451279;
        points[39] = 0.534446309648847586399802417425204355788763287356337084;
        points[40] = 0.579041135130225030489977117136083403820176816683960341;
        points[41] = 0.621966435263079111033984058745491120232235253849255085;
        points[42] = 0.663098445332125266433016299753565691960643624304121991;
        points[43] = 0.702318571153908113479757301458201383660685816647606889;
        points[44] = 0.73951373102004226784661723485103279097065744804820353;
        points[45] = 0.774576681749652745266140046496826665648970000627280787;
        points[46] = 0.807406327913088141048997152207395227983283424010130542;
        points[47] = 0.837908013339373316352097920621624361286867305697942394;
        points[48] = 0.865993794074807479275071232512087657694274148605561063;
        points[49] = 0.891582692022030176399882820812797546482551849941030649;
        points[50] = 0.914600928564352540686505649897521820495615095425406115;
        points[51] = 0.934982137588259348480843234766247495409147422744563944;
        points[52] = 0.952667557518869091442845510022930333705587628975491226;
        points[53] = 0.96760620250292409015330078462120619491287277499442596;
        points[54] = 0.979755014694350309107816334392598034869875945691289139;
        points[55] = 0.989079008248442636499910255275442056883205365501321505;
        points[56] = 0.995551476597290902602771526179946141276967280242974881;
        points[57] = 0.999155200407386606442737044184605761045813585872715631;
        weights[0] = 0.00216772324962744994305434292498451143103544022457861832;
        weights[1] = 0.00503998161265024308501750117462242355333087943674126262;
        weights[2] = 0.00790197384999867475401674567484775950725497451144570023;
        weights[3] = 0.0107415535328787741168563619136618737235674500177416583;
        weights[4] = 0.0135502371129888121451789664017618618308308531829865017;
        weights[5] = 0.0163198742349709650521208304195708874821816105277690602;
        weights[6] = 0.0190424654618934086557876594821076039333641329342966622;
        weights[7] = 0.021710156140146235766916809495118289922602934077950337;
        weights[8] = 0.0243152527249639525402587606257985097442911865134363059;
        weights[9] = 0.0268502431819818684759074786781449555910274646571860066;
        weights[10] = 0.0293078180441604907183940268884438100349616013719531896;
        weights[11] = 0.0316808912538093273202920396219502966872861645240879873;
        weights[12] = 0.0339626204934160107977275551845847994387837763949648006;
        weights[13] = 0.0361464268670872705407808569758552272333427912991269834;
        weights[14] = 0.0382260138458584332294590344571485400659427639863191565;
        weights[15] = 0.0401953854098677968880767508268822923579140402207077844;
        weights[16] = 0.0420488633295821259945699819172542314622665402355190603;
        weights[17] = 0.0437811035336402510390256923483360732427561176600973783;
        weights[18] = 0.0453871115148198025039805360888660491491617686449521352;
        weights[19] = 0.0468622567290263469184180780379200348509136109749744945;
        weights[20] = 0.0482022859454177484065704061098669065750307136268468626;
        weights[21] = 0.0494033355089623928665108657127013196506444226693611684;
        weights[22] = 0.0504619424799531252976598215676317780474879663625451496;
        weights[23] = 0.0513750546182857254745148206110653803029581080956232019;
        weights[24] = 0.0521400391836698189712605560600718257610216901342433444;
        weights[25] = 0.0527546905263708334296457672315231717649335929173374798;
        weights[26] = 0.0532172364465790141034809843773847932124579233045218451;
        weights[27] = 0.0535263433040582521006108138861701805419674894903239215;
        weights[28] = 0.0536811198633348488639059553057246129006819920023619436;
        weights[29] = 0.0536811198633348488639059553057246129006819920023619436;
        weights[30] = 0.0535263433040582521006108138861701805419674894903239215;
        weights[31] = 0.0532172364465790141034809843773847932124579233045218451;
        weights[32] = 0.0527546905263708334296457672315231717649335929173374798;
        weights[33] = 0.0521400391836698189712605560600718257610216901342433444;
        weights[34] = 0.0513750546182857254745148206110653803029581080956232019;
        weights[35] = 0.0504619424799531252976598215676317780474879663625451496;
        weights[36] = 0.0494033355089623928665108657127013196506444226693611684;
        weights[37] = 0.0482022859454177484065704061098669065750307136268468626;
        weights[38] = 0.0468622567290263469184180780379200348509136109749744945;
        weights[39] = 0.0453871115148198025039805360888660491491617686449521352;
        weights[40] = 0.0437811035336402510390256923483360732427561176600973783;
        weights[41] = 0.0420488633295821259945699819172542314622665402355190603;
        weights[42] = 0.0401953854098677968880767508268822923579140402207077844;
        weights[43] = 0.0382260138458584332294590344571485400659427639863191565;
        weights[44] = 0.0361464268670872705407808569758552272333427912991269834;
        weights[45] = 0.0339626204934160107977275551845847994387837763949648006;
        weights[46] = 0.0316808912538093273202920396219502966872861645240879873;
        weights[47] = 0.0293078180441604907183940268884438100349616013719531896;
        weights[48] = 0.0268502431819818684759074786781449555910274646571860066;
        weights[49] = 0.0243152527249639525402587606257985097442911865134363059;
        weights[50] = 0.021710156140146235766916809495118289922602934077950337;
        weights[51] = 0.0190424654618934086557876594821076039333641329342966622;
        weights[52] = 0.0163198742349709650521208304195708874821816105277690602;
        weights[53] = 0.0135502371129888121451789664017618618308308531829865017;
        weights[54] = 0.0107415535328787741168563619136618737235674500177416583;
        weights[55] = 0.00790197384999867475401674567484775950725497451144570023;
        weights[56] = 0.00503998161265024308501750117462242355333087943674126262;
        weights[57] = 0.00216772324962744994305434292498451143103544022457861832;
        return;
    case 59:
        points[0] = -0.999183353909294683756424019504678184974225970330022709;
        points[1] = -0.995699640383245964687201823433448307661855776908591227;
        points[2] = -0.989442365133730931782183935022705793473255280023299343;
        points[3] = -0.980427573956715688449607981403267775462557851139703011;
        points[4] = -0.968680221681781531353633339672562057664889443329818486;
        points[5] = -0.954233009376951055863233112185649937073908138274547126;
        points[6] = -0.93712619035345385940513847104328988491060212647114706;
        points[7] = -0.917407438788155281352541485215245826873143490003803993;
        points[8] = -0.895131711743472085364296829462459275029537139409999277;
        points[9] = -0.870361094292882260963426233104145201284186947396187658;
        points[10] = -0.843164625816872201470350953972236638470225960817232193;
        points[11] = -0.813618107288211571435089773821200447410704065089647454;
        points[12] = -0.781803889862360905632678812767482628029666956950394431;
        points[13] = -0.747810645278640231889257579013212387920894933985514491;
        points[14] = -0.711733118677197731595915721965909353910762452802312234;
        points[15] = -0.673671864504937227024027212755253684415064275115545886;
        points[16] = -0.633732966238850097512580930175007912551898376438962263;
        points[17] = -0.592027740704030144464176159756534339804248169680693676;
        points[18] = -0.548672427808396384372256300387005857440673318324009302;
        points[19] = -0.503787866557717978768087280457308892150980648897875859;
        points[20] = -0.457499158253266690226215260434961508176425775912334218;
        points[21] = -0.409935317810418966722823693755879121014721462678233417;
        points[22] = -0.361228914169794809992312452334048957953413960174839404;
        points[23] = -0.311515700803013700318360149105749750125659237602980342;
        points[24] = -0.260934237342811711610616267414278380003544483433130362;
        points[25] = -0.209625503392036544923366790631491096332050474314493175;
        points[26] = -0.157732505587857968115217856271554304124174624202703188;
        points[27] = -0.105399879016344143836914387761869287053925410936822292;
        points[28] = -0.0527734840883100039516803286033385378247007695091781053;
        points[29] = 0;
        points[30] = 0.0527734840883100039516803286033385378247007695091781053;
        points[31] = 0.105399879016344143836914387761869287053925410936822292;
        points[32] = 0.157732505587857968115217856271554304124174624202703188;
        points[33] = 0.209625503392036544923366790631491096332050474314493175;
        points[34] = 0.260934237342811711610616267414278380003544483433130362;
        points[35] = 0.311515700803013700318360149105749750125659237602980342;
        points[36] = 0.361228914169794809992312452334048957953413960174839404;
        points[37] = 0.409935317810418966722823693755879121014721462678233417;
        points[38] = 0.457499158253266690226215260434961508176425775912334218;
        points[39] = 0.503787866557717978768087280457308892150980648897875859;
        points[40] = 0.548672427808396384372256300387005857440673318324009302;
        points[41] = 0.592027740704030144464176159756534339804248169680693676;
        points[42] = 0.633732966238850097512580930175007912551898376438962263;
        points[43] = 0.673671864504937227024027212755253684415064275115545886;
        points[44] = 0.711733118677197731595915721965909353910762452802312234;
        points[45] = 0.747810645278640231889257579013212387920894933985514491;
        points[46] = 0.781803889862360905632678812767482628029666956950394431;
        points[47] = 0.813618107288211571435089773821200447410704065089647454;
        points[48] = 0.843164625816872201470350953972236638470225960817232193;
        points[49] = 0.870361094292882260963426233104145201284186947396187658;
        points[50] = 0.895131711743472085364296829462459275029537139409999277;
        points[51] = 0.917407438788155281352541485215245826873143490003803993;
        points[52] = 0.93712619035345385940513847104328988491060212647114706;
        points[53] = 0.954233009376951055863233112185649937073908138274547126;
        points[54] = 0.968680221681781531353633339672562057664889443329818486;
        points[55] = 0.980427573956715688449607981403267775462557851139703011;
        points[56] = 0.989442365133730931782183935022705793473255280023299343;
        points[57] = 0.995699640383245964687201823433448307661855776908591227;
        points[58] = 0.999183353909294683756424019504678184974225970330022709;
        weights[0] = 0.00209549228454122340270073148864005976798129321037713635;
        weights[1] = 0.00487223916826528476858200113292406855604266062886634061;
        weights[2] = 0.0076395294534875751427006829747543652575516412084065115;
        weights[3] = 0.0103858855009958621937978744109830403674448291493380061;
        weights[4] = 0.013103366306345191018319546484216966965564839234007091;
        weights[5] = 0.0157843473130814661473204803972491703730725538689579519;
        weights[6] = 0.0184213427536100293606157510564453183105268487171122401;
        weights[7] = 0.0210069982884371873504614732186692650506890277865110939;
        weights[8] = 0.0235341053937133634252753600783577002987844850383689152;
        weights[9] = 0.0259956197312985001866505068017079327139848097316180231;
        weights[10] = 0.0283846802005347979051528693353884987703141837630423358;
        weights[11] = 0.0306946278361116832397503281924808053595267480058283296;
        weights[12] = 0.0329190242710452777575112643535988080802698765574078253;
        weights[13] = 0.0350516696364001087837183589610782511167250811878572546;
        weights[14] = 0.0370866198188709226918379170352773582789499639491344915;
        weights[15] = 0.039018203016160009503030777211285513419091837939024417;
        weights[16] = 0.0408410355386867076602021080894693086860064759028936405;
        weights[17] = 0.0425500368110676386673082004847131274457234133459328312;
        weights[18] = 0.0441404435302973806907980847330809685891863326681307177;
        weights[19] = 0.0456078229405097698318682131583742114179944597204615576;
        weights[20] = 0.046948085186962019193159736482928952238545917474570698;
        weights[21] = 0.0481574947146064403881468292859357839604642187210079111;
        weights[22] = 0.0492326806793619857796936200150241883828630358705233273;
        weights[23] = 0.0501706463429969028107204304421656821438441057158682953;
        weights[24] = 0.0509687774253939168502479689936810100983096097852119893;
        weights[25] = 0.0516248493908914821464399397734228085937643377492687371;
        weights[26] = 0.0521370336483753913839872083078182338745975798794849498;
        weights[27] = 0.0525039026478287390509413220142884653607880584859075305;
        weights[28] = 0.052724433859127931961304248870612502871883937503544267;
        weights[29] = 0.0527980126219904214155123324308552672990156744026711684;
        weights[30] = 0.052724433859127931961304248870612502871883937503544267;
        weights[31] = 0.0525039026478287390509413220142884653607880584859075305;
        weights[32] = 0.0521370336483753913839872083078182338745975798794849498;
        weights[33] = 0.0516248493908914821464399397734228085937643377492687371;
        weights[34] = 0.0509687774253939168502479689936810100983096097852119893;
        weights[35] = 0.0501706463429969028107204304421656821438441057158682953;
        weights[36] = 0.0492326806793619857796936200150241883828630358705233273;
        weights[37] = 0.0481574947146064403881468292859357839604642187210079111;
        weights[38] = 0.046948085186962019193159736482928952238545917474570698;
        weights[39] = 0.0456078229405097698318682131583742114179944597204615576;
        weights[40] = 0.0441404435302973806907980847330809685891863326681307177;
        weights[41] = 0.0425500368110676386673082004847131274457234133459328312;
        weights[42] = 0.0408410355386867076602021080894693086860064759028936405;
        weights[43] = 0.039018203016160009503030777211285513419091837939024417;
        weights[44] = 0.0370866198188709226918379170352773582789499639491344915;
        weights[45] = 0.0350516696364001087837183589610782511167250811878572546;
        weights[46] = 0.0329190242710452777575112643535988080802698765574078253;
        weights[47] = 0.0306946278361116832397503281924808053595267480058283296;
        weights[48] = 0.0283846802005347979051528693353884987703141837630423358;
        weights[49] = 0.0259956197312985001866505068017079327139848097316180231;
        weights[50] = 0.0235341053937133634252753600783577002987844850383689152;
        weights[51] = 0.0210069982884371873504614732186692650506890277865110939;
        weights[52] = 0.0184213427536100293606157510564453183105268487171122401;
        weights[53] = 0.0157843473130814661473204803972491703730725538689579519;
        weights[54] = 0.013103366306345191018319546484216966965564839234007091;
        weights[55] = 0.0103858855009958621937978744109830403674448291493380061;
        weights[56] = 0.0076395294534875751427006829747543652575516412084065115;
        weights[57] = 0.00487223916826528476858200113292406855604266062886634061;
        weights[58] = 0.00209549228454122340270073148864005976798129321037713635;
        return;
    case 60:
        points[0] = -0.999210123227436022034229585797649266398798978711325671;
        points[1] = -0.995840525118838173876746713377440652774890294977139102;
        points[2] = -0.989787895222221717367278987016096042577393153786939041;
        points[3] = -0.981067201752598185618576799826770033880538579221891743;
        points[4] = -0.969701788765052733721544098913794272540934344868247072;
        points[5] = -0.95572225583999610739723184582969950248009374476661422;
        points[6] = -0.939166276116423249495419011609705096419403420401198032;
        points[7] = -0.92007847617762755285665686251989682878376887601370604;
        points[8] = -0.898510310810045941937789329572628330164458442747073825;
        points[9] = -0.874519922646898315129308099912435805159182294435782076;
        points[10] = -0.848171984785929632490515494994375601297528716506778197;
        points[11] = -0.81953752616214575936851810851972357189949051896959251;
        points[12] = -0.78869373993226405456994479977721573524633292787922762;
        points[13] = -0.755723775306585686868842066602373105928900199564707725;
        points[14] = -0.720716513355730399436021061013521077764773994733239043;
        points[15] = -0.68376632738135543722293023922429715908759460433887498;
        points[16] = -0.644972828489477067813447896420444717165190019346660996;
        points[17] = -0.604440597048510363444208776311201720650421053591059838;
        points[18] = -0.5622789007539445391782725874859987290631882376593954;
        points[19] = -0.518601400058569747417889348484721301329846676288685573;
        points[20] = -0.47352584176170711110816305375279463800786800509983689;
        points[21] = -0.42717374158307838930745285353031192335344213618423209;
        points[22] = -0.379670056576797977154952670521887704056374433162389866;
        points[23] = -0.331142848268448194252352965350552704800121496376311203;
        points[24] = -0.281722937423261691690694860339441598308263060795377424;
        points[25] = -0.231543551376029338010344631346755440743539051939585732;
        points[26] = -0.180739964873425417240876941261852631231772168639045493;
        points[27] = -0.129449135396945003146444164649575774759873524366472143;
        points[28] = -0.077809333949536569419285507082225287577594782897723955;
        points[29] = -0.0259597723012477985891703854003448256603147607172752255;
        points[30] = 0.0259597723012477985891703854003448256603147607172752255;
        points[31] = 0.077809333949536569419285507082225287577594782897723955;
        points[32] = 0.129449135396945003146444164649575774759873524366472143;
        points[33] = 0.180739964873425417240876941261852631231772168639045493;
        points[34] = 0.231543551376029338010344631346755440743539051939585732;
        points[35] = 0.281722937423261691690694860339441598308263060795377424;
        points[36] = 0.331142848268448194252352965350552704800121496376311203;
        points[37] = 0.379670056576797977154952670521887704056374433162389866;
        points[38] = 0.42717374158307838930745285353031192335344213618423209;
        points[39] = 0.47352584176170711110816305375279463800786800509983689;
        points[40] = 0.518601400058569747417889348484721301329846676288685573;
        points[41] = 0.5622789007539445391782725874859987290631882376593954;
        points[42] = 0.604440597048510363444208776311201720650421053591059838;
        points[43] = 0.644972828489477067813447896420444717165190019346660996;
        points[44] = 0.68376632738135543722293023922429715908759460433887498;
        points[45] = 0.720716513355730399436021061013521077764773994733239043;
        points[46] = 0.755723775306585686868842066602373105928900199564707725;
        points[47] = 0.78869373993226405456994479977721573524633292787922762;
        points[48] = 0.81953752616214575936851810851972357189949051896959251;
        points[49] = 0.848171984785929632490515494994375601297528716506778197;
        points[50] = 0.874519922646898315129308099912435805159182294435782076;
        points[51] = 0.898510310810045941937789329572628330164458442747073825;
        points[52] = 0.92007847617762755285665686251989682878376887601370604;
        points[53] = 0.939166276116423249495419011609705096419403420401198032;
        points[54] = 0.95572225583999610739723184582969950248009374476661422;
        points[55] = 0.969701788765052733721544098913794272540934344868247072;
        points[56] = 0.981067201752598185618576799826770033880538579221891743;
        points[57] = 0.989787895222221717367278987016096042577393153786939041;
        points[58] = 0.995840525118838173876746713377440652774890294977139102;
        points[59] = 0.999210123227436022034229585797649266398798978711325671;
        weights[0] = 0.00202681196887375849643171020989232469531166822555894991;
        weights[1] = 0.00471272992695356864089482171407723594808497019371506012;
        weights[2] = 0.00738993116334545553151695602208606088222818020622509209;
        weights[3] = 0.0100475571822879843578857643770572564996517474876773843;
        weights[4] = 0.0126781664768159601314953792695142349883383643026329456;
        weights[5] = 0.0152746185967847993067260380988253351779093841150728645;
        weights[6] = 0.0178299010142077202603962612483485676338592195833932469;
        weights[7] = 0.0203371207294572867750321474171063014620171125053439038;
        weights[8] = 0.0227895169439978198637834581929002078101673842152082582;
        weights[9] = 0.0251804776215212483795709659723612791317808329441895486;
        weights[10] = 0.0275035567499247916352231976386222476484034707541621773;
        weights[11] = 0.029752491500788945240836484673487710332475158124107232;
        weights[12] = 0.031921219019296328949458899536760476766697292282991421;
        weights[13] = 0.034003892724946422834914401555258741187276223552858876;
        weights[14] = 0.0359948980510845030665786462880623385942424200210035839;
        weights[15] = 0.0378888675692434440309407942092760318100842810638063715;
        weights[16] = 0.0396806954523807994701228348117100087628035112941742187;
        weights[17] = 0.0413655512355847556131638368066588968801870085215107142;
        weights[18] = 0.042938892835935641954231220656382806949211771964916479;
        weights[19] = 0.0443964787957871133277841640913773696638849857340142985;
        weights[20] = 0.0457343797161144866471964552909093330079349742586849544;
        weights[21] = 0.0469489888489122048470131563947015662755749025834444429;
        weights[22] = 0.0480370318199711809636666527287336536025000292469219569;
        weights[23] = 0.0489955754557568353894756868578942983575838959990902425;
        weights[24] = 0.0498220356905501810111592308937033124792155972437847697;
        weights[25] = 0.0505141845325093745982387357416536432399561627374166281;
        weights[26] = 0.0510701560698556274045491207344910353661970831136710547;
        weights[27] = 0.0514884515009809339950443971770543117339238266595808248;
        weights[28] = 0.0517679431749101875438036430288237329323469454992015641;
        weights[29] = 0.0519078776312206397328649383622696801801515955656409356;
        weights[30] = 0.0519078776312206397328649383622696801801515955656409356;
        weights[31] = 0.0517679431749101875438036430288237329323469454992015641;
        weights[32] = 0.0514884515009809339950443971770543117339238266595808248;
        weights[33] = 0.0510701560698556274045491207344910353661970831136710547;
        weights[34] = 0.0505141845325093745982387357416536432399561627374166281;
        weights[35] = 0.0498220356905501810111592308937033124792155972437847697;
        weights[36] = 0.0489955754557568353894756868578942983575838959990902425;
        weights[37] = 0.0480370318199711809636666527287336536025000292469219569;
        weights[38] = 0.0469489888489122048470131563947015662755749025834444429;
        weights[39] = 0.0457343797161144866471964552909093330079349742586849544;
        weights[40] = 0.0443964787957871133277841640913773696638849857340142985;
        weights[41] = 0.042938892835935641954231220656382806949211771964916479;
        weights[42] = 0.0413655512355847556131638368066588968801870085215107142;
        weights[43] = 0.0396806954523807994701228348117100087628035112941742187;
        weights[44] = 0.0378888675692434440309407942092760318100842810638063715;
        weights[45] = 0.0359948980510845030665786462880623385942424200210035839;
        weights[46] = 0.034003892724946422834914401555258741187276223552858876;
        weights[47] = 0.031921219019296328949458899536760476766697292282991421;
        weights[48] = 0.029752491500788945240836484673487710332475158124107232;
        weights[49] = 0.0275035567499247916352231976386222476484034707541621773;
        weights[50] = 0.0251804776215212483795709659723612791317808329441895486;
        weights[51] = 0.0227895169439978198637834581929002078101673842152082582;
        weights[52] = 0.0203371207294572867750321474171063014620171125053439038;
        weights[53] = 0.0178299010142077202603962612483485676338592195833932469;
        weights[54] = 0.0152746185967847993067260380988253351779093841150728645;
        weights[55] = 0.0126781664768159601314953792695142349883383643026329456;
        weights[56] = 0.0100475571822879843578857643770572564996517474876773843;
        weights[57] = 0.00738993116334545553151695602208606088222818020622509209;
        weights[58] = 0.00471272992695356864089482171407723594808497019371506012;
        weights[59] = 0.00202681196887375849643171020989232469531166822555894991;
        return;
    case 61:
        points[0] = -0.999235597631363471731862259569130862853442048503000831;
        points[1] = -0.995974599815120234268012760712288276286848864789131725;
        points[2] = -0.990116745232517050965531685699916501628756781176497313;
        points[3] = -0.981676011284037079685172540751319422160074062094926546;
        points[4] = -0.97067425883318290824740845354791027256833637675753032;
        points[5] = -0.95714015191298409137208028742121526110444034092702351;
        points[6] = -0.941108986681361147477543860977789008280474711058459422;
        points[7] = -0.922622581382955261257551500555845445450635161298717512;
        points[8] = -0.901729162474001170642040042683511164653117521087263577;
        points[9] = -0.878483237214881032478947513893352631459554520280417946;
        points[10] = -0.852945450847663445564846904674170538339953259984460132;
        points[11] = -0.825182428108659950664281892450847527006394659959583126;
        points[12] = -0.795266599282359649152048802752546264873236870205831179;
        points[13] = -0.763276011172312197145914668494350371044519151098621473;
        points[14] = -0.729294123449465109688956690135531798576371014538177349;
        points[15] = -0.69340959089449115549918436396023173728437756854618546;
        points[16] = -0.655716032095070871699185777836306887000847346441682259;
        points[17] = -0.616311785197921724709616859328591035895671683961232725;
        points[18] = -0.575299651350830618600369981944972878997331925337729135;
        points[19] = -0.532786626502925265638481716373071640324819910945474154;
        points[20] = -0.488883622262252118820698511425829597516530924724996168;
        points[21] = -0.443705176538531601995589301065822559382324637472238324;
        points[22] = -0.39736915472575660917829184736858922181287289269372192;
        points[23] = -0.349996442204066834533434477062093849787504617404883983;
        points[24] = -0.301710628963030712604486525456977125241197632870037328;
        points[25] = -0.252637687169053495833690863334405106227510747560059222;
        points[26] = -0.202905642518058499226947203343057054501439051858363433;
        points[27] = -0.152644240230815300529506761773477416883538976617459301;
        points[28] = -0.10198460656227406895720840476436564197678981705575171;
        points[29] = -0.0510589067079743493668875006189007980701842540412565385;
        points[30] = 0;
        points[31] = 0.0510589067079743493668875006189007980701842540412565385;
        points[32] = 0.10198460656227406895720840476436564197678981705575171;
        points[33] = 0.152644240230815300529506761773477416883538976617459301;
        points[34] = 0.202905642518058499226947203343057054501439051858363433;
        points[35] = 0.252637687169053495833690863334405106227510747560059222;
        points[36] = 0.301710628963030712604486525456977125241197632870037328;
        points[37] = 0.349996442204066834533434477062093849787504617404883983;
        points[38] = 0.39736915472575660917829184736858922181287289269372192;
        points[39] = 0.443705176538531601995589301065822559382324637472238324;
        points[40] = 0.488883622262252118820698511425829597516530924724996168;
        points[41] = 0.532786626502925265638481716373071640324819910945474154;
        points[42] = 0.575299651350830618600369981944972878997331925337729135;
        points[43] = 0.616311785197921724709616859328591035895671683961232725;
        points[44] = 0.655716032095070871699185777836306887000847346441682259;
        points[45] = 0.69340959089449115549918436396023173728437756854618546;
        points[46] = 0.729294123449465109688956690135531798576371014538177349;
        points[47] = 0.763276011172312197145914668494350371044519151098621473;
        points[48] = 0.795266599282359649152048802752546264873236870205831179;
        points[49] = 0.825182428108659950664281892450847527006394659959583126;
        points[50] = 0.852945450847663445564846904674170538339953259984460132;
        points[51] = 0.878483237214881032478947513893352631459554520280417946;
        points[52] = 0.901729162474001170642040042683511164653117521087263577;
        points[53] = 0.922622581382955261257551500555845445450635161298717512;
        points[54] = 0.941108986681361147477543860977789008280474711058459422;
        points[55] = 0.95714015191298409137208028742121526110444034092702351;
        points[56] = 0.97067425883318290824740845354791027256833637675753032;
        points[57] = 0.981676011284037079685172540751319422160074062094926546;
        points[58] = 0.990116745232517050965531685699916501628756781176497313;
        points[59] = 0.995974599815120234268012760712288276286848864789131725;
        points[60] = 0.999235597631363471731862259569130862853442048503000831;
        weights[0] = 0.00196145336167028267177306446192684809414929406187149776;
        weights[1] = 0.00456092400601241718453893257974278827081304337831533151;
        weights[2] = 0.00715235499174908958583399309169417557127328166702841504;
        weights[3] = 0.00972546183035613373613667175557011832684334637992202658;
        weights[4] = 0.0122732635078121046292778003595261313544926604914256755;
        weights[5] = 0.0147890658849379145461785157814882612603715285337802068;
        weights[6] = 0.0172662929876137435944332127724366211841880545205192719;
        weights[7] = 0.019698477746101181330517830212684566665796636136043834;
        weights[8] = 0.0220792731483190440024757656281816274361721240829312286;
        weights[9] = 0.0244024671875442029153406597324675323257701985040236008;
        weights[10] = 0.0266619985241508896628107068449680195640554191241206074;
        weights[11] = 0.0288519720881834015043417755455902525435071199346938874;
        weights[12] = 0.0309666743683973948246979466124893837667092710275253843;
        weights[13] = 0.0330005882759074106327236834410044928074089398081505862;
        weights[14] = 0.0349484075165333510908519192092192782550094709415075836;
        weights[15] = 0.0368050504231548173843210428640674608759007235916177133;
        weights[16] = 0.0385656732070081727461520476296538028292229332149573981;
        weights[17] = 0.0402256825909982473676399837575115791559285285247384514;
        weights[18] = 0.0417807477908884920666755723510730075126973740835647877;
        weights[19] = 0.0432268118124960979010436458226828733502967443538131357;
        weights[20] = 0.0445601020350834882715414198310883529333563351947651631;
        weights[21] = 0.045777140053145959371339833846824791961534814552092104;
        weights[22] = 0.0468747507508090659764294455885907359337142723543964814;
        weights[23] = 0.0478500705850956071618334275186996627134012529702368159;
        weights[24] = 0.0487005550564115260875300883147056067586983721814505763;
        weights[25] = 0.0494239853467355899399687766511164994166596566677484811;
        weights[26] = 0.050018474108178253425051615006358625442055919236672434;
        weights[27] = 0.0504824703867974046481444651881512691728991520000886696;
        weights[28] = 0.0508147636688183432077005292234786973478423438565676647;
        weights[29] = 0.0510144870386972635437350805738520107682023754233863468;
        weights[30] = 0.0510811194407862179779210956063098528020576264040892788;
        weights[31] = 0.0510144870386972635437350805738520107682023754233863468;
        weights[32] = 0.0508147636688183432077005292234786973478423438565676647;
        weights[33] = 0.0504824703867974046481444651881512691728991520000886696;
        weights[34] = 0.050018474108178253425051615006358625442055919236672434;
        weights[35] = 0.0494239853467355899399687766511164994166596566677484811;
        weights[36] = 0.0487005550564115260875300883147056067586983721814505763;
        weights[37] = 0.0478500705850956071618334275186996627134012529702368159;
        weights[38] = 0.0468747507508090659764294455885907359337142723543964814;
        weights[39] = 0.045777140053145959371339833846824791961534814552092104;
        weights[40] = 0.0445601020350834882715414198310883529333563351947651631;
        weights[41] = 0.0432268118124960979010436458226828733502967443538131357;
        weights[42] = 0.0417807477908884920666755723510730075126973740835647877;
        weights[43] = 0.0402256825909982473676399837575115791559285285247384514;
        weights[44] = 0.0385656732070081727461520476296538028292229332149573981;
        weights[45] = 0.0368050504231548173843210428640674608759007235916177133;
        weights[46] = 0.0349484075165333510908519192092192782550094709415075836;
        weights[47] = 0.0330005882759074106327236834410044928074089398081505862;
        weights[48] = 0.0309666743683973948246979466124893837667092710275253843;
        weights[49] = 0.0288519720881834015043417755455902525435071199346938874;
        weights[50] = 0.0266619985241508896628107068449680195640554191241206074;
        weights[51] = 0.0244024671875442029153406597324675323257701985040236008;
        weights[52] = 0.0220792731483190440024757656281816274361721240829312286;
        weights[53] = 0.019698477746101181330517830212684566665796636136043834;
        weights[54] = 0.0172662929876137435944332127724366211841880545205192719;
        weights[55] = 0.0147890658849379145461785157814882612603715285337802068;
        weights[56] = 0.0122732635078121046292778003595261313544926604914256755;
        weights[57] = 0.00972546183035613373613667175557011832684334637992202658;
        weights[58] = 0.00715235499174908958583399309169417557127328166702841504;
        weights[59] = 0.00456092400601241718453893257974278827081304337831533151;
        weights[60] = 0.00196145336167028267177306446192684809414929406187149776;
        return;
    case 62:
        points[0] = -0.999259859308777029698408465035798938019634460510221853;
        points[1] = -0.996102296316267132885148430476171492632140217279841958;
        points[2] = -0.99042997118929035242807106186068064500231531367714058;
        points[3] = -0.982255949097236649491103128009792471563001203053950845;
        points[4] = -0.971600723371651806447179482540305835154160553929264677;
        points[5] = -0.958491172973927092029560475165970943317106647782847211;
        points[6] = -0.942960401392328503826364811623351587241418158740212175;
        points[7] = -0.925047635636203755227300130757048619448630524042658125;
        points[8] = -0.904798122521093465758485602428375624398449892610323052;
        points[9] = -0.88226301283189736307268662435582975601712579191938624;
        points[10] = -0.857499231512070922818403320544675506891508937511621746;
        points[11] = -0.830569333604004851345931109477208222919811239495206516;
        points[12] = -0.801541346103976371538505514495386347306189483107850394;
        points[13] = -0.770488596055419318990944694995048188453809265505423986;
        points[14] = -0.737489525283156749860784276501439460280103435631180086;
        points[15] = -0.702627492222297055120972765059986723144031285289579655;
        points[16] = -0.665990561335479446997546034082388079933208584475695868;
        points[17] = -0.627671280646885180726954764916162788587208438303692503;
        points[18] = -0.587766447953087338002149550121987763858197496847643018;
        points[19] = -0.546376866300251095816100384523633707232171091578385675;
        points[20] = -0.503607089344755955917020805931616276965841967296053744;
        points[21] = -0.459565157240113395207143978075752651418602087013646598;
        points[22] = -0.414362323717126048129588750657611345135889299571842248;
        points[23] = -0.368112775046564529663021830952507922017235455535164745;
        points[24] = -0.320933341594194004074101601003456385085858702159362965;
        points[25] = -0.272943202696726343188683627973480980854861620343509936;
        points[26] = -0.224263585604165531668991393344882700608965256717494693;
        points[27] = -0.17501745924901562855568742390423603170050770944644704;
        points[28] = -0.125329223615896808619648999499726257796755400789475805;
        points[29] = -0.0753243954962343327638269391178708775768458123144207998;
        points[30] = -0.025129291421820614727088275999146962314504918024814949;
        points[31] = 0.025129291421820614727088275999146962314504918024814949;
        points[32] = 0.0753243954962343327638269391178708775768458123144207998;
        points[33] = 0.125329223615896808619648999499726257796755400789475805;
        points[34] = 0.17501745924901562855568742390423603170050770944644704;
        points[35] = 0.224263585604165531668991393344882700608965256717494693;
        points[36] = 0.272943202696726343188683627973480980854861620343509936;
        points[37] = 0.320933341594194004074101601003456385085858702159362965;
        points[38] = 0.368112775046564529663021830952507922017235455535164745;
        points[39] = 0.414362323717126048129588750657611345135889299571842248;
        points[40] = 0.459565157240113395207143978075752651418602087013646598;
        points[41] = 0.503607089344755955917020805931616276965841967296053744;
        points[42] = 0.546376866300251095816100384523633707232171091578385675;
        points[43] = 0.587766447953087338002149550121987763858197496847643018;
        points[44] = 0.627671280646885180726954764916162788587208438303692503;
        points[45] = 0.665990561335479446997546034082388079933208584475695868;
        points[46] = 0.702627492222297055120972765059986723144031285289579655;
        points[47] = 0.737489525283156749860784276501439460280103435631180086;
        points[48] = 0.770488596055419318990944694995048188453809265505423986;
        points[49] = 0.801541346103976371538505514495386347306189483107850394;
        points[50] = 0.830569333604004851345931109477208222919811239495206516;
        points[51] = 0.857499231512070922818403320544675506891508937511621746;
        points[52] = 0.88226301283189736307268662435582975601712579191938624;
        points[53] = 0.904798122521093465758485602428375624398449892610323052;
        points[54] = 0.925047635636203755227300130757048619448630524042658125;
        points[55] = 0.942960401392328503826364811623351587241418158740212175;
        points[56] = 0.958491172973927092029560475165970943317106647782847211;
        points[57] = 0.971600723371651806447179482540305835154160553929264677;
        points[58] = 0.982255949097236649491103128009792471563001203053950845;
        points[59] = 0.99042997118929035242807106186068064500231531367714058;
        points[60] = 0.996102296316267132885148430476171492632140217279841958;
        points[61] = 0.999259859308777029698408465035798938019634460510221853;
        weights[0] = 0.00189920567951369048039734386093514017087884977236897663;
        weights[1] = 0.00441633345693090481327412425549064072971198213049489617;
        weights[2] = 0.00692604190183096087170282409925706711954721309845612182;
        weights[3] = 0.00941857942842038763793756340656642815543364295156699935;
        weights[4] = 0.0118873901170105019448189389667979365274285962699907244;
        weights[5] = 0.0143261918238065177674028823094145960770999460756654786;
        weights[6] = 0.0167288117901773162885504717840924583631319372334291324;
        weights[7] = 0.0190891766585731987325037124822838057744426750473217115;
        weights[8] = 0.0214013222776699688411790899649052776408375205805733304;
        weights[9] = 0.0236594072086827925745168006505345647014315294308404535;
        weights[10] = 0.0258577269540246980270955665535105155948598700257474233;
        weights[11] = 0.0279907281633146375412382927540413048736838088959792964;
        weights[12] = 0.0300530225739898700770094692270623794862287815545353735;
        weights[13] = 0.0320394005816246781063392372781563731304930348629342626;
        weights[14] = 0.0339448443794105450911174772542360577864065417327114703;
        weights[15] = 0.0357645406227681412855873783617220425845980677311738019;
        weights[16] = 0.0374938925822800299856185635187930282343318531675349904;
        weights[17] = 0.0391285317519630841233108018226088606261799149434694791;
        weights[18] = 0.0406643288824174409682850175166634173129867186716685745;
        weights[19] = 0.0420974044103850966430226269038388460100870864191350467;
        weights[20] = 0.0434241382580474195800692304339443041957713299146806061;
        weights[21] = 0.0446411789771244142936446918091377844103487557080767163;
        weights[22] = 0.0457454522145701807772322722976961876704039463776258646;
        weights[23] = 0.0467341684784155248022070550794847787621597834290144551;
        weights[24] = 0.0476048301841012322704500882678663730607374180494971446;
        weights[25] = 0.0483552379634776728348031814784589867622005024623890562;
        weights[26] = 0.0489834962205178371048511270262173725653489027963997494;
        weights[27] = 0.0494880179196992925278658109047740184636337882109571078;
        weights[28] = 0.0498675285949523942447613106348428168881959590452746142;
        weights[29] = 0.050121069569043288074804100101530968004895319933921361;
        weights[30] = 0.0502480003752562816884029489951356683165047234765657809;
        weights[31] = 0.0502480003752562816884029489951356683165047234765657809;
        weights[32] = 0.050121069569043288074804100101530968004895319933921361;
        weights[33] = 0.0498675285949523942447613106348428168881959590452746142;
        weights[34] = 0.0494880179196992925278658109047740184636337882109571078;
        weights[35] = 0.0489834962205178371048511270262173725653489027963997494;
        weights[36] = 0.0483552379634776728348031814784589867622005024623890562;
        weights[37] = 0.0476048301841012322704500882678663730607374180494971446;
        weights[38] = 0.0467341684784155248022070550794847787621597834290144551;
        weights[39] = 0.0457454522145701807772322722976961876704039463776258646;
        weights[40] = 0.0446411789771244142936446918091377844103487557080767163;
        weights[41] = 0.0434241382580474195800692304339443041957713299146806061;
        weights[42] = 0.0420974044103850966430226269038388460100870864191350467;
        weights[43] = 0.0406643288824174409682850175166634173129867186716685745;
        weights[44] = 0.0391285317519630841233108018226088606261799149434694791;
        weights[45] = 0.0374938925822800299856185635187930282343318531675349904;
        weights[46] = 0.0357645406227681412855873783617220425845980677311738019;
        weights[47] = 0.0339448443794105450911174772542360577864065417327114703;
        weights[48] = 0.0320394005816246781063392372781563731304930348629342626;
        weights[49] = 0.0300530225739898700770094692270623794862287815545353735;
        weights[50] = 0.0279907281633146375412382927540413048736838088959792964;
        weights[51] = 0.0258577269540246980270955665535105155948598700257474233;
        weights[52] = 0.0236594072086827925745168006505345647014315294308404535;
        weights[53] = 0.0214013222776699688411790899649052776408375205805733304;
        weights[54] = 0.0190891766585731987325037124822838057744426750473217115;
        weights[55] = 0.0167288117901773162885504717840924583631319372334291324;
        weights[56] = 0.0143261918238065177674028823094145960770999460756654786;
        weights[57] = 0.0118873901170105019448189389667979365274285962699907244;
        weights[58] = 0.00941857942842038763793756340656642815543364295156699935;
        weights[59] = 0.00692604190183096087170282409925706711954721309845612182;
        weights[60] = 0.00441633345693090481327412425549064072971198213049489617;
        weights[61] = 0.00189920567951369048039734386093514017087884977236897663;
        return;
    case 63:
        points[0] = -0.999282984029123780378936140928944461072796718186242813;
        points[1] = -0.996224012777970108602193361146311353293076971857523298;
        points[2] = -0.99072854689218946681089466720470345305426226535032778;
        points[3] = -0.982808810593727234862511405691611739202599161956207342;
        points[4] = -0.972484034697570022801960678576810948164976541203097838;
        points[5] = -0.959779449758941927070354166258988969165416503161655427;
        points[6] = -0.944726134041009802966375319627500663744580688957766982;
        points[7] = -0.927360920621843205447031381325121569456054361068601918;
        points[8] = -0.907726302778531558036953132915953225547793928275658208;
        points[9] = -0.885870328507853426290298457313369875149868469487853717;
        points[10] = -0.861846482364123719539611839431059953996536225216268314;
        points[11] = -0.835713554319502843471807769615705452823614477583885981;
        points[12] = -0.8075354957734567600514659863632431345941923607774963;
        points[13] = -0.777381262990372335563330189911042755759799142048102003;
        points[14] = -0.745324648317847417829321661037587632314602947261940726;
        points[15] = -0.711444099584845807851431537704014879128282511787012492;
        points[16] = -0.675822528114986090131103315969544508779811254723799706;
        points[17] = -0.63854710582136538500030695387337648123329492461318164;
        points[18] = -0.599709051877625235739008926868799861071169523997529146;
        points[19] = -0.559403409486285013267697800070054696540528415606657527;
        points[20] = -0.51772881329003324812447758452631553557737395502174835;
        points[21] = -0.47478724799480439992221230985149474928601795896973317;
        points[22] = -0.430683798795111600662088933918629982066481417200037325;
        points[23] = -0.385526394212247892477615022274398150275045705437133427;
        points[24] = -0.339425541974584402468834431594315085043918046718704485;
        points[25] = -0.29249405858625144003615715555066692368934587193884237;
        points[26] = -0.244846793245953362748404593924829370148342175358214833;
        points[27] = -0.19660034679150668455762745706571769792078300580349276;
        points[28] = -0.147872786357871968569839096552972943441463664083963029;
        points[29] = -0.0987833564469452795297036694539221034395586011789432173;
        points[30] = -0.0494521871161596272342338180518076098977554568999159461;
        points[31] = 0;
        points[32] = 0.0494521871161596272342338180518076098977554568999159461;
        points[33] = 0.0987833564469452795297036694539221034395586011789432173;
        points[34] = 0.147872786357871968569839096552972943441463664083963029;
        points[35] = 0.19660034679150668455762745706571769792078300580349276;
        points[36] = 0.244846793245953362748404593924829370148342175358214833;
        points[37] = 0.29249405858625144003615715555066692368934587193884237;
        points[38] = 0.339425541974584402468834431594315085043918046718704485;
        points[39] = 0.385526394212247892477615022274398150275045705437133427;
        points[40] = 0.430683798795111600662088933918629982066481417200037325;
        points[41] = 0.47478724799480439992221230985149474928601795896973317;
        points[42] = 0.51772881329003324812447758452631553557737395502174835;
        points[43] = 0.559403409486285013267697800070054696540528415606657527;
        points[44] = 0.599709051877625235739008926868799861071169523997529146;
        points[45] = 0.63854710582136538500030695387337648123329492461318164;
        points[46] = 0.675822528114986090131103315969544508779811254723799706;
        points[47] = 0.711444099584845807851431537704014879128282511787012492;
        points[48] = 0.745324648317847417829321661037587632314602947261940726;
        points[49] = 0.777381262990372335563330189911042755759799142048102003;
        points[50] = 0.8075354957734567600514659863632431345941923607774963;
        points[51] = 0.835713554319502843471807769615705452823614477583885981;
        points[52] = 0.861846482364123719539611839431059953996536225216268314;
        points[53] = 0.885870328507853426290298457313369875149868469487853717;
        points[54] = 0.907726302778531558036953132915953225547793928275658208;
        points[55] = 0.927360920621843205447031381325121569456054361068601918;
        points[56] = 0.944726134041009802966375319627500663744580688957766982;
        points[57] = 0.959779449758941927070354166258988969165416503161655427;
        points[58] = 0.972484034697570022801960678576810948164976541203097838;
        points[59] = 0.982808810593727234862511405691611739202599161956207342;
        points[60] = 0.99072854689218946681089466720470345305426226535032778;
        points[61] = 0.996224012777970108602193361146311353293076971857523298;
        points[62] = 0.999282984029123780378936140928944461072796718186242813;
        weights[0] = 0.00183987459557708411709244555404392385263847233884024248;
        weights[1] = 0.0042785083468637618660784110826227855171274726708752114;
        weights[2] = 0.00671029176596013625190693072972880397343602855571611024;
        weights[3] = 0.00912596867632665635405864542175995484969241778837534967;
        weights[4] = 0.0115193760768800417507506061486180648415887939453889832;
        weights[5] = 0.0138846126161156108248660863676244349192776582534906475;
        weights[6] = 0.016215878410338338882283672975130914915815603829930901;
        weights[7] = 0.0185074644601612704092605458051579631102389214176312854;
        weights[8] = 0.0207537612580390907753419534214731533478132648784418211;
        weights[9] = 0.0229492710048899331489423195617705058910474999190868284;
        weights[10] = 0.0250886205533449866186301380684433561023538074476335724;
        weights[11] = 0.0271665743590979332251898394394127266066426839866291275;
        weights[12] = 0.0291780472082805269455515021540288022829409459208054268;
        weights[13] = 0.0311181166222198175082159885571885820249111895329151127;
        weights[14] = 0.0329820348837793417656831796724593071377942161572778556;
        weights[15] = 0.0347652406453558776971805046427881571070733024941471943;
        weights[16] = 0.0364633700854572896304524097875417918318329502542965112;
        weights[17] = 0.0380722675843495567636383249278892186273033572541754295;
        weights[18] = 0.0395879958915440939848079281492023644541949391141024388;
        weights[19] = 0.0410068457596663986351100370090723507401779662124993039;
        weights[20] = 0.0423253450208158229825054854030274564828433789141963751;
        weights[21] = 0.0435402670830275907989643157044011396409312119283805381;
        weights[22] = 0.0446486388259413953703326695168133932341005635625203337;
        weights[23] = 0.0456477478762926086858859926085425224266073239389639298;
        weights[24] = 0.0465351492453836965103954187469531872278224771737984217;
        weights[25] = 0.0473086713122689190806049883388440623866200019726457181;
        weights[26] = 0.0479664211379951314110527561951322536106849214321465806;
        weights[27] = 0.048506789097883847864090099145801582027591769247826655;
        weights[28] = 0.0489284528205119899447093615492148212325258099816152682;
        weights[29] = 0.0492303804237475607850431169881445875918765328199142233;
        weights[30] = 0.0494118330399181789670396461167048596977283900845409696;
        weights[31] = 0.0494723666239310208886693604209259446135322539423832672;
        weights[32] = 0.0494118330399181789670396461167048596977283900845409696;
        weights[33] = 0.0492303804237475607850431169881445875918765328199142233;
        weights[34] = 0.0489284528205119899447093615492148212325258099816152682;
        weights[35] = 0.048506789097883847864090099145801582027591769247826655;
        weights[36] = 0.0479664211379951314110527561951322536106849214321465806;
        weights[37] = 0.0473086713122689190806049883388440623866200019726457181;
        weights[38] = 0.0465351492453836965103954187469531872278224771737984217;
        weights[39] = 0.0456477478762926086858859926085425224266073239389639298;
        weights[40] = 0.0446486388259413953703326695168133932341005635625203337;
        weights[41] = 0.0435402670830275907989643157044011396409312119283805381;
        weights[42] = 0.0423253450208158229825054854030274564828433789141963751;
        weights[43] = 0.0410068457596663986351100370090723507401779662124993039;
        weights[44] = 0.0395879958915440939848079281492023644541949391141024388;
        weights[45] = 0.0380722675843495567636383249278892186273033572541754295;
        weights[46] = 0.0364633700854572896304524097875417918318329502542965112;
        weights[47] = 0.0347652406453558776971805046427881571070733024941471943;
        weights[48] = 0.0329820348837793417656831796724593071377942161572778556;
        weights[49] = 0.0311181166222198175082159885571885820249111895329151127;
        weights[50] = 0.0291780472082805269455515021540288022829409459208054268;
        weights[51] = 0.0271665743590979332251898394394127266066426839866291275;
        weights[52] = 0.0250886205533449866186301380684433561023538074476335724;
        weights[53] = 0.0229492710048899331489423195617705058910474999190868284;
        weights[54] = 0.0207537612580390907753419534214731533478132648784418211;
        weights[55] = 0.0185074644601612704092605458051579631102389214176312854;
        weights[56] = 0.016215878410338338882283672975130914915815603829930901;
        weights[57] = 0.0138846126161156108248660863676244349192776582534906475;
        weights[58] = 0.0115193760768800417507506061486180648415887939453889832;
        weights[59] = 0.00912596867632665635405864542175995484969241778837534967;
        weights[60] = 0.00671029176596013625190693072972880397343602855571611024;
        weights[61] = 0.0042785083468637618660784110826227855171274726708752114;
        weights[62] = 0.00183987459557708411709244555404392385263847233884024248;
        return;
    case 64:
        points[0] = -0.999305041735772139456905624345636311969712191675608776;
        points[1] = -0.996340116771955279346924500676399123209857506340226612;
        points[2] = -0.991013371476744320739382383443303113641349445390790485;
        points[3] = -0.983336253884625956931299302156831116945247506623740384;
        points[4] = -0.973326827789910963741853507352272668026145294455174176;
        points[5] = -0.961008799652053718918614121897157206762114611037845949;
        points[6] = -0.94641137485840281606248149134726479527939497179523319;
        points[7] = -0.929569172131939575821490154559225607347427014429715498;
        points[8] = -0.910522137078502805756380668008329861013488084888364029;
        points[9] = -0.889315445995114105853404038272851622429194461510452189;
        points[10] = -0.865999398154092819760783385070157502412501918758249643;
        points[11] = -0.840629296252580362751691544695873302982489823801755354;
        points[12] = -0.813265315122797559741923338086303340698141822565597217;
        points[13] = -0.783972358943341407610220525213768284056414124989825933;
        points[14] = -0.752819907260531896611863774885693985551714271322087193;
        points[15] = -0.719881850171610826848940217831947244758138003314901953;
        points[16] = -0.685236313054233242563558371031376301935641078539671868;
        points[17] = -0.648965471254657339857761231993404885529690433473201173;
        points[18] = -0.611155355172393250248852971018548918696124559307971844;
        points[19] = -0.571895646202634034283878116659188643183191006091250993;
        points[20] = -0.531279464019894545658013903544455247408525588734180238;
        points[21] = -0.489403145707052957478526307021921390849373297463739837;
        points[22] = -0.446366017253464087984947714758915189206750757826250176;
        points[23] = -0.402270157963991603695766771260158848713265205615020808;
        points[24] = -0.357220158337668115950442615046202531626264464640909112;
        points[25] = -0.311322871990210956157512698560156883557715357868050127;
        points[26] = -0.264687162208767416373964172510020117980413136295093244;
        points[27] = -0.217423643740007084149648748988822617578485831141222349;
        points[28] = -0.169644420423992818037313629748269844199990266734377851;
        points[29] = -0.121462819296120554470376463492247878218683638337191294;
        points[30] = -0.0729931217877990394495429419403374932441261816687788534;
        points[31] = -0.0243502926634244325089558428537156614268871093149758092;
        points[32] = 0.0243502926634244325089558428537156614268871093149758092;
        points[33] = 0.0729931217877990394495429419403374932441261816687788534;
        points[34] = 0.121462819296120554470376463492247878218683638337191294;
        points[35] = 0.169644420423992818037313629748269844199990266734377851;
        points[36] = 0.217423643740007084149648748988822617578485831141222349;
        points[37] = 0.264687162208767416373964172510020117980413136295093244;
        points[38] = 0.311322871990210956157512698560156883557715357868050127;
        points[39] = 0.357220158337668115950442615046202531626264464640909112;
        points[40] = 0.402270157963991603695766771260158848713265205615020808;
        points[41] = 0.446366017253464087984947714758915189206750757826250176;
        points[42] = 0.489403145707052957478526307021921390849373297463739837;
        points[43] = 0.531279464019894545658013903544455247408525588734180238;
        points[44] = 0.571895646202634034283878116659188643183191006091250993;
        points[45] = 0.611155355172393250248852971018548918696124559307971844;
        points[46] = 0.648965471254657339857761231993404885529690433473201173;
        points[47] = 0.685236313054233242563558371031376301935641078539671868;
        points[48] = 0.719881850171610826848940217831947244758138003314901953;
        points[49] = 0.752819907260531896611863774885693985551714271322087193;
        points[50] = 0.783972358943341407610220525213768284056414124989825933;
        points[51] = 0.813265315122797559741923338086303340698141822565597217;
        points[52] = 0.840629296252580362751691544695873302982489823801755354;
        points[53] = 0.865999398154092819760783385070157502412501918758249643;
        points[54] = 0.889315445995114105853404038272851622429194461510452189;
        points[55] = 0.910522137078502805756380668008329861013488084888364029;
        points[56] = 0.929569172131939575821490154559225607347427014429715498;
        points[57] = 0.94641137485840281606248149134726479527939497179523319;
        points[58] = 0.961008799652053718918614121897157206762114611037845949;
        points[59] = 0.973326827789910963741853507352272668026145294455174176;
        points[60] = 0.983336253884625956931299302156831116945247506623740384;
        points[61] = 0.991013371476744320739382383443303113641349445390790485;
        points[62] = 0.996340116771955279346924500676399123209857506340226612;
        points[63] = 0.999305041735772139456905624345636311969712191675608776;
        weights[0] = 0.00178328072169643294729607914497193317995934727192795567;
        weights[1] = 0.00414703326056246763528753572855141531330281925368480246;
        weights[2] = 0.0065044579689783628561173603999812667711317610549523401;
        weights[3] = 0.0088467598263639477230309146597306476951762660792204998;
        weights[4] = 0.0111681394601311288185904930192081350727787978168272872;
        weights[5] = 0.0134630478967186425980607666859556841084257719773496708;
        weights[6] = 0.0157260304760247193219659952975397944260290098431565122;
        weights[7] = 0.0179517157756973430850453020011193688971673570364158573;
        weights[8] = 0.0201348231535302093723403167285438970895266801007919519;
        weights[9] = 0.0222701738083832541592983303841550024229592905997594051;
        weights[10] = 0.024352702568710873338177550409068987649978415513378412;
        weights[11] = 0.0263774697150546586716917926252251856755993308422457184;
        weights[12] = 0.028339672614259483227511305200237351981207584125754336;
        weights[13] = 0.0302346570724024788679740598195486591582813977684812416;
        weights[14] = 0.0320579283548515535854675043478987169662215738813980623;
        weights[15] = 0.0338051618371416093915654821107254310210499263140045347;
        weights[16] = 0.0354722132568823838106931467152459479480946310024100947;
        weights[17] = 0.0370551285402400460404151018095833750834649453056563022;
        weights[18] = 0.038550153178615629128962496946808991012787112201718032;
        weights[19] = 0.0399537411327203413866569261283360739186769506703336301;
        weights[20] = 0.0412625632426235286101562974736380477399306355305474105;
        weights[21] = 0.0424735151236535890073397679088173661655466481806496697;
        weights[22] = 0.0435837245293234533768278609737374809227888974971180151;
        weights[23] = 0.0445905581637565630601347100309448432940237999912217256;
        weights[24] = 0.0454916279274181444797709969712690588873234618023998968;
        weights[25] = 0.0462847965813144172959532492322611849696503075324468008;
        weights[26] = 0.046968182816210017325326285754581075199897528473812565;
        weights[27] = 0.0475401657148303086622822069442231716408252512625387522;
        weights[28] = 0.0479993885964583077281261798713460699543167134714936209;
        weights[29] = 0.0483447622348029571697695271580178097036925506095010806;
        weights[30] = 0.0485754674415034269347990667839781136875565447049294857;
        weights[31] = 0.0486909570091397203833653907347499124426286922838743305;
        weights[32] = 0.0486909570091397203833653907347499124426286922838743305;
        weights[33] = 0.0485754674415034269347990667839781136875565447049294857;
        weights[34] = 0.0483447622348029571697695271580178097036925506095010806;
        weights[35] = 0.0479993885964583077281261798713460699543167134714936209;
        weights[36] = 0.0475401657148303086622822069442231716408252512625387522;
        weights[37] = 0.046968182816210017325326285754581075199897528473812565;
        weights[38] = 0.0462847965813144172959532492322611849696503075324468008;
        weights[39] = 0.0454916279274181444797709969712690588873234618023998968;
        weights[40] = 0.0445905581637565630601347100309448432940237999912217256;
        weights[41] = 0.0435837245293234533768278609737374809227888974971180151;
        weights[42] = 0.0424735151236535890073397679088173661655466481806496697;
        weights[43] = 0.0412625632426235286101562974736380477399306355305474105;
        weights[44] = 0.0399537411327203413866569261283360739186769506703336301;
        weights[45] = 0.038550153178615629128962496946808991012787112201718032;
        weights[46] = 0.0370551285402400460404151018095833750834649453056563022;
        weights[47] = 0.0354722132568823838106931467152459479480946310024100947;
        weights[48] = 0.0338051618371416093915654821107254310210499263140045347;
        weights[49] = 0.0320579283548515535854675043478987169662215738813980623;
        weights[50] = 0.0302346570724024788679740598195486591582813977684812416;
        weights[51] = 0.028339672614259483227511305200237351981207584125754336;
        weights[52] = 0.0263774697150546586716917926252251856755993308422457184;
        weights[53] = 0.024352702568710873338177550409068987649978415513378412;
        weights[54] = 0.0222701738083832541592983303841550024229592905997594051;
        weights[55] = 0.0201348231535302093723403167285438970895266801007919519;
        weights[56] = 0.0179517157756973430850453020011193688971673570364158573;
        weights[57] = 0.0157260304760247193219659952975397944260290098431565122;
        weights[58] = 0.0134630478967186425980607666859556841084257719773496708;
        weights[59] = 0.0111681394601311288185904930192081350727787978168272872;
        weights[60] = 0.0088467598263639477230309146597306476951762660792204998;
        weights[61] = 0.0065044579689783628561173603999812667711317610549523401;
        weights[62] = 0.00414703326056246763528753572855141531330281925368480246;
        weights[63] = 0.00178328072169643294729607914497193317995934727192795567;
        return;
    }
}
