# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClientArgs', 'Client']

@pulumi.input_type
class ClientArgs:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input['ClientAddonsArgs']] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input['ClientJwtConfigurationArgs']] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input['ClientMobileArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input['ClientNativeSocialLoginArgs']] = None,
                 oidc_backchannel_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input['ClientRefreshTokenArgs']] = None,
                 require_pushed_authorization_requests: Optional[pulumi.Input[bool]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Client resource.
        :param pulumi.Input['ClientAddonsArgs'] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI. Must be HTTPS or an empty string.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        :param pulumi.Input['ClientJwtConfigurationArgs'] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input['ClientMobileArgs'] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input['ClientNativeSocialLoginArgs'] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_backchannel_logout_urls: Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input['ClientRefreshTokenArgs'] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[bool] require_pushed_authorization_requests: Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if callbacks is not None:
            pulumi.set(__self__, "callbacks", callbacks)
        if client_aliases is not None:
            pulumi.set(__self__, "client_aliases", client_aliases)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if cross_origin_auth is not None:
            pulumi.set(__self__, "cross_origin_auth", cross_origin_auth)
        if cross_origin_loc is not None:
            pulumi.set(__self__, "cross_origin_loc", cross_origin_loc)
        if custom_login_page is not None:
            pulumi.set(__self__, "custom_login_page", custom_login_page)
        if custom_login_page_on is not None:
            pulumi.set(__self__, "custom_login_page_on", custom_login_page_on)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if form_template is not None:
            pulumi.set(__self__, "form_template", form_template)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if initiate_login_uri is not None:
            pulumi.set(__self__, "initiate_login_uri", initiate_login_uri)
        if is_first_party is not None:
            pulumi.set(__self__, "is_first_party", is_first_party)
        if is_token_endpoint_ip_header_trusted is not None:
            pulumi.set(__self__, "is_token_endpoint_ip_header_trusted", is_token_endpoint_ip_header_trusted)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_social_login is not None:
            pulumi.set(__self__, "native_social_login", native_social_login)
        if oidc_backchannel_logout_urls is not None:
            pulumi.set(__self__, "oidc_backchannel_logout_urls", oidc_backchannel_logout_urls)
        if oidc_conformant is not None:
            pulumi.set(__self__, "oidc_conformant", oidc_conformant)
        if organization_require_behavior is not None:
            pulumi.set(__self__, "organization_require_behavior", organization_require_behavior)
        if organization_usage is not None:
            pulumi.set(__self__, "organization_usage", organization_usage)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if require_pushed_authorization_requests is not None:
            pulumi.set(__self__, "require_pushed_authorization_requests", require_pushed_authorization_requests)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if sso_disabled is not None:
            pulumi.set(__self__, "sso_disabled", sso_disabled)
        if web_origins is not None:
            pulumi.set(__self__, "web_origins", web_origins)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input['ClientAddonsArgs']]:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input['ClientAddonsArgs']]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter
    def callbacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @callbacks.setter
    def callbacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "callbacks", value)

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @client_aliases.setter
    def client_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_aliases", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        """
        return pulumi.get(self, "cross_origin_auth")

    @cross_origin_auth.setter
    def cross_origin_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_origin_auth", value)

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @cross_origin_loc.setter
    def cross_origin_loc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_origin_loc", value)

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> Optional[pulumi.Input[str]]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @custom_login_page.setter
    def custom_login_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_login_page", value)

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @custom_login_page_on.setter
    def custom_login_page_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_login_page_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> Optional[pulumi.Input[str]]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @form_template.setter
    def form_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_template", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Initiate login URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "initiate_login_uri")

    @initiate_login_uri.setter
    def initiate_login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiate_login_uri", value)

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @is_first_party.setter
    def is_first_party(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_first_party", value)

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @is_token_endpoint_ip_header_trusted.setter
    def is_token_endpoint_ip_header_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_token_endpoint_ip_header_trusted", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['ClientJwtConfigurationArgs']]:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['ClientJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input['ClientMobileArgs']]:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input['ClientMobileArgs']]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> Optional[pulumi.Input['ClientNativeSocialLoginArgs']]:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @native_social_login.setter
    def native_social_login(self, value: Optional[pulumi.Input['ClientNativeSocialLoginArgs']]):
        pulumi.set(self, "native_social_login", value)

    @property
    @pulumi.getter(name="oidcBackchannelLogoutUrls")
    def oidc_backchannel_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        """
        return pulumi.get(self, "oidc_backchannel_logout_urls")

    @oidc_backchannel_logout_urls.setter
    def oidc_backchannel_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oidc_backchannel_logout_urls", value)

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @oidc_conformant.setter
    def oidc_conformant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oidc_conformant", value)

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @organization_require_behavior.setter
    def organization_require_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_require_behavior", value)

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @organization_usage.setter
    def organization_usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_usage", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input['ClientRefreshTokenArgs']]:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input['ClientRefreshTokenArgs']]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="requirePushedAuthorizationRequests")
    def require_pushed_authorization_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        """
        return pulumi.get(self, "require_pushed_authorization_requests")

    @require_pushed_authorization_requests.setter
    def require_pushed_authorization_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_pushed_authorization_requests", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input[bool]]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @sso_disabled.setter
    def sso_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_disabled", value)

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

    @web_origins.setter
    def web_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "web_origins", value)


@pulumi.input_type
class _ClientState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input['ClientAddonsArgs']] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input['ClientJwtConfigurationArgs']] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input['ClientMobileArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input['ClientNativeSocialLoginArgs']] = None,
                 oidc_backchannel_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input['ClientRefreshTokenArgs']] = None,
                 require_pushed_authorization_requests: Optional[pulumi.Input[bool]] = None,
                 signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Client resources.
        :param pulumi.Input['ClientAddonsArgs'] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI. Must be HTTPS or an empty string.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        :param pulumi.Input['ClientJwtConfigurationArgs'] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input['ClientMobileArgs'] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input['ClientNativeSocialLoginArgs'] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_backchannel_logout_urls: Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input['ClientRefreshTokenArgs'] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[bool] require_pushed_authorization_requests: Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if app_type is not None:
            pulumi.set(__self__, "app_type", app_type)
        if callbacks is not None:
            pulumi.set(__self__, "callbacks", callbacks)
        if client_aliases is not None:
            pulumi.set(__self__, "client_aliases", client_aliases)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if cross_origin_auth is not None:
            pulumi.set(__self__, "cross_origin_auth", cross_origin_auth)
        if cross_origin_loc is not None:
            pulumi.set(__self__, "cross_origin_loc", cross_origin_loc)
        if custom_login_page is not None:
            pulumi.set(__self__, "custom_login_page", custom_login_page)
        if custom_login_page_on is not None:
            pulumi.set(__self__, "custom_login_page_on", custom_login_page_on)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if form_template is not None:
            pulumi.set(__self__, "form_template", form_template)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if initiate_login_uri is not None:
            pulumi.set(__self__, "initiate_login_uri", initiate_login_uri)
        if is_first_party is not None:
            pulumi.set(__self__, "is_first_party", is_first_party)
        if is_token_endpoint_ip_header_trusted is not None:
            pulumi.set(__self__, "is_token_endpoint_ip_header_trusted", is_token_endpoint_ip_header_trusted)
        if jwt_configuration is not None:
            pulumi.set(__self__, "jwt_configuration", jwt_configuration)
        if logo_uri is not None:
            pulumi.set(__self__, "logo_uri", logo_uri)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_social_login is not None:
            pulumi.set(__self__, "native_social_login", native_social_login)
        if oidc_backchannel_logout_urls is not None:
            pulumi.set(__self__, "oidc_backchannel_logout_urls", oidc_backchannel_logout_urls)
        if oidc_conformant is not None:
            pulumi.set(__self__, "oidc_conformant", oidc_conformant)
        if organization_require_behavior is not None:
            pulumi.set(__self__, "organization_require_behavior", organization_require_behavior)
        if organization_usage is not None:
            pulumi.set(__self__, "organization_usage", organization_usage)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if require_pushed_authorization_requests is not None:
            pulumi.set(__self__, "require_pushed_authorization_requests", require_pushed_authorization_requests)
        if signing_keys is not None:
            pulumi.set(__self__, "signing_keys", signing_keys)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if sso_disabled is not None:
            pulumi.set(__self__, "sso_disabled", sso_disabled)
        if web_origins is not None:
            pulumi.set(__self__, "web_origins", web_origins)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input['ClientAddonsArgs']]:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input['ClientAddonsArgs']]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @app_type.setter
    def app_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_type", value)

    @property
    @pulumi.getter
    def callbacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @callbacks.setter
    def callbacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "callbacks", value)

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @client_aliases.setter
    def client_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_aliases", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        """
        return pulumi.get(self, "cross_origin_auth")

    @cross_origin_auth.setter
    def cross_origin_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_origin_auth", value)

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @cross_origin_loc.setter
    def cross_origin_loc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_origin_loc", value)

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> Optional[pulumi.Input[str]]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @custom_login_page.setter
    def custom_login_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_login_page", value)

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @custom_login_page_on.setter
    def custom_login_page_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_login_page_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> Optional[pulumi.Input[str]]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @form_template.setter
    def form_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_template", value)

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grant_types", value)

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Initiate login URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "initiate_login_uri")

    @initiate_login_uri.setter
    def initiate_login_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initiate_login_uri", value)

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @is_first_party.setter
    def is_first_party(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_first_party", value)

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @is_token_endpoint_ip_header_trusted.setter
    def is_token_endpoint_ip_header_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_token_endpoint_ip_header_trusted", value)

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> Optional[pulumi.Input['ClientJwtConfigurationArgs']]:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @jwt_configuration.setter
    def jwt_configuration(self, value: Optional[pulumi.Input['ClientJwtConfigurationArgs']]):
        pulumi.set(self, "jwt_configuration", value)

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @logo_uri.setter
    def logo_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo_uri", value)

    @property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input['ClientMobileArgs']]:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input['ClientMobileArgs']]):
        pulumi.set(self, "mobile", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> Optional[pulumi.Input['ClientNativeSocialLoginArgs']]:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @native_social_login.setter
    def native_social_login(self, value: Optional[pulumi.Input['ClientNativeSocialLoginArgs']]):
        pulumi.set(self, "native_social_login", value)

    @property
    @pulumi.getter(name="oidcBackchannelLogoutUrls")
    def oidc_backchannel_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        """
        return pulumi.get(self, "oidc_backchannel_logout_urls")

    @oidc_backchannel_logout_urls.setter
    def oidc_backchannel_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oidc_backchannel_logout_urls", value)

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @oidc_conformant.setter
    def oidc_conformant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "oidc_conformant", value)

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @organization_require_behavior.setter
    def organization_require_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_require_behavior", value)

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @organization_usage.setter
    def organization_usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_usage", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input['ClientRefreshTokenArgs']]:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input['ClientRefreshTokenArgs']]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="requirePushedAuthorizationRequests")
    def require_pushed_authorization_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        """
        return pulumi.get(self, "require_pushed_authorization_requests")

    @require_pushed_authorization_requests.setter
    def require_pushed_authorization_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_pushed_authorization_requests", value)

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        """
        List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        """
        return pulumi.get(self, "signing_keys")

    @signing_keys.setter
    def signing_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "signing_keys", value)

    @property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input[bool]]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso", value)

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @sso_disabled.setter
    def sso_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sso_disabled", value)

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

    @web_origins.setter
    def web_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "web_origins", value)


class Client(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['ClientAddonsArgs']]] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input[pulumi.InputType['ClientMobileArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input[pulumi.InputType['ClientNativeSocialLoginArgs']]] = None,
                 oidc_backchannel_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']]] = None,
                 require_pushed_authorization_requests: Optional[pulumi.Input[bool]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        With this resource, you can set up applications that use Auth0 for authentication and configure allowed callback URLs and secrets for these applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_client = auth0.Client("my_client",
            name="Application - Acceptance Test",
            description="Test Applications Long Description",
            app_type="non_interactive",
            custom_login_page_on=True,
            is_first_party=True,
            is_token_endpoint_ip_header_trusted=True,
            oidc_conformant=False,
            callbacks=["https://example.com/callback"],
            allowed_origins=["https://example.com"],
            allowed_logout_urls=["https://example.com"],
            web_origins=["https://example.com"],
            grant_types=[
                "authorization_code",
                "http://auth0.com/oauth/grant-type/password-realm",
                "implicit",
                "password",
                "refresh_token",
            ],
            client_metadata={
                "foo": "zoo",
            },
            jwt_configuration=auth0.ClientJwtConfigurationArgs(
                lifetime_in_seconds=300,
                secret_encoded=True,
                alg="RS256",
                scopes={
                    "foo": "bar",
                },
            ),
            refresh_token=auth0.ClientRefreshTokenArgs(
                leeway=0,
                token_lifetime=2592000,
                rotation_type="rotating",
                expiration_type="expiring",
            ),
            mobile=auth0.ClientMobileArgs(
                ios=auth0.ClientMobileIosArgs(
                    team_id="9JA89QQLNQ",
                    app_bundle_identifier="com.my.bundle.id",
                ),
            ),
            addons=auth0.ClientAddonsArgs(
                samlp=auth0.ClientAddonsSamlpArgs(
                    audience="https://example.com/saml",
                    issuer="https://example.com",
                    mappings={
                        "email": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress",
                        "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
                    },
                    create_upn_claim=False,
                    passthrough_claims_with_no_mapping=False,
                    map_unknown_claims_as_is=False,
                    map_identities=False,
                    name_identifier_format="urn:oasis:names:tc:SAML:2.0:nameid-format:persistent",
                    name_identifier_probes=["http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"],
                    signing_cert=\"\"\"-----BEGIN PUBLIC KEY-----
        MIGf...bpP/t3
        +JGNGIRMj1hF1rnb6QIDAQAB
        -----END PUBLIC KEY-----
        \"\"\",
                ),
            ))
        ```

        ## Import

        This resource can be imported by specifying the client ID.

        # 

        Example:

        ```sh
        $ pulumi import auth0:index/client:Client my_client "AaiyAPdpYdesoKnqjj8HJqRn4T5titww"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClientAddonsArgs']] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI. Must be HTTPS or an empty string.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        :param pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['ClientMobileArgs']] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input[pulumi.InputType['ClientNativeSocialLoginArgs']] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_backchannel_logout_urls: Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[bool] require_pushed_authorization_requests: Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClientArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can set up applications that use Auth0 for authentication and configure allowed callback URLs and secrets for these applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_client = auth0.Client("my_client",
            name="Application - Acceptance Test",
            description="Test Applications Long Description",
            app_type="non_interactive",
            custom_login_page_on=True,
            is_first_party=True,
            is_token_endpoint_ip_header_trusted=True,
            oidc_conformant=False,
            callbacks=["https://example.com/callback"],
            allowed_origins=["https://example.com"],
            allowed_logout_urls=["https://example.com"],
            web_origins=["https://example.com"],
            grant_types=[
                "authorization_code",
                "http://auth0.com/oauth/grant-type/password-realm",
                "implicit",
                "password",
                "refresh_token",
            ],
            client_metadata={
                "foo": "zoo",
            },
            jwt_configuration=auth0.ClientJwtConfigurationArgs(
                lifetime_in_seconds=300,
                secret_encoded=True,
                alg="RS256",
                scopes={
                    "foo": "bar",
                },
            ),
            refresh_token=auth0.ClientRefreshTokenArgs(
                leeway=0,
                token_lifetime=2592000,
                rotation_type="rotating",
                expiration_type="expiring",
            ),
            mobile=auth0.ClientMobileArgs(
                ios=auth0.ClientMobileIosArgs(
                    team_id="9JA89QQLNQ",
                    app_bundle_identifier="com.my.bundle.id",
                ),
            ),
            addons=auth0.ClientAddonsArgs(
                samlp=auth0.ClientAddonsSamlpArgs(
                    audience="https://example.com/saml",
                    issuer="https://example.com",
                    mappings={
                        "email": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress",
                        "name": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name",
                    },
                    create_upn_claim=False,
                    passthrough_claims_with_no_mapping=False,
                    map_unknown_claims_as_is=False,
                    map_identities=False,
                    name_identifier_format="urn:oasis:names:tc:SAML:2.0:nameid-format:persistent",
                    name_identifier_probes=["http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"],
                    signing_cert=\"\"\"-----BEGIN PUBLIC KEY-----
        MIGf...bpP/t3
        +JGNGIRMj1hF1rnb6QIDAQAB
        -----END PUBLIC KEY-----
        \"\"\",
                ),
            ))
        ```

        ## Import

        This resource can be imported by specifying the client ID.

        # 

        Example:

        ```sh
        $ pulumi import auth0:index/client:Client my_client "AaiyAPdpYdesoKnqjj8HJqRn4T5titww"
        ```

        :param str resource_name: The name of the resource.
        :param ClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['ClientAddonsArgs']]] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_type: Optional[pulumi.Input[str]] = None,
                 callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cross_origin_auth: Optional[pulumi.Input[bool]] = None,
                 cross_origin_loc: Optional[pulumi.Input[str]] = None,
                 custom_login_page: Optional[pulumi.Input[str]] = None,
                 custom_login_page_on: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 form_template: Optional[pulumi.Input[str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 initiate_login_uri: Optional[pulumi.Input[str]] = None,
                 is_first_party: Optional[pulumi.Input[bool]] = None,
                 is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
                 jwt_configuration: Optional[pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']]] = None,
                 logo_uri: Optional[pulumi.Input[str]] = None,
                 mobile: Optional[pulumi.Input[pulumi.InputType['ClientMobileArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_social_login: Optional[pulumi.Input[pulumi.InputType['ClientNativeSocialLoginArgs']]] = None,
                 oidc_backchannel_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oidc_conformant: Optional[pulumi.Input[bool]] = None,
                 organization_require_behavior: Optional[pulumi.Input[str]] = None,
                 organization_usage: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']]] = None,
                 require_pushed_authorization_requests: Optional[pulumi.Input[bool]] = None,
                 sso: Optional[pulumi.Input[bool]] = None,
                 sso_disabled: Optional[pulumi.Input[bool]] = None,
                 web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientArgs.__new__(ClientArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["allowed_clients"] = allowed_clients
            __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
            __props__.__dict__["allowed_origins"] = allowed_origins
            __props__.__dict__["app_type"] = app_type
            __props__.__dict__["callbacks"] = callbacks
            __props__.__dict__["client_aliases"] = client_aliases
            __props__.__dict__["client_metadata"] = client_metadata
            __props__.__dict__["cross_origin_auth"] = cross_origin_auth
            __props__.__dict__["cross_origin_loc"] = cross_origin_loc
            __props__.__dict__["custom_login_page"] = custom_login_page
            __props__.__dict__["custom_login_page_on"] = custom_login_page_on
            if description is None:
                description = 'Managed by Pulumi'
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["form_template"] = form_template
            __props__.__dict__["grant_types"] = grant_types
            __props__.__dict__["initiate_login_uri"] = initiate_login_uri
            __props__.__dict__["is_first_party"] = is_first_party
            __props__.__dict__["is_token_endpoint_ip_header_trusted"] = is_token_endpoint_ip_header_trusted
            __props__.__dict__["jwt_configuration"] = jwt_configuration
            __props__.__dict__["logo_uri"] = logo_uri
            __props__.__dict__["mobile"] = mobile
            __props__.__dict__["name"] = name
            __props__.__dict__["native_social_login"] = native_social_login
            __props__.__dict__["oidc_backchannel_logout_urls"] = oidc_backchannel_logout_urls
            __props__.__dict__["oidc_conformant"] = oidc_conformant
            __props__.__dict__["organization_require_behavior"] = organization_require_behavior
            __props__.__dict__["organization_usage"] = organization_usage
            __props__.__dict__["refresh_token"] = refresh_token
            __props__.__dict__["require_pushed_authorization_requests"] = require_pushed_authorization_requests
            __props__.__dict__["sso"] = sso
            __props__.__dict__["sso_disabled"] = sso_disabled
            __props__.__dict__["web_origins"] = web_origins
            __props__.__dict__["client_id"] = None
            __props__.__dict__["signing_keys"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["signingKeys"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Client, __self__).__init__(
            'auth0:index/client:Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[pulumi.InputType['ClientAddonsArgs']]] = None,
            allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_type: Optional[pulumi.Input[str]] = None,
            callbacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            client_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cross_origin_auth: Optional[pulumi.Input[bool]] = None,
            cross_origin_loc: Optional[pulumi.Input[str]] = None,
            custom_login_page: Optional[pulumi.Input[str]] = None,
            custom_login_page_on: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            form_template: Optional[pulumi.Input[str]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            initiate_login_uri: Optional[pulumi.Input[str]] = None,
            is_first_party: Optional[pulumi.Input[bool]] = None,
            is_token_endpoint_ip_header_trusted: Optional[pulumi.Input[bool]] = None,
            jwt_configuration: Optional[pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']]] = None,
            logo_uri: Optional[pulumi.Input[str]] = None,
            mobile: Optional[pulumi.Input[pulumi.InputType['ClientMobileArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            native_social_login: Optional[pulumi.Input[pulumi.InputType['ClientNativeSocialLoginArgs']]] = None,
            oidc_backchannel_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            oidc_conformant: Optional[pulumi.Input[bool]] = None,
            organization_require_behavior: Optional[pulumi.Input[str]] = None,
            organization_usage: Optional[pulumi.Input[str]] = None,
            refresh_token: Optional[pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']]] = None,
            require_pushed_authorization_requests: Optional[pulumi.Input[bool]] = None,
            signing_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
            sso: Optional[pulumi.Input[bool]] = None,
            sso_disabled: Optional[pulumi.Input[bool]] = None,
            web_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Client':
        """
        Get an existing Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClientAddonsArgs']] addons: Addons enabled for this client and their associated configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_clients: List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        :param pulumi.Input[str] app_type: Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callbacks: URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_aliases: List of audiences/realms for SAML protocol. Used by the wsfed addon.
        :param pulumi.Input[str] client_id: The ID of the client.
        :param pulumi.Input[Mapping[str, Any]] client_metadata: Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        :param pulumi.Input[bool] cross_origin_auth: Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        :param pulumi.Input[str] cross_origin_loc: URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        :param pulumi.Input[str] custom_login_page: The content (HTML, CSS, JS) of the custom login page.
        :param pulumi.Input[bool] custom_login_page_on: Indicates whether a custom login page is to be used.
        :param pulumi.Input[str] description: Description of the purpose of the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_key: Encryption used for WS-Fed responses with this client.
        :param pulumi.Input[str] form_template: HTML form template to be used for WS-Federation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grant_types: Types of grants that this client is authorized to use.
        :param pulumi.Input[str] initiate_login_uri: Initiate login URI. Must be HTTPS or an empty string.
        :param pulumi.Input[bool] is_first_party: Indicates whether this client is a first-party client.
        :param pulumi.Input[bool] is_token_endpoint_ip_header_trusted: Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        :param pulumi.Input[pulumi.InputType['ClientJwtConfigurationArgs']] jwt_configuration: Configuration settings for the JWTs issued for this client.
        :param pulumi.Input[str] logo_uri: URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        :param pulumi.Input[pulumi.InputType['ClientMobileArgs']] mobile: Additional configuration for native mobile apps.
        :param pulumi.Input[str] name: Name of the client.
        :param pulumi.Input[pulumi.InputType['ClientNativeSocialLoginArgs']] native_social_login: Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_backchannel_logout_urls: Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        :param pulumi.Input[bool] oidc_conformant: Indicates whether this client will conform to strict OIDC specifications.
        :param pulumi.Input[str] organization_require_behavior: Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        :param pulumi.Input[str] organization_usage: Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        :param pulumi.Input[pulumi.InputType['ClientRefreshTokenArgs']] refresh_token: Configuration settings for the refresh tokens issued for this client.
        :param pulumi.Input[bool] require_pushed_authorization_requests: Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] signing_keys: List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        :param pulumi.Input[bool] sso: Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        :param pulumi.Input[bool] sso_disabled: Indicates whether or not SSO is disabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_origins: URLs that represent valid web origins for use with web message response mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientState.__new__(_ClientState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["allowed_clients"] = allowed_clients
        __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
        __props__.__dict__["allowed_origins"] = allowed_origins
        __props__.__dict__["app_type"] = app_type
        __props__.__dict__["callbacks"] = callbacks
        __props__.__dict__["client_aliases"] = client_aliases
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_metadata"] = client_metadata
        __props__.__dict__["cross_origin_auth"] = cross_origin_auth
        __props__.__dict__["cross_origin_loc"] = cross_origin_loc
        __props__.__dict__["custom_login_page"] = custom_login_page
        __props__.__dict__["custom_login_page_on"] = custom_login_page_on
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["form_template"] = form_template
        __props__.__dict__["grant_types"] = grant_types
        __props__.__dict__["initiate_login_uri"] = initiate_login_uri
        __props__.__dict__["is_first_party"] = is_first_party
        __props__.__dict__["is_token_endpoint_ip_header_trusted"] = is_token_endpoint_ip_header_trusted
        __props__.__dict__["jwt_configuration"] = jwt_configuration
        __props__.__dict__["logo_uri"] = logo_uri
        __props__.__dict__["mobile"] = mobile
        __props__.__dict__["name"] = name
        __props__.__dict__["native_social_login"] = native_social_login
        __props__.__dict__["oidc_backchannel_logout_urls"] = oidc_backchannel_logout_urls
        __props__.__dict__["oidc_conformant"] = oidc_conformant
        __props__.__dict__["organization_require_behavior"] = organization_require_behavior
        __props__.__dict__["organization_usage"] = organization_usage
        __props__.__dict__["refresh_token"] = refresh_token
        __props__.__dict__["require_pushed_authorization_requests"] = require_pushed_authorization_requests
        __props__.__dict__["signing_keys"] = signing_keys
        __props__.__dict__["sso"] = sso
        __props__.__dict__["sso_disabled"] = sso_disabled
        __props__.__dict__["web_origins"] = web_origins
        return Client(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional['outputs.ClientAddons']]:
        """
        Addons enabled for this client and their associated configurations.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of applications ID's that will be allowed to make delegation request. By default, all applications will be allowed.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URLs that represent valid origins for cross-origin resource sharing. By default, all your callback URLs will be allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="appType")
    def app_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of application the client represents. Possible values are: `native`, `spa`, `regular_web`, `non_interactive`, `sso_integration`. Specific SSO integrations types accepted as well are: `rms`, `box`, `cloudbees`, `concur`, `dropbox`, `mscrm`, `echosign`, `egnyte`, `newrelic`, `office365`, `salesforce`, `sentry`, `sharepoint`, `slack`, `springcm`, `zendesk`, `zoom`.
        """
        return pulumi.get(self, "app_type")

    @property
    @pulumi.getter
    def callbacks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URLs that Auth0 may call back to after a user authenticates for the client. Make sure to specify the protocol (https://) otherwise the callback may fail in some cases. With the exception of custom URI schemes for native clients, all callbacks should use protocol https://.
        """
        return pulumi.get(self, "callbacks")

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of audiences/realms for SAML protocol. Used by the wsfed addon.
        """
        return pulumi.get(self, "client_aliases")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Metadata associated with the client, in the form of an object with string values (max 255 chars). Maximum of 10 metadata properties allowed. Field names (max 255 chars) are alphanumeric and may only include the following special characters: `:,-+=_*?"/\\()<>@ [Tab] [Space]`.
        """
        return pulumi.get(self, "client_metadata")

    @property
    @pulumi.getter(name="crossOriginAuth")
    def cross_origin_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this client can be used to make cross-origin authentication requests (`true`) or it is not allowed to make such requests (`false`).
        """
        return pulumi.get(self, "cross_origin_auth")

    @property
    @pulumi.getter(name="crossOriginLoc")
    def cross_origin_loc(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the location in your site where the cross-origin verification takes place for the cross-origin auth flow when performing authentication in your own domain instead of Auth0 Universal Login page.
        """
        return pulumi.get(self, "cross_origin_loc")

    @property
    @pulumi.getter(name="customLoginPage")
    def custom_login_page(self) -> pulumi.Output[Optional[str]]:
        """
        The content (HTML, CSS, JS) of the custom login page.
        """
        return pulumi.get(self, "custom_login_page")

    @property
    @pulumi.getter(name="customLoginPageOn")
    def custom_login_page_on(self) -> pulumi.Output[bool]:
        """
        Indicates whether a custom login page is to be used.
        """
        return pulumi.get(self, "custom_login_page_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the purpose of the client.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Encryption used for WS-Fed responses with this client.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="formTemplate")
    def form_template(self) -> pulumi.Output[Optional[str]]:
        """
        HTML form template to be used for WS-Federation.
        """
        return pulumi.get(self, "form_template")

    @property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Types of grants that this client is authorized to use.
        """
        return pulumi.get(self, "grant_types")

    @property
    @pulumi.getter(name="initiateLoginUri")
    def initiate_login_uri(self) -> pulumi.Output[Optional[str]]:
        """
        Initiate login URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "initiate_login_uri")

    @property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> pulumi.Output[bool]:
        """
        Indicates whether this client is a first-party client.
        """
        return pulumi.get(self, "is_first_party")

    @property
    @pulumi.getter(name="isTokenEndpointIpHeaderTrusted")
    def is_token_endpoint_ip_header_trusted(self) -> pulumi.Output[bool]:
        """
        Indicates whether the token endpoint IP header is trusted. Requires the authentication method to be set to `client_secret_post` or `client_secret_basic`. Setting this property when creating the resource, will default the authentication method to `client_secret_post`. To change the authentication method to `client_secret_basic` use the `ClientCredentials` resource.
        """
        return pulumi.get(self, "is_token_endpoint_ip_header_trusted")

    @property
    @pulumi.getter(name="jwtConfiguration")
    def jwt_configuration(self) -> pulumi.Output['outputs.ClientJwtConfiguration']:
        """
        Configuration settings for the JWTs issued for this client.
        """
        return pulumi.get(self, "jwt_configuration")

    @property
    @pulumi.getter(name="logoUri")
    def logo_uri(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the logo for the client. Recommended size is 150px x 150px. If none is set, the default badge for the application type will be shown.
        """
        return pulumi.get(self, "logo_uri")

    @property
    @pulumi.getter
    def mobile(self) -> pulumi.Output['outputs.ClientMobile']:
        """
        Additional configuration for native mobile apps.
        """
        return pulumi.get(self, "mobile")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeSocialLogin")
    def native_social_login(self) -> pulumi.Output['outputs.ClientNativeSocialLogin']:
        """
        Configuration settings to toggle native social login for mobile native applications. Once this is set it must stay set, with both resources set to `false` in order to change the `app_type`.
        """
        return pulumi.get(self, "native_social_login")

    @property
    @pulumi.getter(name="oidcBackchannelLogoutUrls")
    def oidc_backchannel_logout_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of URLs that are valid to call back from Auth0 for OIDC backchannel logout. Currently only one URL is allowed.
        """
        return pulumi.get(self, "oidc_backchannel_logout_urls")

    @property
    @pulumi.getter(name="oidcConformant")
    def oidc_conformant(self) -> pulumi.Output[bool]:
        """
        Indicates whether this client will conform to strict OIDC specifications.
        """
        return pulumi.get(self, "oidc_conformant")

    @property
    @pulumi.getter(name="organizationRequireBehavior")
    def organization_require_behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Defines how to proceed during an authentication transaction when `organization_usage = "require"`. Can be `no_prompt` (default), `pre_login_prompt` or  `post_login_prompt`.
        """
        return pulumi.get(self, "organization_require_behavior")

    @property
    @pulumi.getter(name="organizationUsage")
    def organization_usage(self) -> pulumi.Output[Optional[str]]:
        """
        Defines how to proceed during an authentication transaction with regards to an organization. Can be `deny` (default), `allow` or `require`.
        """
        return pulumi.get(self, "organization_usage")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output['outputs.ClientRefreshToken']:
        """
        Configuration settings for the refresh tokens issued for this client.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="requirePushedAuthorizationRequests")
    def require_pushed_authorization_requests(self) -> pulumi.Output[Optional[bool]]:
        """
        Makes the use of Pushed Authorization Requests mandatory for this client. This feature currently needs to be enabled on the tenant in order to make use of it.
        """
        return pulumi.get(self, "require_pushed_authorization_requests")

    @property
    @pulumi.getter(name="signingKeys")
    def signing_keys(self) -> pulumi.Output[Sequence[Mapping[str, Any]]]:
        """
        List containing a map of the public cert of the signing key and the public cert of the signing key in PKCS7.
        """
        return pulumi.get(self, "signing_keys")

    @property
    @pulumi.getter
    def sso(self) -> pulumi.Output[Optional[bool]]:
        """
        Applies only to SSO clients and determines whether Auth0 will handle Single Sign-On (true) or whether the identity provider will (false).
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter(name="ssoDisabled")
    def sso_disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether or not SSO is disabled.
        """
        return pulumi.get(self, "sso_disabled")

    @property
    @pulumi.getter(name="webOrigins")
    def web_origins(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URLs that represent valid web origins for use with web message response mode.
        """
        return pulumi.get(self, "web_origins")

