
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

import re
from ..base_rpc_errors import FloodError


class TwoFaConfirmWaitError(
    FloodError,
    pattern=re.compile(r'2FA_CONFIRM_WAIT_(?P<seconds>\d+)')
):
    """
    FloodError (420): `2FA_CONFIRM_WAIT_{seconds}`
    """

    def __init__(
        self,
        request,
        seconds: int = 0
    ):
        self.seconds = seconds

        super().__init__(
            request,
            f"Since this account is active and protected by a 2FA password, we will delete it in 1 week for security purposes. You can cancel this process at any time, you'll be able to reset your account in {seconds} seconds."
        )

class AddressInvalidError(
    FloodError,
    pattern='ADDRESS_INVALID'
):
    """
    FloodError (420): `ADDRESS_INVALID`
    """

    def __init__(
        self,
        request
    ):
        super().__init__(
            request,
            'The specified geopoint address is invalid.'
        )

class FloodPremiumWaitError(
    FloodError,
    pattern=re.compile(r'FLOOD_PREMIUM_WAIT_(?P<seconds>\d+)')
):
    """
    FloodError (420): `FLOOD_PREMIUM_WAIT_{seconds}`
    """

    def __init__(
        self,
        request,
        seconds: int = 0
    ):
        self.seconds = seconds

        super().__init__(
            request,
            f'Please wait {seconds} seconds before repeating the action, or purchase a [Telegram Premium subscription](https://core.telegram.org/api/premium) to remove this rate limit.'
        )

class PremiumSubActiveUntilError(
    FloodError,
    pattern=re.compile(r'PREMIUM_SUB_ACTIVE_UNTIL_(?P<unixtime>\d+)')
):
    """
    FloodError (420): `PREMIUM_SUB_ACTIVE_UNTIL_{unixtime}`
    """

    def __init__(
        self,
        request,
        unixtime: int = 0
    ):
        self.unixtime = unixtime

        super().__init__(
            request,
            f'You already have a premium subscription active until unixtime {unixtime} .'
        )

class SlowmodeWaitError(
    FloodError,
    pattern=re.compile(r'SLOWMODE_WAIT_(?P<seconds>\d+)')
):
    """
    FloodError (420): `SLOWMODE_WAIT_{seconds}`
    """

    def __init__(
        self,
        request,
        seconds: int = 0
    ):
        self.seconds = seconds

        super().__init__(
            request,
            f'Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.'
        )

class TakeoutInitDelayError(
    FloodError,
    pattern=re.compile(r'TAKEOUT_INIT_DELAY_(?P<seconds>\d+)')
):
    """
    FloodError (420): `TAKEOUT_INIT_DELAY_{seconds}`
    """

    def __init__(
        self,
        request,
        seconds: int = 0
    ):
        self.seconds = seconds

        super().__init__(
            request,
            f"Sorry, for security reasons, you will be able to begin downloading your data in {seconds} seconds. We have notified all your devices about the export request to make sure it's authorized and to give you time to react if it's not."
        )

class FloodWaitError(
    FloodError,
    pattern=re.compile(r'FLOOD_WAIT_(?P<seconds>\d+)')
):
    """
    FloodError (420): `FLOOD_WAIT_{seconds}`
    """

    def __init__(
        self,
        request,
        seconds: int = 0
    ):
        self.seconds = seconds

        super().__init__(
            request,
            f'Please wait {seconds} seconds before repeating the action.'
        )