
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.theme import TypeTheme
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_theme import TypeInputTheme


class GetTheme(TLRequest[TypeTheme]):
    """
    Get theme information

    Raises:
        `400`ThemeFormatInvalidError: Invalid theme format provided.
        `400`ThemeInvalidError: Invalid theme provided.

    """

    _id = 0X3A5869EC
    _result_id = 0X5E6FFFBC

    def __init__(
        self,
        format: str,
        theme: 'TypeInputTheme'
    ):

        """
        Get theme information

        Args:
            format (str): Theme format, a string that identifies the theming engines supported by the client
            theme ('TypeInputTheme'): Theme
        """

        self.format = format
        self.theme = theme

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeciX:' if boxed else b'') as writer:
            writer.string(self.format)
            writer.object(
                self.theme,
                group_id=0X339F9825
            )

            return writer.getvalue()