
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.sent_code import TypeAuthSentCode


if TYPE_CHECKING:
    from ...types.code_settings import TypeCodeSettings


class SendChangePhoneCode(TLRequest[TypeAuthSentCode]):
    """
    Verify a new phone number to associate to the current account

    Raises:
        `406`FreshChangePhoneForbiddenError: You can't change phone number right after logging in, please wait at least 24 hours.
        `406`PhoneNumberInvalidError: The phone number is invalid.
        `400`PhoneNumberBannedError: The provided phone number is banned from telegram.
        `400`PhoneNumberOccupiedError: The phone number is already in use.

    """

    _id = 0X82574AE5
    _result_id = 0X8F0C24F5

    def __init__(
        self,
        phone_number: str,
        settings: 'TypeCodeSettings'
    ):

        """
        Verify a new phone number to associate to the current account

        Args:
            phone_number (str): New phone number
            settings ('TypeCodeSettings'): Phone code settings
        """

        self.phone_number = phone_number
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe5JW\x82' if boxed else b'') as writer:
            writer.string(self.phone_number)
            writer.object(
                self.settings,
                group_id=0X4A76A298
            )

            return writer.getvalue()