
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.authorization import TypeAuthAuthorization


if TYPE_CHECKING:
    from ...types.account.password_input_settings import TypeAccountPasswordInputSettings


class RecoverPassword(TLRequest[TypeAuthAuthorization]):
    """
    Reset the [2FA password](https://core.telegram.org/api/srp) using the recovery code sent using [auth.requestPasswordRecovery](https://core.telegram.org/method/auth.requestPasswordRecovery).

    Raises:
        `400`CodeEmptyError: The provided code is empty.
        `400`NewSettingsInvalidError: The new password settings are invalid.

    """

    _id = 0X37096C70
    _result_id = 0X2A654890

    def __init__(
        self,
        code: str,
        new_settings: Optional['TypeAccountPasswordInputSettings'] = None
    ):

        """
        Reset the [2FA password](https://core.telegram.org/api/srp) using the recovery code sent using [auth.requestPasswordRecovery](https://core.telegram.org/method/auth.requestPasswordRecovery).

        Args:
            code (str): Code received via email
            new_settings (Optional['TypeAccountPasswordInputSettings'], optional): New password
        """

        self.code = code
        self.new_settings = new_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'pl\t7' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.code)

                if flags(self.new_settings, 0):
                    writer.object(
                        self.new_settings,
                        group_id=0X59FEE6C
                    )

            return writer.getvalue()