
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_history import TypeMessagesAffectedHistory


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_channel import TypeInputChannel


class DeleteParticipantHistory(TLRequest[TypeMessagesAffectedHistory]):
    """
    Delete all messages sent by a specific participant of a given supergroup

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`ParticipantIdInvalidError: The specified participant ID is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0X367544DB
    _result_id = 0XC038BDBA

    def __init__(
        self,
        channel: 'TypeInputChannel',
        participant: 'TypeInputPeer'
    ):

        """
        Delete all messages sent by a specific participant of a given supergroup

        Args:
            channel ('TypeInputChannel'): Supergroup
            participant ('TypeInputPeer'): The participant whose messages should be deleted
        """

        self.channel = channel
        self.participant = participant

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdbDu6' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.object(
                self.participant,
                group_id=0X995DB9DF
            )

            return writer.getvalue()