
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.chatlists.exported_chatlist_invite import TypeChatlistsExportedChatlistInvite


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_chatlist import TypeInputChatlist


class ExportChatlistInvite(TLRequest[TypeChatlistsExportedChatlistInvite]):
    """
    Export a [folder](https://core.telegram.org/api/folders), creating a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatlistsTooMuchError: You have created too many folder links, hitting the `chatlist_invites_limit_default`/`chatlist_invites_limit_premium` [limits &raquo;](https://core.telegram.org/api/config#chatlist-invites-limit-default).
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`FilterIdInvalidError: The specified filter ID is invalid.
        `400`FilterNotSupportedError: The specified filter cannot be used in this context.
        `400`InvitesTooMuchError: The maximum number of per-folder invites specified by the `chatlist_invites_limit_default`/`chatlist_invites_limit_premium` [client configuration parameters &raquo;](https://core.telegram.org/api/config#chatlist-invites-limit-default) was reached.
        `400`PeersListEmptyError: The specified list of peers is empty.

    """

    _id = 0X8472478E
    _result_id = 0XBD6B498D

    def __init__(
        self,
        chatlist: 'TypeInputChatlist',
        title: str,
        peers: List['TypeInputPeer']
    ):

        """
        Export a [folder](https://core.telegram.org/api/folders), creating a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

        Args:
            chatlist ('TypeInputChatlist'): The folder to export
            title (str): An optional name for the link
            peers (List['TypeInputPeer']): The list of channels, group and supergroups to share with the link. Basic groups will automatically be [converted to supergroups](https://core.telegram.org/api/channel#migration) when invoking the method.
        """

        self.chatlist = chatlist
        self.title = title
        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8eGr\x84' if boxed else b'') as writer:
            writer.object(
                self.chatlist,
                group_id=0XF1847C0F
            )
            writer.string(self.title)
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0X995DB9DF
                )
            )

            return writer.getvalue()