
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.bot_results import TypeMessagesBotResults


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_peer import TypeInputPeer
    from ...types.input_geo_point import TypeInputGeoPoint


class GetInlineBotResults(TLRequest[TypeMessagesBotResults]):
    """
    Query an inline bot

    Raises:
        `400`BotInlineDisabledError: This bot can't be used in inline mode.
        `400`BotInvalidError: This is not a valid bot.
        `400`BotResponseTimeoutError: A timeout occurred while fetching data from the bot.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.

    """

    _id = 0X514E999D
    _result_id = 0XF96CDD05

    def __init__(
        self,
        bot: 'TypeInputUser',
        peer: 'TypeInputPeer',
        query: str,
        offset: str,
        geo_point: Optional['TypeInputGeoPoint'] = None
    ):

        """
        Query an inline bot

        Args:
            bot ('TypeInputUser'): The bot to query
            peer ('TypeInputPeer'): The currently opened chat
            query (str): The query
            offset (str): The offset within the results, will be passed directly as-is to the bot.
            geo_point (Optional['TypeInputGeoPoint'], optional): The geolocation, if requested
        """

        self.bot = bot
        self.peer = peer
        self.query = query
        self.offset = offset
        self.geo_point = geo_point

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9d\x99NQ' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.geo_point, 0):
                    writer.object(
                        self.geo_point,
                        group_id=0XF78B3873
                    )
                writer.string(self.query)
                writer.string(self.offset)

            return writer.getvalue()