
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_encrypted_chat import TypeInputEncryptedChat


class ReadEncryptedHistory(TLRequest[bool]):
    """
    Marks message history within a secret chat as read.

    Raises:
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`MaxDateInvalidError: The specified maximum date is invalid.
        `400`MsgWaitFailedError: A waiting call returned an error.

    """

    _id = 0X7F4B690A
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputEncryptedChat',
        max_date: int
    ):

        """
        Marks message history within a secret chat as read.

        Args:
            peer ('TypeInputEncryptedChat'): Secret chat ID
            max_date (int): Maximum date value for received messages in history
        """

        self.peer = peer
        self.max_date = max_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\niK\x7f' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X947D3E78
            )
            writer.int(self.max_date)

            return writer.getvalue()