
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_messages import TypeMessagesAffectedMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class ReadHistory(TLRequest[TypeMessagesAffectedMessages]):
    """
    Marks message history as read.

    Raises:
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XE306D3A
    _result_id = 0X115F5ED1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        max_id: int
    ):

        """
        Marks message history as read.

        Args:
            peer ('TypeInputPeer'): Target user or group
            max_id (int): If a positive value is passed, only messages with identifiers less or equal than the given one will be read
        """

        self.peer = peer
        self.max_id = max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b':m0\x0e' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.max_id)

            return writer.getvalue()