
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.web_view_result import TypeWebViewResult


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON
    from ...types.input_peer import TypeInputPeer
    from ...types.input_bot_app import TypeInputBotApp


class RequestAppWebView(TLRequest[TypeWebViewResult]):
    """
    Open a [bot mini app](https://core.telegram.org/bots/webapps) from a [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links), sending over user information after user confirmation.

    Raises:
        `400`BotAppBotInvalidError: The bot_id passed in the inputBotAppShortName constructor is invalid.
        `400`BotAppInvalidError: The specified bot app is invalid.
        `400`BotAppShortnameInvalidError: The specified bot app short name is invalid.

    """

    _id = 0X53618BCE
    _result_id = 0X60754D10

    def __init__(
        self,
        peer: 'TypeInputPeer',
        app: 'TypeInputBotApp',
        platform: str,
        write_allowed: bool = False,
        compact: bool = False,
        fullscreen: bool = False,
        start_param: Optional[str] = None,
        theme_params: Optional['TypeDataJSON'] = None
    ):

        """
        Open a [bot mini app](https://core.telegram.org/bots/webapps) from a [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links), sending over user information after user confirmation.

        Args:
            peer ('TypeInputPeer'): If the client has clicked on the link in a Telegram chat, pass the chat's peer information; otherwise pass the bot's peer information, instead.
            app ('TypeInputBotApp'): The app obtained by invoking [messages.getBotApp](https://core.telegram.org/method/messages.getBotApp) as specified in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) docs.
            platform (str): Short name of the application; 0-64 English letters, digits, and underscores
            write_allowed (bool, optional): Set this flag if the bot is asking permission to send messages to the user as specified in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) docs, and the user agreed.
            compact (bool, optional): If set, requests to open the mini app in compact mode (as opposed to normal or fullscreen mode). Must be set if the mode parameter of the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) is equal to compact.
            fullscreen (bool, optional): If set, requests to open the mini app in fullscreen mode (as opposed to compact or normal mode). Must be set if the mode parameter of the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links) is equal to fullscreen.
            start_param (Optional[str], optional): If the startapp query string parameter is present in the [direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links), pass it to start_param.
            theme_params (Optional['TypeDataJSON'], optional): [Theme parameters](https://core.telegram.org/api/bots/webapps#theme-parameters)
        """

        self.peer = peer
        self.app = app
        self.platform = platform
        self.write_allowed = write_allowed
        self.compact = compact
        self.fullscreen = fullscreen
        self.start_param = start_param
        self.theme_params = theme_params

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xce\x8baS' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.write_allowed, 0)
                flags(self.compact, 7)
                flags(self.fullscreen, 8)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.app,
                    group_id=0X40D88192
                )

                if flags(self.start_param, 1):
                    writer.string(self.start_param)

                if flags(self.theme_params, 2):
                    writer.object(
                        self.theme_params,
                        group_id=0XE95B0798
                    )
                writer.string(self.platform)

            return writer.getvalue()