
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer
from ...types.messages.sent_encrypted_message import TypeMessagesSentEncryptedMessage


if TYPE_CHECKING:
    from ...types.input_encrypted_chat import TypeInputEncryptedChat


class SendEncrypted(TLRequest[TypeMessagesSentEncryptedMessage]):
    """
    Sends a text message to a secret chat.

    Raises:
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`DataInvalidError: Encrypted data invalid.
        `400`DataTooLongError: Data too long.
        `400`EncryptionDeclinedError: The secret chat was declined.
        `500`MsgWaitFailedError: A waiting call returned an error.
        `403`UserIsBlockedError: You were blocked by this user.

    """

    _id = 0X44FA7A15
    _result_id = 0XFA58ED64

    def __init__(
        self,
        peer: 'TypeInputEncryptedChat',
        data: bytes,
        silent: bool = False,
        random_id: int = None
    ):

        """
        Sends a text message to a secret chat.

        Args:
            peer ('TypeInputEncryptedChat'): Secret chat ID
            data (bytes): TL-serialization of [DecryptedMessage](https://core.telegram.org/type/DecryptedMessage) type, encrypted with a key that was created during chat initialization
            silent (bool, optional): Send encrypted message without a notification
            random_id (int, optional): Unique client message ID, necessary to avoid message resending
        """

        self.peer = peer
        self.data = data
        self.silent = silent
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x15z\xfaD' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 0)
                writer.object(
                    self.peer,
                    group_id=0X947D3E78
                )
                writer.long(self.random_id)
                writer.bytes(self.data)

            return writer.getvalue()